/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.thrift.api.udf;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.thrift.api.udf.PrestoThriftPage;
import com.facebook.presto.thrift.api.udf.ThriftSerializedPage;
import com.facebook.presto.thrift.api.udf.ThriftUdfPageFormat;
import java.util.Objects;
import javax.annotation.Nullable;

@ThriftStruct(value="UdfPage")
public class ThriftUdfPage {
    private final ThriftUdfPageFormat pageFormat;
    private final PrestoThriftPage thriftPage;
    private final ThriftSerializedPage prestoPage;

    @ThriftConstructor
    public ThriftUdfPage(ThriftUdfPageFormat pageFormat, @Nullable PrestoThriftPage thriftPage, @Nullable ThriftSerializedPage prestoPage) {
        this.pageFormat = pageFormat;
        this.thriftPage = thriftPage;
        this.prestoPage = prestoPage;
    }

    @ThriftField(value=1)
    public ThriftUdfPageFormat getPageFormat() {
        return this.pageFormat;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftPage getThriftPage() {
        return this.thriftPage;
    }

    @Nullable
    @ThriftField(value=3, requiredness=ThriftField.Requiredness.OPTIONAL)
    public ThriftSerializedPage getPrestoPage() {
        return this.prestoPage;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThriftUdfPage other = (ThriftUdfPage)obj;
        return Objects.equals((Object)this.pageFormat, (Object)other.pageFormat) && Objects.equals(this.thriftPage, other.thriftPage) && Objects.equals(this.prestoPage, other.prestoPage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pageFormat, this.thriftPage, this.prestoPage});
    }

    public static ThriftUdfPage thriftPage(PrestoThriftPage thriftPage) {
        return new ThriftUdfPage(ThriftUdfPageFormat.PRESTO_THRIFT, thriftPage, null);
    }

    public static ThriftUdfPage prestoPage(SerializedPage prestoPage) {
        return new ThriftUdfPage(ThriftUdfPageFormat.PRESTO_SERIALIZED, null, new ThriftSerializedPage(prestoPage));
    }
}

