/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.thrift.api.connector;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.thrift.api.connector.PrestoThriftId;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftBlock;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ThriftStruct
public final class PrestoThriftPageResult {
    private final List<PrestoThriftBlock> columnBlocks;
    private final int rowCount;
    private final PrestoThriftId nextToken;

    @ThriftConstructor
    public PrestoThriftPageResult(List<PrestoThriftBlock> columnBlocks, int rowCount, @Nullable PrestoThriftId nextToken) {
        this.columnBlocks = Objects.requireNonNull(columnBlocks, "columnBlocks is null");
        Preconditions.checkArgument((rowCount >= 0 ? 1 : 0) != 0, (Object)"rowCount is negative");
        PrestoThriftPageResult.checkAllColumnsAreOfExpectedSize(columnBlocks, rowCount);
        this.rowCount = rowCount;
        this.nextToken = nextToken;
    }

    @ThriftField(value=1)
    public List<PrestoThriftBlock> getColumnBlocks() {
        return this.columnBlocks;
    }

    @ThriftField(value=2)
    public int getRowCount() {
        return this.rowCount;
    }

    @Nullable
    @ThriftField(value=3, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftId getNextToken() {
        return this.nextToken;
    }

    @Nullable
    public Page toPage(List<Type> columnTypes) {
        if (this.rowCount == 0) {
            return null;
        }
        Preconditions.checkArgument((this.columnBlocks.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columns and types have different sizes");
        int numberOfColumns = this.columnBlocks.size();
        if (numberOfColumns == 0) {
            return new Page(this.rowCount);
        }
        Block[] blocks = new Block[numberOfColumns];
        for (int i = 0; i < numberOfColumns; ++i) {
            blocks[i] = this.columnBlocks.get(i).toBlock(columnTypes.get(i));
        }
        return new Page(blocks);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftPageResult other = (PrestoThriftPageResult)obj;
        return Objects.equals(this.columnBlocks, other.columnBlocks) && this.rowCount == other.rowCount && Objects.equals(this.nextToken, other.nextToken);
    }

    public int hashCode() {
        return Objects.hash(this.columnBlocks, this.rowCount, this.nextToken);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnBlocks", this.columnBlocks).add("rowCount", this.rowCount).add("nextToken", (Object)this.nextToken).toString();
    }

    public static PrestoThriftPageResult fromRecordSet(RecordSet recordSet) {
        List types = recordSet.getColumnTypes();
        int numberOfColumns = types.size();
        int positions = PrestoThriftPageResult.totalRecords(recordSet);
        if (numberOfColumns == 0) {
            return new PrestoThriftPageResult((List<PrestoThriftBlock>)ImmutableList.of(), positions, null);
        }
        ArrayList<PrestoThriftBlock> thriftBlocks = new ArrayList<PrestoThriftBlock>(numberOfColumns);
        for (int columnIndex = 0; columnIndex < numberOfColumns; ++columnIndex) {
            thriftBlocks.add(PrestoThriftBlock.fromRecordSetColumn(recordSet, columnIndex, positions));
        }
        return new PrestoThriftPageResult(thriftBlocks, positions, null);
    }

    private static void checkAllColumnsAreOfExpectedSize(List<PrestoThriftBlock> columnBlocks, int expectedNumberOfRows) {
        for (int i = 0; i < columnBlocks.size(); ++i) {
            Preconditions.checkArgument((columnBlocks.get(i).numberOfRecords() == expectedNumberOfRows ? 1 : 0) != 0, (String)"Incorrect number of records for column with index %s: expected %s, got %s", (Object)i, (Object)expectedNumberOfRows, (Object)columnBlocks.get(i).numberOfRecords());
        }
    }

    private static int totalRecords(RecordSet recordSet) {
        RecordCursor cursor = recordSet.cursor();
        int result = 0;
        while (cursor.advanceNextPosition()) {
            ++result;
        }
        return result;
    }
}

