/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.Column;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementClient;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.util.DateTimeUtils;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.intellij.lang.annotations.Language;

public class TestingPrestoClient
implements Closeable {
    private static final Logger log = Logger.get((String)"TestQueries");
    private static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private final TestingPrestoServer prestoServer;
    private final ConnectorSession defaultSession;
    private final HttpClient httpClient;

    public TestingPrestoClient(TestingPrestoServer prestoServer, ConnectorSession defaultSession) {
        this.prestoServer = (TestingPrestoServer)Preconditions.checkNotNull((Object)prestoServer, (Object)"prestoServer is null");
        this.defaultSession = (ConnectorSession)Preconditions.checkNotNull((Object)defaultSession, (Object)"defaultSession is null");
        this.httpClient = new JettyHttpClient(new HttpClientConfig().setConnectTimeout(new Duration(1.0, TimeUnit.DAYS)).setReadTimeout(new Duration(10.0, TimeUnit.DAYS)));
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    public MaterializedResult execute(@Language(value="SQL") String sql) {
        return this.execute(this.defaultSession, sql);
    }

    public MaterializedResult execute(ConnectorSession session, @Language(value="SQL") String sql) {
        Throwable throwable = null;
        try (StatementClient client = new StatementClient(this.httpClient, QUERY_RESULTS_CODEC, this.toClientSession(session), sql);){
            QueryResults results;
            AtomicBoolean loggedUri = new AtomicBoolean(false);
            ImmutableList.Builder rows = ImmutableList.builder();
            List<Type> types = null;
            while (client.isValid()) {
                results = client.current();
                if (!loggedUri.getAndSet(true)) {
                    log.info("Query %s: %s?pretty", new Object[]{results.getId(), results.getInfoUri()});
                }
                if (types == null && results.getColumns() != null) {
                    types = TestingPrestoClient.getTypes(this.prestoServer.getMetadata(), results.getColumns());
                }
                if (results.getData() != null) {
                    rows.addAll(Iterables.transform((Iterable)results.getData(), TestingPrestoClient.dataToRow(session.getTimeZoneKey(), types)));
                }
                client.advance();
            }
            if (!client.isFailed()) {
                results = new MaterializedResult((List)rows.build(), types);
                return results;
            }
            try {
                QueryError error = client.finalResults().getError();
                assert (error != null);
                if (error.getFailureInfo() != null) {
                    throw error.getFailureInfo().toException();
                }
                throw new RuntimeException("Query failed: " + error.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public List<QualifiedTableName> listTables(ConnectorSession session, String catalog, String schema) {
        return this.prestoServer.getMetadata().listTables(session, new QualifiedTablePrefix(catalog, schema));
    }

    public boolean tableExists(ConnectorSession session, String table) {
        QualifiedTableName name = new QualifiedTableName(session.getCatalog(), session.getSchema(), table);
        Optional handle = this.prestoServer.getMetadata().getTableHandle(session, name);
        return handle.isPresent();
    }

    public ConnectorSession getDefaultSession() {
        return this.defaultSession;
    }

    public TestingPrestoServer getServer() {
        return this.prestoServer;
    }

    public ClientSession toClientSession(ConnectorSession connectorSession) {
        return new ClientSession(this.prestoServer.getBaseUrl(), connectorSession.getUser(), connectorSession.getSource(), connectorSession.getCatalog(), connectorSession.getSchema(), connectorSession.getTimeZoneKey().getId(), connectorSession.getLocale(), true);
    }

    private static Function<List<Object>, MaterializedRow> dataToRow(final TimeZoneKey timeZoneKey, final List<Type> types) {
        return new Function<List<Object>, MaterializedRow>(){

            public MaterializedRow apply(List<Object> data) {
                Preconditions.checkArgument((data.size() == types.size() ? 1 : 0) != 0, (Object)"columns size does not match types size");
                ArrayList<Object> row = new ArrayList<Object>();
                for (int i = 0; i < data.size(); ++i) {
                    Object value = data.get(i);
                    if (value == null) {
                        row.add(null);
                        continue;
                    }
                    Type type = (Type)types.get(i);
                    if (BooleanType.BOOLEAN.equals((Object)type)) {
                        row.add(value);
                        continue;
                    }
                    if (BigintType.BIGINT.equals((Object)type)) {
                        row.add(((Number)value).longValue());
                        continue;
                    }
                    if (DoubleType.DOUBLE.equals((Object)type)) {
                        row.add(((Number)value).doubleValue());
                        continue;
                    }
                    if (VarcharType.VARCHAR.equals((Object)type)) {
                        row.add(value);
                        continue;
                    }
                    if (DateType.DATE.equals((Object)type)) {
                        row.add(new Date(DateTimeUtils.parseDate((String)((String)value))));
                        continue;
                    }
                    if (TimeType.TIME.equals((Object)type)) {
                        row.add(new Time(DateTimeUtils.parseTime((TimeZoneKey)timeZoneKey, (String)((String)value))));
                        continue;
                    }
                    if (TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.equals((Object)type)) {
                        row.add(new Time(DateTimeEncoding.unpackMillisUtc((long)DateTimeUtils.parseTimeWithTimeZone((String)((String)value)))));
                        continue;
                    }
                    if (TimestampType.TIMESTAMP.equals((Object)type)) {
                        row.add(new Timestamp(DateTimeUtils.parseTimestamp((TimeZoneKey)timeZoneKey, (String)((String)value))));
                        continue;
                    }
                    if (TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals((Object)type)) {
                        row.add(new Timestamp(DateTimeEncoding.unpackMillisUtc((long)DateTimeUtils.parseTimestampWithTimeZone((String)((String)value)))));
                        continue;
                    }
                    throw new AssertionError((Object)("unhandled type: " + type));
                }
                return new MaterializedRow(5, row);
            }
        };
    }

    private static List<Type> getTypes(Metadata metadata, List<Column> columns) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(columns, TestingPrestoClient.columnTypeGetter(metadata)));
    }

    private static Function<Column, Type> columnTypeGetter(final Metadata metadata) {
        return new Function<Column, Type>(){

            public Type apply(Column column) {
                String typeName = column.getType();
                Type type = metadata.getType(typeName);
                if (type == null) {
                    throw new AssertionError((Object)("Unhandled type: " + typeName));
                }
                return type;
            }
        };
    }
}

