/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DistinctType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeWithName;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.operator.scalar.JsonFunctions;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.testing.ExpectedQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchRecordSet;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.tpch.TpchTable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.core.statement.StatementContext;
import org.joda.time.DateTimeZone;

public class H2QueryRunner
implements ExpectedQueryRunner {
    private final Handle handle = Jdbi.open((String)("jdbc:h2:mem:test" + System.nanoTime() + "_" + ThreadLocalRandom.current().nextInt()));

    public H2QueryRunner() {
        TpchMetadata tpchMetadata = new TpchMetadata("");
        this.handle.execute("CREATE TABLE orders (\n  orderkey BIGINT PRIMARY KEY,\n  custkey BIGINT NOT NULL,\n  orderstatus CHAR(1) NOT NULL,\n  totalprice DOUBLE NOT NULL,\n  orderdate DATE NOT NULL,\n  orderpriority CHAR(15) NOT NULL,\n  clerk CHAR(15) NOT NULL,\n  shippriority INTEGER NOT NULL,\n  comment VARCHAR(79) NOT NULL\n)", new Object[0]);
        this.handle.execute("CREATE INDEX custkey_index ON orders (custkey)", new Object[0]);
        this.insertRows(tpchMetadata, TpchTable.ORDERS);
        this.handle.execute("CREATE TABLE lineitem (\n  orderkey BIGINT,\n  partkey BIGINT NOT NULL,\n  suppkey BIGINT NOT NULL,\n  linenumber INTEGER,\n  quantity DOUBLE NOT NULL,\n  extendedprice DOUBLE NOT NULL,\n  discount DOUBLE NOT NULL,\n  tax DOUBLE NOT NULL,\n  returnflag CHAR(1) NOT NULL,\n  linestatus CHAR(1) NOT NULL,\n  shipdate DATE NOT NULL,\n  commitdate DATE NOT NULL,\n  receiptdate DATE NOT NULL,\n  shipinstruct VARCHAR(25) NOT NULL,\n  shipmode VARCHAR(10) NOT NULL,\n  comment VARCHAR(44) NOT NULL,\n  PRIMARY KEY (orderkey, linenumber))", new Object[0]);
        this.insertRows(tpchMetadata, TpchTable.LINE_ITEM);
        this.handle.execute(" CREATE TABLE partsupp (\n  partkey BIGINT NOT NULL,\n  suppkey BIGINT NOT NULL,\n  availqty INTEGER NOT NULL,\n  supplycost DOUBLE NOT NULL,\n  comment VARCHAR(199) NOT NULL,\n  PRIMARY KEY(partkey, suppkey))", new Object[0]);
        this.insertRows(tpchMetadata, TpchTable.PART_SUPPLIER);
        this.handle.execute("CREATE TABLE nation (\n  nationkey BIGINT PRIMARY KEY,\n  name VARCHAR(25) NOT NULL,\n  regionkey BIGINT NOT NULL,\n  comment VARCHAR(114) NOT NULL\n)", new Object[0]);
        this.insertRows(tpchMetadata, TpchTable.NATION);
        this.handle.execute("CREATE TABLE region(\n  regionkey BIGINT PRIMARY KEY,\n  name VARCHAR(25) NOT NULL,\n  comment VARCHAR(115) NOT NULL\n)", new Object[0]);
        this.insertRows(tpchMetadata, TpchTable.REGION);
        this.handle.execute("CREATE TABLE part(\n  partkey BIGINT PRIMARY KEY,\n  name VARCHAR(55) NOT NULL,\n  mfgr VARCHAR(25) NOT NULL,\n  brand VARCHAR(10) NOT NULL,\n  type VARCHAR(25) NOT NULL,\n  size INTEGER NOT NULL,\n  container VARCHAR(10) NOT NULL,\n  retailprice DOUBLE NOT NULL,\n  comment VARCHAR(23) NOT NULL\n)", new Object[0]);
        this.insertRows(tpchMetadata, TpchTable.PART);
        this.handle.execute(" CREATE TABLE customer (     \n    custkey BIGINT NOT NULL,         \n    name VARCHAR(25) NOT NULL,       \n    address VARCHAR(40) NOT NULL,    \n    nationkey BIGINT NOT NULL,       \n    phone VARCHAR(15) NOT NULL,      \n    acctbal DOUBLE NOT NULL,         \n    mktsegment VARCHAR(10) NOT NULL, \n    comment VARCHAR(117) NOT NULL    \n ) ", new Object[0]);
        this.insertRows(tpchMetadata, TpchTable.CUSTOMER);
        this.handle.execute(" CREATE TABLE supplier ( \n    suppkey bigint NOT NULL,         \n    name varchar(25) NOT NULL,       \n    address varchar(40) NOT NULL,    \n    nationkey bigint NOT NULL,       \n    phone varchar(15) NOT NULL,      \n    acctbal double NOT NULL,         \n    comment varchar(101) NOT NULL    \n ) ", new Object[0]);
        this.insertRows(tpchMetadata, TpchTable.SUPPLIER);
    }

    private void insertRows(TpchMetadata tpchMetadata, TpchTable tpchTable) {
        TpchTableHandle tableHandle = tpchMetadata.getTableHandle(null, new SchemaTableName("tiny", tpchTable.getTableName()));
        H2QueryRunner.insertRows(tpchMetadata.getTableMetadata(null, (ConnectorTableHandle)tableHandle), this.handle, (RecordSet)TpchRecordSet.createTpchRecordSet((TpchTable)tpchTable, (double)tableHandle.getScaleFactor()));
    }

    public void close() {
        this.handle.close();
    }

    public MaterializedResult execute(Session session, @Language(value="SQL") String sql, List<? extends Type> resultTypes) {
        MaterializedResult materializedRows = new MaterializedResult(((Handle)((Handle)this.handle.setSqlParser((SqlParser)new RawSqlParser())).setTemplateEngine((template, context) -> template)).createQuery(sql).map(H2QueryRunner.rowMapper(resultTypes)).list(), resultTypes);
        return materializedRows;
    }

    public Handle getHandle() {
        return this.handle;
    }

    private static RowMapper<MaterializedRow> rowMapper(final List<? extends Type> types) {
        return new RowMapper<MaterializedRow>(){

            private Object getValue(Type type, ResultSet resultSet, int position) throws SQLException {
                if (BooleanType.BOOLEAN.equals((Object)type)) {
                    boolean booleanValue = resultSet.getBoolean(position);
                    return resultSet.wasNull() ? null : Boolean.valueOf(booleanValue);
                }
                if (TinyintType.TINYINT.equals((Object)type)) {
                    byte byteValue = resultSet.getByte(position);
                    return resultSet.wasNull() ? null : Byte.valueOf(byteValue);
                }
                if (SmallintType.SMALLINT.equals((Object)type)) {
                    short shortValue = resultSet.getShort(position);
                    return resultSet.wasNull() ? null : Short.valueOf(shortValue);
                }
                if (IntegerType.INTEGER.equals((Object)type)) {
                    int intValue = resultSet.getInt(position);
                    return resultSet.wasNull() ? null : Integer.valueOf(intValue);
                }
                if (BigintType.BIGINT.equals((Object)type)) {
                    long longValue = resultSet.getLong(position);
                    return resultSet.wasNull() ? null : Long.valueOf(longValue);
                }
                if (RealType.REAL.equals((Object)type)) {
                    float floatValue = resultSet.getFloat(position);
                    return resultSet.wasNull() ? null : Float.valueOf(floatValue);
                }
                if (DoubleType.DOUBLE.equals((Object)type)) {
                    double doubleValue = resultSet.getDouble(position);
                    return resultSet.wasNull() ? null : Double.valueOf(doubleValue);
                }
                if (Varchars.isVarcharType((Type)type)) {
                    String stringValue = resultSet.getString(position);
                    return resultSet.wasNull() ? null : stringValue;
                }
                if (Chars.isCharType((Type)type)) {
                    String stringValue = resultSet.getString(position);
                    return resultSet.wasNull() ? null : Strings.padEnd((String)stringValue, (int)((CharType)type).getLength(), (char)' ');
                }
                if (VarbinaryType.VARBINARY.equals((Object)type)) {
                    byte[] binary = resultSet.getBytes(position);
                    return resultSet.wasNull() ? null : binary;
                }
                if (JsonType.JSON.equals((Object)type)) {
                    String stringValue = resultSet.getString(position);
                    return resultSet.wasNull() ? null : JsonFunctions.jsonParse((Slice)Slices.utf8Slice((String)stringValue)).toStringUtf8();
                }
                if (DateType.DATE.equals((Object)type)) {
                    LocalDate dateValue = resultSet.getObject(position, LocalDate.class);
                    return resultSet.wasNull() ? null : dateValue;
                }
                if (TimeType.TIME.equals((Object)type)) {
                    LocalTime timeValue = resultSet.getObject(position, LocalTime.class);
                    return resultSet.wasNull() ? null : timeValue;
                }
                if (TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.equals((Object)type)) {
                    throw new UnsupportedOperationException("H2 does not support TIME WITH TIME ZONE");
                }
                if (TimestampType.TIMESTAMP.equals((Object)type)) {
                    LocalDateTime timestampValue;
                    try {
                        timestampValue = resultSet.getObject(position, LocalDateTime.class);
                    }
                    catch (SQLException first) {
                        try {
                            timestampValue = Optional.ofNullable(resultSet.getObject(position, LocalDate.class)).map(LocalDate::atStartOfDay).orElse(null);
                        }
                        catch (RuntimeException e) {
                            first.addSuppressed(e);
                            throw first;
                        }
                    }
                    return resultSet.wasNull() ? null : timestampValue;
                }
                if (TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals((Object)type)) {
                    OffsetDateTime timestampValue = resultSet.getObject(position, OffsetDateTime.class);
                    return resultSet.wasNull() ? null : timestampValue.toZonedDateTime().withZoneSameInstant(ZoneId.of("UTC"));
                }
                if (UnknownType.UNKNOWN.equals((Object)type)) {
                    Object objectValue = resultSet.getObject(position);
                    Preconditions.checkState((boolean)resultSet.wasNull(), (String)"Expected a null value, but got %s", (Object)objectValue);
                    return null;
                }
                if (type instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)type;
                    BigDecimal decimalValue = resultSet.getBigDecimal(position);
                    return resultSet.wasNull() ? null : decimalValue.setScale(decimalType.getScale(), 4).round(new MathContext(decimalType.getPrecision()));
                }
                if (type instanceof ArrayType) {
                    Array array = resultSet.getArray(position);
                    return resultSet.wasNull() ? null : Lists.newArrayList((Object[])H2QueryRunner.mapArrayValues((ArrayType)type, (Object[])array.getArray()));
                }
                if (type instanceof RowType) {
                    Array array = resultSet.getArray(position);
                    return resultSet.wasNull() ? null : Lists.newArrayList((Object[])H2QueryRunner.mapRowValues((RowType)type, (Object[])array.getArray()));
                }
                if (type instanceof TypeWithName) {
                    return this.getValue(((TypeWithName)type).getType(), resultSet, position);
                }
                if (type instanceof DistinctType) {
                    return this.getValue(((DistinctType)type).getBaseType(), resultSet, position);
                }
                throw new AssertionError((Object)("unhandled type: " + String.valueOf(type)));
            }

            public MaterializedRow map(ResultSet resultSet, StatementContext context) throws SQLException {
                int count = resultSet.getMetaData().getColumnCount();
                Preconditions.checkArgument((types.size() == count ? 1 : 0) != 0, (String)"expected types count (%s) does not match actual column count (%s)", (int)types.size(), (int)count);
                ArrayList<Object> row = new ArrayList<Object>(count);
                for (int i = 1; i <= count; ++i) {
                    row.add(this.getValue((Type)types.get(i - 1), resultSet, i));
                }
                return new MaterializedRow(5, row);
            }
        };
    }

    private static Object[] mapArrayValues(ArrayType arrayType, Object[] values) {
        Type elementType = arrayType.getElementType();
        if (elementType instanceof ArrayType) {
            return Arrays.stream(values).map(v -> v == null ? null : Lists.newArrayList((Object[])((Object[])v))).toArray();
        }
        if (elementType instanceof RowType) {
            RowType rowType = (RowType)elementType;
            return Arrays.stream(values).map(v -> v == null ? null : Lists.newArrayList((Object[])H2QueryRunner.mapRowValues(rowType, (Object[])v))).toArray();
        }
        if (elementType instanceof CharType) {
            int length = ((CharType)elementType).getLength();
            return Arrays.stream(values).map(String.class::cast).map(v -> v == null ? null : Strings.padEnd((String)v, (int)length, (char)' ')).toArray();
        }
        if (elementType instanceof TimestampType) {
            return Arrays.stream(values).map(v -> v == null ? null : ((Timestamp)v).toLocalDateTime()).toArray();
        }
        if (elementType instanceof DateType) {
            return Arrays.stream(values).map(v -> v == null ? null : ((Date)v).toLocalDate()).toArray();
        }
        return values;
    }

    private static Object[] mapRowValues(RowType rowType, Object[] values) {
        int fieldCount = rowType.getFields().size();
        Object[] fields = new Object[fieldCount];
        for (int j = 0; j < fieldCount; ++j) {
            Type fieldType = (Type)rowType.getTypeParameters().get(j);
            fields[j] = fieldType instanceof RowType ? Lists.newArrayList((Object[])H2QueryRunner.mapRowValues((RowType)fieldType, (Object[])values[j])) : values[j];
        }
        return fields;
    }

    private static void insertRows(ConnectorTableMetadata tableMetadata, Handle handle, RecordSet data) {
        List columns = (List)tableMetadata.getColumns().stream().filter(columnMetadata -> !columnMetadata.isHidden()).collect(ImmutableList.toImmutableList());
        String vars = Joiner.on((char)',').join(Collections.nCopies(columns.size(), "?"));
        String sql = String.format("INSERT INTO %s VALUES (%s)", tableMetadata.getTable().getTableName(), vars);
        RecordCursor cursor = data.cursor();
        while (true) {
            PreparedBatch batch = handle.prepareBatch(sql);
            for (int row = 0; row < 1000; ++row) {
                if (!cursor.advanceNextPosition()) {
                    if (batch.size() > 0) {
                        batch.execute();
                    }
                    return;
                }
                for (int column = 0; column < columns.size(); ++column) {
                    Type type = ((ColumnMetadata)columns.get(column)).getType();
                    if (BooleanType.BOOLEAN.equals((Object)type)) {
                        batch.bind(column, cursor.getBoolean(column));
                        continue;
                    }
                    if (BigintType.BIGINT.equals((Object)type)) {
                        batch.bind(column, cursor.getLong(column));
                        continue;
                    }
                    if (IntegerType.INTEGER.equals((Object)type)) {
                        batch.bind(column, (int)cursor.getLong(column));
                        continue;
                    }
                    if (DoubleType.DOUBLE.equals((Object)type)) {
                        batch.bind(column, cursor.getDouble(column));
                        continue;
                    }
                    if (type instanceof VarcharType) {
                        batch.bind(column, cursor.getSlice(column).toStringUtf8());
                        continue;
                    }
                    if (DateType.DATE.equals((Object)type)) {
                        long millisUtc = TimeUnit.DAYS.toMillis(cursor.getLong(column));
                        long localMillis = DateTimeZone.UTC.getMillisKeepLocal(DateTimeZone.getDefault(), millisUtc);
                        batch.bind(column, new Date(localMillis));
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported type " + String.valueOf(type));
                }
                batch.add();
            }
            batch.execute();
        }
    }

    private static class RawSqlParser
    implements SqlParser {
        private RawSqlParser() {
        }

        public ParsedSql parse(String sql, StatementContext ctx) {
            return ParsedSql.builder().append(sql).build();
        }

        public String nameParameter(String rawName, StatementContext ctx) {
            throw new UnsupportedOperationException();
        }
    }
}

