/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.drift.transport.netty.client.DriftNettyClientModule;
import com.facebook.presto.functionNamespace.execution.SimpleAddressSqlFunctionExecutorsModule;
import com.facebook.presto.functionNamespace.mysql.MySqlFunctionNamespaceManager;
import com.facebook.presto.functionNamespace.mysql.MySqlFunctionNamespaceManagerModule;
import com.facebook.presto.spi.function.FunctionHandleResolver;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceManagerContext;
import com.facebook.presto.spi.function.FunctionNamespaceManagerFactory;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.tests.H2ConnectionModule;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;

public class H2FunctionNamespaceManagerFactory
implements FunctionNamespaceManagerFactory {
    public static final String NAME = "h2";
    private static final SqlFunctionHandle.Resolver HANDLE_RESOLVER = SqlFunctionHandle.Resolver.getInstance();

    public String getName() {
        return NAME;
    }

    public FunctionHandleResolver getHandleResolver() {
        return HANDLE_RESOLVER;
    }

    public FunctionNamespaceManager<?> create(String catalogName, Map<String, String> config, FunctionNamespaceManagerContext context) {
        try {
            Bootstrap app = new Bootstrap(new Module[]{new DriftNettyClientModule(), new MySqlFunctionNamespaceManagerModule(catalogName), new H2ConnectionModule(), new SimpleAddressSqlFunctionExecutorsModule()});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (FunctionNamespaceManager)injector.getInstance(MySqlFunctionNamespaceManager.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

