/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import org.testng.annotations.Test;

public abstract class AbstractTestSqlInvokedFunctions
extends AbstractTestQueryFramework {
    @Test
    public void testArraySplitIntoChunks() {
        String sql = "select array_split_into_chunks(array[1, 2, 3, 4, 5, 6], 2)";
        this.assertQuery(sql, "values array[array[1, 2], array[3, 4], array[5, 6]]");
        sql = "select array_split_into_chunks(array[1, 2, 3, 4, 5], 3)";
        this.assertQuery(sql, "values array[array[1, 2, 3], array[4, 5]]");
        sql = "select array_split_into_chunks(array[1, 2, 3], 5)";
        this.assertQuery(sql, "values array[array[1, 2, 3]]");
        sql = "select array_split_into_chunks(null, 2)";
        this.assertQuery(sql, "values null");
        sql = "select array_split_into_chunks(array[1, 2, 3], 0)";
        this.assertQueryFails(sql, ".*Invalid slice size: 0. Size must be greater than zero.*");
        sql = "select array_split_into_chunks(array[1, 2, 3], -1)";
        this.assertQueryFails(sql, ".*Invalid slice size: -1. Size must be greater than zero.*");
        sql = "select array_split_into_chunks(array[1, null, 3, null, 5], 2)";
        this.assertQuery(sql, "values array[array[1, null], array[3, null], array[5]]");
        sql = "select array_split_into_chunks(array['a', 'b', 'c', 'd'], 2)";
        this.assertQuery(sql, "values array[array['a', 'b'], array['c', 'd']]");
        sql = "select array_split_into_chunks(array[1.1, 2.2, 3.3, 4.4, 5.5], 2)";
        this.assertQuery(sql, "values array[array[1.1, 2.2], array[3.3, 4.4], array[5.5]]");
        sql = "select array_split_into_chunks(array[null, null, null], 0)";
        this.assertQueryFails(sql, ".*Invalid slice size: 0. Size must be greater than zero.*");
        sql = "select array_split_into_chunks(array[null, null, null], 2)";
        this.assertQuery(sql, "values array[array[null, null], array[null]]");
        sql = "select array_split_into_chunks(array[null, 1, 2], 5)";
        this.assertQuery(sql, "values array[array[null, 1, 2]]");
        sql = "select array_split_into_chunks(array[], 0)";
        this.assertQueryFails(sql, ".*Invalid slice size: 0. Size must be greater than zero.*");
    }

    @Test
    public void testCrossJoinWithArrayNotContainsCondition() {
        Session enableOptimization = Session.builder((Session)this.getSession()).setSystemProperty("push_down_filter_expression_evaluation_through_cross_join", "REWRITTEN_TO_INNER_JOIN").setSystemProperty("rewrite_cross_join_array_not_contains_to_anti_join", "true").build();
        String sql = "with t1 as (select * from (values (array[1, 2, 3])) t(arr)), t2 as (select * from (values (1, 'a'), (4, 'b')) t(k, v)) select t2.k, t2.v from t2 where not contains((select t1.arr from t1), t2.k)";
        this.assertQuery(enableOptimization, sql, "values (4, 'b')");
        sql = "with t1 as (select * from (values (array[1, 2, 3, 3, null])) t(arr)), t2 as (select * from (values (1, 'a'), (4, 'b')) t(k, v)) select t2.k, t2.v from t2 where not contains((select t1.arr from t1), t2.k)";
        this.assertQuery(enableOptimization, sql, "values (4, 'b')");
        sql = "with t1 as (select * from (values (1, 'JAPAN'), (2, 'invalid_nation')) t(k, nation)) select t1.k, t1.nation from t1 where not contains((select array_agg(name) from nation), t1.nation)";
        this.assertQuery(enableOptimization, sql, "values (2, 'invalid_nation')");
        sql = "with t1 as (select * from (values (1, 'JAPAN'), (2, 'invalid_nation')) t(k, nation)) select t1.k, t1.nation from t1 where not contains(array_distinct((select array_agg(name) from nation)), t1.nation)";
        this.assertQuery(enableOptimization, sql, "values (2, 'invalid_nation')");
        sql = "with t1 as (select * from (values (array[1, 1, 3], 10)) t(arr, k)), t2 as (select * from (values (1, 'a'), (4, 'b')) t(k, v)) select t1.k, t2.k, t2.v from t1 join t2 on not contains(t1.arr, t2.k)";
        this.assertQuery(enableOptimization, sql, "values (10, 4, 'b')");
        sql = "with t1 as (select * from (values (array[1, 2, 3]), (array[4, 5, 6])) t(arr)), t2 as (select * from (values (1, 'a'), (4, 'b')) t(k, v)) select t1.arr, t2.k, t2.v from t1 join t2 on not contains(t1.arr, t2.k)";
        this.assertQuery(enableOptimization, sql, "values (array[1,2,3], 4, 'b'), (array[4,5,6], 1, 'a')");
        sql = "with t1 as (select * from (values (array[1, 2, 3])) t(arr)), t2 as (select * from (values (1, 'a'), (4, 'b')) t(k, v)) select t2.k, t2.v from t1 join t2 on not contains(t1.arr, t2.k)";
        this.assertQuery(enableOptimization, sql, "values (4, 'b')");
        sql = "with t1 as (select * from (values (array[1, 2, 3])) t(arr)), t2 as (select * from (values (1, 'a'), (4, 'b')) t(k, v)) select t1.arr, t2.k, t2.v from t1 join t2 on not contains(t1.arr, t2.k)";
        this.assertQuery(enableOptimization, sql, "values (array[1,2,3], 4, 'b')");
        sql = "with t1 as (select * from (values (1, 'JAPAN'), (2, 'invalid_nation')) t(k, nation)) select t1.k, t1.nation from t1 where not contains(transform((select array_agg(name) from nation), (x) ->lower(x)), lower(t1.nation))";
        this.assertQuery(enableOptimization, sql, "values (2, 'invalid_nation')");
    }

    @Test
    public void testDefaultSamplingPercent() {
        this.assertQuery("select key_sampling_percent('abc')", "select 0.56");
    }

    @Test
    public void testKeyBasedSampling() {
        String[] queries = new String[]{"select count(1) from orders join lineitem using(orderkey)", "select count(1) from (select custkey, max(orderkey) from orders group by custkey)", "select count_if(m >= 1) from (select max(orderkey) over(partition by custkey) m from orders)", "select cast(m as bigint) from (select sum(totalprice) over(partition by custkey order by comment) m from orders order by 1 desc limit 1)", "select count(1) from lineitem where orderkey in (select orderkey from orders where length(comment) > 7)", "select count(1) from lineitem where orderkey not in (select orderkey from orders where length(comment) > 27)", "select count(1) from (select distinct orderkey, custkey from orders)"};
        int[] unsampledResults = new int[]{60175, 1000, 15000, 5408941, 60175, 9256, 15000};
        for (int i = 0; i < queries.length; ++i) {
            this.assertQuery(queries[i], "select " + unsampledResults[i]);
        }
        Session sessionWithKeyBasedSampling = Session.builder((Session)this.getSession()).setSystemProperty("key_based_sampling_enabled", "true").setSystemProperty("key_based_sampling_percentage", "0.2").build();
        int[] sampled20PercentResults = new int[]{37170, 616, 9189, 5408941, 37170, 5721, 9278};
        for (int i = 0; i < queries.length; ++i) {
            this.assertQuery(sessionWithKeyBasedSampling, queries[i], "select " + sampled20PercentResults[i]);
        }
        sessionWithKeyBasedSampling = Session.builder((Session)this.getSession()).setSystemProperty("key_based_sampling_enabled", "true").setSystemProperty("key_based_sampling_percentage", "0.1").build();
        int[] sampled10PercentResults = new int[]{33649, 557, 8377, 4644937, 33649, 5098, 8397};
        for (int i = 0; i < queries.length; ++i) {
            this.assertQuery(sessionWithKeyBasedSampling, queries[i], "select " + sampled10PercentResults[i]);
        }
    }

    @Test
    public void testLeftJoinWithArrayContainsCondition() {
        Session enableOptimization = Session.builder((Session)this.getSession()).setSystemProperty("rewrite_left_join_array_contains_to_equi_join", "ALWAYS_ENABLED").build();
        String sql = "with t1 as (select * from (values (array[1, 2, 3], 10), (array[4, 5, 6], 11)) t(arr, k)), t2 as (select * from (values (1, 'a'), (4, 'b')) t(k, v)) select t1.k, t2.k, t2.v from t2 left join t1 on contains(t1.arr, t2.k)";
        this.assertQuery(enableOptimization, sql, "values (10, 1, 'a'), (11, 4, 'b')");
        sql = "with t1 as (select * from (values (array[1, 2, 3, null], 10), (array[4, 5, 6, null, null], 11)) t(arr, k)), t2 as (select * from (values (1, 'a'), (4, 'b')) t(k, v)) select t1.k, t2.k, t2.v from t2 left join t1 on contains(t1.arr, t2.k)";
        this.assertQuery(enableOptimization, sql, "values (10, 1, 'a'), (11, 4, 'b')");
        sql = "with t1 as (select * from (values (array[1, 2, 3], 10), (array[4, 5, 6], 11), (array[null, 9], 12)) t(arr, k)), t2 as (select * from (values (1, 'a'), (4, 'b'), (null, 'c'), (9, 'd'), (8, 'd')) t(k, v)) select t1.k, t2.k, t2.v from t2 left join t1 on contains(t1.arr, t2.k)";
        this.assertQuery(enableOptimization, sql, "values (10, 1, 'a'), (11, 4, 'b'), (null, null, 'c'), (12, 9, 'd'), (null, 8, 'd')");
        sql = "with t1 as (select * from (values (array[1, 2, 3, null, null], 10), (array[4, 5, 6, null, null], 11), (array[null, 9], 12)) t(arr, k)), t2 as (select * from (values (1, 'a'), (4, 'b'), (null, 'c'), (9, 'd'), (8, 'd')) t(k, v)) select t1.k, t2.k, t2.v from t2 left join t1 on contains(t1.arr, t2.k)";
        this.assertQuery(enableOptimization, sql, "values (10, 1, 'a'), (11, 4, 'b'), (null, null, 'c'), (12, 9, 'd'), (null, 8, 'd')");
        sql = "with t1 as (select * from (values (array[1, 1, 3], 10), (array[4, 4, 6], 11)) t(arr, k)), t2 as (select * from (values (1, 'a'), (4, 'b')) t(k, v)) select t1.k, t2.k, t2.v from t2 left join t1 on contains(t1.arr, t2.k)";
        this.assertQuery(enableOptimization, sql, "values (10, 1, 'a'), (11, 4, 'b')");
        sql = "with t1 as (select * from (values (array[1, 1, 3, null, null], 10), (array[4, 4, 6, null, null], 11)) t(arr, k)), t2 as (select * from (values (1, 'a'), (4, 'b')) t(k, v)) select t1.k, t2.k, t2.v from t2 left join t1 on contains(t1.arr, t2.k)";
        this.assertQuery(enableOptimization, sql, "values (10, 1, 'a'), (11, 4, 'b')");
        sql = "with t1 as (select * from (values (array[1, null, 3], 10), (array[4, null, 6], 11)) t(arr, k)), t2 as (select * from (values (1, 'a'), (null, 'b')) t(k, v)) select t1.k, t2.k, t2.v from t2 left join t1 on contains(t1.arr, t2.k)";
        this.assertQuery(enableOptimization, sql, "values (10, 1, 'a'), (NULL, NULL, 'b')");
        sql = "with t1 as (select * from (values (array[1, 2, 3], 10), (array[4, 5, 6], 11)) t(arr, k)), t2 as (select * from (values (1, 'a'), (4, 'b')) t(k, v)) select t1.k, t2.k, t2.v from t2 left join t1 on contains(t1.arr, t2.k) and t1.k > 10";
        this.assertQuery(enableOptimization, sql, "values (NULL, 1, 'a'), (11, 4, 'b')");
        sql = "with t1 as (select * from (values (array[1, 2, 3], 1), (array[4, 5, 6], 11)) t(arr, k)), t2 as (select * from (values (1, 'a'), (4, 'b')) t(k, v)) select t1.k, t2.k, t2.v from t2 left join t1 on contains(t1.arr, t2.k) or t1.k = t2.k";
        this.assertQuery(enableOptimization, sql, "values (1, 1, 'a'), (11, 4, 'b')");
        sql = "with t1 as (select array_agg(orderkey) orderkey, partkey from lineitem l where l.quantity < 5 group by partkey) select t1.partkey, o.orderkey, o.totalprice from orders o left join t1 on contains(t1.orderkey, o.orderkey) where o.totalprice < 2000";
        String h2Sql = "with t1 as (select array_agg(orderkey) orderkey, partkey from lineitem l where l.quantity < 5 group by partkey) select t1.partkey, o.orderkey, o.totalprice from orders o left join t1 on array_contains(t1.orderkey, o.orderkey) where o.totalprice < 2000";
        this.assertQuery(enableOptimization, sql, h2Sql);
        sql = "with t1 as (select array_agg(orderkey) orderkey, partkey from lineitem l where l.quantity < 5 group by partkey) select t1.partkey, o.orderkey, o.totalprice from orders o left join t1 on contains(t1.orderkey, o.orderkey) and t1.partkey < o.orderkey where o.totalprice < 2000";
        h2Sql = "with t1 as (select array_agg(orderkey) orderkey, partkey from lineitem l where l.quantity < 5 group by partkey) select t1.partkey, o.orderkey, o.totalprice from orders o left join t1 on array_contains(t1.orderkey, o.orderkey) and t1.partkey < o.orderkey where o.totalprice < 2000";
        this.assertQuery(enableOptimization, sql, h2Sql);
        sql = "with t1 as (select * from (values (array[cast(1 as bigint), 2, 3], 10), (array[4, 5, 6], 11)) t(arr, k)), t2 as (select * from (values (cast(1 as integer), 'a'), (4, 'b')) t(k, v)) select t1.k, t2.k, t2.v from t2 left join t1 on contains(t1.arr, t2.k)";
        this.assertQuery(enableOptimization, sql, "values (11, 4, 'b'), (10, 1, 'a')");
        sql = "with t1 as (select * from (values (array[cast(1 as integer), 2, 3], 10), (array[4, 5, 6], 11)) t(arr, k)), t2 as (select * from (values (cast(1 as bigint), 'a'), (4, 'b')) t(k, v)) select t1.k, t2.k, t2.v from t2 left join t1 on contains(t1.arr, t2.k)";
        this.assertQuery(enableOptimization, sql, "values (11, 4, 'b'), (10, 1, 'a')");
    }

    @Test
    public void testKeyBasedSamplingFunctionError() {
        Session sessionWithKeyBasedSampling = Session.builder((Session)this.getSession()).setSystemProperty("key_based_sampling_enabled", "true").setSystemProperty("key_based_sampling_function", "blah").build();
        this.assertQueryFails(sessionWithKeyBasedSampling, "select count(1) from orders join lineitem using(orderkey)", "Sampling function: blah not cannot be resolved");
    }

    @Test
    public void testSamplingJoinChain() {
        Session sessionWithKeyBasedSampling = Session.builder((Session)this.getSession()).setSystemProperty("key_based_sampling_enabled", "true").build();
        String sql = "select count(1) FROM lineitem l left JOIN orders o ON l.orderkey = o.orderkey JOIN customer c ON o.custkey = c.custkey";
        this.assertQuery(sql, "select 60175");
        this.assertQuery(sessionWithKeyBasedSampling, sql, "select 16185");
    }

    @Test
    public void testTry() {
        this.assertQuery("SELECT\n    TRY(map_keys_by_top_n_values(c0, BIGINT '6455219767830808341'))\nFROM (\n    VALUES\n        MAP(\n            ARRAY[1, 2], ARRAY[\n                ARRAY[1, null],\n                ARRAY[1, null]\n            ]\n        )\n) t(c0)", "SELECT NULL");
        this.assertQuery("SELECT\n    TRY(map_keys_by_top_n_values(c0, BIGINT '6455219767830808341'))\nFROM (\n    VALUES\n        MAP(\n            ARRAY[1, 2], ARRAY[\n                ARRAY[null, null],\n                ARRAY[1, 2]\n            ]\n        )\n) t(c0)", "SELECT NULL");
        this.assertQuery("SELECT TRY(ARRAY_MAX(ARRAY [ARRAY[1, NULL], ARRAY[1, 2]]))", "SELECT NULL");
    }
}

