/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.sql;

import com.facebook.presto.tests.sql.SqlExecutor;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class TestTable
implements AutoCloseable {
    private static final SecureRandom random = new SecureRandom();
    private static final int RANDOM_SUFFIX_LENGTH = 10;
    private final SqlExecutor sqlExecutor;
    private final String name;
    private static final AtomicInteger instanceCounter = new AtomicInteger();

    public TestTable(SqlExecutor sqlExecutor, String namePrefix, String createDdlTemplate) {
        this.sqlExecutor = sqlExecutor;
        this.name = namePrefix + "_" + instanceCounter.incrementAndGet();
        sqlExecutor.execute(createDdlTemplate.replace("{TABLE_NAME}", this.name));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        this.sqlExecutor.execute("DROP TABLE " + this.name);
    }

    public static String randomTableSuffix() {
        String randomSuffix = Long.toString(Math.abs(random.nextLong()), 36);
        return randomSuffix.substring(0, Math.min(10, randomSuffix.length()));
    }
}

