/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.BuiltInFunction;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.operator.scalar.ApplyFunction;
import com.facebook.presto.operator.scalar.InvokeFunction;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestngUtils;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.CreateHll;
import com.facebook.presto.tests.CustomAdd;
import com.facebook.presto.tests.CustomRank;
import com.facebook.presto.tests.CustomSum;
import com.facebook.presto.tests.QueryAssertions;
import com.facebook.presto.tests.QueryTemplate;
import com.facebook.presto.tests.StatefulSleepingSum;
import com.facebook.presto.tests.StructuralTestUtil;
import com.facebook.presto.type.SqlIntervalDayTime;
import com.facebook.presto.type.SqlIntervalYearMonth;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import io.airlift.tpch.TpchTable;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class AbstractTestQueries
extends AbstractTestQueryFramework {
    public static final List<SqlFunction> CUSTOM_FUNCTIONS = new FunctionListBuilder().aggregates(CustomSum.class).window(CustomRank.class).scalars(CustomAdd.class).scalars(CreateHll.class).functions(new BuiltInFunction[]{ApplyFunction.APPLY_FUNCTION, InvokeFunction.INVOKE_FUNCTION, StatefulSleepingSum.STATEFUL_SLEEPING_SUM}).getFunctions();
    public static final List<PropertyMetadata<?>> TEST_SYSTEM_PROPERTIES = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"test_string", (String)"test string property", (String)"test default", (boolean)false), (Object)PropertyMetadata.longProperty((String)"test_long", (String)"test long property", (Long)42L, (boolean)false));
    public static final List<PropertyMetadata<?>> TEST_CATALOG_PROPERTIES = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"connector_string", (String)"connector string property", (String)"connector default", (boolean)false), (Object)PropertyMetadata.longProperty((String)"connector_long", (String)"connector long property", (Long)33L, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"connector_boolean", (String)"connector boolean property", (Boolean)true, (boolean)false), (Object)PropertyMetadata.doubleProperty((String)"connector_double", (String)"connector double property", (Double)99.0, (boolean)false));
    private static final DateTimeFormatter ZONED_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSS VV");
    private static final String UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG = "line .*: Given correlated subquery is not supported";

    @Test
    public void testParsingError() {
        this.assertQueryFails("SELECT foo FROM", "line 1:16: mismatched input '<EOF>'. Expecting: .*");
    }

    @Test
    public void testSelectLargeInterval() {
        MaterializedResult result = this.computeActual("SELECT INTERVAL '30' DAY");
        Assert.assertEquals((int)result.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)result.getMaterializedRows().get(0)).getField(0), (Object)new SqlIntervalDayTime(30, 0, 0, 0, 0));
        result = this.computeActual("SELECT INTERVAL '32767' YEAR");
        Assert.assertEquals((int)result.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)result.getMaterializedRows().get(0)).getField(0), (Object)new SqlIntervalYearMonth(Short.MAX_VALUE, 0));
    }

    @Test(enabled=false)
    public void testEmptyJoins() {
        Session sessionWithEmptyJoin = Session.builder((Session)this.getSession()).setSystemProperty("optimize_joins_with_empty_sources", "true").build();
        Session sessionWithoutEmptyJoin = Session.builder((Session)this.getSession()).setSystemProperty("optimize_joins_with_empty_sources", "false").build();
        this.emptyJoinQueries(sessionWithEmptyJoin);
        this.emptyJoinQueries(sessionWithoutEmptyJoin);
    }

    private void emptyJoinQueries(Session session) {
        this.assertQuery(session, "select 1 from (select * from orders where 1 = 0) DT join customer on DT.custkey=customer.custkey", "select 1 from orders where 1 =0");
        this.assertQuery(session, "select 1 from (select * from orders where 1 = 0) DT left outer join customer on DT.custkey=customer.custkey", "select 1 from orders where 1 =0");
        this.assertQuery(session, "select 1 from (select * from orders where 1 = 0) DT left outer join customer C1 on DT.custkey=C1.custkey left outer join customer C2 on C1.custkey=C2.custkey", "select 1 from orders where 1 =0");
        this.assertQuery(session, "select 1 from (select * from orders LIMIT 0) DT join customer on DT.custkey=customer.custkey", "select 1 from orders where 1 =0");
        this.assertQuery(session, "select 1 from (select * from orders) DT join customer on DT.custkey=customer.custkey", "select 1 from orders");
        this.assertQuery(session, "select 1 from (select * from orders) ORD left outer join (select custkey from customer where 1=0) CUST on ORD.custkey=CUST.custkey", "select 1 from orders");
        this.assertQuery(session, "select One from (select * from orders) ORD left outer join (select 1 as One, custkey from customer where 1=0) CUST on ORD.custkey=CUST.custkey", "select null as One from orders");
        this.assertQuery(session, "select One from (select 1 as One, custkey from customer where 1=0) CUST right outer join (select * from orders) ORD  ON ORD.custkey=CUST.custkey", "select null as One from orders");
        this.assertQuery(session, "select 1 from (select * from orders where 1 = 0) DT left outer join customer C1 on DT.custkey=C1.custkey right outer join orders O2 on C1.custkey=O2.custkey", "select 1 from orders");
        this.assertQuery(session, "select 1 from (select * from orders) ORD full outer join (select custkey from customer where 1=0) CUST on ORD.custkey=CUST.custkey", "select 1 from orders");
        this.assertQuery(session, "select count(*), orderkey from (select * from orders) ORD full outer join (select custkey from customer where 1=0) CUST on ORD.custkey=CUST.custkey group by orderkey order by orderkey", "select count(*), orderkey from orders group by orderkey order by orderkey");
    }

    @Test
    public void testSelectNull() {
        this.assertQuery("SELECT NULL");
    }

    @Test
    public void testAggregationOverUnknown() {
        this.assertQuery("SELECT clerk, min(totalprice), max(totalprice), min(nullvalue), max(nullvalue) FROM (SELECT clerk, totalprice, null AS nullvalue FROM orders) GROUP BY clerk");
    }

    @Test
    public void testLimitIntMax() {
        this.assertQuery("SELECT orderkey FROM orders LIMIT 2147483647");
        this.assertQuery("SELECT orderkey FROM orders ORDER BY orderkey LIMIT 2147483647");
    }

    @Test
    public void testNonDeterministic() {
        MaterializedResult materializedResult = this.computeActual("SELECT rand() FROM orders LIMIT 10");
        long distinctCount = materializedResult.getMaterializedRows().stream().map(row -> row.getField(0)).distinct().count();
        org.testng.Assert.assertTrue((distinctCount >= 8L ? 1 : 0) != 0, (String)"rand() must produce different rows");
        materializedResult = this.computeActual("SELECT apply(1, x -> x + rand()) FROM orders LIMIT 10");
        distinctCount = materializedResult.getMaterializedRows().stream().map(row -> row.getField(0)).distinct().count();
        org.testng.Assert.assertTrue((distinctCount >= 8L ? 1 : 0) != 0, (String)"rand() must produce different rows");
    }

    @Test
    public void testLambdaCapture() {
        this.assertQuery("SELECT apply(0, x -> x + c1) FROM (VALUES 1) t(c1)", "VALUES 1");
        this.assertQuery("SELECT apply(0, x -> x + t.c1) FROM (VALUES 1) t(c1)", "VALUES 1");
        this.assertQuery("SELECT apply(c1, x -> x + c2) FROM (VALUES (1, 2), (3, 4), (5, 6)) t(c1, c2)", "VALUES 3, 7, 11");
        this.assertQuery("SELECT apply(c1 + 10, x -> apply(x + 100, y -> c1)) FROM (VALUES 1) t(c1)", "VALUES 1");
        this.assertQuery("SELECT apply(c1 + 10, x -> apply(x + 100, y -> t.c1)) FROM (VALUES 1) t(c1)", "VALUES 1");
        this.assertQuery("SELECT apply(CAST(ROW(10) AS ROW(x INTEGER)), r -> r.x)", "VALUES 10");
        this.assertQuery("SELECT apply(CAST(ROW(10) AS ROW(x INTEGER)), r -> r.x) FROM (VALUES 1) u(x)", "VALUES 10");
        this.assertQuery("SELECT apply(CAST(ROW(10) AS ROW(x INTEGER)), r -> r.x) FROM (VALUES 1) r(x)", "VALUES 10");
        this.assertQuery("SELECT apply(CAST(ROW(10) AS ROW(x INTEGER)), r -> apply(3, y -> y + r.x)) FROM (VALUES 1) u(x)", "VALUES 13");
        this.assertQuery("SELECT apply(CAST(ROW(10) AS ROW(x INTEGER)), r -> apply(3, y -> y + r.x)) FROM (VALUES 1) r(x)", "VALUES 13");
        this.assertQuery("SELECT apply(CAST(ROW(10) AS ROW(x INTEGER)), r -> apply(3, y -> y + r.x)) FROM (VALUES 'a') r(x)", "VALUES 13");
        this.assertQuery("SELECT apply(CAST(ROW(10) AS ROW(x INTEGER)), z -> apply(3, y -> y + r.x)) FROM (VALUES 1) r(x)", "VALUES 4");
        this.assertQuery("SELECT apply(1, x -> apply(10, y -> x)) FROM (VALUES 1000) t(x)", "VALUES 1");
        this.assertQuery("SELECT apply(1, x -> apply(10, y -> x)) FROM (VALUES 'abc') t(x)", "VALUES 1");
        this.assertQuery("SELECT apply(1, x -> apply(10, y -> apply(100, z -> x))) FROM (VALUES 1000) t(x)", "VALUES 1");
        this.assertQuery("SELECT apply(1, x -> apply(10, y -> apply(100, z -> x))) FROM (VALUES 'abc') t(x)", "VALUES 1");
        this.assertQuery("SELECT * FROM (VALUES true) t(x) left JOIN (VALUES 1001) t2(y) ON (apply(false, z -> apply(false, y -> x)))", "SELECT true, 1001");
    }

    @Test
    public void testLambdaInAggregationContext() {
        this.assertQuery("SELECT apply(sum(x), i -> i * i) FROM (VALUES 1, 2, 3, 4, 5) t(x)", "SELECT 225");
        this.assertQuery("SELECT apply(x, i -> i - 1), sum(y) FROM (VALUES (1, 10), (1, 20), (2, 50)) t(x,y) GROUP BY x", "VALUES (0, 30), (1, 50)");
        this.assertQuery("SELECT x, apply(sum(y), i -> i * 10) FROM (VALUES (1, 10), (1, 20), (2, 50)) t(x,y) GROUP BY x", "VALUES (1, 300), (2, 500)");
        this.assertQuery("SELECT apply(8, x -> x + 1) FROM (VALUES (1, 2)) t(x,y) GROUP BY y", "SELECT 9");
        this.assertQuery("SELECT apply(CAST(ROW(1) AS ROW(someField BIGINT)), x -> x.someField) FROM (VALUES (1,2)) t(x,y) GROUP BY y", "SELECT 1");
        this.assertQuery("SELECT apply(sum(x), x -> x * x) FROM (VALUES 1, 2, 3, 4, 5) t(x)", "SELECT 225");
        this.assertQuery("SELECT apply(sum(x), x -> apply(x, x -> x * x)) FROM (VALUES 1, 2, 3, 4, 5) t(x)", "SELECT 225");
    }

    @Test
    public void testLambdaInSubqueryContext() {
        this.assertQuery("SELECT apply(x, i -> i * i) FROM (SELECT 10 x)", "SELECT 100");
        this.assertQuery("SELECT apply((SELECT 10), i -> i * i)", "SELECT 100");
        this.assertQuery("SELECT apply(x, i -> i * x) FROM (SELECT 10 x)", "SELECT 100");
        this.assertQuery("SELECT apply(x, y -> y * x) FROM (SELECT 10 x, 3 y)", "SELECT 100");
        this.assertQuery("SELECT apply(x, z -> y * x) FROM (SELECT 10 x, 3 y)", "SELECT 30");
    }

    @Test
    public void testLambdaInValuesAndUnnest() {
        this.assertQuery("SELECT * FROM UNNEST(transform(sequence(1, 5), x -> x * x))", "SELECT * FROM (VALUES 1, 4, 9, 16, 25)");
        this.assertQuery("SELECT x[5] FROM (VALUES transform(sequence(1, 5), x -> x * x)) t(x)", "SELECT 25");
    }

    @Test
    public void testTryLambdaRepeated() {
        this.assertQuery("SELECT x + x FROM (SELECT apply(a, i -> i * i) x FROM (VALUES 3) t(a))", "SELECT 18");
        this.assertQuery("SELECT apply(a, i -> i * i) + apply(a, i -> i * i) FROM (VALUES 3) t(a)", "SELECT 18");
        this.assertQuery("SELECT apply(a, i -> i * i), apply(a, i -> i * i) FROM (VALUES 3) t(a)", "SELECT 9, 9");
        this.assertQuery("SELECT try(10 / a) + try(10 / a) FROM (VALUES 5) t(a)", "SELECT 4");
        this.assertQuery("SELECT try(10 / a), try(10 / a) FROM (VALUES 5) t(a)", "SELECT 2, 2");
    }

    @Test
    public void testTryLambdaWithCast() {
        this.assertQuery("SELECT IF(TRY(CAST(a AS INT)) IN (1, 5), TRY(CAST(b AS DOUBLE)), 0.0) FROM (VALUES (varchar'1', varchar'2.1'), (varchar'5', varchar'3.4')) t(a, b)", "VALUES 2.1, 3.4");
    }

    @Test
    public void testNonDeterministicFilter() {
        MaterializedResult materializedResult = this.computeActual("SELECT u FROM ( SELECT if(rand() > 0.5, 0, 1) AS u ) WHERE u <> u");
        Assert.assertEquals((int)materializedResult.getRowCount(), (int)0);
        materializedResult = this.computeActual("SELECT u, v FROM ( SELECT if(rand() > 0.5, 0, 1) AS u, 4*4 AS v ) WHERE u <> u and v > 10");
        Assert.assertEquals((int)materializedResult.getRowCount(), (int)0);
        materializedResult = this.computeActual("SELECT u, v, w FROM ( SELECT if(rand() > 0.5, 0, 1) AS u, 4*4 AS v, 'abc' AS w ) WHERE v > 10");
        Assert.assertEquals((int)materializedResult.getRowCount(), (int)1);
    }

    @Test
    public void testNonDeterministicProjection() {
        MaterializedResult materializedResult = this.computeActual("SELECT r, r + 1 FROM (SELECT rand(100) r FROM orders) LIMIT 10");
        Assert.assertEquals((int)materializedResult.getRowCount(), (int)10);
        for (MaterializedRow materializedRow : materializedResult) {
            Assert.assertEquals((int)materializedRow.getFieldCount(), (int)2);
            Assert.assertEquals((Object)(((Number)materializedRow.getField(0)).intValue() + 1), (Object)materializedRow.getField(1));
        }
    }

    @Test
    public void testMapSubscript() {
        this.assertQuery("SELECT map(array[1], array['aa'])[1]", "SELECT 'aa'");
        this.assertQuery("SELECT map(array['a'], array['aa'])['a']", "SELECT 'aa'");
        this.assertQuery("SELECT map(array[array[1,1]], array['a'])[array[1,1]]", "SELECT 'a'");
        this.assertQuery("SELECT map(array[(1,2)], array['a'])[(1,2)]", "SELECT 'a'");
    }

    @Test
    public void testRowSubscript() {
        this.assertQuery("SELECT ROW (1, 'a', true)[2]", "SELECT 'a'");
        this.assertQuery("SELECT r[2] FROM (VALUES (ROW (ROW (1, 'a', true)))) AS v(r)", "SELECT 'a'");
        this.assertQuery("SELECT r[1], r[2] FROM (SELECT ROW (name, regionkey) FROM nation ORDER BY name LIMIT 1) t(r)", "VALUES ('ALGERIA', 0)");
        this.assertQuery("SELECT (CAST (ROW (1, 'a', 2 ) AS ROW (field1 bigint, field2 varchar(1), field3 bigint)))[2]", "SELECT 'a'");
        this.assertQuery("SELECT ROW (1, 'a', ROW (false, 2, 'b'))[3][3]", "SELECT 'b'");
        this.assertQuery("SELECT orderstatus FROM orders WHERE ROW (orderkey, custkey)[1] = 100", "SELECT 'O'");
        this.assertQuery("SELECT n.name, r.name FROM nation n JOIN region r ON ROW (n.name, n.regionkey)[2] = ROW (r.name, r.regionkey)[2] ORDER BY n.name LIMIT 1", "VALUES ('ALGERIA', 'AFRICA')");
        this.assertQuery("SELECT apply(ROW (1, 2), r -> r[2])", "SELECT 2");
    }

    @Test
    public void testVarbinary() {
        this.assertQuery("SELECT LENGTH(x) FROM (SELECT from_base64('gw==') AS x)", "SELECT 1");
        this.assertQuery("SELECT LENGTH(from_base64('gw=='))", "SELECT 1");
    }

    @Test
    public void testRowFieldAccessor() {
        this.assertQuery("SELECT a FROM (VALUES ROW (CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)).col0)) AS t (a)", "SELECT 1");
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW (CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a)", "SELECT 1");
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW (CAST(ROW(1.0E0, 2.0E0) AS ROW(col0 integer, col1 integer)))) AS t (a)", "SELECT 1.0");
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW (CAST(ROW(TRUE, FALSE) AS ROW(col0 boolean, col1 boolean)))) AS t (a)", "SELECT TRUE");
        this.assertQuery("SELECT a.col1 FROM (VALUES ROW (CAST(ROW(1.0, 'kittens') AS ROW(col0 varchar, col1 varchar)))) AS t (a)", "SELECT 'kittens'");
        this.assertQuery("SELECT a.col2.col1 FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2], row(3, 4.0)) AS ROW(col0 double, col1 array(int), col2 row(col0 integer, col1 double))))) t(a)", "SELECT 4.0");
        this.assertQuery("SELECT CAST(row(1, t.x) AS row(col0 bigint, col1 bigint)).col1 FROM (VALUES 1, 2, 3) t(x)", "SELECT * FROM (VALUES 1, 2, 3)");
        this.assertQuery("SELECT Y.col1 FROM (SELECT CAST(row(1, t.x) AS row(col0 bigint, col1 bigint)) AS Y FROM (VALUES 1, 2, 3) t(x)) test_t", "SELECT * FROM (VALUES 1, 2, 3)");
        this.assertQuery("SELECT a.col1[2] FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[22, 33, 44, 55], row(3, 4.0E0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a)", "SELECT 33");
        this.assertQuery("SELECT a.col1[2].col0, a.col1[2].col1 FROM (VALUES ROW(cast(row(1.0, ARRAY[row(31, 4.1E0), row(32, 4.2E0)], row(3, 4.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double))))) t(a)", "SELECT 32, 4.2");
        this.assertQuery("SELECT CAST(row(11, 12) AS row(col0 bigint, col1 bigint)).col0", "SELECT 11");
        this.assertQuery("SELECT v FROM ( VALUES (ARRAY[ CAST( ROW(2, 'a') AS ROW( int_field BIGINT, str_field VARCHAR ) )][1].str_field)) AS t (v)", "SELECT 'a'");
    }

    @Test
    public void testRowFieldAccessorInAggregate() {
        this.assertQuery("SELECT a.col0, SUM(a.col1[2]), SUM(a.col2.col0), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2, 13, 4], row(11, 4.1E0))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.0, ARRAY[2, 23, 4], row(12, 14.0E0))  AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.0, ARRAY[22, 33, 44], row(13, 5.0E0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a) GROUP BY a.col0", "SELECT * FROM VALUES (1.0, 46, 24, 9.1), (2.0, 23, 12, 14.0)");
        this.assertQuery("SELECT a.col2.col0, SUM(a.col0), SUM(a.col1[2]), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2, 13, 4], row(11, 4.1E0))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.0, ARRAY[2, 23, 4], row(11, 14.0E0))  AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(7.0, ARRAY[22, 33, 44], row(13, 5.0E0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a) GROUP BY a.col2.col0", "SELECT * FROM VALUES (11, 3.0, 36, 18.1), (13, 7.0, 33, 5.0)");
        this.assertQuery("SELECT a.col1[1].col0, SUM(a.col0), SUM(a.col1[1].col1), SUM(a.col1[2].col0), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[row(31, 4.5E0), row(12, 4.2E0)], row(3, 4.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.1, ARRAY[row(41, 3.1E0), row(32, 4.2E0)], row(6, 6.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.2, ARRAY[row(31, 4.2E0), row(22, 4.2E0)], row(5, 4.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double))))) t(a) GROUP BY a.col1[1].col0", "SELECT * FROM VALUES (31, 3.2, 8.7, 34, 8.0), (41, 3.1, 3.1, 32, 6.0)");
        this.assertQuery("SELECT a.col1[1].col0, SUM(a.col0), SUM(a.col1[1].col1), SUM(a.col1[2].col0), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(2.2, ARRAY[row(31, 4.2E0), row(22, 4.2E0)], row(5, 4.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.0, ARRAY[row(31, 4.5E0), row(12, 4.2E0)], row(3, 4.1E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.1, ARRAY[row(41, 3.1E0), row(32, 4.2E0)], row(6, 6.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.3, ARRAY[row(41, 3.1E0), row(32, 4.2E0)], row(6, 6.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))) ) t(a) GROUP BY a.col1[1]", "SELECT * FROM VALUES (31, 2.2, 4.2, 22, 4.0), (31, 1.0, 4.5, 12, 4.1), (41, 6.4, 6.2, 64, 12.0)");
        this.assertQuery("SELECT a.col1[2], SUM(a.col0), SUM(a.col1[1]), SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2, 13, 4], row(11, 4.1E0))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.0, ARRAY[2, 13, 4], row(12, 14.0E0))  AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(7.0, ARRAY[22, 33, 44], row(13, 5.0E0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a) GROUP BY a.col1[2]", "SELECT * FROM VALUES (13, 3.0, 4, 18.1), (33, 7.0, 22, 5.0)");
        this.assertQuery("SELECT a.col2.col0, SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(2.2, ARRAY[row(31, 4.2E0), row(22, 4.2E0)], row(5, 4.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.0, ARRAY[row(31, 4.5E0), row(12, 4.2E0)], row(3, 4.1E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.1, ARRAY[row(41, 3.1E0), row(32, 4.2E0)], row(6, 6.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(3.3, ARRAY[row(41, 3.1E0), row(32, 4.2E0)], row(6, 6.0E0)) AS ROW(col0 double, col1 array(row(col0 integer, col1 double)), col2 row(col0 integer, col1 double)))) ) t(a) GROUP BY a.col2", "SELECT * FROM VALUES (5, 4.0), (3, 4.1), (6, 12.0)");
        this.assertQuery("SELECT a.col2.col0, a.col0, SUM(a.col2.col1) FROM (VALUES ROW(CAST(ROW(1.0, ARRAY[2, 13, 4], row(11, 4.1E0))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(2.0, ARRAY[2, 23, 4], row(11, 14.0E0))  AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.5, ARRAY[2, 13, 4], row(11, 4.1E0))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(1.5, ARRAY[2, 13, 4], row(11, 4.1E0))   AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double)))), ROW(CAST(ROW(7.0, ARRAY[22, 33, 44], row(13, 5.0E0)) AS ROW(col0 double, col1 array(integer), col2 row(col0 integer, col1 double))))) t(a) WHERE a.col1[2] < 30 GROUP BY 1, 2 ORDER BY 1", "SELECT * FROM VALUES (11, 1.0, 4.1), (11, 1.5, 8.2), (11, 2.0, 14.0)");
        this.assertQuery("SELECT a[1].col0, COUNT(1) FROM (VALUES (ROW(CAST(ARRAY[row(31, 4.2E0), row(22, 4.2E0)] AS ARRAY(ROW(col0 integer, col1 double))))), (ROW(CAST(ARRAY[row(31, 4.5E0), row(12, 4.2E0)] AS ARRAY(ROW(col0 integer, col1 double))))), (ROW(CAST(ARRAY[row(41, 3.1E0), row(32, 4.2E0)] AS ARRAY(ROW(col0 integer, col1 double))))), (ROW(CAST(ARRAY[row(31, 3.1E0), row(32, 4.2E0)] AS ARRAY(ROW(col0 integer, col1 double))))) ) t(a) GROUP BY 1 ORDER BY 2 DESC", "SELECT * FROM VALUES (31, 3), (41, 1)");
    }

    @Test
    public void testMapTransformKeys() {
        this.assertQuery("SELECT\n   MAP_KEYS(TRANSFORM_KEYS(features, (k, v) -> MAP(ARRAY[1, 2], ARRAY[10, 20])[k])) as k1, \n   MAP_KEYS(TRANSFORM_KEYS(features, (k, v) -> MAP(ARRAY[1, 2], ARRAY[30, 40])[k])) as k2 \nFROM (SELECT MAP(ARRAY[1], ARRAY[1]) as features) ", "VALUES ((10), (30))");
    }

    @Test
    public void testTryMapTransformValueFunction() {
        MaterializedResult actual = this.computeActual("SELECT COALESCE( TRY( TRANSFORM_VALUES( id, (k, v) -> k / v ) ) , MAP() )FROM ( VALUES (MAP(ARRAY[1, 2], ARRAY[0, 0])), (MAP(ARRAY[1, 2], ARRAY[1, 2])), (MAP(ARRAY[28, 56], ARRAY[2, 4])), (MAP(ARRAY[4, 5], ARRAY[0, 0])), (MAP(ARRAY[12, 72], ARRAY[3, 6]))) AS t (id)");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)}).row(new Object[]{ImmutableMap.of()}).row(new Object[]{ImmutableMap.of((Object)1, (Object)1, (Object)2, (Object)1)}).row(new Object[]{ImmutableMap.of((Object)28, (Object)14, (Object)56, (Object)14)}).row(new Object[]{ImmutableMap.of()}).row(new Object[]{ImmutableMap.of((Object)12, (Object)4, (Object)72, (Object)12)}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testRowCast() {
        this.assertQuery("SELECT CAST(row(1, 2) AS row(aa bigint, bb boolean)).aa", "SELECT 1");
        this.assertQuery("SELECT CAST(row(1, 2) AS row(aa bigint, bb boolean)).bb", "SELECT true");
        this.assertQuery("SELECT CAST(row(1, 2) AS row(aa bigint, bb varchar)).bb", "SELECT '2'");
        this.assertQuery("SELECT CAST(row(true, array[0, 2]) AS row(aa boolean, bb array(boolean))).bb[1]", "SELECT false");
        this.assertQuery("SELECT CAST(row(0.1, array[0, 2], row(1, 0.5)) AS row(aa bigint, bb array(boolean), cc row(dd varchar, ee varchar))).cc.ee", "SELECT '0.5'");
        this.assertQuery("SELECT CAST(array[row(0.1, array[0, 2], row(1, 0.5))] AS array<row(aa bigint, bb array(boolean), cc row(dd varchar, ee varchar))>)[1].cc.ee", "SELECT '0.5'");
    }

    @Test
    public void testDereferenceInSubquery() {
        this.assertQuery("SELECT x FROM (   SELECT a.x   FROM (VALUES 1, 2, 3) a(x)) GROUP BY x", "SELECT * FROM VALUES 1, 2, 3");
        this.assertQuery("SELECT t2.*, max(t1.b) AS max_b FROM (VALUES (1, 'a'),  (2, 'b'), (1, 'c'), (3, 'd')) t1(a, b) INNER JOIN (VALUES 1, 2, 3, 4) t2(a) ON t1.a = t2.a GROUP BY t2.a", "SELECT * FROM VALUES (1, 'c'), (2, 'b'), (3, 'd')");
        this.assertQuery("SELECT t2.*, max(t1.b1) AS max_b1 FROM (VALUES (1, 'a'),  (2, 'b'), (1, 'c'), (3, 'd')) t1(a1, b1) INNER JOIN (VALUES (1, 11, 111), (2, 22, 222), (3, 33, 333), (4, 44, 444)) t2(a2, b2, c2) ON t1.a1 = t2.a2 GROUP BY t2.a2, t2.b2, t2.c2", "SELECT * FROM VALUES (1, 11, 111, 'c'), (2, 22, 222, 'b'), (3, 33, 333, 'd')");
        this.assertQuery("SELECT custkey, orders2 FROM (   SELECT x.custkey, SUM(x.orders) + 1 orders2    FROM (       SELECT x.custkey, COUNT(x.orderkey) orders       FROM orders x       WHERE x.custkey < 100       GROUP BY x.custkey    ) x    GROUP BY x.custkey) ORDER BY custkey");
    }

    @Test
    public void testDereferenceInFunctionCall() {
        this.assertQuery("SELECT COUNT(DISTINCT custkey) FROM (   SELECT x.custkey   FROM orders x   WHERE custkey < 100 ) t");
    }

    @Test
    public void testDereferenceInComparison() {
        this.assertQuery("SELECT orders.custkey, orders.orderkey FROM orders WHERE orders.custkey > orders.orderkey AND orders.custkey < 200.3");
    }

    @Test
    public void testMissingRowFieldInGroupBy() {
        this.assertQueryFails("SELECT a.col0, count(*) FROM (VALUES ROW(cast(ROW(1, 1) AS ROW(col0 integer, col1 integer)))) t(a)", "line 1:8: 'a.col0' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testWhereWithRowField() {
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 > 0", "SELECT 1");
        this.assertQuery("SELECT SUM(a.col0) FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 <= 0", "SELECT null");
        this.assertQuery("SELECT a.col0 FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 < a.col1", "SELECT 1");
        this.assertQuery("SELECT SUM(a.col0) FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 < a.col1", "SELECT 1");
        this.assertQuery("SELECT SUM(a.col0) FROM (VALUES ROW(CAST(ROW(1, 2) AS ROW(col0 integer, col1 integer)))) AS t (a) WHERE a.col0 > a.col1", "SELECT null");
    }

    @Test
    public void testUnnest() {
        this.assertQuery("SELECT 1 FROM (VALUES (ARRAY[1])) AS t (a) CROSS JOIN UNNEST(a)", "SELECT 1");
        this.assertQuery("SELECT x[1] FROM UNNEST(ARRAY[ARRAY[1, 2, 3]]) t(x)", "SELECT 1");
        this.assertQuery("SELECT x[1][2] FROM UNNEST(ARRAY[ARRAY[ARRAY[1, 2, 3]]]) t(x)", "SELECT 2");
        this.assertQuery("SELECT x[2] FROM UNNEST(ARRAY[MAP(ARRAY[1,2], ARRAY['hello', 'hi'])]) t(x)", "SELECT 'hi'");
        this.assertQuery("SELECT * FROM UNNEST(ARRAY[1, 2, 3])", "SELECT * FROM VALUES (1), (2), (3)");
        this.assertQuery("SELECT a FROM UNNEST(ARRAY[1, 2, 3]) t(a)", "SELECT * FROM VALUES (1), (2), (3)");
        this.assertQuery("SELECT a, b FROM UNNEST(ARRAY[1, 2], ARRAY[3, 4]) t(a, b)", "SELECT * FROM VALUES (1, 3), (2, 4)");
        this.assertQuery("SELECT a, b FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) t(a, b)", "SELECT * FROM VALUES (1, 4), (2, 5), (3, NULL)");
        this.assertQuery("SELECT a FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) t(a, b)", "SELECT * FROM VALUES 1, 2, 3");
        this.assertQuery("SELECT b FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) t(a, b)", "SELECT * FROM VALUES 4, 5, NULL");
        this.assertQuery("SELECT count(*) FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5])", "SELECT 3");
        this.assertQuery("SELECT a FROM UNNEST(ARRAY['kittens', 'puppies']) t(a)", "SELECT * FROM VALUES ('kittens'), ('puppies')");
        this.assertQuery("WITH unioned AS ( SELECT 1 UNION ALL SELECT 2 ) SELECT * FROM unioned CROSS JOIN UNNEST(ARRAY[3]) steps (step)", "SELECT * FROM (VALUES (1, 3), (2, 3))");
        this.assertQuery("SELECT c FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) t(a, b) CROSS JOIN (values (8), (9)) t2(c)", "SELECT * FROM VALUES 8, 8, 8, 9, 9, 9");
        this.assertQuery("SELECT a.custkey, t.e FROM (SELECT custkey, ARRAY[1, 2, 3] AS my_array FROM orders ORDER BY orderkey LIMIT 1) a CROSS JOIN UNNEST(my_array) t(e)", "SELECT * FROM (SELECT custkey FROM orders ORDER BY orderkey LIMIT 1) CROSS JOIN (VALUES (1), (2), (3))");
        this.assertQuery("SELECT a.custkey, t.e FROM (SELECT custkey, ARRAY[1, 2, 3] AS my_array FROM orders ORDER BY orderkey LIMIT 1) a, UNNEST(my_array) t(e)", "SELECT * FROM (SELECT custkey FROM orders ORDER BY orderkey LIMIT 1) CROSS JOIN (VALUES (1), (2), (3))");
        this.assertQuery("SELECT * FROM UNNEST(ARRAY[0, 1]) CROSS JOIN UNNEST(ARRAY[0, 1]) CROSS JOIN UNNEST(ARRAY[0, 1])", "SELECT * FROM VALUES (0, 0, 0), (0, 0, 1), (0, 1, 0), (0, 1, 1), (1, 0, 0), (1, 0, 1), (1, 1, 0), (1, 1, 1)");
        this.assertQuery("SELECT * FROM UNNEST(ARRAY[0, 1]), UNNEST(ARRAY[0, 1]), UNNEST(ARRAY[0, 1])", "SELECT * FROM VALUES (0, 0, 0), (0, 0, 1), (0, 1, 0), (0, 1, 1), (1, 0, 0), (1, 0, 1), (1, 1, 0), (1, 1, 1)");
        this.assertQuery("SELECT a, b FROM UNNEST(MAP(ARRAY[1,2], ARRAY['cat', 'dog'])) t(a, b)", "SELECT * FROM VALUES (1, 'cat'), (2, 'dog')");
        this.assertQuery("SELECT a, b FROM UNNEST(MAP(ARRAY[1,2], ARRAY['cat', NULL])) t(a, b)", "SELECT * FROM VALUES (1, 'cat'), (2, NULL)");
        this.assertQuery("SELECT 1 FROM (VALUES (ARRAY[1])) AS t (a) CROSS JOIN UNNEST(a) WITH ORDINALITY", "SELECT 1");
        this.assertQuery("SELECT * FROM UNNEST(ARRAY[1, 2, 3]) WITH ORDINALITY", "SELECT * FROM VALUES (1, 1), (2, 2), (3, 3)");
        this.assertQuery("SELECT b FROM UNNEST(ARRAY[10, 20, 30]) WITH ORDINALITY t(a, b)", "SELECT * FROM VALUES (1), (2), (3)");
        this.assertQuery("SELECT a, b, c FROM UNNEST(ARRAY[10, 20, 30], ARRAY[4, 5]) WITH ORDINALITY t(a, b, c)", "SELECT * FROM VALUES (10, 4, 1), (20, 5, 2), (30, NULL, 3)");
        this.assertQuery("SELECT a, b FROM UNNEST(ARRAY['kittens', 'puppies']) WITH ORDINALITY t(a, b)", "SELECT * FROM VALUES ('kittens', 1), ('puppies', 2)");
        this.assertQuery("SELECT c FROM UNNEST(ARRAY[1, 2, 3], ARRAY[4, 5]) WITH ORDINALITY t(a, b, c) CROSS JOIN (values (8), (9)) t2(d)", "SELECT * FROM VALUES 1, 1, 2, 2, 3, 3");
        this.assertQuery("SELECT a.custkey, t.e, t.f FROM (SELECT custkey, ARRAY[10, 20, 30] AS my_array FROM orders ORDER BY orderkey LIMIT 1) a CROSS JOIN UNNEST(my_array) WITH ORDINALITY t(e, f)", "SELECT * FROM (SELECT custkey FROM orders ORDER BY orderkey LIMIT 1) CROSS JOIN (VALUES (10, 1), (20, 2), (30, 3))");
        this.assertQuery("SELECT a.custkey, t.e, t.f FROM (SELECT custkey, ARRAY[10, 20, 30] AS my_array FROM orders ORDER BY orderkey LIMIT 1) a, UNNEST(my_array) WITH ORDINALITY t(e, f)", "SELECT * FROM (SELECT custkey FROM orders ORDER BY orderkey LIMIT 1) CROSS JOIN (VALUES (10, 1), (20, 2), (30, 3))");
        this.assertQuery("SELECT * FROM orders, UNNEST(ARRAY[1])", "SELECT orders.*, 1 FROM orders");
        this.assertQuery("SELECT a FROM (    SELECT l.arr AS arr FROM (        SELECT orderkey, ARRAY[1,2,3] AS arr FROM orders ORDER BY orderkey LIMIT 1) l    FULL OUTER JOIN (        SELECT orderkey, ARRAY[1,2,3] AS arr FROM orders ORDER BY orderkey LIMIT 1) o    ON l.orderkey = o.orderkey) CROSS JOIN UNNEST(arr) AS t (a)", "SELECT * FROM (VALUES (1), (2), (3))");
        this.assertQueryFails("SELECT * FROM (VALUES array[2, 2]) a(x) LEFT OUTER JOIN UNNEST(x) ON true", "line .*: UNNEST on other than the right side of CROSS JOIN is not supported");
        this.assertQueryFails("SELECT * FROM (VALUES array[2, 2]) a(x) RIGHT OUTER JOIN UNNEST(x) ON true", "line .*: UNNEST on other than the right side of CROSS JOIN is not supported");
        this.assertQueryFails("SELECT * FROM (VALUES array[2, 2]) a(x) FULL OUTER JOIN UNNEST(x) ON true", "line .*: UNNEST on other than the right side of CROSS JOIN is not supported");
    }

    @Test
    public void testArrays() {
        this.assertQuery("SELECT a[1] FROM (SELECT ARRAY[orderkey] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey FROM orders");
        this.assertQuery("SELECT a[1 + CAST(round(rand()) AS BIGINT)] FROM (SELECT ARRAY[orderkey, orderkey] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey FROM orders");
        this.assertQuery("SELECT a[1] + 1 FROM (SELECT ARRAY[orderkey] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey + 1 FROM orders");
        this.assertQuery("SELECT a[1] FROM (SELECT ARRAY[orderkey + 1] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey + 1 FROM orders");
        this.assertQuery("SELECT a[1][1] FROM (SELECT ARRAY[ARRAY[orderkey + 1]] AS a FROM orders ORDER BY orderkey) t", "SELECT orderkey + 1 FROM orders");
        this.assertQuery("SELECT CARDINALITY(a) FROM (SELECT ARRAY[orderkey, orderkey + 1] AS a FROM orders ORDER BY orderkey) t", "SELECT 2 FROM orders");
    }

    @Test
    public void testArrayAgg() {
        this.assertQuery("SELECT clerk, cardinality(array_agg(orderkey)) FROM orders GROUP BY clerk", "SELECT clerk, count(*) FROM orders GROUP BY clerk");
    }

    @Test
    public void testReduceAgg() {
        this.assertQuery("SELECT x, reduce_agg(y, 1, (a, b) -> a * b, (a, b) -> a * b) FROM (VALUES (1, 5), (1, 6), (1, 7), (2, 8), (2, 9), (3, 10)) AS t(x, y) GROUP BY x", "VALUES (1, 5 * 6 * 7), (2, 8 * 9), (3, 10)");
        this.assertQuery("SELECT x, reduce_agg(y, 0, (a, b) -> a + b, (a, b) -> a + b) FROM (VALUES (1, 5), (1, 6), (1, 7), (2, 8), (2, 9), (3, 10)) AS t(x, y) GROUP BY x", "VALUES (1, 5 + 6 + 7), (2, 8 + 9), (3, 10)");
        this.assertQuery("SELECT x, reduce_agg(y, 1, (a, b) -> a * b, (a, b) -> a * b) FROM (VALUES (1, CAST(5 AS DOUBLE)), (1, 6), (1, 7), (2, 8), (2, 9), (3, 10)) AS t(x, y) GROUP BY x", "VALUES (1, CAST(5 AS DOUBLE) * 6 * 7), (2, 8 * 9), (3, 10)");
        this.assertQuery("SELECT x, reduce_agg(y, 0, (a, b) -> a + b, (a, b) -> a + b) FROM (VALUES (1, CAST(5 AS DOUBLE)), (1, 6), (1, 7), (2, 8), (2, 9), (3, 10)) AS t(x, y) GROUP BY x", "VALUES (1, CAST(5 AS DOUBLE) + 6 + 7), (2, 8 + 9), (3, 10)");
        this.assertQuery("SELECT x, array_join(   array_sort(       split(reduce_agg(y, '', (a, b) -> a || b, (a, b) -> a || b), '')   ),    '') FROM (VALUES (1, 'a'), (1, 'b'), (1, 'c'), (2, 'd'), (2, 'e'), (3, 'f')) AS t(x, y) GROUP BY x", "VALUES (1, 'abc'), (2, 'de'), (3, 'f')");
        this.assertQuery("SELECT x, array_join(   array_sort(       reduce_agg(y, ARRAY['x'], (a, b) -> a || b, (a, b) -> a || b)   ),    '') FROM (VALUES (1, ARRAY['a']), (1, ARRAY['b']), (1, ARRAY['c']), (2, ARRAY['d']), (2, ARRAY['e']), (3, ARRAY['f'])) AS t(x, y) GROUP BY x", "VALUES (1, 'abcx'), (2, 'dex'), (3, 'fx')");
        this.assertQuery("SELECT REDUCE_AGG((x,y), (0,0), (x, y)->(x[1],y[1]), (x,y)->(x[1],y[1]))[1] from (select 1 x, 2 y)", "select 0");
    }

    @Test
    public void testRows() {
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(1 + 2, CONCAT('a', 'b')) AS JSON))", "SELECT '[3,\"ab\"]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(a + b) AS JSON)) FROM (VALUES (1, 2)) AS t(a, b)", "SELECT '[3]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(1, ROW(9, a, ARRAY[], NULL), ROW(1, 2)) AS JSON)) FROM (VALUES ('a')) t(a)", "SELECT '[1,[9,\"a\",[],null],[1,2]]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(ROW(ROW(ROW(ROW(a, b), c), d), e), f) AS JSON)) FROM (VALUES (ROW(0, 1), 2, '3', NULL, ARRAY[5], ARRAY[])) t(a, b, c, d, e, f)", "SELECT '[[[[[[0,1],2],\"3\"],null],[5]],[]]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ARRAY_AGG(ROW(a, b)) AS JSON)) FROM (VALUES (1, 2), (3, 4), (5, 6)) t(a, b)", "SELECT '[[1,2],[3,4],[5,6]]'");
        this.assertQuery("SELECT CONTAINS(ARRAY_AGG(ROW(a, b)), ROW(1, 2)) FROM (VALUES (1, 2), (3, 4), (5, 6)) t(a, b)", "SELECT TRUE");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ARRAY_AGG(ROW(c, d)) AS JSON)) FROM (VALUES (ARRAY[1, 3, 5], ARRAY[2, 4, 6])) AS t(a, b) CROSS JOIN UNNEST(a, b) AS u(c, d)", "SELECT '[[1,2],[3,4],[5,6]]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(x, y, z) AS JSON)) FROM (VALUES ROW(1, NULL, '3')) t(x,y,z)", "SELECT '[1,null,\"3\"]'");
        this.assertQuery("SELECT JSON_FORMAT(CAST(ROW(x, y, z) AS JSON)) FROM (VALUES ROW(1, CAST(NULL AS INTEGER), '3')) t(x,y,z)", "SELECT '[1,null,\"3\"]'");
    }

    @Test
    public void testMaps() {
        this.assertQuery("SELECT m[max_key] FROM (SELECT map_agg(orderkey, orderkey) m, max(orderkey) max_key FROM orders)", "SELECT max(orderkey) FROM orders");
        this.assertQuery("SELECT JSON_FORMAT(CAST(TRY(MAP(ARRAY[NULL], ARRAY[x])) AS JSON)) FROM (VALUES 1, 2) t(x)", "SELECT * FROM (VALUES NULL, NULL)");
    }

    @Test
    public void testValues() {
        this.assertQuery("VALUES 1, 2, 3, 4");
        this.assertQuery("VALUES 1, 3, 2, 4 ORDER BY 1", "SELECT * FROM (VALUES 1, 3, 2, 4) ORDER BY 1");
        this.assertQuery("VALUES (1.1, 2, 'foo'), (sin(3.3), 2+2, 'bar')");
        this.assertQuery("VALUES (1.1, 2), (sin(3.3), 2+2) ORDER BY 1", "VALUES (sin(3.3), 2+2), (1.1, 2)");
        this.assertQuery("VALUES (1.1, 2), (sin(3.3), 2+2) LIMIT 1", "VALUES (1.1, 2)");
        this.assertQuery("SELECT * FROM (VALUES (1.1, 2), (sin(3.3), 2+2))");
        this.assertQuery("SELECT 1.1 in (VALUES (1.1), (2.2))", "VALUES (TRUE)");
        this.assertQuery("WITH a AS (VALUES (1.1, 2), (sin(3.3), 2+2)) SELECT * FROM a", "VALUES (1.1, 2), (sin(3.3), 2+2)");
        this.assertQuery("VALUES 1, 2.2, 3, 4.4");
        this.assertQuery("VALUES (1, 2), (3.3, 4.4)");
        this.assertQuery("VALUES true, 1.0 in (1, 2, 3)");
    }

    @Test
    public void testSpecialFloatingPointValues() {
        MaterializedResult actual = this.computeActual("SELECT nan(), infinity(), -infinity()");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)actual.getMaterializedRows());
        Assert.assertEquals((Object)row.getField(0), (Object)Double.NaN);
        Assert.assertEquals((Object)row.getField(1), (Object)Double.POSITIVE_INFINITY);
        Assert.assertEquals((Object)row.getField(2), (Object)Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testMaxMinStringWithNulls() {
        this.assertQuery("SELECT custkey, MAX(NULLIF(orderstatus, 'O')), MIN(NULLIF(orderstatus, 'O')) FROM orders GROUP BY custkey");
    }

    @Test
    public void testApproxPercentile() {
        MaterializedResult raw = this.computeActual("SELECT orderstatus, orderkey, totalprice FROM orders");
        ArrayListMultimap orderKeyByStatus = ArrayListMultimap.create();
        ArrayListMultimap totalPriceByStatus = ArrayListMultimap.create();
        for (MaterializedRow row : raw.getMaterializedRows()) {
            orderKeyByStatus.put((Object)((String)row.getField(0)), (Object)((Number)row.getField(1)).longValue());
            totalPriceByStatus.put((Object)((String)row.getField(0)), (Object)((Double)row.getField(2)));
        }
        MaterializedResult actual = this.computeActual("SELECT orderstatus,    approx_percentile(orderkey, 0.5),    approx_percentile(totalprice, 0.5),   approx_percentile(orderkey, 2, 0.5),   approx_percentile(totalprice, 2, 0.5)\nFROM orders\nGROUP BY orderstatus");
        for (MaterializedRow row : actual.getMaterializedRows()) {
            String status = (String)row.getField(0);
            Long orderKey = ((Number)row.getField(1)).longValue();
            Double totalPrice = (Double)row.getField(2);
            Long orderKeyWeighted = ((Number)row.getField(3)).longValue();
            Double totalPriceWeighted = (Double)row.getField(4);
            List orderKeys = Ordering.natural().sortedCopy((Iterable)orderKeyByStatus.get((Object)status));
            List totalPrices = Ordering.natural().sortedCopy((Iterable)totalPriceByStatus.get((Object)status));
            org.testng.Assert.assertTrue((orderKey >= (Long)orderKeys.get((int)(0.49 * (double)orderKeys.size())) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((orderKey <= (Long)orderKeys.get((int)(0.51 * (double)orderKeys.size())) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((orderKeyWeighted >= (Long)orderKeys.get((int)(0.49 * (double)orderKeys.size())) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((orderKeyWeighted <= (Long)orderKeys.get((int)(0.51 * (double)orderKeys.size())) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((totalPrice >= (Double)totalPrices.get((int)(0.49 * (double)totalPrices.size())) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((totalPrice <= (Double)totalPrices.get((int)(0.51 * (double)totalPrices.size())) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((totalPriceWeighted >= (Double)totalPrices.get((int)(0.49 * (double)totalPrices.size())) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((totalPriceWeighted <= (Double)totalPrices.get((int)(0.51 * (double)totalPrices.size())) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testComplexQuery() {
        this.assertQueryOrdered("SELECT sum(orderkey), row_number() OVER (ORDER BY orderkey) FROM orders WHERE orderkey <= 10 GROUP BY orderkey HAVING sum(orderkey) >= 3 ORDER BY orderkey DESC LIMIT 3", "VALUES (7, 5), (6, 4), (5, 3)");
    }

    @Test
    public void testWhereNull() {
        this.assertQuery("SELECT custkey FROM orders WHERE custkey = custkey AND CAST(nullif(custkey, custkey) AS boolean) AND CAST(nullif(custkey, custkey) AS boolean)");
    }

    @Test
    public void testDistinctMultipleFields() {
        this.assertQuery("SELECT DISTINCT custkey, orderstatus FROM orders");
    }

    @Test
    public void testArithmeticNegation() {
        this.assertQuery("SELECT -custkey FROM orders");
    }

    @Test
    public void testDistinct() {
        this.assertQuery("SELECT DISTINCT custkey FROM orders");
    }

    @Test
    public void testDistinctHaving() {
        this.assertQuery("SELECT COUNT(DISTINCT clerk) AS count FROM orders GROUP BY orderdate HAVING COUNT(DISTINCT clerk) > 1");
    }

    @Test
    public void testDistinctLimitWithQuickDistinctLimitEnabled() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("quick_distinct_limit_enabled", "true").build();
        this.testDistinctLimitInternal(session);
    }

    @Test
    public void testDistinctLimitWithHashBasedDistinctLimitEnabled() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("hash_based_distinct_limit_enabled", "true").build();
        this.testDistinctLimitInternal(session);
    }

    @Test
    public void testDistinctLimit() {
        this.testDistinctLimitInternal(this.getSession());
    }

    public void testDistinctLimitInternal(Session session) {
        this.assertQuery(session, "SELECT DISTINCT orderstatus, custkey FROM (SELECT orderstatus, custkey FROM orders ORDER BY orderkey LIMIT 10) LIMIT 10");
        this.assertQuery(session, "SELECT COUNT(*) FROM (SELECT DISTINCT orderstatus, custkey FROM orders LIMIT 10)");
        this.assertQuery(session, "SELECT DISTINCT custkey, orderstatus FROM orders WHERE custkey = 1268 LIMIT 2");
        this.assertQuery(session, "SELECT DISTINCT custkey, orderstatus FROM orders WHERE custkey = 1268 LIMIT 10000");
        this.assertQuery(session, "SELECT DISTINCT custkey, orderstatus FROM orders WHERE custkey = 1268 LIMIT 15000");
        this.assertQuerySucceeds(session, "SELECT DISTINCT custkey FROM orders LIMIT 2");
        this.assertQuerySucceeds(session, "SELECT DISTINCT custkey FROM orders LIMIT 10000");
        this.assertQuery(session, "SELECT DISTINCT x FROM (VALUES 1) t(x) JOIN (VALUES 10, 20) u(a) ON t.x < u.a LIMIT 100", "SELECT 1");
    }

    @Test
    public void testDistinctWithOrderBy() {
        this.assertQueryOrdered("SELECT DISTINCT custkey FROM orders ORDER BY custkey LIMIT 10");
    }

    @Test
    public void testDistinctWithOrderByNotInSelect() {
        this.assertQueryFails("SELECT DISTINCT custkey FROM orders ORDER BY orderkey LIMIT 10", "line 1:1: For SELECT DISTINCT, ORDER BY expressions must appear in select list");
    }

    @Test
    public void testGroupByOrderByLimit() {
        this.assertQueryOrdered("SELECT custkey, SUM(totalprice) FROM orders GROUP BY custkey ORDER BY SUM(totalprice) DESC LIMIT 10");
    }

    @Test
    public void testLimitZero() {
        this.assertQuery("SELECT custkey, totalprice FROM orders LIMIT 0");
    }

    @Test
    public void testLimitAll() {
        this.assertQuery("SELECT custkey, totalprice FROM orders LIMIT ALL", "SELECT custkey, totalprice FROM orders");
    }

    @Test
    public void testOffset() {
        Session localSession = Session.builder((Session)this.getSession()).setSystemProperty("offset_clause_enabled", "true").build();
        String values = "(VALUES ('A', 3), ('D', 2), ('C', 1), ('B', 4)) AS t(x, y)";
        MaterializedResult actual = this.computeActual(localSession, "SELECT x FROM " + values + " OFFSET 2 ROWS");
        MaterializedResult all = this.computeExpected("SELECT x FROM " + values, actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)2);
        org.testng.Assert.assertNotEquals(actual.getMaterializedRows().get(0), actual.getMaterializedRows().get(1));
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testOffsetEmptyResult() {
        Session localSession = Session.builder((Session)this.getSession()).setSystemProperty("offset_clause_enabled", "true").build();
        this.assertQueryReturnsEmptyResult(localSession, "SELECT name FROM nation OFFSET 100 ROWS");
        this.assertQueryReturnsEmptyResult(localSession, "SELECT name FROM nation ORDER BY regionkey OFFSET 100 ROWS");
        this.assertQueryReturnsEmptyResult(localSession, "SELECT name FROM nation OFFSET 100 ROWS LIMIT 20");
        this.assertQueryReturnsEmptyResult(localSession, "SELECT name FROM nation ORDER BY regionkey OFFSET 100 ROWS LIMIT 20");
    }

    @Test
    public void testRepeatedAggregations() {
        this.assertQuery("SELECT SUM(orderkey), SUM(orderkey) FROM orders");
    }

    @Test
    public void testRepeatedOutputs() {
        this.assertQuery("SELECT orderkey a, orderkey b FROM orders WHERE orderstatus = 'F'");
    }

    @Test
    public void testRepeatedOutputs2() {
        this.assertQuery("SELECT orderdate, orderdate, orderkey FROM orders");
    }

    @Test
    public void testLimit() {
        MaterializedResult actual = this.computeActual("SELECT orderkey FROM orders LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testLimitWithAggregation() {
        MaterializedResult actual = this.computeActual("SELECT custkey, SUM(CAST(totalprice * 100 AS BIGINT)) FROM orders GROUP BY custkey LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT custkey, SUM(CAST(totalprice * 100 AS BIGINT)) FROM orders GROUP BY custkey", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testLimitInInlineView() {
        MaterializedResult actual = this.computeActual("SELECT orderkey FROM (SELECT orderkey FROM orders LIMIT 100) T LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testCountAll() {
        this.assertQuery("SELECT COUNT(*) FROM orders");
        this.assertQuery("SELECT COUNT(42) FROM orders", "SELECT COUNT(*) FROM orders");
        this.assertQuery("SELECT COUNT(42 + 42) FROM orders", "SELECT COUNT(*) FROM orders");
        this.assertQuery("SELECT COUNT(null) FROM orders", "SELECT 0");
    }

    @Test
    public void testCountColumn() {
        this.assertQuery("SELECT COUNT(orderkey) FROM orders");
        this.assertQuery("SELECT COUNT(orderstatus) FROM orders");
        this.assertQuery("SELECT COUNT(orderdate) FROM orders");
        this.assertQuery("SELECT COUNT(1) FROM orders");
        this.assertQuery("SELECT COUNT(NULLIF(orderstatus, 'F')) FROM orders");
        this.assertQuery("SELECT COUNT(CAST(NULL AS BIGINT)) FROM orders");
    }

    @Test
    public void testWildcard() {
        this.assertQuery("SELECT * FROM orders");
    }

    @Test
    public void testMultipleWildcards() {
        this.assertQuery("SELECT *, 123, * FROM orders");
    }

    @Test
    public void testMixedWildcards() {
        this.assertQuery("SELECT *, orders.*, orderkey FROM orders");
    }

    @Test
    public void testQualifiedWildcardFromAlias() {
        this.assertQuery("SELECT T.* FROM orders T");
    }

    @Test
    public void testQualifiedWildcardFromInlineView() {
        this.assertQuery("SELECT T.* FROM (SELECT orderkey + custkey FROM orders) T");
    }

    @Test
    public void testQualifiedWildcard() {
        this.assertQuery("SELECT orders.* FROM orders");
    }

    @Test
    public void testAverageAll() {
        this.assertQuery("SELECT AVG(totalprice) FROM orders");
    }

    @Test
    public void testVariance() {
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM orders");
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT VAR_SAMP(custkey) FROM (SELECT custkey FROM orders LIMIT 0) T");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM orders");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT VAR_SAMP(totalprice) FROM (SELECT totalprice FROM orders LIMIT 0) T");
    }

    @Test
    public void testVariancePop() {
        this.assertQuery("SELECT VAR_POP(custkey) FROM orders");
        this.assertQuery("SELECT VAR_POP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT VAR_POP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT VAR_POP(custkey) FROM (SELECT custkey FROM orders LIMIT 0) T");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM orders");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT VAR_POP(totalprice) FROM (SELECT totalprice FROM orders LIMIT 0) T");
    }

    @Test
    public void testStdDev() {
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM orders");
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_SAMP(custkey) FROM (SELECT custkey FROM orders LIMIT 0) T");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM orders");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_SAMP(totalprice) FROM (SELECT totalprice FROM orders LIMIT 0) T");
    }

    @Test
    public void testStdDevPop() {
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM orders");
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM (SELECT custkey FROM orders ORDER BY custkey LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_POP(custkey) FROM (SELECT custkey FROM orders LIMIT 0) T");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM orders");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 2) T");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM (SELECT totalprice FROM orders ORDER BY totalprice LIMIT 1) T");
        this.assertQuery("SELECT STDDEV_POP(totalprice) FROM (SELECT totalprice FROM orders LIMIT 0) T");
    }

    @Test
    public void testRollupOverUnion() {
        this.assertQuery("SELECT orderstatus, sum(orderkey)\nFROM (SELECT orderkey, orderstatus\n      FROM orders\n      UNION ALL\n      SELECT orderkey, orderstatus\n      FROM orders) x\nGROUP BY ROLLUP (orderstatus)", "VALUES ('P', 21470000),\n('O', 439774330),\n('F', 438500670),\n(NULL, 899745000)");
        this.assertQuery("SELECT regionkey, count(*) FROM (   SELECT regionkey FROM nation    UNION ALL    SELECT * FROM (VALUES 2, 100) t(regionkey)) GROUP BY ROLLUP (regionkey)", "SELECT * FROM (VALUES  (0, 5), (1, 5), (2, 6), (3, 5), (4, 5), (100, 1), (NULL, 27))");
    }

    @Test
    public void testGrouping() {
        this.assertQuery("SELECT a, b AS t, sum(c), grouping(a, b) + grouping(a) FROM (VALUES ('h', 'j', 11), ('k', 'l', 7)) AS t (a, b, c) GROUP BY GROUPING SETS ( (a), (b)) ORDER BY grouping(b) ASC", "VALUES (NULL, 'j', 11, 3), (NULL, 'l', 7, 3), ('h', NULL, 11, 1), ('k', NULL, 7, 1)");
        this.assertQuery("SELECT a, sum(b), grouping(a) FROM (VALUES ('h', 11, 0), ('k', 7, 0)) AS t (a, b, c) GROUP BY GROUPING SETS (a)", "VALUES ('h', 11, 0), ('k', 7, 0)");
        this.assertQuery("SELECT a, sum(b) as sum FROM (VALUES ('h', 11), ('h', 12), ('k', 7)) AS t (a, b) GROUP BY GROUPING SETS ((), a) order by sum limit 1", "VALUES ('k',7)");
        this.assertQuery("SELECT a, b, sum(c), grouping(a, b) FROM (VALUES ('h', 'j', 11), ('k', 'l', 7) ) AS t (a, b, c) GROUP BY GROUPING SETS ( (a), (b)) HAVING grouping(a, b) > 1 ", "VALUES (NULL, 'j', 11, 2), (NULL, 'l', 7, 2)");
        this.assertQuery("SELECT a, grouping(a) * 1.0 FROM (VALUES (1) ) AS t (a) GROUP BY a", "VALUES (1, 0.0)");
        this.assertQuery("SELECT a, grouping(a), grouping(a) FROM (VALUES (1) ) AS t (a) GROUP BY a", "VALUES (1, 0, 0)");
        this.assertQuery("SELECT grouping(a) FROM (VALUES ('h', 'j', 11), ('k', 'l', 7)) AS t (a, b, c) GROUP BY GROUPING SETS (a,c), c*2", "VALUES (0), (1), (0), (1)");
    }

    @Test
    public void testGroupingWithFortyArguments() {
        String fortyLetterSequence = "aa, ab, ac, ad, ae, af, ag, ah, ai, aj, ak, al, am, an, ao, ap, aq, ar, asa, at, au, av, aw, ax, ay, az, ba, bb, bc, bd, be, bf, bg, bh, bi, bj, bk, bl, bm, bn";
        String fortyIntegers = "1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40";
        String groupingSet1 = "at, ab, am, bg, bn, ai, an";
        String groupingSet2 = "bb, ad, ae, bc, be, aj";
        String query = String.format("SELECT grouping(%s) FROM (VALUES (%s)) AS t(%s) GROUP BY GROUPING SETS ((%s), (%s), (%s))", fortyLetterSequence, fortyIntegers, fortyLetterSequence, fortyLetterSequence, groupingSet1, groupingSet2);
        this.assertQuery(query, "VALUES (0), (822283861886), (995358664191)");
    }

    @Test
    public void testGroupingInTableSubquery() {
        this.assertQuery("SELECT orderkey, custkey, sum(agg_price) AS outer_sum, grouping(orderkey, custkey), g FROM     (SELECT orderkey, custkey, sum(totalprice) AS agg_price, grouping(custkey, orderkey) AS g         FROM orders         GROUP BY orderkey, custkey         ORDER BY agg_price ASC         LIMIT 5) AS t GROUP BY GROUPING SETS ((orderkey, custkey), g) ORDER BY outer_sum", "VALUES (35271, 334, 874.89, 0, NULL),        (28647, 1351, 924.33, 0, NULL),        (58145, 862, 929.03, 0, NULL),        (8354, 634, 974.04, 0, NULL),        (37415, 301, 986.63, 0, NULL),        (NULL, NULL, 4688.92, 3, 0)");
        this.assertQuery("SELECT orderkey, custkey, g, sum(agg_price) AS outer_sum, grouping(orderkey, custkey) FROM     (SELECT orderkey, custkey, sum(totalprice) AS agg_price, grouping(custkey, orderkey) AS g      FROM orders      GROUP BY GROUPING SETS ((custkey), (orderkey))      ORDER BY agg_price ASC      LIMIT 5) AS t GROUP BY orderkey, custkey, g", "VALUES (28647, NULL, 2, 924.33, 0),        (8354, NULL, 2, 974.04, 0),        (37415, NULL, 2, 986.63, 0),        (58145, NULL, 2, 929.03, 0),        (35271, NULL, 2, 874.89, 0)");
        this.assertQuery("SELECT orderkey, custkey, sum(agg_price) AS outer_sum, grouping(orderkey, custkey) FROM    (SELECT orderkey, custkey, sum(totalprice) AS agg_price     FROM orders     GROUP BY GROUPING SETS ((custkey), (orderkey))     ORDER BY agg_price ASC NULLS FIRST) AS t GROUP BY orderkey, custkey ORDER BY outer_sum ASC NULLS FIRST LIMIT 5", "VALUES (35271, NULL, 874.89, 0),        (28647, NULL, 924.33, 0),        (58145, NULL, 929.03, 0),        (8354,  NULL, 974.04, 0),        (37415, NULL, 986.63, 0)");
    }

    @Test
    public void testIntersect() {
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21");
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT DISTINCT SELECT regionkey FROM nation WHERE nationkey > 21", "VALUES 1, 3");
        this.assertQuery("WITH wnation AS (SELECT nationkey, regionkey FROM nation) SELECT regionkey FROM wnation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM wnation WHERE nationkey > 21", "VALUES 1, 3");
        this.assertQuery("SELECT num FROM (SELECT 1 AS num FROM nation WHERE nationkey=10 INTERSECT SELECT 1 FROM nation WHERE nationkey=20) T");
        this.assertQuery("SELECT nationkey, nationkey / 2 FROM (SELECT nationkey FROM nation WHERE nationkey < 10 INTERSECT SELECT nationkey FROM nation WHERE nationkey > 4) T WHERE nationkey % 2 = 0");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21) UNION SELECT 4");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 UNION SELECT regionkey FROM nation WHERE nationkey > 21) INTERSECT SELECT 1");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21) UNION ALL SELECT 3");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 INTERSECT SELECT regionkey FROM nation WHERE nationkey > 21) UNION ALL SELECT 3");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) INTERSECT SELECT * FROM (VALUES 1.0, 2)", "VALUES 1.0, 2.0");
        this.assertQuery("SELECT NULL, NULL INTERSECT SELECT NULL, NULL FROM nation");
        MaterializedResult emptyResult = this.computeActual("SELECT 100 INTERSECT (SELECT regionkey FROM nation WHERE nationkey <10)");
        Assert.assertEquals((int)emptyResult.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testIntersectWithAggregation() {
        this.assertQuery("SELECT COUNT(*) FROM nation INTERSECT SELECT COUNT(regionkey) FROM nation HAVING SUM(regionkey) IS NOT NULL");
        this.assertQuery("SELECT SUM(nationkey), COUNT(name) FROM (SELECT nationkey,name FROM nation INTERSECT SELECT regionkey, name FROM nation) n");
        this.assertQuery("SELECT COUNT(*) * 2 FROM nation INTERSECT (SELECT SUM(nationkey) FROM nation GROUP BY regionkey ORDER BY 1 LIMIT 2)");
        this.assertQuery("SELECT COUNT(a) FROM (SELECT nationkey AS a FROM (SELECT nationkey FROM nation INTERSECT SELECT regionkey FROM nation) n1 INTERSECT SELECT regionkey FROM nation) n2");
        this.assertQuery("SELECT COUNT(*), SUM(2), regionkey FROM (SELECT nationkey, regionkey FROM nation INTERSECT SELECT regionkey, regionkey FROM nation) n GROUP BY regionkey");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT nationkey FROM nation INTERSECT SELECT 2) n1 INTERSECT SELECT regionkey FROM nation");
    }

    @Test
    public void testIntersectAllFails() {
        this.assertQueryFails("SELECT * FROM (VALUES 1, 2, 3, 4) INTERSECT ALL SELECT * FROM (VALUES 3, 4)", "line 1:35: INTERSECT ALL not yet implemented");
    }

    @Test
    public void testExcept() {
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM nation WHERE nationkey > 21");
        this.assertQuery("SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT DISTINCT SELECT regionkey FROM nation WHERE nationkey > 21", "VALUES 0, 4");
        this.assertQuery("WITH wnation AS (SELECT nationkey, regionkey FROM nation) SELECT regionkey FROM wnation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM wnation WHERE nationkey > 21", "VALUES 0, 4");
        this.assertQuery("SELECT num FROM (SELECT 1 AS num FROM nation WHERE nationkey=10 EXCEPT SELECT 2 FROM nation WHERE nationkey=20) T");
        this.assertQuery("SELECT nationkey, nationkey / 2 FROM (SELECT nationkey FROM nation WHERE nationkey < 10 EXCEPT SELECT nationkey FROM nation WHERE nationkey > 4) T WHERE nationkey % 2 = 0");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM nation WHERE nationkey > 21) UNION SELECT 3");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 UNION SELECT regionkey FROM nation WHERE nationkey > 21) EXCEPT SELECT 1");
        this.assertQuery("SELECT regionkey FROM (SELECT regionkey FROM nation WHERE nationkey < 7 EXCEPT SELECT regionkey FROM nation WHERE nationkey > 21) UNION ALL SELECT 4");
        this.assertQuery("SELECT * FROM (VALUES 1, 2) EXCEPT SELECT * FROM (VALUES 3.0, 2)");
        this.assertQuery("SELECT NULL, NULL EXCEPT SELECT NULL, NULL FROM nation");
        this.assertQuery("(SELECT * FROM (VALUES 1) EXCEPT SELECT * FROM (VALUES 0))EXCEPT (SELECT * FROM (VALUES 1) EXCEPT SELECT * FROM (VALUES 1))");
        MaterializedResult emptyResult = this.computeActual("SELECT 0 EXCEPT (SELECT regionkey FROM nation WHERE nationkey <10)");
        Assert.assertEquals((int)emptyResult.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testExceptWithAggregation() {
        this.assertQuery("SELECT COUNT(*) FROM nation EXCEPT SELECT COUNT(regionkey) FROM nation WHERE regionkey < 3 HAVING SUM(regionkey) IS NOT NULL");
        this.assertQuery("SELECT SUM(nationkey), COUNT(name) FROM (SELECT nationkey, name FROM nation WHERE nationkey < 6 EXCEPT SELECT regionkey, name FROM nation) n");
        this.assertQuery("(SELECT SUM(nationkey) FROM nation GROUP BY regionkey ORDER BY 1 LIMIT 2) EXCEPT SELECT COUNT(*) * 2 FROM nation");
        this.assertQuery("SELECT COUNT(a) FROM (SELECT nationkey AS a FROM (SELECT nationkey FROM nation EXCEPT SELECT regionkey FROM nation) n1 EXCEPT SELECT regionkey FROM nation) n2");
        this.assertQuery("SELECT COUNT(*), SUM(2), regionkey FROM (SELECT nationkey, regionkey FROM nation EXCEPT SELECT regionkey, regionkey FROM nation) n GROUP BY regionkey HAVING regionkey < 3");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT nationkey FROM nation EXCEPT SELECT 10) n1 EXCEPT SELECT regionkey FROM nation");
    }

    @Test
    public void testExceptAllFails() {
        this.assertQueryFails("SELECT * FROM (VALUES 1, 2, 3, 4) EXCEPT ALL SELECT * FROM (VALUES 3, 4)", "line 1:35: EXCEPT ALL not yet implemented");
    }

    @Test
    public void testSelectWithComparison() {
        this.assertQuery("SELECT orderkey FROM lineitem WHERE tax < discount");
    }

    @Test
    public void testInlineView() {
        this.assertQuery("SELECT orderkey, custkey FROM (SELECT orderkey, custkey FROM orders) U");
    }

    @Test
    public void testAliasedInInlineView() {
        this.assertQuery("SELECT x, y FROM (SELECT orderkey x, custkey y FROM orders) U");
    }

    @Test
    public void testInlineViewWithProjections() {
        this.assertQuery("SELECT x + 1, y FROM (SELECT orderkey * 10 x, custkey y FROM orders) u");
    }

    @Test
    public void testInUncorrelatedSubquery() {
        this.assertQuery("SELECT CASE WHEN false THEN 1 IN (VALUES 2) END", "SELECT NULL");
        this.assertQuery("SELECT x FROM (VALUES 2) t(x) WHERE MAP(ARRAY[8589934592], ARRAY[x]) IN (VALUES MAP(ARRAY[8589934592],ARRAY[2]))", "SELECT 2");
        this.assertQuery("SELECT a IN (VALUES 2), a FROM (VALUES (2)) t(a)", "SELECT TRUE, 2");
    }

    @Test
    public void testChecksum() {
        this.assertQuery("SELECT to_hex(checksum(0))", "SELECT '0000000000000000'");
    }

    @Test
    public void testMaxBy() {
        this.assertQuery("SELECT MAX_BY(orderkey, totalprice) FROM orders", "SELECT orderkey FROM orders ORDER BY totalprice DESC LIMIT 1");
    }

    @Test
    public void testMaxByN() {
        this.assertQuery("SELECT y FROM (SELECT MAX_BY(orderkey, totalprice, 2) mx FROM orders) CROSS JOIN UNNEST(mx) u(y)", "SELECT orderkey FROM orders ORDER BY totalprice DESC LIMIT 2");
    }

    @Test
    public void testMinBy() {
        this.assertQuery("SELECT MIN_BY(orderkey, totalprice) FROM orders", "SELECT orderkey FROM orders ORDER BY totalprice ASC LIMIT 1");
        this.assertQuery("SELECT MIN_BY(a, ROW(b, c)) FROM (VALUES (1, 2, 3), (2, 2, 1)) AS t(a, b, c)", "SELECT 2");
    }

    @Test
    public void testMinByN() {
        this.assertQuery("SELECT y FROM (SELECT MIN_BY(orderkey, totalprice, 2) mx FROM orders) CROSS JOIN UNNEST(mx) u(y)", "SELECT orderkey FROM orders ORDER BY totalprice ASC LIMIT 2");
    }

    @Test
    public void testHaving() {
        this.assertQuery("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus HAVING orderstatus = 'O'");
    }

    @Test
    public void testHaving2() {
        this.assertQuery("SELECT custkey, sum(orderkey) FROM orders GROUP BY custkey HAVING sum(orderkey) > 400000");
    }

    @Test
    public void testHaving3() {
        this.assertQuery("SELECT custkey, sum(totalprice) * 2 FROM orders GROUP BY custkey");
        this.assertQuery("SELECT custkey, avg(totalprice + 5) FROM orders GROUP BY custkey");
        this.assertQuery("SELECT custkey, sum(totalprice) * 2 FROM orders GROUP BY custkey HAVING avg(totalprice + 5) > 10");
    }

    @Test
    public void testHavingWithoutGroupBy() {
        this.assertQuery("SELECT sum(orderkey) FROM orders HAVING sum(orderkey) > 400000");
    }

    @Test
    public void testColumnAliases() {
        this.assertQuery("SELECT x, T.y, z + 1 FROM (SELECT custkey, orderstatus, totalprice FROM orders) T (x, y, z)", "SELECT custkey, orderstatus, totalprice + 1 FROM orders");
    }

    @Test
    public void testRowNumberNoOptimization() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) WHERE NOT rn <= 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey, orderstatus FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)(all.getMaterializedRows().size() - 10));
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn - 5 <= 10");
        all = this.computeExpected("SELECT orderkey, orderstatus FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)15);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testRowNumberLimit() {
        MaterializedResult actual = this.computeActual("SELECT row_number() OVER (PARTITION BY orderstatus) rn, orderstatus\nFROM orders\nLIMIT 10");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        actual = this.computeActual("SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn\nFROM orders\nLIMIT 10");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        actual = this.computeActual("SELECT row_number() OVER () rn, orderstatus\nFROM orders\nLIMIT 10");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        actual = this.computeActual("SELECT row_number() OVER (ORDER BY orderkey) rn\nFROM orders\nLIMIT 10");
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
    }

    @Test
    public void testRowNumberMultipleFilters() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn < 3 AND rn % 2 = 0 AND a = 2 LIMIT 2");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{2, 2L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testRowNumberSpecialFilters() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn = -1");
        this.assertQueryReturnsEmptyResult("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn <= -1");
        this.assertQueryReturnsEmptyResult("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn = 0");
        this.assertQueryReturnsEmptyResult("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn = -1");
        this.assertQueryReturnsEmptyResult("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn <= -1");
        this.assertQueryReturnsEmptyResult("SELECT * FROM (   SELECT a, row_number() OVER (PARTITION BY a) rn\n   FROM (VALUES (1), (1), (1), (2), (2), (3)) t (a)) t WHERE rn = 0");
    }

    @Test
    public void testRowNumberFilterAndLimit() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (SELECT a, row_number() OVER (PARTITION BY a ORDER BY a) rn\nFROM (VALUES (1), (2), (1), (2)) t (a)) t WHERE rn < 2 LIMIT 2");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1, 1L}).row(new Object[]{2, 1L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
        actual = this.computeActual("SELECT * FROM (SELECT a, row_number() OVER (PARTITION BY a) rn\nFROM (VALUES (1), (2), (1), (2), (1)) t (a)) t WHERE rn < 3 LIMIT 2");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1, 1L}).row(new Object[]{1, 2L}).row(new Object[]{2, 1L}).row(new Object[]{2, 2L}).build();
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)2);
        QueryAssertions.assertContains(expected, actual);
    }

    @Test
    public void testRowNumberUnpartitionedFilter() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn <= 5 AND orderstatus != 'Z'");
        MaterializedResult all = this.computeExpected("SELECT orderkey, orderstatus FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)5);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn < 5");
        all = this.computeExpected("SELECT orderkey, orderstatus FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)4);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER () rn, orderkey, orderstatus\n   FROM orders\n) LIMIT 5");
        all = this.computeExpected("SELECT orderkey, orderstatus FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)5);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testRowNumberPartitionedFilter() {
        MaterializedResult actual = this.computeActual("SELECT orderkey, orderstatus FROM (\n   SELECT row_number() OVER (PARTITION BY orderstatus) rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn <= 5");
        MaterializedResult all = this.computeExpected("SELECT orderkey, orderstatus FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)15);
        QueryAssertions.assertContains(all, actual);
        actual = this.computeActual("SELECT orderkey FROM (\n   SELECT row_number() OVER (PARTITION BY orderstatus) rn, orderkey\n   FROM orders\n) WHERE rn <= 5");
        all = this.computeExpected("SELECT orderkey FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)15);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testRowNumberUnpartitionedFilterLimit() {
        this.assertQuery("SELECT row_number() OVER ()\nFROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey\nWHERE orders.orderkey = 10000\nLIMIT 20");
    }

    @Test
    public void testRowNumberPropertyDerivation() {
        this.assertQuery("SELECT orderkey, orderstatus, SUM(rn) OVER (PARTITION BY orderstatus) c FROM (    SELECT orderkey, orderstatus, row_number() OVER (PARTITION BY orderstatus) rn    FROM (        SELECT * FROM orders ORDER BY orderkey LIMIT 10    ) )", "VALUES (1, 'O', 21), (2, 'O', 21), (3, 'F', 10), (4, 'O', 21), (5, 'F', 10), (6, 'F', 10), (7, 'O', 21), (32, 'O', 21), (33, 'F', 10), (34, 'O', 21)");
    }

    @Test
    public void testTopNUnpartitionedWindow() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n   SELECT row_number() OVER (ORDER BY orderkey) rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn <= 5");
        String sql = "SELECT row_number() OVER (), orderkey, orderstatus FROM orders ORDER BY orderkey LIMIT 5";
        MaterializedResult expected = this.computeExpected(sql, actual.getTypes());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testTopNUnpartitionedLargeWindow() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (\n   SELECT row_number() OVER (ORDER BY orderkey) rn, orderkey, orderstatus\n   FROM orders\n) WHERE rn <= 10000");
        String sql = "SELECT row_number() OVER (), orderkey, orderstatus FROM orders ORDER BY orderkey LIMIT 10000";
        MaterializedResult expected = this.computeExpected(sql, actual.getTypes());
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testTopNPartitionedWindow() {
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderkey, orderstatus    FROM orders ) WHERE rn <= 2", "VALUES (1, 1, 'O'), (2, 2, 'O'), (1, 3, 'F'), (2, 5, 'F'), (1, 65, 'P'), (2, 197, 'P')");
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderkey    FROM orders ) WHERE rn <= 2", "VALUES (1, 1), (2, 2), (1, 3), (2, 5), (1, 65), (2, 197)");
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderstatus    FROM orders ) WHERE rn <= 2", "VALUES (1, 'O'), (2, 'O'), (1, 'F'), (2, 'F'), (1, 'P'), (2, 'P')");
    }

    @Test
    public void testTopNUnpartitionedWindowWithEqualityFilter() {
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (ORDER BY orderkey) rn, orderkey, orderstatus    FROM orders ) WHERE rn = 2", "VALUES (2, 2, 'O')");
    }

    @Test
    public void testTopNUnpartitionedWindowWithCompositeFilter() {
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (ORDER BY orderkey) rn, orderkey, orderstatus    FROM orders ) WHERE rn = 1 OR rn IN (3, 4) OR rn BETWEEN 6 AND 7", "VALUES (1, 1, 'O'), (3, 3, 'F'), (4, 4, 'O'), (6, 6, 'F'), (7, 7, 'O')");
    }

    @Test
    public void testTopNPartitionedWindowWithEqualityFilter() {
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderkey, orderstatus    FROM orders ) WHERE rn = 2", "VALUES (2, 2, 'O'), (2, 5, 'F'), (2, 197, 'P')");
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderkey    FROM orders ) WHERE rn = 2", "VALUES (2, 2), (2, 5), (2, 197)");
        this.assertQuery("SELECT * FROM (    SELECT row_number() OVER (PARTITION BY orderstatus ORDER BY orderkey) rn, orderstatus    FROM orders ) WHERE rn = 2", "VALUES (2, 'O'), (2, 'F'), (2, 'P')");
    }

    @Test
    public void testScalarFunction() {
        this.assertQuery("SELECT SUBSTR('Quadratically', 5, 6)");
    }

    @Test
    public void testCast() {
        this.assertQuery("SELECT CAST('1' AS BIGINT)");
        this.assertQuery("SELECT CAST(totalprice AS BIGINT) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS DOUBLE) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS VARCHAR) FROM orders");
        this.assertQuery("SELECT CAST(orderkey AS BOOLEAN) FROM orders");
        this.assertQuery("SELECT try_cast('1' AS BIGINT)", "SELECT CAST('1' AS BIGINT)");
        this.assertQuery("SELECT try_cast(totalprice AS BIGINT) FROM orders", "SELECT CAST(totalprice AS BIGINT) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey AS DOUBLE) FROM orders", "SELECT CAST(orderkey AS DOUBLE) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey AS VARCHAR) FROM orders", "SELECT CAST(orderkey AS VARCHAR) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey AS BOOLEAN) FROM orders", "SELECT CAST(orderkey AS BOOLEAN) FROM orders");
        this.assertQuery("SELECT try_cast('foo' AS BIGINT)", "SELECT CAST(null AS BIGINT)");
        this.assertQuery("SELECT try_cast(clerk AS BIGINT) FROM orders", "SELECT CAST(null AS BIGINT) FROM orders");
        this.assertQuery("SELECT try_cast(orderkey * orderkey AS VARCHAR) FROM orders", "SELECT CAST(orderkey * orderkey AS VARCHAR) FROM orders");
        this.assertQuery("SELECT try_cast(try_cast(orderkey AS VARCHAR) AS BIGINT) FROM orders", "SELECT orderkey FROM orders");
        this.assertQuery("SELECT try_cast(clerk AS VARCHAR) || try_cast(clerk AS VARCHAR) FROM orders", "SELECT clerk || clerk FROM orders");
        this.assertQuery("SELECT coalesce(try_cast('foo' AS BIGINT), 456)", "SELECT 456");
        this.assertQuery("SELECT coalesce(try_cast(clerk AS BIGINT), 456) FROM orders", "SELECT 456 FROM orders");
        this.assertQuery("SELECT CAST(x AS BIGINT) FROM (VALUES 1, 2, 3, NULL) t (x)", "VALUES 1, 2, 3, NULL");
        this.assertQuery("SELECT try_cast(x AS BIGINT) FROM (VALUES 1, 2, 3, NULL) t (x)", "VALUES 1, 2, 3, NULL");
    }

    @Test
    public void testNestedCast() {
        this.assertQuery("select cast(varchar_value as varchar(3)) || ' sfd' from (values ('9898.122')) t(varchar_value)", "VALUES '989 sfd'");
        this.assertQuery("select cast(cast(varchar_value as varchar(3)) as varchar(5)) from (values ('9898.122')) t(varchar_value)", "VALUES '989'");
    }

    @Test
    public void testInvalidCast() {
        this.assertQueryFails("SELECT CAST(1 AS DATE)", "line 1:8: Cannot cast integer to date");
    }

    @Test
    public void testInvalidCastInMultilineQuery() {
        this.assertQueryFails("SELECT CAST(totalprice AS BIGINT),\nCAST(2015 AS DATE),\nCAST(orderkey AS DOUBLE) FROM orders", "line 2:1: Cannot cast integer to date");
    }

    @Test
    public void testTryInvalidCast() {
        this.assertQuery("SELECT TRY(CAST('a' AS BIGINT))", "SELECT NULL");
    }

    @Test
    public void testConcatOperator() {
        this.assertQuery("SELECT '12' || '34'");
    }

    @Test
    public void testQuotedIdentifiers() {
        this.assertQuery("SELECT \"TOTALPRICE\" \"my price\" FROM \"ORDERS\"");
    }

    @Test
    public void testInvalidColumn() {
        this.assertQueryFails("SELECT * FROM lineitem l JOIN (SELECT orderkey_1, custkey FROM orders) o on l.orderkey = o.orderkey_1", "line 1:39: Column 'orderkey_1' cannot be resolved");
    }

    @Test
    public void testUnaliasedSubqueries() {
        this.assertQuery("SELECT orderkey FROM (SELECT orderkey FROM orders)");
    }

    @Test
    public void testUnaliasedSubqueries1() {
        this.assertQuery("SELECT a FROM (SELECT orderkey a FROM orders)");
    }

    @Test
    public void testWith() {
        this.assertQuery("WITH a AS (SELECT * FROM orders) SELECT * FROM a", "SELECT * FROM orders");
        this.assertQuerySucceeds("WITH t(x, y, z) AS (TABLE region) SELECT * FROM t");
    }

    @Test
    public void testWithQualifiedPrefix() {
        this.assertQuery("WITH a AS (SELECT 123) SELECT a.* FROM a", "SELECT 123");
    }

    @Test
    public void testWithAliased() {
        this.assertQuery("WITH a AS (SELECT * FROM orders) SELECT * FROM a x", "SELECT * FROM orders");
    }

    @Test
    public void testReferenceToWithQueryInFromClause() {
        this.assertQuery("WITH a AS (SELECT * FROM orders)SELECT * FROM (   SELECT * FROM a)", "SELECT * FROM orders");
    }

    @Test
    public void testWithChaining() {
        this.assertQuery("WITH a AS (SELECT orderkey n FROM orders)\n, b AS (SELECT n + 1 n FROM a)\n, c AS (SELECT n + 1 n FROM b)\nSELECT n + 1 FROM c", "SELECT orderkey + 3 FROM orders");
    }

    @Test
    public void testWithNestedSubqueries() {
        this.assertQuery("WITH a AS (\n  WITH aa AS (SELECT 123 x FROM orders LIMIT 1)\n  SELECT x y FROM aa\n), b AS (\n  WITH bb AS (\n    WITH bbb AS (SELECT y FROM a)\n    SELECT bbb.* FROM bbb\n  )\n  SELECT y z FROM bb\n)\nSELECT *\nFROM (\n  WITH q AS (SELECT z w FROM b)\n  SELECT j.*, k.*\n  FROM a j\n  JOIN q k ON (j.y = k.w)\n) t", "SELECT 123, 123 FROM orders LIMIT 1");
    }

    @Test
    public void testWithColumnAliasing() {
        this.assertQuery("WITH a (id) AS (SELECT 123) SELECT id FROM a", "SELECT 123");
        this.assertQuery("WITH t (a, b, c) AS (SELECT 1, custkey x, orderkey FROM orders) SELECT c, b, a FROM t", "SELECT orderkey, custkey, 1 FROM orders");
    }

    @Test
    public void testWithHiding() {
        this.assertQuery("WITH a AS (SELECT 1),      b AS (         WITH a AS (SELECT 2)         SELECT * FROM a    )SELECT * FROM b", "SELECT 2");
        this.assertQueryFails("WITH a AS (VALUES 1),      a AS (VALUES 2)SELECT * FROM a", "line 1:28: WITH query name 'a' specified more than once");
    }

    @Test
    public void testWithRecursive() {
        this.assertQueryFails("WITH RECURSIVE a AS (SELECT 123) SELECT * FROM a", "line 1:1: Recursive WITH queries are not supported");
    }

    @Test
    public void testCaseNoElse() {
        this.assertQuery("SELECT orderkey, CASE orderstatus WHEN 'O' THEN 'a' END FROM orders");
    }

    @Test
    public void testCaseNoElseInconsistentResultType() {
        this.assertQueryFails("SELECT orderkey, CASE orderstatus WHEN 'O' THEN 'a' WHEN '1' THEN 2 END FROM orders", "\\Qline 1:67: All CASE results must be the same type: varchar(1)\\E");
    }

    @Test
    public void testCaseWithSupertypeCast() {
        this.assertQuery(" SELECT CASE x WHEN 1 THEN CAST(1 AS decimal(4,1)) WHEN 2 THEN CAST(1 AS decimal(4,2)) ELSE CAST(1 AS decimal(4,3)) END FROM (values 1) t(x)", "SELECT 1.000");
    }

    @Test
    public void testIfExpression() {
        this.assertQuery("SELECT sum(IF(orderstatus = 'F', totalprice, 0.0)) FROM orders", "SELECT sum(CASE WHEN orderstatus = 'F' THEN totalprice ELSE 0.0 END) FROM orders");
        this.assertQuery("SELECT sum(IF(orderstatus = 'Z', totalprice)) FROM orders", "SELECT sum(CASE WHEN orderstatus = 'Z' THEN totalprice END) FROM orders");
        this.assertQuery("SELECT sum(IF(orderstatus = 'F', NULL, totalprice)) FROM orders", "SELECT sum(CASE WHEN orderstatus = 'F' THEN NULL ELSE totalprice END) FROM orders");
        this.assertQuery("SELECT IF(orderstatus = 'Z', orderkey / 0, orderkey) FROM orders", "SELECT CASE WHEN orderstatus = 'Z' THEN orderkey / 0 ELSE orderkey END FROM orders");
        this.assertQuery("SELECT sum(IF(NULLIF(orderstatus, 'F') <> 'F', totalprice, 5.1)) FROM orders", "SELECT sum(CASE WHEN NULLIF(orderstatus, 'F') <> 'F' THEN totalprice ELSE 5.1 END) FROM orders");
        this.assertQuery("SELECT if(true, CAST(1 AS decimal(2,1)), 1)", "SELECT 1.0");
    }

    @Test
    public void testIn() {
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1, 2, 3)");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1.5, 2.3)", "SELECT orderkey FROM orders LIMIT 0");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1, 2E0, 3)");
        this.assertQuery("SELECT orderkey FROM orders WHERE totalprice IN (1, 2, 3)");
        this.assertQuery("SELECT x FROM (values 3, 100) t(x) WHERE x IN (2147483649)", "SELECT * WHERE false");
        this.assertQuery("SELECT x FROM (values 3, 100, 2147483648, 2147483649, 2147483650) t(x) WHERE x IN (2147483648, 2147483650)", "values 2147483648, 2147483650");
        this.assertQuery("SELECT x FROM (values 3, 100, 2147483648, 2147483649, 2147483650) t(x) WHERE x IN (3, 4, 2147483648, 2147483650)", "values 3, 2147483648, 2147483650");
        this.assertQuery("SELECT x FROM (values 1, 2, 3) t(x) WHERE x IN (1 + CAST(rand() < 0 AS bigint), 2 + CAST(rand() < 0 AS bigint))", "values 1, 2");
        this.assertQuery("SELECT x FROM (values 1, 2, 3, 4) t(x) WHERE x IN (1 + CAST(rand() < 0 AS bigint), 2 + CAST(rand() < 0 AS bigint), 4)", "values 1, 2, 4");
        this.assertQuery("SELECT x FROM (values 1, 2, 3, 4) t(x) WHERE x IN (4, 2, 1)", "values 1, 2, 4");
        this.assertQuery("SELECT x FROM (values 1, 2, 3, 2147483648) t(x) WHERE x IN (1 + CAST(rand() < 0 AS bigint), 2 + CAST(rand() < 0 AS bigint), 2147483648)", "values 1, 2, 2147483648");
        this.assertQuery("SELECT x IN (0) FROM (values 4294967296) t(x)", "values false");
        this.assertQuery("SELECT x IN (0, 4294967297 + CAST(rand() < 0 AS bigint)) FROM (values 4294967296, 4294967297) t(x)", "values false, true");
        this.assertQuery("SELECT NULL in (1, 2, 3)", "values null");
        this.assertQuery("SELECT 1 in (1, NULL, 3)", "values true");
        this.assertQuery("SELECT 2 in (1, NULL, 3)", "values null");
        this.assertQuery("SELECT x FROM (values DATE '1970-01-01', DATE '1970-01-03') t(x) WHERE x IN (DATE '1970-01-01')", "values DATE '1970-01-01'");
        Assert.assertEquals((Collection)this.computeActual("SELECT x FROM (values TIMESTAMP '1970-01-01 00:01:00+00:00', TIMESTAMP '1970-01-01 08:01:00+08:00', TIMESTAMP '1970-01-01 00:01:00+08:00') t(x) WHERE x IN (TIMESTAMP '1970-01-01 00:01:00+00:00')").getOnlyColumn().collect(Collectors.toList()), (Collection)ImmutableList.of((Object)this.zonedDateTime("1970-01-01 00:01:00.000 UTC"), (Object)this.zonedDateTime("1970-01-01 08:01:00.000 +08:00")));
        this.assertQuery("SELECT COUNT(*) FROM (values 1) t(x) WHERE x IN (null, 0)", "SELECT 0");
        this.assertQuery("SELECT d IN (DECIMAL '2.0', DECIMAL '30.0') FROM (VALUES (2.0E0)) t(d)", "SELECT true");
    }

    @Test
    public void testLargeIn() {
        String longValues = IntStream.range(0, 5000).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (" + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey NOT IN (" + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (mod(1000, orderkey), " + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey NOT IN (mod(1000, orderkey), " + longValues + ")");
        String varcharValues = IntStream.range(0, 5000).mapToObj(i -> "'" + i + "'").collect(Collectors.joining(", "));
        this.assertQuery("SELECT orderkey FROM orders WHERE cast(orderkey AS VARCHAR) IN (" + varcharValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE cast(orderkey AS VARCHAR) NOT IN (" + varcharValues + ")");
        String arrayValues = IntStream.range(0, 5000).mapToObj(i -> String.format("ARRAY[%s, %s, %s]", i, i + 1, i + 2)).collect(Collectors.joining(", "));
        this.assertQuery("SELECT ARRAY[0, 0, 0] in (ARRAY[0, 0, 0], " + arrayValues + ")", "values true");
        this.assertQuery("SELECT ARRAY[0, 0, 0] in (" + arrayValues + ")", "values false");
    }

    @Test
    public void testNullOnLhsOfInPredicateAllowed() {
        this.assertQuery("SELECT NULL IN (1, 2, 3)", "SELECT NULL");
        this.assertQuery("SELECT NULL IN (SELECT 1)", "SELECT NULL");
        this.assertQuery("SELECT NULL IN (SELECT 1 WHERE FALSE)", "SELECT FALSE");
        this.assertQuery("SELECT x FROM (VALUES NULL) t(x) WHERE x IN (SELECT 1)", "SELECT 33 WHERE FALSE");
        this.assertQuery("SELECT NULL IN (SELECT CAST(NULL AS BIGINT))", "SELECT NULL");
        this.assertQuery("SELECT NULL IN (SELECT NULL WHERE FALSE)", "SELECT FALSE");
        this.assertQuery("SELECT NULL IN ((SELECT 1) UNION ALL (SELECT NULL))", "SELECT NULL");
        this.assertQuery("SELECT x IN (SELECT TRUE) FROM (SELECT * FROM (VALUES CAST(NULL AS BOOLEAN)) t(x) WHERE (x OR NULL) IS NULL)", "SELECT NULL");
        this.assertQuery("SELECT x IN (SELECT 1) FROM (SELECT * FROM (VALUES CAST(NULL AS INTEGER)) t(x) WHERE (x + 10 IS NULL) OR X = 2)", "SELECT NULL");
        this.assertQuery("SELECT x IN (SELECT 1 WHERE FALSE) FROM (SELECT * FROM (VALUES CAST(NULL AS INTEGER)) t(x) WHERE (x + 10 IS NULL) OR X = 2)", "SELECT FALSE");
    }

    @Test
    public void testDuplicateFields() {
        this.assertQuery("SELECT * FROM (SELECT orderkey, orderkey FROM orders)", "SELECT orderkey, orderkey FROM orders");
    }

    @Test
    public void testWildcardFromSubquery() {
        this.assertQuery("SELECT * FROM (SELECT orderkey X FROM orders)");
    }

    @Test
    public void testCaseInsensitiveAttribute() {
        this.assertQuery("SELECT x FROM (SELECT orderkey X FROM orders)");
    }

    @Test
    public void testCaseInsensitiveAliasedRelation() {
        this.assertQuery("SELECT A.* FROM orders a");
    }

    @Test
    public void testCaseInsensitiveRowFieldReference() {
        this.assertQuery("SELECT a.Col0 FROM (VALUES row(cast(ROW(1,2) AS ROW(col0 integer, col1 integer)))) AS t (a)", "SELECT 1");
    }

    @Test
    public void testSubqueryBody() {
        this.assertQuery("(SELECT orderkey, custkey FROM orders)");
    }

    @Test
    public void testSubqueryBodyOrderLimit() {
        this.assertQueryOrdered("(SELECT orderkey AS a, custkey AS b FROM orders) ORDER BY a LIMIT 1");
    }

    @Test
    public void testSubqueryBodyProjectedOrderby() {
        this.assertQueryOrdered("(SELECT orderkey, custkey FROM orders) ORDER BY orderkey * -1");
    }

    @Test
    public void testSubqueryBodyDoubleOrderby() {
        this.assertQueryOrdered("(SELECT orderkey, custkey FROM orders ORDER BY custkey) ORDER BY orderkey");
    }

    @Test
    public void testNodeRoster() {
        List result = this.computeActual("SELECT * FROM system.runtime.nodes").getMaterializedRows();
        Assert.assertEquals((int)result.size(), (int)this.getNodeCount());
    }

    @Test
    public void testCountOnInternalTables() {
        List rows = this.computeActual("SELECT count(*) FROM system.runtime.nodes").getMaterializedRows();
        Assert.assertEquals((long)((Long)((MaterializedRow)rows.get(0)).getField(0)), (long)this.getNodeCount());
    }

    @Test
    public void testTransactionsTable() {
        List result = this.computeActual("SELECT * FROM system.runtime.transactions").getMaterializedRows();
        org.testng.Assert.assertTrue((result.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultExplainTextFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("EXPLAIN ", query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testDefaultExplainGraphvizFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (FORMAT GRAPHVIZ) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getGraphvizExplainPlan("EXPLAIN (FORMAT GRAPHVIZ) ", query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testLogicalExplain() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE LOGICAL) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("EXPLAIN (TYPE LOGICAL) ", query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testIOExplain() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE IO) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("EXPLAIN (TYPE IO) ", query, ExplainType.Type.IO));
    }

    @Test
    public void testLogicalExplainTextFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE LOGICAL, FORMAT TEXT) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("EXPLAIN (TYPE LOGICAL, FORMAT TEXT) ", query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testLogicalExplainGraphvizFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE LOGICAL, FORMAT GRAPHVIZ) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getGraphvizExplainPlan("EXPLAIN (TYPE LOGICAL, FORMAT GRAPHVIZ) ", query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testLogicalExplainJsonFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE LOGICAL, FORMAT JSON) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getJsonExplainPlan("EXPLAIN (TYPE LOGICAL, FORMAT JSON) ", query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testDistributedExplain() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE DISTRIBUTED) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("EXPLAIN (TYPE DISTRIBUTED) ", query, ExplainType.Type.DISTRIBUTED));
    }

    @Test
    public void testDistributedExplainTextFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE DISTRIBUTED, FORMAT TEXT) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("EXPLAIN (TYPE DISTRIBUTED, FORMAT TEXT) ", query, ExplainType.Type.DISTRIBUTED));
    }

    @Test
    public void testDistributedExplainGraphvizFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE DISTRIBUTED, FORMAT GRAPHVIZ) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getGraphvizExplainPlan("EXPLAIN (TYPE DISTRIBUTED, FORMAT GRAPHVIZ) ", query, ExplainType.Type.DISTRIBUTED));
    }

    @Test
    public void testDistributedExplainJsonFormat() {
        String query = "SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE DISTRIBUTED, FORMAT JSON) " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getJsonExplainPlan("EXPLAIN (TYPE DISTRIBUTED, FORMAT JSON) ", query, ExplainType.Type.DISTRIBUTED));
    }

    @Test
    public void testExplainValidate() {
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE VALIDATE) SELECT 1");
        Assert.assertEquals((Object)result.getOnlyValue(), (Object)true);
    }

    @Test(expectedExceptions={Exception.class}, expectedExceptionsMessageRegExp="line 1:32: Column 'x' cannot be resolved")
    public void testExplainValidateThrows() {
        this.computeActual("EXPLAIN (TYPE VALIDATE) SELECT x");
    }

    @Test
    public void testExplainOfExplain() {
        String query = "EXPLAIN SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("EXPLAIN ", query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testExplainOfExplainAnalyze() {
        String query = "EXPLAIN ANALYZE SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("EXPLAIN ", query, ExplainType.Type.LOGICAL));
    }

    @Test
    public void testExplainDdl() {
        this.assertExplainDdl("CREATE TABLE foo (pk bigint)", "CREATE TABLE foo");
        this.assertExplainDdl("CREATE VIEW foo AS SELECT * FROM orders", "CREATE VIEW foo");
        this.assertExplainDdl("CREATE OR REPLACE FUNCTION testing.default.tan (x int) RETURNS double COMMENT 'tangent trigonometric function' LANGUAGE SQL DETERMINISTIC CALLED ON NULL INPUT RETURN sin(x) / cos(x)", "CREATE FUNCTION testing.default.tan");
        this.assertExplainDdl("ALTER FUNCTION testing.default.tan CALLED ON NULL INPUT", "ALTER FUNCTION testing.default.tan");
        this.assertExplainDdl("DROP FUNCTION IF EXISTS testing.default.tan (int)", "DROP FUNCTION testing.default.tan");
        this.assertExplainDdl("DROP TABLE orders");
        this.assertExplainDdl("DROP VIEW view");
        this.assertExplainDdl("ALTER TABLE orders RENAME TO new_name");
        this.assertExplainDdl("ALTER TABLE orders RENAME COLUMN orderkey TO new_column_name");
        this.assertExplainDdl("SET SESSION foo = 'bar'");
        this.assertExplainDdl("PREPARE my_query FROM SELECT * FROM orders", "PREPARE my_query");
        this.assertExplainDdl("DEALLOCATE PREPARE my_query");
        this.assertExplainDdl("RESET SESSION foo");
        this.assertExplainDdl("START TRANSACTION");
        this.assertExplainDdl("COMMIT");
        this.assertExplainDdl("ROLLBACK");
    }

    private void assertExplainDdl(String query) {
        this.assertExplainDdl(query, query);
    }

    private void assertExplainDdl(String query, String expected) {
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)expected);
    }

    @Test
    public void testExplainExecute() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT * FROM orders").build();
        MaterializedResult result = this.computeActual(session, "EXPLAIN (TYPE LOGICAL) EXECUTE my_query");
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("", "SELECT * FROM orders", ExplainType.Type.LOGICAL));
    }

    @Test
    public void testExplainExecuteWithUsing() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT * FROM orders WHERE orderkey < ?").build();
        MaterializedResult result = this.computeActual(session, "EXPLAIN (TYPE LOGICAL) EXECUTE my_query USING 7");
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("", "SELECT * FROM orders WHERE orderkey < 7", ExplainType.Type.LOGICAL));
    }

    @Test
    public void testExplainSetSessionWithUsing() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SET SESSION foo = ?").build();
        MaterializedResult result = this.computeActual(session, "EXPLAIN (TYPE LOGICAL) EXECUTE my_query USING 7");
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)"SET SESSION foo = 7");
    }

    @Test
    public void testShowCatalogs() {
        MaterializedResult result = this.computeActual("SHOW CATALOGS");
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().contains(this.getSession().getCatalog().get()));
    }

    @Test
    public void testShowCatalogsLike() {
        MaterializedResult result = this.computeActual(String.format("SHOW CATALOGS LIKE '%s'", this.getSession().getCatalog().get()));
        Assert.assertEquals((Set)result.getOnlyColumnAsSet(), (Set)ImmutableSet.of(this.getSession().getCatalog().get()));
    }

    @Test
    public void testShowSchemas() {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS");
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of(this.getSession().getSchema().get(), (Object)"information_schema")));
    }

    @Test
    public void testShowSchemasFrom() {
        MaterializedResult result = this.computeActual(String.format("SHOW SCHEMAS FROM %s", this.getSession().getCatalog().get()));
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of(this.getSession().getSchema().get(), (Object)"information_schema")));
    }

    @Test
    public void testShowSchemasLike() {
        MaterializedResult result = this.computeActual(String.format("SHOW SCHEMAS LIKE '%s'", this.getSession().getSchema().get()));
        Assert.assertEquals((Set)result.getOnlyColumnAsSet(), (Set)ImmutableSet.of(this.getSession().getSchema().get()));
    }

    @Test
    public void testShowSchemasLikeWithEscape() {
        this.assertQueryFails("SHOW SCHEMAS IN foo LIKE '%$_%' ESCAPE", "line 1:39: mismatched input '<EOF>'. Expecting: <string>");
        this.assertQueryFails("SHOW SCHEMAS LIKE 't$_%' ESCAPE ''", "Escape string must be a single character");
        this.assertQueryFails("SHOW SCHEMAS LIKE 't$_%' ESCAPE '$$'", "Escape string must be a single character");
        Set allSchemas = this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet();
        Assert.assertEquals((Set)allSchemas, (Set)this.computeActual("SHOW SCHEMAS LIKE '%_%'").getOnlyColumnAsSet());
        Set result = this.computeActual("SHOW SCHEMAS LIKE '%$_%' ESCAPE '$'").getOnlyColumnAsSet();
        org.testng.Assert.assertNotEquals((Object)allSchemas, (Object)result);
        Assertions.assertThat((Iterable)result).contains(new Object[]{"information_schema"}).allMatch(schemaName -> ((String)schemaName).contains("_"));
    }

    @Test
    public void testShowTables() {
        ImmutableSet expectedTables = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)TpchTable.getTables(), TpchTable::getTableName));
        MaterializedResult result = this.computeActual("SHOW TABLES");
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)expectedTables));
    }

    @Test
    public void testShowTablesFrom() {
        ImmutableSet expectedTables = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)TpchTable.getTables(), TpchTable::getTableName));
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        MaterializedResult result = this.computeActual("SHOW TABLES FROM " + schema);
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)expectedTables));
        result = this.computeActual("SHOW TABLES FROM " + catalog + "." + schema);
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)expectedTables));
        this.assertQueryFails("SHOW TABLES FROM UNKNOWN", "line 1:1: Schema 'unknown' does not exist");
        this.assertQueryFails("SHOW TABLES FROM UNKNOWNCATALOG.UNKNOWNSCHEMA", "line 1:1: Catalog 'unknowncatalog' does not exist");
    }

    @Test
    public void testShowTablesLike() {
        Assertions.assertThat((Iterable)this.computeActual("SHOW TABLES LIKE 'or%'").getOnlyColumnAsSet()).contains(new Object[]{"orders"}).allMatch(tableName -> ((String)tableName).startsWith("or"));
    }

    @Test
    public void testShowTablesLikeWithEscape() {
        this.assertQueryFails("SHOW TABLES IN a LIKE '%$_%' ESCAPE", "line 1:36: mismatched input '<EOF>'. Expecting: <string>");
        this.assertQueryFails("SHOW TABLES LIKE 't$_%' ESCAPE ''", "Escape string must be a single character");
        this.assertQueryFails("SHOW TABLES LIKE 't$_%' ESCAPE '$$'", "Escape string must be a single character");
        Set allTables = this.computeActual("SHOW TABLES FROM information_schema").getOnlyColumnAsSet();
        Assert.assertEquals((Set)allTables, (Set)this.computeActual("SHOW TABLES FROM information_schema LIKE '%_%'").getOnlyColumnAsSet());
        Set result = this.computeActual("SHOW TABLES FROM information_schema LIKE '%$_%' ESCAPE '$'").getOnlyColumnAsSet();
        org.testng.Assert.assertNotEquals((Object)allTables, (Object)result);
        Assertions.assertThat((Iterable)result).contains(new Object[]{"table_privileges"}).allMatch(schemaName -> ((String)schemaName).contains("_"));
    }

    @Test
    public void testShowColumns() {
        MaterializedResult actual = this.computeActual("SHOW COLUMNS FROM orders");
        MaterializedResult expectedUnparametrizedVarchar = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar", "", ""}).row(new Object[]{"clerk", "varchar", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar", "", ""}).build();
        MaterializedResult expectedParametrizedVarchar = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
        org.testng.Assert.assertTrue((actual.equals((Object)expectedParametrizedVarchar) || actual.equals((Object)expectedUnparametrizedVarchar) ? 1 : 0) != 0, (String)String.format("%s matches neither %s nor %s", actual, expectedParametrizedVarchar, expectedUnparametrizedVarchar));
    }

    @Test
    public void testAtTimeZone() {
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE INTERVAL '07:09' hour to minute"), (Object)this.zonedDateTime("2012-10-30 18:09:00.000 +07:09"));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'Asia/Oral'"), (Object)this.zonedDateTime("2012-10-30 16:00:00.000 Asia/Oral"));
        Assert.assertEquals((Object)this.computeScalar("SELECT MIN(x) AT TIME ZONE 'America/Chicago' FROM (VALUES TIMESTAMP '1970-01-01 00:01:00+00:00') t(x)"), (Object)this.zonedDateTime("1969-12-31 18:01:00.000 America/Chicago"));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE '+07:09'"), (Object)this.zonedDateTime("2012-10-30 18:09:00.000 +07:09"));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00 UTC' AT TIME ZONE 'America/Los_Angeles'"), (Object)this.zonedDateTime("2012-10-30 18:00:00.000 America/Los_Angeles"));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'America/Los_Angeles'"), (Object)this.zonedDateTime("2012-10-30 04:00:00.000 America/Los_Angeles"));
        Assert.assertEquals((Set)this.computeActual("SELECT x AT TIME ZONE 'America/Los_Angeles' FROM (values TIMESTAMP '1970-01-01 00:01:00+00:00', TIMESTAMP '1970-01-01 08:01:00+08:00', TIMESTAMP '1969-12-31 16:01:00-08:00') t(x)").getOnlyColumnAsSet(), (Set)ImmutableSet.of((Object)this.zonedDateTime("1969-12-31 16:01:00.000 America/Los_Angeles")));
        Assert.assertEquals((Collection)this.computeActual("SELECT x AT TIME ZONE 'America/Los_Angeles' FROM (values TIMESTAMP '1970-01-01 00:01:00', TIMESTAMP '1970-01-01 08:01:00', TIMESTAMP '1969-12-31 16:01:00') t(x)").getOnlyColumn().collect(Collectors.toList()), (Collection)ImmutableList.of((Object)this.zonedDateTime("1970-01-01 03:01:00.000 America/Los_Angeles"), (Object)this.zonedDateTime("1970-01-01 11:01:00.000 America/Los_Angeles"), (Object)this.zonedDateTime("1969-12-31 19:01:00.000 America/Los_Angeles")));
        Assert.assertEquals((Object)this.computeScalar("SELECT min(x) AT TIME ZONE 'America/Los_Angeles' FROM (values TIMESTAMP '1970-01-01 00:01:00+00:00', TIMESTAMP '1970-01-01 08:01:00+08:00', TIMESTAMP '1969-12-31 16:01:00-08:00') t(x)"), (Object)this.zonedDateTime("1969-12-31 16:01:00.000 America/Los_Angeles"));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'America/Los_Angeles' AT TIME ZONE 'UTC'"), (Object)this.zonedDateTime("2012-10-30 11:00:00.000 UTC"));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'Asia/Tokyo' AT TIME ZONE 'America/Los_Angeles'"), (Object)this.zonedDateTime("2012-10-30 04:00:00.000 America/Los_Angeles"));
        Assert.assertEquals((Object)this.computeScalar("SELECT TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'America/Los_Angeles' AT TIME ZONE 'Asia/Shanghai'"), (Object)this.zonedDateTime("2012-10-30 19:00:00.000 Asia/Shanghai"));
        Assert.assertEquals((Object)this.computeScalar("SELECT min(x) AT TIME ZONE 'America/Los_Angeles' AT TIME ZONE 'UTC' FROM (values TIMESTAMP '1970-01-01 00:01:00+00:00', TIMESTAMP '1970-01-01 08:01:00+08:00', TIMESTAMP '1969-12-31 16:01:00-08:00') t(x)"), (Object)this.zonedDateTime("1970-01-01 00:01:00.000 UTC"));
        Assert.assertEquals((Object)this.computeScalar("SELECT * FROM (VALUES TIMESTAMP '2012-10-31 01:00' AT TIME ZONE 'Asia/Oral')"), (Object)this.zonedDateTime("2012-10-30 16:00:00.000 Asia/Oral"));
    }

    private ZonedDateTime zonedDateTime(String value) {
        return ZONED_DATE_TIME_FORMAT.parse((CharSequence)value, ZonedDateTime::from);
    }

    @Test
    public void testShowFunctions() {
        MaterializedResult result = this.computeActual("SHOW FUNCTIONS");
        ImmutableListMultimap functions = Multimaps.index((Iterable)result.getMaterializedRows(), input -> {
            Assert.assertEquals((int)input.getFieldCount(), (int)10);
            return (String)input.getField(0);
        });
        org.testng.Assert.assertTrue((boolean)functions.containsKey((Object)"avg"), (String)("Expected function names " + functions + " to contain 'avg'"));
        Assert.assertEquals((int)functions.get((Object)"avg").asList().size(), (int)6);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(0)).getField(1), (Object)"decimal(p,s)");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(0)).getField(2), (Object)"decimal(p,s)");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(0)).getField(3), (Object)"aggregate");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(1)).getField(1), (Object)"double");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(1)).getField(2), (Object)"bigint");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(1)).getField(3), (Object)"aggregate");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(2)).getField(1), (Object)"double");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(2)).getField(2), (Object)"double");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(2)).getField(3), (Object)"aggregate");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(3)).getField(1), (Object)"interval day to second");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(3)).getField(2), (Object)"interval day to second");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(3)).getField(3), (Object)"aggregate");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(4)).getField(1), (Object)"interval year to month");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(4)).getField(2), (Object)"interval year to month");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(4)).getField(3), (Object)"aggregate");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(5)).getField(1), (Object)"real");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(5)).getField(2), (Object)"real");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"avg").asList().get(5)).getField(3), (Object)"aggregate");
        org.testng.Assert.assertTrue((boolean)functions.containsKey((Object)"abs"), (String)("Expected function names " + functions + " to contain 'abs'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"abs").asList().get(0)).getField(3), (Object)"scalar");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"abs").asList().get(0)).getField(4), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"abs").asList().get(0)).getField(6), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"abs").asList().get(0)).getField(7), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"abs").asList().get(0)).getField(8), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"abs").asList().get(0)).getField(9), (Object)"");
        org.testng.Assert.assertTrue((boolean)functions.containsKey((Object)"rand"), (String)("Expected function names " + functions + " to contain 'rand'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rand").asList().get(0)).getField(3), (Object)"scalar");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rand").asList().get(0)).getField(4), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rand").asList().get(0)).getField(6), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rand").asList().get(0)).getField(7), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rand").asList().get(0)).getField(8), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rand").asList().get(0)).getField(9), (Object)"");
        org.testng.Assert.assertTrue((boolean)functions.containsKey((Object)"rank"), (String)("Expected function names " + functions + " to contain 'rank'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rank").asList().get(0)).getField(3), (Object)"window");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rank").asList().get(0)).getField(4), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rank").asList().get(0)).getField(6), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rank").asList().get(0)).getField(7), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rank").asList().get(0)).getField(8), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"rank").asList().get(0)).getField(9), (Object)"");
        org.testng.Assert.assertTrue((boolean)functions.containsKey((Object)"greatest"), (String)("Expected function names " + functions + " to contain 'greatest'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"greatest").asList().get(0)).getField(3), (Object)"scalar");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"greatest").asList().get(0)).getField(4), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"greatest").asList().get(0)).getField(6), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"greatest").asList().get(0)).getField(7), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"greatest").asList().get(0)).getField(8), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"greatest").asList().get(0)).getField(9), (Object)"");
        org.testng.Assert.assertTrue((boolean)functions.containsKey((Object)"split_part"), (String)("Expected function names " + functions + " to contain 'split_part'"));
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(1), (Object)"varchar(x)");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(2), (Object)"varchar(x), varchar(y), bigint");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(3), (Object)"scalar");
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(4), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(6), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(7), (Object)true);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(8), (Object)false);
        Assert.assertEquals((Object)((MaterializedRow)functions.get((Object)"split_part").asList().get(0)).getField(9), (Object)"");
        org.testng.Assert.assertFalse((boolean)functions.containsKey((Object)"like"), (String)("Expected function names " + functions + " not to contain 'like'"));
    }

    @Test
    public void testInformationSchemaFiltering() {
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_name = 'orders' LIMIT 1", "SELECT 'orders' table_name");
        this.assertQuery("SELECT table_name FROM information_schema.columns WHERE data_type = 'bigint' AND table_name = 'customer' and column_name = 'custkey' LIMIT 1", "SELECT 'customer' table_name");
    }

    @Test
    public void testInformationSchemaUppercaseName() {
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = 'LOCAL'", "SELECT '' WHERE false");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = 'TINY'", "SELECT '' WHERE false");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_name = 'ORDERS'", "SELECT '' WHERE false");
    }

    @Test
    public void testSelectColumnOfNulls() {
        this.assertQueryOrdered("SELECT CAST(NULL AS VARCHAR), CAST(NULL AS BIGINT) FROM orders ORDER BY 1");
    }

    @Test
    public void testSelectCaseInsensitive() {
        this.assertQuery("SELECT ORDERKEY FROM ORDERS");
        this.assertQuery("SELECT OrDeRkEy FROM OrDeRs");
    }

    @Test
    public void testShowSession() {
        Session session = new Session(this.getSession().getQueryId(), Optional.empty(), this.getSession().isClientTransactionSupport(), this.getSession().getIdentity(), this.getSession().getSource(), this.getSession().getCatalog(), this.getSession().getSchema(), this.getSession().getTraceToken(), this.getSession().getTimeZoneKey(), this.getSession().getLocale(), this.getSession().getRemoteUserAddress(), this.getSession().getUserAgent(), this.getSession().getClientInfo(), this.getSession().getClientTags(), this.getSession().getResourceEstimates(), this.getSession().getStartTime(), (Map)ImmutableMap.builder().put((Object)"test_string", (Object)"foo string").put((Object)"test_long", (Object)"424242").build(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"testing_catalog", (Object)ImmutableMap.builder().put((Object)"connector_string", (Object)"bar string").put((Object)"connector_long", (Object)"11").build()), this.getQueryRunner().getMetadata().getSessionPropertyManager(), this.getSession().getPreparedStatements(), (Map)ImmutableMap.of(), this.getSession().getTracer());
        MaterializedResult result = this.computeActual(session, "SHOW SESSION");
        ImmutableMap properties = Maps.uniqueIndex((Iterable)result.getMaterializedRows(), input -> {
            Assert.assertEquals((int)input.getFieldCount(), (int)5);
            return (String)input.getField(0);
        });
        Assert.assertEquals((Object)properties.get((Object)"test_string"), (Object)new MaterializedRow(1, new Object[]{"test_string", "foo string", "test default", "varchar", "test string property"}));
        Assert.assertEquals((Object)properties.get((Object)"test_long"), (Object)new MaterializedRow(1, new Object[]{"test_long", "424242", "42", "bigint", "test long property"}));
        Assert.assertEquals((Object)properties.get((Object)"testing_catalog.connector_string"), (Object)new MaterializedRow(1, new Object[]{"testing_catalog.connector_string", "bar string", "connector default", "varchar", "connector string property"}));
        Assert.assertEquals((Object)properties.get((Object)"testing_catalog.connector_long"), (Object)new MaterializedRow(1, new Object[]{"testing_catalog.connector_long", "11", "33", "bigint", "connector long property"}));
    }

    @Test
    public void testTry() {
        this.assertQuery("SELECT linenumber, sum(TRY(100/(CAST (tax*10 AS BIGINT)))) FROM lineitem GROUP BY linenumber", "SELECT linenumber, sum(100/(CAST (tax*10 AS BIGINT))) FROM lineitem WHERE CAST(tax*10 AS BIGINT) <> 0 GROUP BY linenumber");
        this.assertQuery("SELECT TRY(CAST(IF(round(totalprice) % 2 = 0, CAST(totalprice AS VARCHAR), '^&$' || CAST(totalprice AS VARCHAR)) AS DOUBLE)) FROM orders", "SELECT CASE WHEN round(totalprice) % 2 = 0 THEN totalprice ELSE null END FROM orders");
        this.assertQuery("SELECT COUNT(TRY(to_base(100, CAST(round(totalprice/100) AS BIGINT)))) FROM orders", "SELECT SUM(CASE WHEN CAST(round(totalprice/100) AS BIGINT) BETWEEN 2 AND 36 THEN 1 ELSE 0 END) FROM orders");
        this.assertQuery("SELECT COUNT(CAST(orderkey AS VARCHAR) || TRY(to_base(100, CAST(round(totalprice/100) AS BIGINT)))) FROM orders", "SELECT SUM(CASE WHEN CAST(round(totalprice/100) AS BIGINT) BETWEEN 2 AND 36 THEN 1 ELSE 0 END) FROM orders");
        this.assertQueryFails("SELECT TRY()", "line 1:8: The 'try' function must have exactly one argument");
        this.assertQueryFails("SELECT TRY(x) IS NULL FROM (SELECT 1/y AS x FROM (VALUES 1, 2, 3, 0, 4) t(y))", "/ by zero");
        this.assertQuery("SELECT x IS NULL FROM (SELECT TRY(1/y) AS x FROM (VALUES 3, 0, 4) t(y))", "VALUES false, true, false");
        this.assertQuery("SELECT TRY(apply(5, x -> x + 1) / 0)", "SELECT NULL");
        this.assertQuery("SELECT TRY(apply(5 + RANDOM(1), x -> x + 1) / 0)", "SELECT NULL");
        this.assertQuery("SELECT apply(5 + RANDOM(1), x -> x + TRY(1 / 0))", "SELECT NULL");
        this.assertQuery("SELECT JSON_FORMAT(TRY(JSON 'INVALID'))", "SELECT NULL");
        this.assertQuery("SELECT JSON_FORMAT(TRY (JSON_PARSE('INVALID')))", "SELECT NULL");
        this.assertQuery("SELECT TRY(CAST(NULL AS BIGINT))", "SELECT NULL");
        this.assertQuery("SELECT TRY(CAST('123' AS BIGINT))", "SELECT 123L");
        this.assertQuery("SELECT TRY(CAST('foo' AS BIGINT))", "SELECT NULL");
        this.assertQuery("SELECT TRY(CAST('foo' AS BIGINT)) + TRY(CAST('123' AS BIGINT))", "SELECT NULL");
        this.assertQuery("SELECT TRY(CAST(CAST(123 AS VARCHAR) AS BIGINT))", "SELECT 123L");
        this.assertQuery("SELECT COALESCE(CAST(CONCAT('123', CAST(123 AS VARCHAR)) AS BIGINT), 0)", "SELECT 123123L");
        this.assertQuery("SELECT TRY(CAST(CONCAT('hello', CAST(123 AS VARCHAR)) AS BIGINT))", "SELECT NULL");
        this.assertQuery("SELECT COALESCE(TRY(CAST(CONCAT('a', CAST(123 AS VARCHAR)) AS INTEGER)), 0)", "SELECT 0");
        this.assertQuery("SELECT COALESCE(TRY(CAST(CONCAT('a', CAST(123 AS VARCHAR)) AS BIGINT)), 0)", "SELECT 0L");
        this.assertQuery("SELECT 123 + TRY(ABS(-9223372036854775807 - 1))", "SELECT NULL");
        this.assertQuery("SELECT JSON_FORMAT(TRY(JSON '[]')) || '123'", "SELECT '[]123'");
        this.assertQuery("SELECT JSON_FORMAT(TRY(JSON 'INVALID')) || '123'", "SELECT NULL");
        this.assertQuery("SELECT TRY(2/1)", "SELECT 2");
        this.assertQuery("SELECT TRY(2/0)", "SELECT null");
        this.assertQuery("SELECT COALESCE(TRY(2/0), 0)", "SELECT 0");
        this.assertQuery("SELECT TRY(ABS(-2))", "SELECT 2");
        this.assertQuery("SELECT TRY(1 / x) FROM (SELECT NULL as x)", "SELECT NULL");
    }

    @Test
    public void testTryNoMergeProjections() {
        this.assertQueryFails("SELECT TRY(x) FROM (SELECT 1/y AS x FROM (VALUES 1, 2, 3, 0, 4) t(y))", ".*");
    }

    @Test
    public void testNoFrom() {
        this.assertQuery("SELECT 1 + 2, 3 + 4");
    }

    @Test
    public void testTopNByMultipleFields() {
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey ASC, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey ASC, custkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey DESC, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey DESC, custkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey ASC, orderkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey ASC, orderkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey DESC, orderkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey DESC, orderkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS FIRST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS FIRST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS LAST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC, custkey ASC LIMIT 10", "SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST, custkey ASC LIMIT 10");
    }

    @Test
    public void testExchangeWithProjectionPushDown() {
        this.assertQuery("SELECT * FROM \n  (SELECT orderkey + 1 orderkey FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 100)) o \nJOIN \n  (SELECT orderkey + 1 orderkey FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 100)) o1 \nON (o.orderkey = o1.orderkey)");
    }

    @Test
    public void testUnionWithProjectionPushDown() {
        this.assertQuery("SELECT key + 5, status FROM (SELECT orderkey key, orderstatus status FROM orders UNION ALL SELECT orderkey key, linestatus status FROM lineitem)");
    }

    @Test
    public void testUnion() {
        this.assertQuery("SELECT orderkey FROM orders UNION SELECT custkey FROM orders");
        this.assertQuery("SELECT 123 UNION DISTINCT SELECT 123 UNION ALL SELECT 123");
        this.assertQuery("SELECT NULL UNION SELECT NULL");
        this.assertQuery("SELECT NULL, NULL UNION ALL SELECT NULL, NULL FROM nation");
        this.assertQuery("SELECT 'x', 'y' UNION ALL SELECT name, name FROM nation");
        this.assertQuery("SELECT orderkey FROM orders UNION ALL SELECT 123 UNION ALL (SELECT custkey FROM orders GROUP BY custkey)");
    }

    @Test
    public void testUnionDistinct() {
        this.assertQuery("SELECT orderkey FROM orders UNION DISTINCT SELECT custkey FROM orders");
    }

    @Test
    public void testUnionAll() {
        this.assertQuery("SELECT orderkey FROM orders UNION ALL SELECT custkey FROM orders");
    }

    @Test
    public void testUnionArray() {
        this.assertQuery("SELECT a[1] FROM (SELECT ARRAY[1] UNION ALL SELECT ARRAY[1]) t(a) LIMIT 1", "SELECT 1");
    }

    @Test
    public void testChainedUnionsWithOrder() {
        this.assertQueryOrdered("SELECT orderkey FROM orders UNION (SELECT custkey FROM orders UNION SELECT linenumber FROM lineitem) UNION ALL SELECT orderkey FROM lineitem ORDER BY orderkey");
    }

    @Test
    public void testUnionWithTopN() {
        this.assertQuery("SELECT * FROM (   SELECT regionkey FROM nation    UNION ALL    SELECT nationkey FROM nation) t(a) ORDER BY a LIMIT 1", "SELECT 0");
    }

    @Test
    public void testUnionWithAggregation() {
        this.assertQuery("SELECT regionkey, count(*) FROM (   SELECT regionkey FROM nation    UNION ALL    SELECT * FROM (VALUES 2, 100) t(regionkey)) GROUP BY regionkey", "SELECT * FROM (VALUES  (0, 5), (1, 5), (2, 6), (3, 5), (4, 5), (100, 1))");
        this.assertQuery("SELECT ds, count(*) FROM (   SELECT orderdate ds, orderkey FROM orders    UNION ALL    SELECT shipdate ds, orderkey FROM lineitem) a GROUP BY ds");
        this.assertQuery("SELECT ds, count(*) FROM (   SELECT orderdate ds, orderkey FROM orders    UNION    SELECT shipdate ds, orderkey FROM lineitem) a GROUP BY ds");
        this.assertQuery("SELECT ds, count(DISTINCT orderkey) FROM (   SELECT orderdate ds, orderkey FROM orders    UNION    SELECT shipdate ds, orderkey FROM lineitem) a GROUP BY ds");
        this.assertQuery("SELECT clerk, count(DISTINCT orderstatus) FROM (SELECT * FROM orders WHERE orderkey=0  UNION ALL SELECT * FROM orders WHERE orderkey<>0) GROUP BY clerk");
        this.assertQuery("SELECT count(clerk) FROM (SELECT clerk FROM orders WHERE orderkey=0  UNION ALL SELECT clerk FROM orders WHERE orderkey<>0) GROUP BY clerk");
        this.assertQuery("SELECT count(orderkey), sum(sc) FROM (    SELECT sum(custkey) sc, orderkey FROM (        SELECT custkey,orderkey, orderkey+1 FROM orders WHERE orderkey=0        UNION ALL         SELECT custkey,orderkey,orderkey+1 FROM orders WHERE orderkey<>0)     GROUP BY orderkey)");
        this.assertQuery("SELECT count(orderkey), sum(sc) FROM (\n    SELECT sum(custkey) sc, orderkey FROM (\n        SELECT custkey, orderkey, orderkey+1, orderstatus FROM orders WHERE orderkey=0\n        UNION ALL \n        SELECT custkey, orderkey, orderkey+1, orderstatus FROM orders WHERE orderkey<>0) \n    GROUP BY GROUPING SETS ((orderkey, orderstatus), (orderkey)))", "SELECT count(orderkey), sum(sc) FROM (\n    SELECT sum(custkey) sc, orderkey FROM (\n        SELECT custkey, orderkey, orderkey+1, orderstatus FROM orders WHERE orderkey=0\n        UNION ALL \n        SELECT custkey, orderkey, orderkey+1, orderstatus FROM orders WHERE orderkey<>0) \n    GROUP BY orderkey, orderstatus \n    \n    UNION ALL \n    \n    SELECT sum(custkey) sc, orderkey FROM (\n        SELECT custkey, orderkey, orderkey+1, orderstatus FROM orders WHERE orderkey=0\n        UNION ALL \n        SELECT custkey, orderkey, orderkey+1, orderstatus FROM orders WHERE orderkey<>0) \n    GROUP BY orderkey)");
    }

    @Test
    public void testUnionWithUnionAndAggregation() {
        this.assertQuery("SELECT count(*) FROM (SELECT 1 FROM nation GROUP BY regionkey UNION ALL SELECT 1 FROM (   SELECT 1 FROM nation    UNION ALL    SELECT 1 FROM nation))");
        this.assertQuery("SELECT count(*) FROM (SELECT 1 FROM (   SELECT 1 FROM nation    UNION ALL    SELECT 1 FROM nation)UNION ALL SELECT 1 FROM nation GROUP BY regionkey)");
    }

    @Test
    public void testUnionWithAggregationAndTableScan() {
        this.assertQuery("SELECT orderkey, 1 FROM orders UNION ALL SELECT orderkey, count(*) FROM orders GROUP BY 1", "SELECT orderkey, 1 FROM orders UNION ALL SELECT orderkey, count(*) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT orderkey, count(*) FROM orders GROUP BY 1 UNION ALL SELECT orderkey, 1 FROM orders", "SELECT orderkey, count(*) FROM orders GROUP BY orderkey UNION ALL SELECT orderkey, 1 FROM orders");
    }

    @Test
    public void testSubqueryUnion() {
        this.assertQueryOrdered("SELECT * FROM (SELECT orderkey FROM orders UNION SELECT custkey FROM orders UNION SELECT orderkey FROM orders) ORDER BY orderkey LIMIT 1000");
    }

    @Test
    public void testUnionWithFilterNotInSelect() {
        this.assertQuery("SELECT orderkey, orderdate FROM orders WHERE custkey < 1000 UNION ALL SELECT orderkey, shipdate FROM lineitem WHERE linenumber < 2000");
        this.assertQuery("SELECT orderkey, orderdate FROM orders UNION ALL SELECT orderkey, shipdate FROM lineitem WHERE linenumber < 2000");
        this.assertQuery("SELECT orderkey, orderdate FROM orders WHERE custkey < 1000 UNION ALL SELECT orderkey, shipdate FROM lineitem");
    }

    @Test
    public void testSelectOnlyUnion() {
        this.assertQuery("SELECT 123, 'foo' UNION ALL SELECT 999, 'bar'");
    }

    @Test
    public void testMultiColumnUnionAll() {
        this.assertQuery("SELECT * FROM orders UNION ALL SELECT * FROM orders");
    }

    @Test
    public void testUnionRequiringCoercion() {
        this.assertQuery("VALUES 1 UNION ALL VALUES 1.0, 2", "SELECT * FROM (VALUES 1) UNION ALL SELECT * FROM (VALUES 1.0, 2)");
        this.assertQuery("(VALUES 1) UNION ALL (VALUES 1.0, 2)", "SELECT * FROM (VALUES 1) UNION ALL SELECT * FROM (VALUES 1.0, 2)");
        this.assertQuery("SELECT 0, 0 UNION ALL SELECT 1.0, 0");
        this.assertQuery("SELECT 0, 0, 0, 0 UNION ALL SELECT 0.0, 0.0, 0, 0");
        this.assertQuery("SELECT * FROM (VALUES 1) UNION ALL SELECT * FROM (VALUES 1.0, 2)");
        this.assertQuery("SELECT * FROM (VALUES 1) UNION SELECT * FROM (VALUES 1.0, 2)", "VALUES 1.0, 2.0");
        this.assertQuery("SELECT * FROM (VALUES (2, 2)) UNION SELECT * FROM (VALUES (1, 1.0))");
        this.assertQuery("SELECT * FROM (VALUES (NULL, NULL)) UNION SELECT * FROM (VALUES (1, 1.0))");
        this.assertQuery("SELECT * FROM (VALUES (NULL, NULL)) UNION ALL SELECT * FROM (VALUES (NULL, 1.0))");
        this.assertQuery("SELECT a FROM (  (SELECT orderstatus AS a FROM orders LIMIT 1) UNION ALL   SELECT 'aaaa' AS a) WHERE  a = 'aaa'");
    }

    @Test
    public void testTableQuery() {
        this.assertQuery("TABLE orders", "SELECT * FROM orders");
    }

    @Test
    public void testTableQueryOrderLimit() {
        this.assertQueryOrdered("TABLE orders ORDER BY orderkey LIMIT 10", "SELECT * FROM orders ORDER BY orderkey LIMIT 10");
    }

    @Test
    public void testTableQueryInUnion() {
        this.assertQuery("(SELECT * FROM orders ORDER BY orderkey LIMIT 10) UNION ALL TABLE orders", "(SELECT * FROM orders ORDER BY orderkey LIMIT 10) UNION ALL SELECT * FROM orders");
    }

    @Test
    public void testTableAsSubquery() {
        this.assertQueryOrdered("(TABLE orders) ORDER BY orderkey", "(SELECT * FROM orders) ORDER BY orderkey");
    }

    @Test
    public void testLimitPushDown() {
        MaterializedResult actual = this.computeActual("(TABLE orders ORDER BY orderkey) UNION ALL SELECT * FROM orders WHERE orderstatus = 'F' UNION ALL (TABLE orders ORDER BY orderkey LIMIT 20) UNION ALL (TABLE orders LIMIT 5) UNION ALL TABLE orders LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT * FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testUnaliasSymbolReferencesWithUnion() {
        this.assertQuery("SELECT 1, 1, 'a', 'a' UNION ALL SELECT 1, 2, 'a', 'b'");
    }

    @Test
    public void testSameInPredicateInProjectionAndFilter() {
        this.assertQuery("SELECT x IN (SELECT * FROM (VALUES 1))\nFROM (VALUES 1) t(x)\nWHERE x IN (SELECT * FROM (VALUES 1))", "SELECT 1");
        this.assertQuery("SELECT x IN (SELECT * FROM (VALUES 1))\nFROM (VALUES 2) t(x)\nWHERE x IN (SELECT * FROM (VALUES 1))", "SELECT 1 WHERE false");
    }

    @Test
    public void testScalarSubquery() {
        this.assertQuery("SELECT (SELECT (SELECT (SELECT 1)))");
        this.assertQuery("SELECT * FROM lineitem WHERE orderkey = \n(SELECT max(orderkey) FROM orders)");
        this.assertQuery("SELECT * FROM lineitem WHERE orderkey = \n(SELECT orderkey FROM orders WHERE 0=1)");
        this.assertQuery("SELECT * FROM lineitem WHERE \n(SELECT orderkey FROM orders WHERE 0=1) is null");
        this.assertQuery("SELECT * FROM lineitem WHERE \n(SELECT orderkey FROM orders WHERE 0=1) is not null");
        this.assertQuery("SELECT (SELECT 1) IN (1, 2, 3)");
        this.assertQuery("SELECT (SELECT 1) IN (   2, 3)");
        this.assertQuery("SELECT (SELECT 1) = (SELECT 3)");
        this.assertQuery("SELECT (SELECT 1) < (SELECT 3)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE (SELECT min(orderkey) FROM orders)<(SELECT max(orderkey) FROM orders)");
        this.assertQuery("SELECT (SELECT 1), (SELECT 2), (SELECT 3)");
        this.assertQuery("SELECT DISTINCT orderkey FROM lineitem WHERE orderkey BETWEEN   (SELECT avg(orderkey) FROM orders) - 10    AND   (SELECT avg(orderkey) FROM orders) + 10");
        this.assertQuery("SELECT o1.orderkey, COUNT(*) FROM orders o1 INNER JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey");
        this.assertQuery("SELECT o1.orderkey, COUNT(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o1 LEFT JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey");
        this.assertQuery("SELECT o1.orderkey, COUNT(*) FROM orders o1 RIGHT JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey");
        this.assertQuery("SELECT DISTINCT COUNT(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o1 FULL JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o2 ON o1.orderkey BETWEEN (SELECT avg(orderkey) FROM orders) - 10 AND (SELECT avg(orderkey) FROM orders) + 10 GROUP BY o1.orderkey", "VALUES 1, 10");
        this.assertQuery("SELECT orderkey, totalprice FROM orders ORDER BY (SELECT 2)");
        String multipleRowsErrorMsg = "Scalar sub-query has returned multiple rows";
        this.assertQueryFails("SELECT * FROM lineitem WHERE orderkey = (\nSELECT orderkey FROM orders ORDER BY totalprice)", multipleRowsErrorMsg);
        this.assertQueryFails("SELECT orderkey, totalprice FROM orders ORDER BY (VALUES 1, 2)", multipleRowsErrorMsg);
        this.assertQuery("SELECT custkey, (SELECT DISTINCT custkey FROM orders ORDER BY custkey LIMIT 1) FROM orders");
        this.assertQuery("SELECT 1.0/(SELECT 1), CAST(1.0 AS REAL)/(SELECT 1), 1/(SELECT 1)");
        this.assertQuery("SELECT 1.0 = (SELECT 1) AND 1 = (SELECT 1), 2.0 = (SELECT 1) WHERE 1.0 = (SELECT 1) AND 1 = (SELECT 1)");
        this.assertQuery("SELECT 1.0 = (SELECT 1), 2.0 = (SELECT 1), CAST(2.0 AS REAL) = (SELECT 1) WHERE 1.0 = (SELECT 1)");
        this.assertQuery("SELECT * FROM (VALUES 1) t(a) WHERE 1=(SELECT count(*) WHERE 1.0 = a)", "SELECT 1");
        this.assertQuery("SELECT * FROM (VALUES 1.0) t(a) WHERE 1=(SELECT count(*) WHERE 1 = a)", "SELECT 1.0");
    }

    @Test
    public void testExistsSubquery() {
        this.assertQuery("SELECT EXISTS(SELECT NOT EXISTS(SELECT EXISTS(SELECT 1)))");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE EXISTS(SELECT max(orderkey) FROM orders)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NOT EXISTS(SELECT max(orderkey) FROM orders)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NOT EXISTS(SELECT orderkey FROM orders WHERE false)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE EXISTS(SELECT orderkey FROM orders WHERE false)");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NOT EXISTS(SELECT orderkey FROM orders WHERE false)");
        this.assertQuery("SELECT (EXISTS(SELECT 1)) IN (false)", "SELECT false");
        this.assertQuery("SELECT (NOT EXISTS(SELECT 1)) IN (false)", "SELECT true");
        this.assertQuery("SELECT (EXISTS(SELECT 1)) IN (true, false)", "SELECT true");
        this.assertQuery("SELECT (NOT EXISTS(SELECT 1)) IN (true, false)", "SELECT true");
        this.assertQuery("SELECT (EXISTS(SELECT 1 WHERE false)) IN (true, false)", "SELECT true");
        this.assertQuery("SELECT (NOT EXISTS(SELECT 1 WHERE false)) IN (true, false)", "SELECT true");
        this.assertQuery("SELECT (EXISTS(SELECT 1 WHERE false)) IN (false)", "SELECT true");
        this.assertQuery("SELECT (NOT EXISTS(SELECT 1 WHERE false)) IN (false)", "SELECT false");
        this.assertQuery("SELECT (EXISTS(SELECT 1)) = (EXISTS(SELECT 1)) WHERE NOT EXISTS(SELECT 1)", "SELECT true WHERE false");
        this.assertQuery("SELECT (EXISTS(SELECT 1)) = (EXISTS(SELECT 3)) WHERE NOT EXISTS(SELECT 1 WHERE false)", "SELECT true");
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE (EXISTS(SELECT min(orderkey) FROM orders))=(NOT EXISTS(SELECT orderkey FROM orders WHERE false))", "SELECT count(*) FROM lineitem");
        this.assertQuery("SELECT EXISTS(SELECT 1), EXISTS(SELECT 1), EXISTS(SELECT 3), NOT EXISTS(SELECT 1), NOT EXISTS(SELECT 1 WHERE false)");
        this.assertQuery("SELECT DISTINCT orderkey FROM lineitem WHERE EXISTS(SELECT avg(orderkey) FROM orders)");
        QueryTemplate.Parameter joinType = QueryTemplate.parameter((String)"join_type");
        QueryTemplate.Parameter condition = QueryTemplate.parameter((String)"condition");
        QueryTemplate queryTemplate = QueryTemplate.queryTemplate((String)"SELECT o1.orderkey, COUNT(*) FROM orders o1 %join_type% JOIN (SELECT * FROM orders LIMIT 10) o2 ON %condition% GROUP BY o1.orderkey ORDER BY o1.orderkey LIMIT 5", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[]{joinType, condition});
        List conditions = condition.of(new String[]{"EXISTS(SELECT avg(orderkey) FROM orders)", "(SELECT avg(orderkey) FROM orders) > 3"});
        for (QueryTemplate.Parameter actualCondition : conditions) {
            for (QueryTemplate.Parameter actualJoinType : joinType.of(new String[]{"", "LEFT", "RIGHT"})) {
                this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{actualJoinType, actualCondition}));
            }
            this.assertQuery(queryTemplate.replace(new QueryTemplate.Parameter[]{joinType.of("FULL"), actualCondition}), "VALUES (1, 10), (2, 10), (3, 10), (4, 10), (5, 10)");
        }
        this.assertQuery("SELECT orderkey, totalprice FROM orders ORDER BY EXISTS(SELECT 2)");
        this.assertQuery("SELECT orderkey, totalprice FROM orders ORDER BY NOT(EXISTS(SELECT 2))");
    }

    @Test
    public void testScalarSubqueryWithGroupBy() {
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber");
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, (SELECT max(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber, (SELECT max(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber HAVING min(orderkey) < (SELECT avg(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, (SELECT max(orderkey) FROM orders WHERE orderkey < 7)HAVING min(orderkey) < (SELECT max(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, (SELECT sum(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, max(orderkey), (SELECT min(orderkey) FROM orders WHERE orderkey < 5)FROM lineitem GROUP BY linenumber HAVING sum(orderkey) > (SELECT min(orderkey) FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, (SELECT count(orderkey) FROM orders WHERE orderkey < 7)HAVING min(orderkey) < (SELECT sum(orderkey) FROM orders WHERE orderkey < 7)");
    }

    @Test
    public void testOutputInEnforceSingleRow() {
        this.assertQuery("SELECT count(*) FROM (SELECT (SELECT 1))");
        this.assertQuery("SELECT * FROM (SELECT (SELECT 1))");
        this.assertQueryFails("SELECT * FROM (SELECT (SELECT 1, 2))", "line 1:23: Multiple columns returned by subquery are not yet supported. Found 2");
    }

    @Test
    public void testExistsSubqueryWithGroupBy() {
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber");
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM lineitem GROUP BY linenumber HAVING EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)HAVING EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 17)");
        this.assertQuery("SELECT linenumber, max(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 5)FROM lineitem GROUP BY linenumber HAVING EXISTS(SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), EXISTS(SELECT orderkey FROM orders WHERE orderkey < 17)FROM lineitem GROUP BY linenumber, EXISTS(SELECT orderkey FROM orders WHERE orderkey < 17)HAVING EXISTS(SELECT orderkey FROM orders WHERE orderkey < 27)");
    }

    @Test
    public void testCorrelatedScalarSubqueries() {
        this.assertQuery("SELECT (SELECT n.nationkey) FROM nation n");
        this.assertQuery("SELECT (SELECT 2 * n.nationkey) FROM nation n");
        this.assertQuery("SELECT nationkey FROM nation n WHERE 2 = (SELECT 2 * n.nationkey)");
        this.assertQuery("SELECT nationkey FROM nation n ORDER BY (SELECT 2 * n.nationkey)");
        this.assertQuery("SELECT max(n.regionkey), 2 * n.nationkey, (SELECT n.nationkey) FROM nation n GROUP BY n.nationkey");
        this.assertQuery("SELECT max(l.quantity), 2 * l.orderkey FROM lineitem l GROUP BY l.orderkey HAVING max(l.quantity) < (SELECT l.orderkey)");
        this.assertQuery("SELECT max(l.quantity), 2 * l.orderkey FROM lineitem l GROUP BY l.orderkey, (SELECT l.orderkey)");
        this.assertQuery("SELECT * FROM nation n1 JOIN nation n2 ON n1.nationkey = (SELECT n2.nationkey)");
        this.assertQueryFails("SELECT (SELECT l3.* FROM lineitem l2 CROSS JOIN (SELECT l1.orderkey) l3 LIMIT 1) FROM lineitem l1", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQuery("SELECT 1 FROM nation n WHERE 2 * nationkey - 1  = (SELECT * FROM (SELECT n.nationkey))", "SELECT 1");
        this.assertQuery("SELECT * FROM nation n WHERE 2 = (SELECT (SELECT 2 * n.nationkey))");
        this.assertQueryFails("SELECT (SELECT count(*) FROM (VALUES (7,1)) t(orderkey, value) WHERE orderkey = corr_key LIMIT 1) FROM (values 7) t(corr_key)", "line 1:9: Given correlated subquery is not supported");
    }

    @Test
    public void testCorrelatedNonAggregationScalarSubqueries() {
        String subqueryReturnedTooManyRows = "Scalar sub-query has returned multiple rows";
        this.assertQuery("SELECT (SELECT 1 WHERE a = 2) FROM (VALUES 1) t(a)", "SELECT null");
        this.assertQuery("SELECT (SELECT 2 WHERE a = 1) FROM (VALUES 1) t(a)", "SELECT 2");
        this.assertQueryFails("SELECT (SELECT 2 FROM (VALUES 3, 4) WHERE a = 1) FROM (VALUES 1) t(a)", subqueryReturnedTooManyRows);
        this.assertQueryFails("SELECT name FROM nation n WHERE 'AFRICA' = (SELECT 'bleh' FROM region WHERE regionkey > n.regionkey)", subqueryReturnedTooManyRows);
        this.assertQueryFails("SELECT name FROM nation n WHERE 'AFRICA' = (SELECT name FROM region WHERE regionkey > n.regionkey)", subqueryReturnedTooManyRows);
        this.assertQueryFails("SELECT name FROM nation n WHERE 1 = (SELECT 1 FROM region WHERE regionkey > n.regionkey)", subqueryReturnedTooManyRows);
        this.assertQueryFails("SELECT name FROM nation n WHERE 'AFRICA' = (SELECT n.name FROM region WHERE regionkey > n.regionkey)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQuery("SELECT (SELECT 2 WHERE o.orderkey = 1) FROM orders o ORDER BY orderkey LIMIT 5", "VALUES 2, null, null, null, null");
        this.assertQueryFails("SELECT (SELECT o.orderkey WHERE o.orderkey = 1) FROM orders o ORDER BY orderkey LIMIT 5", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT (SELECT o.orderkey * 2 WHERE o.orderkey = 1) FROM orders o ORDER BY orderkey LIMIT 5", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT o.orderkey, (SELECT o.orderkey * 2 WHERE o.orderkey = 1) FROM orders o ORDER BY orderkey LIMIT 5", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQuery("SELECT name FROM nation n WHERE 'AFRICA' = (SELECT name FROM region WHERE regionkey = n.regionkey)");
        this.assertQueryFails("SELECT nationkey FROM nation n WHERE (SELECT n.regionkey * 2 FROM region r WHERE n.regionkey = r.regionkey) > 6", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT nationkey FROM nation n WHERE (SELECT n.nationkey * 2 FROM region r WHERE n.regionkey = r.regionkey) > 6", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQuery("SELECT nationkey FROM nation n WHERE (SELECT regionkey * 2 FROM (SELECT regionkey FROM region r WHERE n.regionkey = r.regionkey)) > 6 ORDER BY 1 LIMIT 3", "VALUES 4, 10, 11");
        this.assertQuery("SELECT (SELECT name FROM nation WHERE nationkey = a) FROM (VALUES 1, 1, 2, 3) t(a)", "VALUES 'ARGENTINA', 'ARGENTINA', 'BRAZIL', 'CANADA'");
        this.assertQuery("SELECT (SELECT name FROM nation WHERE nationkey = a) FROM (VALUES 31) t(a)", "VALUES null");
        this.assertQuery("SELECT (SELECT r.name FROM nation n, region r WHERE r.regionkey = n.regionkey AND n.nationkey = a) FROM (VALUES 1) t(a)", "VALUES 'AMERICA'");
    }

    @Test
    public void testCorrelatedScalarSubqueriesWithScalarAggregationAndEqualityPredicatesInWhere() {
        this.assertQuery("SELECT (SELECT count(*) WHERE o.orderkey = 1) FROM orders o");
        this.assertQuery("SELECT count(*) FROM orders o WHERE 1 = (SELECT count(*) WHERE o.orderkey = 0)");
        this.assertQuery("SELECT * FROM orders o ORDER BY (SELECT count(*) WHERE o.orderkey = 0)");
        this.assertQuery("SELECT count(*) FROM nation n WHERE (SELECT count(*) FROM region r WHERE n.regionkey = r.regionkey) > 1");
        this.assertQueryFails("SELECT count(*) FROM nation n WHERE (SELECT avg(a) FROM (SELECT count(*) FROM region r WHERE n.regionkey = r.regionkey) t(a)) > 1", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQuery("SELECT (SELECT count(*) WHERE a = 1) FROM (VALUES 1, 1, 2, 3) t(a)", "VALUES true, true, false, false");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey, (SELECT count(*) WHERE o.orderkey = 0) FROM orders o GROUP BY o.orderkey");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey HAVING 1 = (SELECT count(*) WHERE o.orderkey = 0)");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey, (SELECT count(*) WHERE o.orderkey = 0)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o1 JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o2 ON NOT 1 = (SELECT count(*) WHERE o1.orderkey = o2.orderkey)");
        this.assertQueryFails("SELECT count(*) FROM orders o1 LEFT JOIN orders o2 ON NOT 1 = (SELECT count(*) WHERE o1.orderkey = o2.orderkey)", "line .*: Correlated subquery in given context is not supported");
        this.assertQuery("SELECT count(*) FROM orders o WHERE 1 = (SELECT * FROM (SELECT (SELECT count(*) WHERE o.orderkey = 0)))", "SELECT count(*) FROM orders o WHERE o.orderkey = 0");
    }

    @Test
    public void testCorrelatedScalarSubqueriesWithScalarAggregation() {
        this.assertQuery("SELECT (SELECT round(3 * avg(i.a)) FROM (VALUES 1, 1, 1, 2, 2, 3, 4) i(a) WHERE i.a < o.a AND i.a < 4) FROM (VALUES 0, 3, 3, 5) o(a)", "VALUES null, 4, 4, 5");
        this.assertQuery("SELECT count(*) FROM orders o WHERE (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0) > 100", "VALUES 14999");
        this.assertQuery("SELECT orderkey FROM orders o ORDER BY    (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0),    orderkey LIMIT 1", "VALUES 1");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey, (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0) FROM orders o GROUP BY o.orderkey ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1, 40000)");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey FROM orders o GROUP BY o.orderkey HAVING 40000 < (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-07-24', 20000)");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey FROM orders o GROUP BY o.orderkey, (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o1 JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o2 ON NOT 1 = (SELECT avg(i.orderkey) FROM orders i WHERE o1.orderkey < o2.orderkey AND i.orderkey % 10000 = 0)");
        this.assertQueryFails("SELECT count(*) FROM orders o1 LEFT JOIN orders o2 ON NOT 1 = (SELECT avg(i.orderkey) FROM orders i WHERE o1.orderkey < o2.orderkey)", "line .*: Correlated subquery in given context is not supported");
        this.assertQuery("SELECT count(*) FROM orders o WHERE 100 < (SELECT * FROM (SELECT (SELECT avg(i.orderkey) FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)))", "VALUES 14999");
        this.assertQuery("SELECT (SELECT avg(regionkey)  FROM nation n2 WHERE n2.nationkey = n1.nationkey),(SELECT avg(regionkey) FROM nation n3 WHERE n3.nationkey = n1.nationkey)FROM nation n1");
        this.assertQuery("SELECT(SELECT avg(regionkey) FROM nation n2  WHERE n2.nationkey = n1.nationkey),(SELECT avg(regionkey)+1  FROM nation n3  WHERE n3.nationkey = n1.nationkey)FROM nation n1");
        this.assertQuery("SELECT * FROM (VALUES (0),( 1), (2), (7)) AS v1(c1) WHERE v1.c1 > (SELECT count(c1) FROM (VALUES (0),( 1), (2)) AS v2(c1) WHERE v1.c1 = v2.c1)", "VALUES (2), (7)");
    }

    @Test
    public void testCorrelatedInPredicateSubqueries() {
        this.assertQuery("SELECT orderkey, clerk IN (SELECT clerk FROM orders s WHERE s.custkey = o.custkey AND s.orderkey < o.orderkey) FROM orders o");
        this.assertQuery("SELECT orderkey FROM orders o WHERE clerk IN (SELECT clerk FROM orders s WHERE s.custkey = o.custkey AND s.orderkey < o.orderkey)");
        this.assertQuery("SELECT t1.a, t1.b,   t1.b in (SELECT t2.b     FROM (values (2, 3), (2, 4), (3, 0), (30,NULL)) t2(a, b)     WHERE t1.a - 5 <= t2.a and t2.a <= t1.a and 0 <= t2.a) from (values (1,1), (2,4), (3,5), (4,NULL), (30,2), (40,NULL) ) t1(a, b) order by t1.a", "VALUES (1,1,FALSE), (2,4,TRUE), (3,5,FALSE), (4,NULL,NULL), (30,2,NULL), (40,NULL,FALSE)");
        this.assertQueryFails("SELECT orderkey FROM orders o WHERE clerk IN (SELECT clerk FROM orders s WHERE s.custkey = o.custkey AND s.orderkey < o.orderkey ORDER BY 1 LIMIT 1)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT 1 IN (SELECT l.orderkey) FROM lineitem l", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT 1 IN (SELECT 2 * l.orderkey) FROM lineitem l", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT * FROM lineitem l WHERE 1 IN (SELECT 2 * l.orderkey)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT * FROM lineitem l ORDER BY 1 IN (SELECT 2 * l.orderkey)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT max(l.quantity), 2 * l.orderkey, 1 IN (SELECT l.orderkey) FROM lineitem l GROUP BY l.orderkey", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT max(l.quantity), 2 * l.orderkey FROM lineitem l GROUP BY l.orderkey HAVING max(l.quantity) IN (SELECT l.orderkey)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT max(l.quantity), 2 * l.orderkey FROM lineitem l GROUP BY l.orderkey, 1 IN (SELECT l.orderkey)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT * FROM lineitem l1 JOIN lineitem l2 ON l1.orderkey IN (SELECT l2.orderkey)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT * FROM lineitem l WHERE (SELECT * FROM (SELECT 1 IN (SELECT 2 * l.orderkey)))", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQueryFails("SELECT * FROM lineitem l WHERE true IN (SELECT 1 IN (SELECT 2 * l.orderkey))", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
    }

    @Test
    public void testCorrelatedExistsSubqueriesWithPrunedCorrelationSymbols() {
        this.assertQuery("SELECT EXISTS(SELECT o.orderkey) FROM orders o");
        this.assertQuery("SELECT count(*) FROM orders o WHERE EXISTS(SELECT o.orderkey)");
        this.assertQuery("SELECT * FROM orders o ORDER BY EXISTS(SELECT o.orderkey)");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey, EXISTS(SELECT o.orderkey) FROM orders o GROUP BY o.orderkey");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey HAVING EXISTS (SELECT o.orderkey)");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey, EXISTS (SELECT o.orderkey)");
        this.assertQuery("SELECT * FROM orders o JOIN (SELECT * FROM lineitem ORDER BY orderkey LIMIT 2) l ON NOT EXISTS(SELECT o.orderkey = l.orderkey)");
        this.assertQuery("SELECT count(*) FROM orders o WHERE (SELECT * FROM (SELECT EXISTS(SELECT o.orderkey)))", "VALUES 15000");
    }

    @Test
    public void testCorrelatedExistsSubqueriesWithEqualityPredicatesInWhere() {
        this.assertQuery("SELECT EXISTS(SELECT 1 WHERE o.orderkey = 1) FROM orders o");
        this.assertQuery("SELECT EXISTS(SELECT null WHERE o.orderkey = 1) FROM orders o");
        this.assertQuery("SELECT count(*) FROM orders o WHERE EXISTS(SELECT 1 WHERE o.orderkey = 0)");
        this.assertQuery("SELECT * FROM orders o ORDER BY EXISTS(SELECT 1 WHERE o.orderkey = 0)");
        this.assertQuery("SELECT count(*) FROM orders o WHERE EXISTS (SELECT avg(l.orderkey) FROM lineitem l WHERE o.orderkey = l.orderkey)");
        this.assertQuery("SELECT count(*) FROM orders o WHERE EXISTS (SELECT avg(l.orderkey) FROM lineitem l WHERE o.orderkey = l.orderkey GROUP BY l.linenumber)");
        this.assertQueryFails("SELECT count(*) FROM orders o WHERE EXISTS (SELECT count(*) FROM lineitem l WHERE o.orderkey = l.orderkey HAVING count(*) > 3)", UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertQuery("SELECT EXISTS(SELECT 1 WHERE a = 1) FROM (VALUES 1, 1, 2, 3) t(a)", "VALUES true, true, false, false");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey, EXISTS(SELECT 1 WHERE o.orderkey = 0) FROM orders o GROUP BY o.orderkey");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey HAVING EXISTS (SELECT 1 WHERE o.orderkey = 0)");
        this.assertQuery("SELECT max(o.totalprice), o.orderkey FROM orders o GROUP BY o.orderkey, EXISTS (SELECT 1 WHERE o.orderkey = 0)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o1 JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o2 ON NOT EXISTS(SELECT 1 WHERE o1.orderkey = o2.orderkey)");
        this.assertQueryFails("SELECT count(*) FROM orders o1 LEFT JOIN orders o2 ON NOT EXISTS(SELECT 1 WHERE o1.orderkey = o2.orderkey)", "line .*: Correlated subquery in given context is not supported");
        this.assertQuery("SELECT count(*) FROM orders o WHERE (SELECT * FROM (SELECT EXISTS(SELECT 1 WHERE o.orderkey = 0)))", "SELECT count(*) FROM orders o WHERE o.orderkey = 0");
        this.assertQuery("SELECT count(*) FROM customer WHERE NOT EXISTS(SELECT * FROM orders WHERE orders.custkey=customer.custkey)", "VALUES 500");
    }

    @Test
    public void testCorrelatedExistsSubqueries() {
        this.assertQuery("SELECT EXISTS(SELECT 1 FROM (VALUES 1, 1, 1, 2, 2, 3, 4) i(a) WHERE i.a < o.a AND i.a < 4) FROM (VALUES 0, 3, 3, 5) o(a)", "VALUES false, true, true, true");
        this.assertQuery("SELECT EXISTS(SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3) FROM lineitem l LIMIT 1");
        this.assertQuery("SELECT count(*) FROM orders o WHERE EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 1000 = 0)", "VALUES 14999");
        this.assertQuery("SELECT count(*) FROM lineitem l WHERE EXISTS(SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3)");
        this.assertQuery("SELECT orderkey FROM orders o ORDER BY EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)LIMIT 1", "VALUES 60000");
        this.assertQuery("SELECT orderkey FROM lineitem l ORDER BY EXISTS(SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3)");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey, EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0) FROM orders o GROUP BY o.orderkey ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1, true)");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey FROM orders o GROUP BY o.orderkey HAVING EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1)");
        this.assertQuery("SELECT max(o.orderdate), o.orderkey FROM orders o GROUP BY o.orderkey, EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)ORDER BY o.orderkey LIMIT 1", "VALUES ('1996-01-02', 1)");
        this.assertQuery("SELECT max(l.quantity), l.orderkey, EXISTS(SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3) FROM lineitem l GROUP BY l.orderkey");
        this.assertQuery("SELECT max(l.quantity), l.orderkey FROM lineitem l GROUP BY l.orderkey HAVING EXISTS (SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3)");
        this.assertQuery("SELECT max(l.quantity), l.orderkey FROM lineitem l GROUP BY l.orderkey, EXISTS (SELECT 1 WHERE l.orderkey > 0 OR l.orderkey != 3)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 10) o1 JOIN (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o2 ON NOT EXISTS(SELECT 1 FROM orders i WHERE o1.orderkey < o2.orderkey AND i.orderkey % 10000 = 0)");
        this.assertQueryFails("SELECT count(*) FROM orders o1 LEFT JOIN orders o2 ON NOT EXISTS(SELECT 1 FROM orders i WHERE o1.orderkey < o2.orderkey)", "line .*: Correlated subquery in given context is not supported");
        this.assertQuery("SELECT count(*) FROM orders o WHERE (SELECT * FROM (SELECT EXISTS(SELECT 1 FROM orders i WHERE o.orderkey < i.orderkey AND i.orderkey % 10000 = 0)))", "VALUES 14999");
        this.assertQuery("SELECT count(*) FROM orders o WHERE (SELECT * FROM (SELECT EXISTS(SELECT 1 WHERE o.orderkey > 10 OR o.orderkey != 3)))", "VALUES 14999");
    }

    @Test
    public void testTwoCorrelatedExistsSubqueries() {
        this.assertQuery("SELECT\n  count(*) AS numwait\nFROM\n  nation l1\nWHERE\n  EXISTS(\n    SELECT *\n    FROM\n      nation l2\n    WHERE\n      l2.nationkey = l1.nationkey\n  )\n  AND NOT EXISTS(\n    SELECT *\n    FROM\n      nation l3\n    WHERE\n      l3.nationkey= l1.nationkey\n  )\n", "VALUES 0");
    }

    @Test
    public void testPredicatePushdown() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey+1 AS a FROM orders WHERE orderstatus = 'F' UNION ALL \n  SELECT orderkey FROM orders WHERE orderkey % 2 = 0 UNION ALL \n  (SELECT orderkey+custkey FROM orders ORDER BY orderkey LIMIT 10)\n) \nWHERE a < 20 OR a > 100 \nORDER BY a");
    }

    @Test
    public void testGroupByKeyPredicatePushdown() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT custkey1, orderstatus1, SUM(totalprice1) totalprice, MAX(custkey2) maxcustkey\n  FROM (\n    SELECT *\n    FROM (\n      SELECT custkey custkey1, orderstatus orderstatus1, CAST(totalprice AS BIGINT) totalprice1, orderkey orderkey1\n      FROM orders\n    ) orders1 \n    JOIN (\n      SELECT custkey custkey2, orderstatus orderstatus2, CAST(totalprice AS BIGINT) totalprice2, orderkey orderkey2\n      FROM orders\n    ) orders2 ON orders1.orderkey1 = orders2.orderkey2\n  ) \n  GROUP BY custkey1, orderstatus1\n)\nWHERE custkey1 = maxcustkey\nAND maxcustkey % 2 = 0 \nAND orderstatus1 = 'F'\nAND totalprice > 10000\nORDER BY custkey1, orderstatus1, totalprice, maxcustkey");
    }

    @Test
    public void testTrivialNonDeterministicPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*) WHERE rand() >= 0");
    }

    @Test
    public void testNonDeterministicTableScanPredicatePushdown() {
        MaterializedResult materializedResult = this.computeActual("SELECT COUNT(*)\nFROM (\n  SELECT *\n  FROM lineitem\n  LIMIT 1000\n)\nWHERE rand() > 0.5");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedResult.getMaterializedRows());
        Assert.assertEquals((int)row.getFieldCount(), (int)1);
        long count = (Long)row.getField(0);
        org.testng.Assert.assertTrue((count > 0L && count < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testNonDeterministicAggregationPredicatePushdown() {
        MaterializedResult materializedResult = this.computeActual("SELECT COUNT(*)\nFROM (\n  SELECT orderkey, COUNT(*)\n  FROM lineitem\n  GROUP BY orderkey\n  LIMIT 1000\n)\nWHERE rand() > 0.5");
        MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedResult.getMaterializedRows());
        Assert.assertEquals((int)row.getFieldCount(), (int)1);
        long count = (Long)row.getField(0);
        org.testng.Assert.assertTrue((count > 0L && count < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testUnionAllPredicateMoveAroundWithOverlappingProjections() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT orderkey AS x, orderkey AS y\n  FROM orders\n  WHERE orderkey % 3 = 0\n  UNION ALL\n  SELECT orderkey AS x, orderkey AS y\n  FROM orders\n  WHERE orderkey % 2 = 0\n) a\nJOIN (\n  SELECT orderkey AS x, orderkey AS y\n  FROM orders\n) b\nON a.x = b.x");
    }

    @Test
    public void testTableSampleBernoulliBoundaryValues() {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (0)");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM orders", fullSample.getTypes());
        QueryAssertions.assertContains(all, fullSample);
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testTableSampleBernoulli() {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        int total = this.computeExpected("SELECT orderkey FROM orders", (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT)).getMaterializedRows().size();
        for (int i = 0; i < 100; ++i) {
            List values = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (50)").getMaterializedRows();
            Assert.assertEquals((int)values.size(), (int)ImmutableSet.copyOf((Collection)values).size(), (String)"TABLESAMPLE produced duplicate rows");
            stats.addValue((double)values.size() * 1.0 / (double)total);
        }
        double mean = stats.getGeometricMean();
        org.testng.Assert.assertTrue((mean > 0.45 && mean < 0.55 ? 1 : 0) != 0, (String)String.format("Expected mean sampling rate to be ~0.5, but was %s", mean));
    }

    @Test
    public void testFunctionNotRegistered() {
        this.assertQueryFails("SELECT length(1)", "\\Qline 1:8: Unexpected parameters (integer) for function length. Expected:\\E.*");
    }

    @Test
    public void testFunctionArgumentTypeConstraint() {
        this.assertQueryFails("SELECT greatest(rgb(255, 0, 0))", "\\Qline 1:8: Unexpected parameters (color) for function greatest. Expected: greatest(E) E:orderable\\E.*");
    }

    @Test
    public void testTypeMismatch() {
        this.assertQueryFails("SELECT 1 <> 'x'", "\\Qline 1:10: '<>' cannot be applied to integer, varchar(1)\\E");
    }

    @Test
    public void testInvalidType() {
        this.assertQueryFails("SELECT CAST(null AS array(foo))", "\\Qline 1:8: Unknown type: array(foo)\\E");
    }

    @Test
    public void testInvalidTypeInfixOperator() {
        this.assertQueryFails("SELECT ('a' || 'z') + (3 * 4) / 5", "\\Qline 1:21: '+' cannot be applied to varchar, integer\\E");
    }

    @Test
    public void testInvalidTypeBetweenOperator() {
        this.assertQueryFails("SELECT 'a' BETWEEN 3 AND 'z'", "\\Qline 1:12: Cannot check if varchar(1) is BETWEEN integer and varchar(1)\\E");
    }

    @Test
    public void testInvalidTypeArray() {
        this.assertQueryFails("SELECT ARRAY[1, 2, 'a']", "\\Qline 1:20: All ARRAY elements must be the same type: integer\\E");
    }

    @Test
    public void testArrayShuffle() {
        List expected = IntStream.rangeClosed(1, 500).boxed().collect(Collectors.toList());
        HashSet<List> distinctResults = new HashSet<List>();
        distinctResults.add(expected);
        for (int i = 0; i < 3; ++i) {
            MaterializedResult results = this.computeActual(String.format("SELECT shuffle(ARRAY %s) FROM orders LIMIT 10", expected));
            List rows = results.getMaterializedRows();
            Assert.assertEquals((int)rows.size(), (int)10);
            for (MaterializedRow row : rows) {
                List actual = (List)row.getField(0);
                QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
                distinctResults.add(actual);
            }
        }
        org.testng.Assert.assertTrue((distinctResults.size() >= 24 ? 1 : 0) != 0, (String)"shuffle must produce at least 24 distinct results");
    }

    @Test
    public void testNonReservedTimeWords() {
        this.assertQuery("SELECT TIME, TIMESTAMP, DATE, INTERVAL FROM (SELECT 1 TIME, 2 TIMESTAMP, 3 DATE, 4 INTERVAL)", "SELECT 1, 2, 3, 4");
    }

    @Test
    public void testCustomAdd() {
        this.assertQuery("SELECT custom_add(orderkey, custkey) FROM orders", "SELECT orderkey + custkey FROM orders");
    }

    @Test
    public void testCustomSum() {
        String sql = "SELECT orderstatus, custom_sum(orderkey) FROM orders GROUP BY orderstatus";
        this.assertQuery(sql, sql.replace("custom_sum", "sum"));
    }

    @Test
    public void testCustomRank() {
        String sql = "SELECT orderstatus, clerk, sales\n, custom_rank() OVER (PARTITION BY orderstatus ORDER BY sales DESC) rnk\nFROM (\n  SELECT orderstatus, clerk, sum(totalprice) sales\n  FROM orders\n  GROUP BY orderstatus, clerk\n)\nORDER BY orderstatus, clerk";
        Assert.assertEquals((Iterable)this.computeActual(sql), (Iterable)this.computeActual(sql.replace("custom_rank", "rank")));
    }

    @Test
    public void testApproxSetBigint() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(custkey)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1002L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetVarchar() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(CAST(custkey AS VARCHAR))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1024L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetDouble() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(CAST(custkey AS DOUBLE))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1014L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetBigintGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(custkey)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1001L}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetVarcharGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(CAST(custkey AS VARCHAR))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1021L}).row(new Object[]{"F", 1019L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetDoubleGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(CAST(custkey AS DOUBLE))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1011L}).row(new Object[]{"F", 1011L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(IF(orderstatus = 'O', custkey))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{1001L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetOnlyNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(null)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{null}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetGroupByWithOnlyNullsInOneGroup() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(IF(orderstatus != 'O', custkey))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", null}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetGroupByWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(approx_set(IF(custkey % 2 <> 0, custkey))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 499L}).row(new Object[]{"F", 496L}).row(new Object[]{"P", 153L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetBigintWithMaxError() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(custkey, 0.01)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1000L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetVarcharWithMaxError() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(CAST(custkey AS VARCHAR), 0.01)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1000L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testApproxSetDoubleWithMaxError() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(approx_set(CAST(custkey AS DOUBLE), 0.01)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1000L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLog() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(create_hll(custkey))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1002L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(merge(create_hll(custkey))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1001L}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(create_hll(IF(orderstatus = 'O', custkey)))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1001L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogGroupByWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(merge(create_hll(IF(orderstatus != 'O', custkey)))) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", null}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 304L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testMergeHyperLogLogOnlyNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(CAST (null AS HyperLogLog))) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{null}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testEmptyApproxSet() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(empty_approx_set())");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{0L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testEmptyApproxSetWithMaxError() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(empty_approx_set(0.1))");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{0L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test(expectedExceptions={RuntimeException.class, PrestoException.class}, expectedExceptionsMessageRegExp="Max standard error must be in.*")
    public void testEmptyApproxSetWithMaxErrorOutsideBounds() {
        this.computeActual("SELECT cardinality(empty_approx_set(0.3))");
    }

    @Test
    public void testMergeEmptyApproxSet() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(empty_approx_set())) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{0L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeEmptyNonEmptyApproxSet() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(c)) FROM (SELECT create_hll(custkey) c FROM orders UNION ALL SELECT empty_approx_set())");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1002L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testMergeEmptyNonEmptyApproxSetWithSameMaxError() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(merge(c)) FROM (SELECT create_hll(custkey, 0.1) c FROM orders UNION ALL SELECT empty_approx_set(0.1))");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1046L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test(expectedExceptions={RuntimeException.class, PrestoException.class}, expectedExceptionsMessageRegExp="Cannot merge HLLs with different number of buckets.*")
    public void testMergeEmptyNonEmptyApproxSetWithDifferentMaxError() {
        this.computeActual("SELECT cardinality(merge(c)) FROM (SELECT create_hll(custkey, 0.1) c FROM orders UNION ALL SELECT empty_approx_set(0.2))");
    }

    @Test
    public void testP4ApproxSetBigint() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(custkey) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1002L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetVarchar() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(CAST(custkey AS VARCHAR)) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1024L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetDouble() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(CAST(custkey AS DOUBLE)) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1014L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetBigintGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(custkey) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1001L}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 308L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetVarcharGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(CAST(custkey AS VARCHAR)) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1021L}).row(new Object[]{"F", 1019L}).row(new Object[]{"P", 302L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetDoubleGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(CAST(custkey AS DOUBLE)) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 1011L}).row(new Object[]{"F", 1011L}).row(new Object[]{"P", 306L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(IF(orderstatus = 'O', custkey)) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{1001L}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetOnlyNulls() {
        MaterializedResult actual = this.computeActual("SELECT cardinality(cast(approx_set(null) AS P4HYPERLOGLOG)) FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{null}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetGroupByWithOnlyNullsInOneGroup() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(IF(orderstatus != 'O', custkey)) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", null}).row(new Object[]{"F", 998L}).row(new Object[]{"P", 308L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testP4ApproxSetGroupByWithNulls() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, cardinality(cast(approx_set(IF(custkey % 2 <> 0, custkey)) AS P4HYPERLOGLOG)) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 495L}).row(new Object[]{"F", 491L}).row(new Object[]{"P", 153L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testValuesWithNonTrivialType() {
        MaterializedResult actual = this.computeActual("VALUES (0E0/0E0, 1E0/0E0, -1E0/0E0)");
        List rows = actual.getMaterializedRows();
        Assert.assertEquals((int)rows.size(), (int)1);
        MaterializedRow row = (MaterializedRow)rows.get(0);
        org.testng.Assert.assertTrue((boolean)((Double)row.getField(0)).isNaN());
        Assert.assertEquals((Object)row.getField(1), (Object)Double.POSITIVE_INFINITY);
        Assert.assertEquals((Object)row.getField(2), (Object)Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testValuesWithTimestamp() {
        MaterializedResult actual = this.computeActual("VALUES (current_timestamp, now())");
        List rows = actual.getMaterializedRows();
        Assert.assertEquals((int)rows.size(), (int)1);
        MaterializedRow row = (MaterializedRow)rows.get(0);
        Assert.assertEquals((Object)row.getField(0), (Object)row.getField(1));
    }

    @Test
    public void testValuesWithUnusedColumns() {
        MaterializedResult actual = this.computeActual("SELECT foo FROM (values (1, 2)) a(foo, bar)");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{1}).build();
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    @Test
    public void testFilterPushdownWithAggregation() {
        this.assertQuery("SELECT * FROM (SELECT count(*) FROM orders) WHERE 0=1");
        this.assertQuery("SELECT * FROM (SELECT count(*) FROM orders) WHERE null");
    }

    @Test
    public void testAccessControl() {
        this.assertAccessDenied("INSERT INTO orders SELECT * FROM orders", "Cannot insert into table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE));
        this.assertAccessDenied("DELETE FROM orders", "Cannot delete from table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DELETE_TABLE));
        this.assertAccessDenied("CREATE TABLE foo AS SELECT * FROM orders", "Cannot create table .*.foo.*", TestingAccessControlManager.privilege((String)"foo", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_TABLE));
        this.assertAccessDenied("SELECT * FROM nation", "Cannot select from columns \\[nationkey, regionkey, name, comment\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT * FROM (SELECT * FROM nation)", "Cannot select from columns \\[nationkey, regionkey, name, comment\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT name FROM (SELECT * FROM nation)", "Cannot select from columns \\[nationkey, regionkey, name, comment\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessAllowed("SELECT name FROM nation", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT n1.nationkey, n2.regionkey FROM nation n1, nation n2", "Cannot select from columns \\[nationkey, regionkey\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT count(name) as c FROM nation where comment > 'abc' GROUP BY regionkey having max(nationkey) > 10", "Cannot select from columns \\[nationkey, regionkey, name, comment\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT 1 FROM region, nation where region.regionkey = nation.nationkey", "Cannot select from columns \\[nationkey\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT count(*) FROM nation", "Cannot select from columns \\[\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nation", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("WITH t1 AS (SELECT * FROM nation) SELECT * FROM t1", "Cannot select from columns \\[nationkey, regionkey, name, comment\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessAllowed("SELECT name AS my_alias FROM nation", TestingAccessControlManager.privilege((String)"my_alias", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessAllowed("SELECT my_alias from (SELECT name AS my_alias FROM nation)", TestingAccessControlManager.privilege((String)"my_alias", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT name AS my_alias FROM nation", "Cannot select from columns \\[name\\] in table .*.nation.*", TestingAccessControlManager.privilege((String)"name", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT nation.name FROM nation JOIN region USING (regionkey)", "Cannot select from columns \\[regionkey, name\\] in table .*", TestingAccessControlManager.privilege((String)"regionkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT array_agg(regionkey ORDER BY regionkey) FROM nation JOIN region USING (regionkey)", "Cannot select from columns \\[regionkey\\] in table .*", TestingAccessControlManager.privilege((String)"regionkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
    }

    @Test
    public void testEmptyInputForUnnest() {
        this.assertQuery("SELECT val FROM (SELECT DISTINCT vals FROM (values (array[2])) t(vals) WHERE false) tmp CROSS JOIN unnest(tmp.vals) tt(val)", "SELECT 1 WHERE 1=2");
    }

    @Test
    public void testCoercions() {
        this.assertQuery("SELECT length(NULL)");
        this.assertQuery("SELECT CAST('abc' AS VARCHAR(255)) || CAST('abc' AS VARCHAR(252))");
        this.assertQuery("SELECT CAST('abc' AS VARCHAR(255)) || 'abc'");
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + NULL");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) + CAST(292.1 AS DECIMAL(5,1))");
        QueryAssertions.assertEqualsIgnoreOrder(this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1))] || CAST(292 AS DECIMAL(5,1))"), this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1)), CAST(292 AS DECIMAL(5,1))]"));
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(292 AS BIGINT)");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) = CAST(292 AS BIGINT)");
        QueryAssertions.assertEqualsIgnoreOrder(this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1))] || CAST(292 AS BIGINT)"), this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1)), CAST(292 AS DECIMAL(19,0))]"));
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(1.1 AS DOUBLE)");
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) = CAST(1.1 AS DOUBLE)");
        this.assertQuery("SELECT SIN(CAST(1.1 AS DECIMAL(38,1)))");
        QueryAssertions.assertEqualsIgnoreOrder(this.computeActual("SELECT ARRAY[CAST(282.1 AS DOUBLE), CAST(283.2 AS DOUBLE)] || CAST(101.3 AS DECIMAL(5,1))"), this.computeActual("SELECT ARRAY[CAST(282.1 AS DOUBLE), CAST(283.2 AS DOUBLE), CAST(101.3 AS DOUBLE)]"));
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(292 AS INTEGER)");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) = CAST(292 AS INTEGER)");
        QueryAssertions.assertEqualsIgnoreOrder(this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1))] || CAST(292 AS INTEGER)"), this.computeActual("SELECT ARRAY[CAST(282 AS DECIMAL(22,1)), CAST(282 AS DECIMAL(10,1)), CAST(292 AS DECIMAL(19,0))]"));
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(CAST(121 AS DECIMAL(30,1)) AS TINYINT)");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) = CAST(CAST(121 AS DECIMAL(30,1)) AS TINYINT)");
        this.assertQuery("SELECT CAST(1.1 AS DECIMAL(38,1)) + CAST(CAST(121 AS DECIMAL(30,1)) AS SMALLINT)");
        this.assertQuery("SELECT CAST(292 AS DECIMAL(38,1)) = CAST(CAST(121 AS DECIMAL(30,1)) AS SMALLINT)");
        this.assertQuery("SELECT * FROM (  SELECT t2.x || t2.z cc FROM (    SELECT *    FROM (VALUES (CAST('a' AS VARCHAR), CAST('c' AS VARCHAR))) t(x, z)  ) t2  JOIN (    SELECT *    FROM (VALUES (CAST('a' AS VARCHAR), CAST('c' AS VARCHAR))) u(x, z)    WHERE z='c'  ) u2  ON t2.z = u2.z) tt WHERE cc = 'ac'", "SELECT 'ac'");
        this.assertQuery("SELECT * FROM (  SELECT greatest (t.x, t.z) cc FROM (    SELECT *    FROM (VALUES (VARCHAR 'a', VARCHAR 'c')) t(x, z)  ) t  JOIN (    SELECT *    FROM (VALUES (VARCHAR 'a', VARCHAR 'c')) u(x, z)    WHERE z='c'  ) u  ON t.z = u.z)WHERE cc = 'c'", "SELECT 'c'");
        this.assertQuery("SELECT cc[1], cc[2] FROM ( SELECT * FROM (  SELECT array[t.x, t.z] cc FROM (    SELECT *    FROM (VALUES (VARCHAR 'a', VARCHAR 'c')) t(x, z)  ) t  JOIN (    SELECT *    FROM (VALUES (VARCHAR 'a', VARCHAR 'c')) u(x, z)    WHERE z='c'  ) u  ON t.z = u.z) WHERE cc = array['a', 'c'])", "SELECT 'a', 'c'");
        this.assertQuery("SELECT c = 'x'FROM (    SELECT 'x' AS c    UNION ALL    SELECT 'yy' AS c)");
    }

    @Test
    public void testExecute() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT 123, 'abc'").build();
        this.assertQuery(session, "EXECUTE my_query", "SELECT 123, 'abc'");
    }

    @Test
    public void testExecuteUsing() {
        String query = "SELECT a + 1, count(?) FROM (VALUES 1, 2, 3, 2) t1(a) JOIN (VALUES 1, 2, 3, 4) t2(b) ON b < ? WHERE a < ? GROUP BY a + 1 HAVING count(1) > ?";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING 1, 5, 4, 0", "VALUES (2, 4), (3, 8), (4, 4)");
    }

    @Test
    public void testExecuteUsingWithDifferentDatatypes() {
        String query = "SELECT c1, c2, c3, c4, c5, c6, c7['alice'], c8[1], c9 FROM (SELECT ? as c1, ? as c2, ? as c3, ? as c4, ? as c5, ? as c6, ? as c7, ? as c8, ? as c9)";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING -100, 'hello', (DATE '2020-10-15'), (TIMESTAMP '2020-03-14 10:12:12'), true, ARRAY [1, 2], MAP(ARRAY['alice', 'bob'], ARRAY [100, 300]), ROW('hi!'), null", "VALUES (-100, 'hello', DATE '2020-10-15', TIMESTAMP '2020-03-14 10:12:12', true, ARRAY [1, 2], 100, 'hi!', null)");
    }

    @Test
    public void testExecuteUsingWithSubquery() {
        String query = "SELECT ? in (SELECT orderkey FROM orders)";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING 10", "SELECT 10 in (SELECT orderkey FROM orders)");
    }

    @Test
    public void testExecuteWithParametersInLambda() {
        String query = "SELECT filter(array[1, 2, 3], x -> x > ?)";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING 2", "SELECT array[3]");
    }

    @Test
    public void testExecuteWithParametersInGroupBy() {
        try {
            String query = "SELECT a + ?, count(1) FROM (VALUES 1, 2, 3, 2) t(a) GROUP BY a + ?";
            Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
            this.computeActual(session, "EXECUTE my_query USING 1, 1");
            org.testng.Assert.fail((String)"parameters in GROUP BY and SELECT should fail");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"line 1:10: '(a + ?)' must be an aggregate expression or appear in GROUP BY clause");
        }
    }

    @Test
    public void testExecuteUsingFunction() {
        String query = "SELECT ?";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING length('Presto!')", "VALUES (7)");
    }

    @Test
    public void testExecuteUsingSubqueryFails() {
        try {
            String query = "SELECT ?";
            Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
            this.computeActual(session, "EXECUTE my_query USING (SELECT 1 from nation)");
            org.testng.Assert.fail((String)"nonLiteral parameters should fail");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.EXPRESSION_NOT_CONSTANT);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"line 1:24: Constant expression cannot contain table references");
        }
    }

    @Test
    public void testExecuteUsingSelectStarFails() {
        try {
            String query = "SELECT ?";
            Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
            this.computeActual(session, "EXECUTE my_query USING (SELECT * from nation)");
            org.testng.Assert.fail((String)"nonLiteral parameters should fail");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.EXPRESSION_NOT_CONSTANT);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"line 1:24: Constant expression cannot contain column references");
        }
    }

    @Test
    public void testExecuteUsingColumnReferenceFails() {
        try {
            String query = "SELECT ? from nation";
            Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
            this.computeActual(session, "EXECUTE my_query USING \"nationkey\"");
            org.testng.Assert.fail((String)"nonLiteral parameters should fail");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.EXPRESSION_NOT_CONSTANT);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"line 1:24: Constant expression cannot contain column references");
        }
    }

    @Test
    public void testExecuteUsingWithWithClause() {
        String query = "WITH src AS (SELECT * FROM (VALUES (1, 4),(2, 5), (3, 6)) AS t(id1, id2) WHERE id2 = ?) SELECT * from src WHERE id1 between ? and ?";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.assertQuery(session, "EXECUTE my_query USING 6, 0, 10", "VALUES (3, 6)");
    }

    @Test
    public void testExecuteNoSuchQuery() {
        this.assertQueryFails("EXECUTE my_query", "Prepared statement not found: my_query");
    }

    @Test
    public void testParametersNonPreparedStatement() {
        try {
            this.computeActual("SELECT ?, 1");
            org.testng.Assert.fail((String)"parameters not in prepared statements should fail");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.INVALID_PARAMETER_USAGE);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"line 1:1: Incorrect number of parameters: expected 1 but found 0");
        }
    }

    @Test
    public void testDescribeInput() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT ? FROM nation WHERE nationkey = ? and name < ?").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE INPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR}).row(new Object[]{0, "unknown"}).row(new Object[]{1, "bigint"}).row(new Object[]{2, "varchar"}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeInputWithAggregation() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT count(*) + ? FROM nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE INPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR}).row(new Object[]{0, "bigint"}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeInputNoParameters() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT * FROM nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE INPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{UnknownType.UNKNOWN, UnknownType.UNKNOWN}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testDescribeInputNoSuchQuery() {
        this.assertQueryFails("DESCRIBE INPUT my_query", "Prepared statement not found: my_query");
    }

    @Test
    public void testQuantifiedComparison() {
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey = ANY (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey = ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <> ANY (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <> ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey = ALL (SELECT regionkey FROM region WHERE name IN ('ASIA'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <> ALL (SELECT regionkey FROM region WHERE name IN ('ASIA'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey = ANY (SELECT regionkey FROM region WHERE name IN ('EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <> ANY (SELECT regionkey FROM region WHERE name IN ('EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey < SOME (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <= ANY (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey > ANY (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey >= SOME (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey < ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey <= ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey > ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT nationkey, name, regionkey FROM nation WHERE regionkey >= ALL (SELECT regionkey FROM region WHERE name IN ('ASIA', 'EUROPE'))");
        this.assertQuery("SELECT 1.0 < ALL(SELECT 1), 1 < ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 < ANY(SELECT 1), 1 < ANY(SELECT 1)");
        this.assertQuery("SELECT 1.0 <= ALL(SELECT 1) WHERE 1 <= ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 <= ANY(SELECT 1) WHERE 1 <= ANY(SELECT 1)");
        this.assertQuery("SELECT 1.0 <= ALL(SELECT 1), 1 <= ALL(SELECT 1) WHERE 1 <= ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 <= ANY(SELECT 1), 1 <= ANY(SELECT 1) WHERE 1 <= ANY(SELECT 1)");
        this.assertQuery("SELECT 1.0 = ALL(SELECT 1) WHERE 1 = ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 = ANY(SELECT 1) WHERE 1 = ANY(SELECT 1)");
        this.assertQuery("SELECT 1.0 = ALL(SELECT 1), 2 = ALL(SELECT 1) WHERE 1 = ALL(SELECT 1)");
        this.assertQuery("SELECT 1.0 = ANY(SELECT 1), 2 = ANY(SELECT 1) WHERE 1 = ANY(SELECT 1)");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) < ALL(SELECT CAST(1 AS decimal(3,1)))");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) < ANY(SELECT CAST(1 AS decimal(3,1)))");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) <= ALL(SELECT CAST(1 AS decimal(3,1)))");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) <= ANY(SELECT CAST(1 AS decimal(3,1)))");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) = ALL(SELECT CAST(1 AS decimal(3,1)))");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) = ANY(SELECT CAST(1 AS decimal(3,1)))", "SELECT true");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) <> ALL(SELECT CAST(1 AS decimal(3,1)))");
        this.assertQuery("SELECT CAST(1 AS decimal(3,2)) <> ANY(SELECT CAST(1 AS decimal(3,1)))");
    }

    @Test(dataProvider="quantified_comparisons_corner_cases")
    public void testQuantifiedComparisonCornerCases(String query) {
        this.assertQuery(query);
    }

    @DataProvider(name="quantified_comparisons_corner_cases")
    public Object[][] qualifiedComparisonsCornerCases() {
        return (Object[][])QueryTemplate.queryTemplate((String)"SELECT %value% %operator% %quantifier% (SELECT * FROM (%subquery%))", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[0]).replaceAll(new List[]{QueryTemplate.parameter((String)"subquery").of(new String[]{"SELECT 1 WHERE false", "SELECT CAST(NULL AS INTEGER)", "VALUES (1), (NULL)"}), QueryTemplate.parameter((String)"quantifier").of(new String[]{"ALL", "ANY"}), QueryTemplate.parameter((String)"value").of(new String[]{"1", "NULL"}), QueryTemplate.parameter((String)"operator").of(new String[]{"=", "!=", "<", ">", "<=", ">="})}).collect(TestngUtils.toDataProvider());
    }

    @Test
    public void testPreparedStatementWithSubqueries() {
        List leftValues = QueryTemplate.parameter((String)"left").of(new String[]{"", "1 = ", "EXISTS", "1 IN", "1 = ANY", "1 = ALL", "2 <> ANY", "2 <> ALL", "0 < ALL", "0 < ANY", "1 <= ALL", "1 <= ANY"});
        QueryTemplate.queryTemplate((String)"SELECT %left% (SELECT 1 WHERE 2 = ?)", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[0]).replaceAll(new List[]{leftValues}).forEach(query -> {
            Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
            this.assertQuery(session, "EXECUTE my_query USING 2", "SELECT true");
        });
    }

    @Test
    public void testDescribeOutput() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT * FROM nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"nationkey", session.getCatalog().get(), session.getSchema().get(), "nation", "bigint", 8, false}).row(new Object[]{"name", session.getCatalog().get(), session.getSchema().get(), "nation", "varchar(25)", 0, false}).row(new Object[]{"regionkey", session.getCatalog().get(), session.getSchema().get(), "nation", "bigint", 8, false}).row(new Object[]{"comment", session.getCatalog().get(), session.getSchema().get(), "nation", "varchar(152)", 0, false}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputNamedAndUnnamed() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT 1, name, regionkey AS my_alias FROM nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"_col0", "", "", "", "integer", 4, false}).row(new Object[]{"name", session.getCatalog().get(), session.getSchema().get(), "nation", "varchar(25)", 0, false}).row(new Object[]{"my_alias", session.getCatalog().get(), session.getSchema().get(), "nation", "bigint", 8, true}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputNonSelect() {
        this.assertDescribeOutputRowCount("CREATE TABLE foo AS SELECT * FROM nation");
        this.assertDescribeOutputRowCount("DELETE FROM orders");
        this.assertDescribeOutputEmpty("CALL foo()");
        this.assertDescribeOutputEmpty("SET SESSION optimize_hash_generation=false");
        this.assertDescribeOutputEmpty("RESET SESSION optimize_hash_generation");
        this.assertDescribeOutputEmpty("START TRANSACTION");
        this.assertDescribeOutputEmpty("COMMIT");
        this.assertDescribeOutputEmpty("ROLLBACK");
        this.assertDescribeOutputEmpty("GRANT INSERT ON foo TO bar");
        this.assertDescribeOutputEmpty("REVOKE INSERT ON foo FROM bar");
        this.assertDescribeOutputEmpty("CREATE SCHEMA foo");
        this.assertDescribeOutputEmpty("ALTER SCHEMA foo RENAME TO bar");
        this.assertDescribeOutputEmpty("DROP SCHEMA foo");
        this.assertDescribeOutputEmpty("CREATE TABLE foo (x bigint)");
        this.assertDescribeOutputEmpty("ALTER TABLE foo ADD COLUMN y bigint");
        this.assertDescribeOutputEmpty("ALTER TABLE foo RENAME TO bar");
        this.assertDescribeOutputEmpty("DROP TABLE foo");
        this.assertDescribeOutputEmpty("CREATE VIEW foo AS SELECT * FROM nation");
        this.assertDescribeOutputEmpty("CREATE FUNCTION testing.default.tan (x int) RETURNS double COMMENT 'tangent trigonometric function' LANGUAGE SQL DETERMINISTIC CALLED ON NULL INPUT RETURN sin(x) / cos(x)");
        this.assertDescribeOutputEmpty("ALTER FUNCTION testing.default.tan CALLED ON NULL INPUT");
        this.assertDescribeOutputEmpty("DROP FUNCTION IF EXISTS testing.default.tan (int)");
        this.assertDescribeOutputEmpty("DROP VIEW foo");
        this.assertDescribeOutputEmpty("PREPARE test FROM SELECT * FROM orders");
        this.assertDescribeOutputEmpty("EXECUTE test");
        this.assertDescribeOutputEmpty("DEALLOCATE PREPARE test");
    }

    private void assertDescribeOutputRowCount(@Language(value="SQL") String sql) {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", sql).build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"rows", "", "", "", "bigint", 8, false}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    private void assertDescribeOutputEmpty(@Language(value="SQL") String sql) {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", sql).build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputShowTables() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SHOW TABLES").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"Table", session.getCatalog().get(), "information_schema", "tables", "varchar", 0, true}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputOnAliasedColumnsAndExpressions() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SELECT count(*) AS this_is_aliased, 1 + 2 FROM nation").build();
        MaterializedResult actual = this.computeActual(session, "DESCRIBE OUTPUT my_query");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).row(new Object[]{"this_is_aliased", "", "", "", "bigint", 8, true}).row(new Object[]{"_col1", "", "", "", "integer", 4, false}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected);
    }

    @Test
    public void testDescribeOutputNoSuchQuery() {
        this.assertQueryFails("DESCRIBE OUTPUT my_query", "Prepared statement not found: my_query");
    }

    @Test
    public void testSubqueriesWithDisjunction() {
        List projections = QueryTemplate.parameter((String)"projection").of(new String[]{"count(*)", "*", "%condition%"});
        List conditions = QueryTemplate.parameter((String)"condition").of(new String[]{"nationkey IN (SELECT 1) OR TRUE", "EXISTS(SELECT 1) OR TRUE"});
        QueryTemplate.queryTemplate((String)"SELECT %projection% FROM nation WHERE %condition%", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[0]).replaceAll(new List[]{projections, conditions}).forEach(this::assertQuery);
        QueryTemplate.queryTemplate((String)"SELECT %projection% FROM nation WHERE (%condition%) AND nationkey <3", (QueryTemplate.Parameter[])new QueryTemplate.Parameter[0]).replaceAll(new List[]{projections, conditions}).forEach(this::assertQuery);
        this.assertQuery("SELECT count(*) FROM nation WHERE (SELECT true FROM (SELECT 1) t(a) WHERE a = nationkey) OR TRUE", "SELECT 25");
        this.assertQuery("SELECT (SELECT true FROM (SELECT 1) t(a) WHERE a = nationkey) FROM nation WHERE (SELECT true FROM (SELECT 1) t(a) WHERE a = nationkey) OR TRUE ORDER BY nationkey LIMIT 2", "VALUES true, null");
    }

    @Test
    public void testAssignUniqueId() {
        String unionLineitem25Times = IntStream.range(0, 25).mapToObj(i -> "SELECT * FROM lineitem").collect(Collectors.joining(" UNION ALL "));
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM (   SELECT (SELECT count(*) WHERE c = 1)    FROM (SELECT CASE orderkey WHEN 1 THEN orderkey ELSE 1 END        FROM (" + unionLineitem25Times + ")) o(c)) result(a) WHERE a = 1)", "VALUES 1504375");
    }

    @Test
    public void testPruningCountAggregationOverScalar() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT SUM(orderkey) FROM orders)");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT SUM(orderkey) FROM orders GROUP BY custkey)", "VALUES 1000");
        this.assertQuery("SELECT count(*) FROM (VALUES 2) t(a) GROUP BY a", "VALUES 1");
        this.assertQuery("SELECT a, count(*) FROM (VALUES 2) t(a) GROUP BY a", "VALUES (2, 1)");
        this.assertQuery("SELECT count(*) FROM (VALUES 2) t(a) GROUP BY a+1", "VALUES 1");
    }

    @Test
    public void testDefaultDecimalLiteralSwitch() {
        Session decimalLiteral = Session.builder((Session)this.getSession()).setSystemProperty("parse_decimal_literals_as_double", "false").build();
        MaterializedResult decimalColumnResult = this.computeActual(decimalLiteral, "SELECT 1.0");
        Assert.assertEquals((int)decimalColumnResult.getRowCount(), (int)1);
        Assert.assertEquals(decimalColumnResult.getTypes().get(0), (Object)DecimalType.createDecimalType((int)2, (int)1));
        Assert.assertEquals((Object)((MaterializedRow)decimalColumnResult.getMaterializedRows().get(0)).getField(0), (Object)new BigDecimal("1.0"));
        Session doubleLiteral = Session.builder((Session)this.getSession()).setSystemProperty("parse_decimal_literals_as_double", "true").build();
        MaterializedResult doubleColumnResult = this.computeActual(doubleLiteral, "SELECT 1.0");
        Assert.assertEquals((int)doubleColumnResult.getRowCount(), (int)1);
        Assert.assertEquals(doubleColumnResult.getTypes().get(0), (Object)DoubleType.DOUBLE);
        Assert.assertEquals((Object)((MaterializedRow)doubleColumnResult.getMaterializedRows().get(0)).getField(0), (Object)1.0);
    }

    @Test
    public void testLastValueIgnoreNulls() {
        this.assertQuery("WITH T AS (    SELECT        p,        v    FROM (        VALUES            (2, 2),            (1, 1),            (3, NULL)    ) T(p, v))SELECT    LAST_VALUE(v) IGNORE NULLS OVER (        PARTITION BY 1        ORDER BY            p ASC    )FROM T", "Values 1, 2, 2");
    }

    @Test
    public void testLargeBytecode() {
        StringBuilder stringBuilder = new StringBuilder("SELECT x FROM (SELECT orderkey x, custkey y from orders limit 10) WHERE CASE true ");
        for (int i = 0; i < 100; ++i) {
            stringBuilder.append(" when x in (");
            for (int j = 0; j < 20; ++j) {
                stringBuilder.append("random(" + (i * 100 + j) + "), ");
            }
            stringBuilder.append("random(" + i + ")) then x = random()");
        }
        stringBuilder.append("else x = random() end");
        this.assertQueryFails(stringBuilder.toString(), "Query results in large bytecode exceeding the limits imposed by JVM|Compiler failed");
    }

    @Test
    public void testInComplexTypes() {
        int i;
        StringBuilder query = new StringBuilder("select * from (values('a'), (null)) as t (name) where ROW('1', name) IN ( ");
        for (i = 2; i < 32; ++i) {
            query.append(String.format("ROW('1','%s'), ", i));
        }
        query.append("ROW('1', name), ROW('2',name), ROW('3',name))");
        this.assertQuerySucceeds(query.toString());
        query = new StringBuilder("select ROW(null_value) IN ( ");
        for (i = 0; i < 32; ++i) {
            query.append(String.format("ROW(%s), ", i));
        }
        query.append("ROW(32)) ");
        query.append("FROM (values(null)) as t (null_value)");
        this.assertQuery(query.toString(), "SELECT NULL");
    }

    @Test
    public void testRowExpressionInterpreterStackOverflow() {
        StringBuilder stringBuilder = new StringBuilder("SELECT  CASE");
        for (int i = 1; i <= 500; ++i) {
            stringBuilder.append(" when x = random(" + i + ") then " + i);
        }
        stringBuilder.append(" else x end from (select -1 x)");
        this.assertQuery(stringBuilder.toString(), "values -1");
    }

    @Test
    public void testSwitchOptimization() {
        this.assertQuery("select 1", "select 1");
        this.assertQuery("SELECT CASE WHEN x = 1 THEN 1 WHEN x = 5 THEN 5 WHEN x = IF(RANDOM() >= 0, 3, 5) THEN 10 ELSE -1 END FROM (SELECT ORDERKEY x FROM orders where orderkey <= 10)", "SELECT CASE x WHEN 1 THEN 1 WHEN 5 THEN 5 WHEN 3 THEN 10 ELSE -1 END FROM (SELECT ORDERKEY x FROM orders where orderkey <= 10)");
        this.assertQuery("SELECT CASE x WHEN 1 THEN 1 WHEN 5 THEN 5 WHEN 3 THEN 10 ELSE -1 END FROM (SELECT ORDERKEY x FROM orders where orderkey <= 10)", "SELECT CASE x WHEN 1 THEN 1 WHEN 5 THEN 5 WHEN 3 THEN 10 ELSE -1 END FROM (SELECT ORDERKEY x FROM orders where orderkey <= 10)");
    }

    @Test
    public void testSwitchReturnsNull() {
        this.assertQuery("SELECT CASE true WHEN random() < 0 THEN true END", "SELECT CAST(NULL AS BOOLEAN)");
        this.assertQuery("SELECT TRUE AND CAST(NULL AS BOOLEAN) AND RANDOM() >= 0", "SELECT CAST(NULL AS BOOLEAN)");
        this.assertQuery("SELECT TRUE AND CAST(NULL AS BOOLEAN) AND RANDOM() < 0", "SELECT FALSE");
        this.assertQuery("SELECT TRUE AND CAST(NULL AS BOOLEAN) IS NULL AND RANDOM() >= 0", "SELECT TRUE");
        this.assertQuery("SELECT 1 = ALL (SELECT CAST(NULL AS INTEGER))", "SELECT CAST(NULL AS BOOLEAN)");
    }

    @Test
    public void testAndInFilter() {
        this.assertQuery("SELECT count() from (select * from orders where orderkey < 10) where ((orderkey > 100 and custkey > 100) or (orderkey > 200 and custkey < 200))", "values 0");
        this.assertQuery("SELECT ((orderkey > 100 and custkey > 100) or (orderkey > 200 and custkey < 200)) from (select * from orders where orderkey < 10 limit 1)", "values false");
    }

    @Test
    public void testSetAgg() {
        String input = "(select 1 x, 2 y union all select 1 x, 2 y union all select 2 x, 1 y)";
        this.assertQuery("select count() from (select set_agg(x) = array_distinct(array_agg(x)) equals from (select 1 x, 2 y union all select 1 x, 2 y union all select 2 x, 1 y) group by y) where equals", "select count(distinct y) from (select 1 x, 2 y union all select 1 x, 2 y union all select 2 x, 1 y)");
        this.assertQuery("select count() from (select set_agg(orderkey) = array_agg(distinct orderkey) eq from orders group by custkey) where eq", "select count(distinct custkey) from orders");
        this.assertQuery("select cardinality(set_agg(orderkey)) from orders", "select count(distinct orderkey) from orders");
        this.assertQuery("select count() from (select set_agg(comment) = array_agg(distinct comment) eq from orders group by orderkey) where eq", "select count(distinct orderkey) from orders");
        this.assertQuery("select cardinality(set_agg(comment)) from orders", "select count(distinct comment) from orders");
        this.assertQuery("select count() from (select set_agg(cast(orderdate as date)) = array_agg(distinct cast(orderdate as date)) eq from orders group by orderkey) where eq", "select count(distinct orderkey) from orders");
        this.assertQuery("select cardinality(set_agg(cast(orderdate as date))) from orders", "select count(distinct orderdate) from orders");
    }

    @Test
    public void testRedundantProjection() {
        this.assertQuery("SELECT x, reduce(x, 0, (s, x) -> s + x, s -> s), reduce(x, 0, (s, x) -> s + x, s -> s) FROM (VALUES (array[1, 2, 3])) t(x)", "SELECT array[1, 2, 3], 6, 6");
        this.assertQuery("SELECT x, filter(x, v -> date(v) BETWEEN date'2020-01-01' AND date'2020-06-30'), filter(x, v -> date(v) BETWEEN date'2020-01-01' AND date_add('day', 2, date'2020-06-28')) FROM (VALUES (array['2020-03-01', '2020-07-01'])) t(x)", "SELECT array['2020-03-01', '2020-07-01'], array['2020-03-01'], array['2020-03-01']");
        this.assertQuerySucceeds("SELECT DISTINCT null AS a, NULL AS b, orderstatus FROM (SELECT orderstatus FROM orders GROUP BY orderstatus)");
    }

    @Test
    public void testComparisonWithLike() {
        this.assertQuery("SELECT t1.custkey, t2.comment FROM (SELECT * FROM orders WHERE (comment LIKE '%shipping_onsite%') = FALSE) t1 JOIN (SELECT * FROM orders WHERE (comment LIKE '%shipping_onsite%') = FALSE) t2 ON t1.orderkey=t2.orderkey");
    }

    @Test
    public void testSetUnion() {
        this.assertQuery("select set_union(x) from (values array[1, 2], array[3, 4], array[5, 6]) as t(x)", "select array[1, 2, 3, 4, 5, 6]");
        this.assertQuery("select set_union(x) from (values array[1, 2, 3], array[2, 3, 4], array[7, 8]) as t(x)", "select array[1, 2, 3, 4, 7, 8]");
        this.assertQuery("select group_id, set_union(numbers) from (values (1, array[1, 2]), (1, array[2, 3]), (2, array[4, 5]), (2, array[5, 6])) as t(group_id, numbers) group by group_id", "select group_id, numbers from (values (1, array[1, 2, 3]), (2, array[4, 5, 6])) as t(group_id, numbers)");
        this.assertQuery("select group_id, set_union(numbers) from (values (1, array[1, 2]), (2, array[2, 3]), (3, array[4, 5]), (4, array[5, 6])) as t(group_id, numbers) group by group_id", "select group_id, numbers from (values (1, array[1, 2]), (2, array[2, 3]), (3, array[4, 5]), (4, array[5, 6])) as t(group_id, numbers)");
        this.assertQuery("select set_union(x) from (values null, null, null) as t(x)", "select array[]");
        this.assertQuery("select set_union(x) from (values null, array[null], null) as t(x)", "select array[null]");
        this.assertQuery("select set_union(x) from (values array[1, 2, 3], array[null], null) as t(x)", "select array[1, 2, 3, null]");
        this.assertQuery("select set_union(x) from (values null, array[null], null) as t(x) where x != null", "select null");
    }

    @Test
    public void testMultipleSqlFunctionsWithLambda() {
        this.assertQuery("SELECT array_sum(zip_with(a, b, (x, y) -> x * y)), array_sum(zip_with(a, b, (x, y) -> x * y)) + array_sum(zip_with(a, a, (x, y) -> x * y)) FROM (VALUES (ARRAY[1, 2, 3], ARRAY[1, 0, 0])) t(a, b)", "SELECT 1, 15");
    }

    @Test
    public void testDistinctFrom() {
        this.assertQuery("SELECT x IS DISTINCT FROM NULL FROM (SELECT CAST(NULL AS VARCHAR)) T(x)", "SELECT FALSE");
        this.assertQuery("SELECT NULL IS DISTINCT FROM x FROM (SELECT CAST(NULL AS VARCHAR)) T(x)", "SELECT FALSE");
        this.assertQuery("SELECT x IS DISTINCT FROM NULL FROM (SELECT CAST('something' AS VARCHAR)) T(x)", "SELECT TRUE");
        this.assertQuery("SELECT NULL IS DISTINCT FROM x FROM (SELECT CAST('something' AS VARCHAR)) T(x)", "SELECT TRUE");
        this.assertQuery("SELECT R.name IS DISTINCT FROM NULL FROM nation N LEFT OUTER JOIN region R ON N.regionkey = R.regionkey AND R.regionkey = 2 WHERE N.name='GERMANY'", "SELECT FALSE");
        this.assertQuery("SELECT NULL IS DISTINCT FROM R.name FROM nation N LEFT OUTER JOIN region R ON N.regionkey = R.regionkey AND R.regionkey = 2 WHERE N.name='KENYA'", "SELECT FALSE");
        this.assertQuery("SELECT NULL IS DISTINCT FROM R.name FROM nation N LEFT OUTER JOIN region R ON N.regionkey = R.regionkey AND R.regionkey = 2 WHERE N.name='KENYA'", "SELECT FALSE");
        this.assertQuery("SELECT NULL IS DISTINCT FROM R.name FROM nation N LEFT OUTER JOIN region R ON N.regionkey = R.regionkey AND R.regionkey = 2 WHERE N.name='KENYA'", "SELECT FALSE");
        this.assertQuery("SELECT NULL IS DISTINCT FROM R.name FROM nation N LEFT OUTER JOIN region R ON N.regionkey = R.regionkey AND R.regionkey = 2 WHERE N.name='INDIA'", "SELECT TRUE");
        this.assertQuery("SELECT NULL IS DISTINCT FROM R.name FROM nation N LEFT OUTER JOIN region R ON N.regionkey = R.regionkey AND R.regionkey = 2 WHERE N.name='JAPAN'", "SELECT TRUE");
    }

    @Test
    public void testDereference() {
        this.assertQuery("select cast(row(row(row(random(10), if(random(10) >= 0, 2)), random(10)), random(100)) AS row(x row(y row(a int, b int), c int), d int)).x.y.b", "select 2");
        this.assertQuery("select cast(row(row(row(random(10), if(random(10) < 0, 2)), random(10)), random(100)) AS row(x row(y row(a int, b int), c int), d int)).x.y.b", "select null");
        this.assertQuery("select cast(row(row(null, random(10)), random(100)) AS row(x row(y row(a int, b int), c int), d int)).x.y.b", "select null");
        this.assertQuery("select cast(row(row(null, if(random(100) >= 0, 4)), random(10)) AS row(x row(y row(a int, b int), c int), d int)).x.c", "select 4");
    }

    @Test
    public void testApproxMostFrequentWithLong() {
        MaterializedResult actual1 = this.computeActual("SELECT approx_most_frequent(3, cast(x as bigint), 15) FROM (values 1, 2, 1, 3, 1, 2, 3, 4, 5) t(x)");
        Assert.assertEquals((int)actual1.getRowCount(), (int)1);
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(0)).getFields().get(0), (Object)ImmutableMap.of((Object)1L, (Object)3L, (Object)2L, (Object)2L, (Object)3L, (Object)2L));
        MaterializedResult actual2 = this.computeActual("SELECT approx_most_frequent(2, cast(x as bigint), 15) FROM (values 1, 2, 1, 3, 1, 2, 3, 4, 5) t(x)");
        Assert.assertEquals((int)actual2.getRowCount(), (int)1);
        Assert.assertEquals(((MaterializedRow)actual2.getMaterializedRows().get(0)).getFields().get(0), (Object)ImmutableMap.of((Object)1L, (Object)3L, (Object)2L, (Object)2L));
    }

    @Test
    public void testApproxMostFrequentWithVarchar() {
        MaterializedResult actual1 = this.computeActual("SELECT approx_most_frequent(3, x, 15) FROM (values 'A', 'B', 'A', 'C', 'A', 'B', 'C', 'D', 'E') t(x)");
        Assert.assertEquals((int)actual1.getRowCount(), (int)1);
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(0)).getFields().get(0), (Object)ImmutableMap.of((Object)"A", (Object)3L, (Object)"B", (Object)2L, (Object)"C", (Object)2L));
        MaterializedResult actual2 = this.computeActual("SELECT approx_most_frequent(2, x, 15) FROM (values 'A', 'B', 'A', 'C', 'A', 'B', 'C', 'D', 'E') t(x)");
        Assert.assertEquals((int)actual2.getRowCount(), (int)1);
        Assert.assertEquals(((MaterializedRow)actual2.getMaterializedRows().get(0)).getFields().get(0), (Object)ImmutableMap.of((Object)"A", (Object)3L, (Object)"B", (Object)2L));
    }

    @Test
    public void testApproxMostFrequentWithLongGroupBy() {
        MaterializedResult actual1 = this.computeActual("SELECT k, approx_most_frequent(3, cast(v as bigint), 15) FROM (values ('a', 1), ('b', 2), ('a', 1), ('c', 3), ('a', 1), ('b', 2), ('c', 3), ('a', 4), ('b', 5)) t(k, v) GROUP BY 1 ORDER BY 1");
        Assert.assertEquals((int)actual1.getRowCount(), (int)3);
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(0)).getFields().get(0), (Object)"a");
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(0)).getFields().get(1), (Object)ImmutableMap.of((Object)1L, (Object)3L, (Object)4L, (Object)1L));
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(1)).getFields().get(0), (Object)"b");
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(1)).getFields().get(1), (Object)ImmutableMap.of((Object)2L, (Object)2L, (Object)5L, (Object)1L));
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(2)).getFields().get(0), (Object)"c");
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(2)).getFields().get(1), (Object)ImmutableMap.of((Object)3L, (Object)2L));
    }

    @Test
    public void testApproxMostFrequentWithStringGroupBy() {
        MaterializedResult actual1 = this.computeActual("SELECT k, approx_most_frequent(3, v, 15) FROM (values ('a', 'A'), ('b', 'B'), ('a', 'A'), ('c', 'C'), ('a', 'A'), ('b', 'B'), ('c', 'C'), ('a', 'D'), ('b', 'E')) t(k, v) GROUP BY 1 ORDER BY 1");
        Assert.assertEquals((int)actual1.getRowCount(), (int)3);
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(0)).getFields().get(0), (Object)"a");
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(0)).getFields().get(1), (Object)ImmutableMap.of((Object)"A", (Object)3L, (Object)"D", (Object)1L));
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(1)).getFields().get(0), (Object)"b");
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(1)).getFields().get(1), (Object)ImmutableMap.of((Object)"B", (Object)2L, (Object)"E", (Object)1L));
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(2)).getFields().get(0), (Object)"c");
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(2)).getFields().get(1), (Object)ImmutableMap.of((Object)"C", (Object)2L));
    }

    @Test
    public void testUnknownMaxBy() {
        this.assertQuery("select max_by(x, y) from (select 1 x, null y)", "select null");
        this.assertQuery("select max_by(x, y) from (select null x, 1 y)", "select null");
        this.assertQuery("select max_by(x, y) from (select null x, null y)", "select null");
    }

    @Test
    public void testMapUnionSum() {
        MaterializedResult actual = this.computeActual("select map_union_sum(x) from (select map(array['x', 'y'], cast(array[1.1,2] as array<real>) ) x union all select map(array['x', 'y'], cast(array[10,20] as array<real>)))");
        Assert.assertEquals((int)actual.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)actual.getMaterializedRows().get(0)).getField(0), (Object)ImmutableMap.of((Object)"x", (Object)Float.valueOf(11.1f), (Object)"y", (Object)Float.valueOf(22.0f)));
        actual = this.computeActual("select map_union_sum(x) from (select map(array['x', 'y'], cast(array[1.1,2.58] as array<double>)) x union all select map(array['x', 'y'], cast(array[10.1,20.1] as array<double>)))");
        Assert.assertEquals((int)actual.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)actual.getMaterializedRows().get(0)).getField(0), (Object)ImmutableMap.of((Object)"x", (Object)11.2, (Object)"y", (Object)22.68));
        actual = this.computeActual("select map_union_sum(x) from (select map(array['x', 'y'], cast(array[1,2] as array<bigint>)) x union all select map(array['x', 'y'], cast(array[10,20] as array<bigint>)))");
        Assert.assertEquals((int)actual.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)actual.getMaterializedRows().get(0)).getField(0), (Object)ImmutableMap.of((Object)"x", (Object)11L, (Object)"y", (Object)22L));
        actual = this.computeActual("select y, map_union_sum(x) from (select 1 y, map(array['x', 'y'], cast(array[1,2] as array<bigint>)) x union all select 1 y, map(array['x', 'z', 'y'], cast(array[10,30,20] as array<bigint>))) group by y");
        Assert.assertEquals((int)actual.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)actual.getMaterializedRows().get(0)).getField(1), (Object)ImmutableMap.of((Object)"x", (Object)11L, (Object)"y", (Object)22L, (Object)"z", (Object)30L));
        actual = this.computeActual("select y, map_union_sum(x) from (select 1 y, map(array['x', 'y'], cast(array[1, null] as array<bigint>))x ) group by y");
        Assert.assertEquals((int)actual.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)actual.getMaterializedRows().get(0)).getField(1), (Object)ImmutableMap.of((Object)"x", (Object)1L, (Object)"y", (Object)0L));
        actual = this.computeActual("select y, map_union_sum(x) from (select 1 y, map(array['x', 'z', 'y'], cast(array[null,30,20] as array<integer>)) x union all select 1 y, map(array['x', 'y'], cast(array[1,null] as array<integer>))x) group by y");
        Assert.assertEquals((int)actual.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)actual.getMaterializedRows().get(0)).getField(1), (Object)ImmutableMap.of((Object)"x", (Object)1, (Object)"y", (Object)20, (Object)"z", (Object)30));
        actual = this.computeActual("select y, map_union_sum(x) from (select 1 y, map(array['x', 'z', 'y'], cast(array[null,30,20] as array<smallint>)) x union all select 1 y, map(array['x', 'y'], cast(array[1,null] as array<smallint>))x) group by y");
        Assert.assertEquals((int)actual.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)actual.getMaterializedRows().get(0)).getField(1), (Object)ImmutableMap.of((Object)"x", (Object)1, (Object)"y", (Object)20, (Object)"z", (Object)30));
        actual = this.computeActual("select y, map_union_sum(x) from (select 1 y, map(array['x', 'z', 'y'], cast(array[null,30,20] as array<tinyint>)) x union all select 1 y, map(array['x', 'y'], cast(array[1,null] as array<tinyint>))x) group by y");
        Assert.assertEquals((int)actual.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)actual.getMaterializedRows().get(0)).getField(1), (Object)ImmutableMap.of((Object)"x", (Object)1, (Object)"y", (Object)20, (Object)"z", (Object)30));
        actual = this.computeActual("select y, map_union_sum(x) from (select 1 y, map(array['x', 'z', 'y'], cast(array[null,30,20] as array<bigint>)) x union all select 1 y, map(array['x', 'y'], cast(array[1,null] as array<bigint>))x) group by y");
        Assert.assertEquals((int)actual.getRowCount(), (int)1);
        Assert.assertEquals((Object)((MaterializedRow)actual.getMaterializedRows().get(0)).getField(1), (Object)ImmutableMap.of((Object)"x", (Object)1L, (Object)"y", (Object)20L, (Object)"z", (Object)30L));
        actual = this.computeActual("select y, map_union_sum(x) from (select 1 y, map(array['x', 'y'], cast(array[1,null] as array<bigint>)) x union all select 1 y, map(array['x', 'z', 'y'], cast(array[null,30,20] as array<bigint>)) union all select 1 y, map(array['a', 'y', 'x'], cast(array[100, 400, 200] as array<bigint>)) union all select 3 y, map(array['a', 'm', 'x'], cast(array[-1, 2, -3] as array<bigint>)) ) group by y order by y");
        Assert.assertEquals((int)actual.getRowCount(), (int)2);
        Assert.assertEquals((Object)((MaterializedRow)actual.getMaterializedRows().get(0)).getField(0), (Object)1);
        Assert.assertEquals((Object)((MaterializedRow)actual.getMaterializedRows().get(0)).getField(1), (Object)ImmutableMap.of((Object)"a", (Object)100L, (Object)"x", (Object)201L, (Object)"y", (Object)420L, (Object)"z", (Object)30L));
        Assert.assertEquals((Object)((MaterializedRow)actual.getMaterializedRows().get(1)).getField(0), (Object)3);
        Assert.assertEquals((Object)((MaterializedRow)actual.getMaterializedRows().get(1)).getField(1), (Object)ImmutableMap.of((Object)"a", (Object)-1L, (Object)"m", (Object)2L, (Object)"x", (Object)-3L));
    }

    @Test
    public void testInvalidMapUnionSum() {
        this.assertQueryFails("SELECT map_union_sum(x) from (select cast(MAP() as map<varchar, varchar>) x)", ".*line 1:8: Unexpected parameters \\(map\\(varchar,varchar\\)\\) for function map_union_sum. Expected: map_union_sum\\(map\\(K,V\\)\\) K:comparable, V:nonDecimalNumeric.*");
        this.assertQueryFails("SELECT map_union_sum(x) from (select cast(MAP() as map<varchar, decimal(10,2)>) x)", ".*line 1:8: Unexpected parameters \\(map\\(varchar,decimal\\(10,2\\)\\)\\) for function map_union_sum. Expected: map_union_sum\\(map\\(K,V\\)\\) K:comparable, V:nonDecimalNumeric.*");
    }

    @Test
    public void testMapUnionSumOverflow() {
        this.assertQueryFails("select y, map_union_sum(x) from (select 1 y, map(array['x', 'z', 'y'], cast(array[null,30,100] as array<tinyint>)) x union all select 1 y, map(array['x', 'y'], cast(array[1,100] as array<tinyint>))x) group by y", ".*Value 200 exceeds MAX_BYTE.*");
        this.assertQueryFails("select y, map_union_sum(x) from (select 1 y, map(array['x', 'z', 'y'], cast(array[null,30, 32760] as array<smallint>)) x union all select 1 y, map(array['x', 'y'], cast(array[1,100] as array<smallint>))x) group by y", ".*Value 32860 exceeds MAX_SHORT.*");
    }

    @Test
    public void testMultipleOrderingOnSameCanonicalVariables() {
        this.assertQuerySucceeds("SELECT ARRAY_AGG( x ORDER BY x ASC, x DESC ) FROM ( SELECT 0 as x, 0 AS y)");
    }

    @Test
    public void tesMultipleConcat() {
        this.assertQuery("select concat('a', '','','', 'b', '', '', 'c', 'd', '', '', '', '')", "select 'abcd'");
        this.assertQuery("select concat('', '','','', '', '', '', '', '', '', '')", "select ''");
        this.assertQuery("select concat('', '','','', 'x', '', '', '', '', '', '')", "select 'x'");
    }

    @Test
    public void testReduceAggWithNulls() {
        this.assertQueryFails("select reduce_agg(x, null, (x,y)->try(x+y), (x,y)->try(x+y)) from (select 1 union all select 10) T(x)", ".*REDUCE_AGG only supports non-NULL literal as the initial value.*");
        this.assertQueryFails("select reduce_agg(x, cast(null as bigint), (x,y)->coalesce(x, 0)+coalesce(y, 0), (x,y)->coalesce(x, 0)+coalesce(y, 0)) from (values cast(10 as bigint),10)T(x)", ".*REDUCE_AGG only supports non-NULL literal as the initial value.*");
        this.assertQuery("select reduce_agg(x, 0, (x,y)->try(1/x+1/y), (x,y)->try(1/x+1/y)) from ((select 0) union all select 10.) T(x)", "select null");
        this.assertQuery("select reduce_agg(x, 0, (x, y)->try(x+y), (x, y)->try(x+y)) from (values 2817, 9223372036854775807) AS T(x)", "select null");
        this.assertQuery("select reduce_agg(x, array[], (x, y)->array[element_at(x, 2)],  (x, y)->array[element_at(x, 2)]) from (select array[array[1]]) T(x)", "select array[null]");
    }

    @Test
    public void testReduceAggWithMapZip() {
        Session sessionWithIntermediateAggEnabled = Session.builder((Session)this.getSession()).setSystemProperty("enable_intermediate_aggregations", "true").build();
        this.assertQuerySucceeds(sessionWithIntermediateAggEnabled, "select reduce_agg(x, map(), (s,x)->map_zip_with( s, x, (k1,v1,v2)->if(v1>v2,v1,v2)), (s,x)->map_zip_with( s, x, (k1,v1,v2)->if(v1>v2,v1,v2))) from (select map(array['k1', 'k2'], array[1e-2, 0.06]) x union all select map(array['k1', 'k2'], array[2e-05, 1e-2]) x)");
    }

    @Test
    public void testReduceAggWithArrayConcat() {
        this.assertQuerySucceeds("select sum(cardinality(s)) from (SELECT REDUCE_AGG(x, cast(array[] as array<bigint>), (x,y)->x||sequence(1, y), (x,y)->x||y) s FROM (SELECT x FROM (SELECT 1) CROSS JOIN UNNEST(SEQUENCE(1, 7000)) T(x)) group by random(100))");
        this.assertQuerySucceeds("select sum(cardinality(s)) from (SELECT REDUCE_AGG(x, cast(map() as map<bigint, bigint>), (x,y) -> map_concat(x, map(sequence(1, y), repeat(1, cast(y as int)))), (x,y)->map_concat(x,y)) s FROM (SELECT x FROM (SELECT 1) CROSS JOIN UNNEST(SEQUENCE(1, 7000)) T(x)) group by random(100))");
    }

    @Test
    public void testDefaultSamplingPercent() {
        this.assertQuery("select key_sampling_percent('abc')", "select 0.56");
    }

    @Test
    public void testKeyBasedSampling() {
        String[] queries = new String[]{"select count(1) from orders join lineitem using(orderkey)", "select count(1) from (select custkey, max(orderkey) from orders group by custkey)", "select count_if(m >= 1) from (select max(orderkey) over(partition by custkey) m from orders)", "select cast(m as bigint) from (select sum(totalprice) over(partition by custkey order by comment) m from orders order by 1 desc limit 1)", "select count(1) from lineitem where orderkey in (select orderkey from orders where length(comment) > 7)", "select count(1) from lineitem where orderkey not in (select orderkey from orders where length(comment) > 27)", "select count(1) from (select distinct orderkey, custkey from orders)"};
        int[] unsampledResults = new int[]{60175, 1000, 15000, 5408941, 60175, 9256, 15000};
        for (int i = 0; i < queries.length; ++i) {
            this.assertQuery(queries[i], "select " + unsampledResults[i]);
        }
        Session sessionWithKeyBasedSampling = Session.builder((Session)this.getSession()).setSystemProperty("key_based_sampling_enabled", "true").setSystemProperty("key_based_sampling_percentage", "0.2").build();
        int[] sampled20PercentResults = new int[]{37170, 616, 9189, 5408941, 37170, 5721, 9278};
        for (int i = 0; i < queries.length; ++i) {
            this.assertQuery(sessionWithKeyBasedSampling, queries[i], "select " + sampled20PercentResults[i]);
        }
        sessionWithKeyBasedSampling = Session.builder((Session)this.getSession()).setSystemProperty("key_based_sampling_enabled", "true").setSystemProperty("key_based_sampling_percentage", "0.1").build();
        int[] sampled10PercentResults = new int[]{33649, 557, 8377, 4644937, 33649, 5098, 8397};
        for (int i = 0; i < queries.length; ++i) {
            this.assertQuery(sessionWithKeyBasedSampling, queries[i], "select " + sampled10PercentResults[i]);
        }
    }

    @Test
    public void testKeyBasedSamplingFunctionError() {
        Session sessionWithKeyBasedSampling = Session.builder((Session)this.getSession()).setSystemProperty("key_based_sampling_enabled", "true").setSystemProperty("key_based_sampling_function", "blah").build();
        this.assertQueryFails(sessionWithKeyBasedSampling, "select count(1) from orders join lineitem using(orderkey)", "Sampling function: blah not cannot be resolved");
    }

    @Test
    public void testSamplingJoinChain() {
        Session sessionWithKeyBasedSampling = Session.builder((Session)this.getSession()).setSystemProperty("key_based_sampling_enabled", "true").build();
        String query = "select count(1) FROM lineitem l left JOIN orders o ON l.orderkey = o.orderkey JOIN customer c ON o.custkey = c.custkey";
        this.assertQuery(query, "select 60175");
        this.assertQuery(sessionWithKeyBasedSampling, query, "select 16185");
    }

    @Test
    public void testGroupByWithLambdaExpression() {
        this.assertQueryFails("SELECT reduce(a, 0, (s, x) -> x, s->s), count(*) FROM (VALUES (array[1]), (array[1, 2, 3]), (array[3])) t(a) GROUP BY reduce(a, 0, (s, x) -> x, s->s)", "GROUP BY does not support lambda expressions, please use GROUP BY # instead");
        this.assertQuery("SELECT reduce(a, 0, (s, x) -> x, s->s), count(*) FROM (VALUES (array[1]), (array[1, 2, 3]), (array[3])) t(a) GROUP BY 1", "VALUES (3, 2), (1, 1)");
    }

    public void testSourceLocationInPlan() {
        MaterializedResult result = this.computeActual("explain(type distributed) select max(orderkey + 1) over(partition by custkey) m from orders");
        Assert.assertEquals((int)result.getRowCount(), (int)1);
        String plan = (String)((MaterializedRow)result.getMaterializedRows().get(0)).getField(0);
        org.testng.Assert.assertTrue((boolean)plan.contains("expr := (orderkey) + (BIGINT'1') (1:88)"));
        org.testng.Assert.assertTrue((boolean)plan.contains("m := max (1:34)"));
        org.testng.Assert.assertTrue((boolean)plan.contains("max := max(expr) RANGE UNBOUNDED_PRECEDING CURRENT_ROW (1:34)"));
    }
}

