/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.QueryAssertions;
import org.testng.annotations.Test;

public abstract class AbstractTestIntegrationSmokeTest
extends AbstractTestQueryFramework {
    protected AbstractTestIntegrationSmokeTest(AbstractTestQueryFramework.QueryRunnerSupplier supplier) {
        super(supplier);
    }

    protected boolean isDateTypeSupported() {
        return true;
    }

    protected boolean isParameterizedVarcharSupported() {
        return true;
    }

    @Test
    public void testAggregateSingleColumn() {
        this.assertQuery("SELECT SUM(orderkey) FROM orders");
        this.assertQuery("SELECT SUM(totalprice) FROM orders");
        this.assertQuery("SELECT MAX(comment) FROM orders");
    }

    @Test
    public void testColumnsInReverseOrder() {
        this.assertQuery("SELECT shippriority, clerk, totalprice FROM orders");
    }

    @Test
    public void testCountAll() {
        this.assertQuery("SELECT COUNT(*) FROM orders");
    }

    @Test
    public void testExactPredicate() {
        this.assertQuery("SELECT * FROM orders WHERE orderkey = 10");
    }

    @Test
    public void testInListPredicate() {
        this.assertQuery("SELECT * FROM orders WHERE orderkey IN (10, 11, 20, 21)");
    }

    @Test
    public void testIsNullPredicate() {
        this.assertQuery("SELECT * FROM orders WHERE orderkey = 10 OR orderkey IS NULL");
    }

    @Test
    public void testLimit() {
        Assert.assertEquals((int)this.computeActual("SELECT * FROM orders LIMIT 10").getRowCount(), (int)10);
    }

    @Test
    public void testMultipleRangesPredicate() {
        this.assertQuery("SELECT * FROM orders WHERE orderkey BETWEEN 10 AND 50 OR orderkey BETWEEN 100 AND 150");
    }

    @Test
    public void testRangePredicate() {
        this.assertQuery("SELECT * FROM orders WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testSelectAll() {
        this.assertQuery("SELECT * FROM orders");
    }

    @Test
    public void testShowSchemas() {
        MaterializedResult actualSchemas = this.computeActual("SHOW SCHEMAS").toTestTypes();
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((Session)this.getQueryRunner().getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR}).row(new Object[]{this.getQueryRunner().getDefaultSession().getSchema().orElse("tpch")});
        QueryAssertions.assertContains(actualSchemas, resultBuilder.build());
    }

    @Test
    public void testShowTables() {
        MaterializedResult actualTables = this.computeActual("SHOW TABLES").toTestTypes();
        MaterializedResult expectedTables = MaterializedResult.resultBuilder((Session)this.getQueryRunner().getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR}).row(new Object[]{"orders"}).build();
        QueryAssertions.assertContains(actualTables, expectedTables);
    }

    @Test
    public void testDescribeTable() {
        MaterializedResult actualColumns = this.computeActual("DESC orders").toTestTypes();
        Assert.assertEquals((Iterable)actualColumns, (Iterable)this.getExpectedOrdersTableDescription(this.isDateTypeSupported(), this.isParameterizedVarcharSupported()));
    }

    @Test
    public void testSelectInformationSchemaTables() {
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String schemaPattern = schema.replaceAll("^.", "_");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = '" + schema + "' AND table_name = 'orders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema LIKE '" + schema + "' AND table_name LIKE '%rders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema LIKE '" + schemaPattern + "' AND table_name LIKE '%rders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = '" + catalog + "' AND table_schema LIKE '" + schema + "' AND table_name LIKE '%orders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = 'something_else'", "SELECT '' WHERE false");
    }

    @Test
    public void testSelectInformationSchemaColumns() {
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String schemaPattern = schema.replaceAll(".$", "_");
        String ordersTableWithColumns = "VALUES ('orders', 'orderkey'), ('orders', 'custkey'), ('orders', 'orderstatus'), ('orders', 'totalprice'), ('orders', 'orderdate'), ('orders', 'orderpriority'), ('orders', 'clerk'), ('orders', 'shippriority'), ('orders', 'comment')";
        this.assertQuery("SELECT table_schema FROM information_schema.columns WHERE table_schema = '" + schema + "' GROUP BY table_schema", "VALUES '" + schema + "'");
        this.assertQuery("SELECT table_name FROM information_schema.columns WHERE table_name = 'orders' GROUP BY table_name", "VALUES 'orders'");
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name = 'orders'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name LIKE '%rders'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema LIKE '" + schemaPattern + "' AND table_name LIKE '_rder_'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "' AND table_name LIKE '%orders%'", ordersTableWithColumns);
        this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_catalog = 'something_else'", "SELECT '' WHERE false");
    }

    @Test
    public void testDuplicatedRowCreateTable() {
        this.assertQueryFails("CREATE TABLE test (a integer, a integer)", "line 1:31: Column name 'a' specified more than once");
        this.assertQueryFails("CREATE TABLE test (a integer, orderkey integer, LIKE orders INCLUDING PROPERTIES)", "line 1:49: Column name 'orderkey' specified more than once");
        this.assertQueryFails("CREATE TABLE test (a integer, A integer)", "line 1:31: Column name 'A' specified more than once");
        this.assertQueryFails("CREATE TABLE test (a integer, OrderKey integer, LIKE orders INCLUDING PROPERTIES)", "line 1:49: Column name 'orderkey' specified more than once");
    }

    protected MaterializedResult getExpectedOrdersTableDescription(boolean dateSupported, boolean parametrizedVarchar) {
        String orderDateType = dateSupported ? "date" : "varchar";
        if (parametrizedVarchar) {
            return MaterializedResult.resultBuilder((Session)this.getQueryRunner().getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", orderDateType, "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
        }
        return MaterializedResult.resultBuilder((Session)this.getQueryRunner().getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", orderDateType, "", ""}).row(new Object[]{"orderpriority", "varchar", "", ""}).row(new Object[]{"clerk", "varchar", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar", "", ""}).build();
    }
}

