/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.airlift.discovery.server.testing.TestingDiscoveryServer;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.sql.planner.ConnectorPlanOptimizerManager;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tests.AbstractTestQueries;
import com.facebook.presto.tests.H2ConnectionModule;
import com.facebook.presto.tests.H2FunctionNamespaceManagerPlugin;
import com.facebook.presto.tests.ResultWithQueryId;
import com.facebook.presto.tests.TestingPrestoClient;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;

public class DistributedQueryRunner
implements QueryRunner {
    private static final Logger log = Logger.get(DistributedQueryRunner.class);
    private static final String ENVIRONMENT = "testing";
    private static final SqlParserOptions DEFAULT_SQL_PARSER_OPTIONS = new SqlParserOptions();
    private final TestingDiscoveryServer discoveryServer;
    private final TestingPrestoServer coordinator;
    private final List<TestingPrestoServer> servers;
    private final List<Process> externalWorkers;
    private final Closer closer = Closer.create();
    private final TestingPrestoClient prestoClient;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicReference<Handle> testFunctionNamespacesHandle = new AtomicReference();

    @Deprecated
    public DistributedQueryRunner(Session defaultSession, int nodeCount) throws Exception {
        this(defaultSession, nodeCount, (Map<String, String>)ImmutableMap.of());
    }

    @Deprecated
    public DistributedQueryRunner(Session defaultSession, int nodeCount, Map<String, String> extraProperties) throws Exception {
        this(defaultSession, nodeCount, extraProperties, (Map<String, String>)ImmutableMap.of(), DEFAULT_SQL_PARSER_OPTIONS, ENVIRONMENT, Optional.empty(), Optional.empty());
    }

    public static Builder builder(Session defaultSession) {
        return new Builder(defaultSession);
    }

    private DistributedQueryRunner(Session defaultSession, int nodeCount, Map<String, String> extraProperties, Map<String, String> coordinatorProperties, SqlParserOptions parserOptions, String environment, Optional<Path> baseDataDir, Optional<BiFunction<Integer, URI, Process>> externalWorkerLauncher) throws Exception {
        long start;
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        try {
            start = System.nanoTime();
            this.discoveryServer = new TestingDiscoveryServer(environment);
            this.closer.register(() -> DistributedQueryRunner.closeUnchecked((AutoCloseable)this.discoveryServer));
            log.info("Created TestingDiscoveryServer in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
            URI discoveryUrl = this.discoveryServer.getBaseUrl();
            log.info("Discovery URL %s", new Object[]{discoveryUrl});
            ImmutableList.Builder servers = ImmutableList.builder();
            HashMap<String, String> extraCoordinatorProperties = new HashMap<String, String>();
            if (externalWorkerLauncher.isPresent()) {
                ImmutableList.Builder externalWorkersBuilder = ImmutableList.builder();
                for (int i = 0; i < nodeCount; ++i) {
                    externalWorkersBuilder.add((Object)externalWorkerLauncher.get().apply(i, discoveryUrl));
                }
                this.externalWorkers = externalWorkersBuilder.build();
                this.closer.register(() -> {
                    for (Process worker : this.externalWorkers) {
                        worker.destroyForcibly();
                    }
                });
                extraCoordinatorProperties.put("node-scheduler.include-coordinator", "false");
            } else {
                this.externalWorkers = ImmutableList.of();
                for (int i = 1; i < nodeCount; ++i) {
                    TestingPrestoServer worker = (TestingPrestoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingPrestoServer(discoveryUrl, false, extraProperties, parserOptions, environment, baseDataDir));
                    servers.add((Object)worker);
                }
            }
            extraCoordinatorProperties.put("experimental.iterative-optimizer-enabled", "true");
            extraCoordinatorProperties.putAll(extraProperties);
            extraCoordinatorProperties.putAll(coordinatorProperties);
            this.coordinator = (TestingPrestoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingPrestoServer(discoveryUrl, true, extraCoordinatorProperties, parserOptions, environment, baseDataDir));
            servers.add((Object)this.coordinator);
            this.servers = servers.build();
        }
        catch (Exception e) {
            try {
                throw this.closer.rethrow((Throwable)e, Exception.class);
            }
            catch (Throwable throwable) {
                this.closer.close();
                throw throwable;
            }
        }
        defaultSession = defaultSession.toSessionRepresentation().toSession(this.coordinator.getMetadata().getSessionPropertyManager());
        this.prestoClient = (TestingPrestoClient)this.closer.register((Closeable)new TestingPrestoClient(this.coordinator, defaultSession));
        start = System.nanoTime();
        while (!this.allNodesGloballyVisible()) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(10.0, TimeUnit.SECONDS));
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        log.info("Announced servers in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
        start = System.nanoTime();
        for (TestingPrestoServer server : this.servers) {
            server.getMetadata().registerBuiltInFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
        }
        log.info("Added functions in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
        for (TestingPrestoServer server : this.servers) {
            Catalog bogusTestingCatalog = TestingSession.createBogusTestingCatalog((String)"testing_catalog");
            server.getCatalogManager().registerCatalog(bogusTestingCatalog);
            SessionPropertyManager sessionPropertyManager = server.getMetadata().getSessionPropertyManager();
            sessionPropertyManager.addSystemSessionProperties(AbstractTestQueries.TEST_SYSTEM_PROPERTIES);
            sessionPropertyManager.addConnectorSessionProperties(bogusTestingCatalog.getConnectorId(), AbstractTestQueries.TEST_CATALOG_PROPERTIES);
        }
    }

    private static TestingPrestoServer createTestingPrestoServer(URI discoveryUri, boolean coordinator, Map<String, String> extraProperties, SqlParserOptions parserOptions, String environment, Optional<Path> baseDataDir) throws Exception {
        long start = System.nanoTime();
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10m").put((Object)"exchange.http-client.idle-timeout", (Object)"1h").put((Object)"task.max-index-memory", (Object)"16kB").put((Object)"datasources", (Object)"system").put((Object)"distributed-index-joins-enabled", (Object)"true");
        if (coordinator) {
            propertiesBuilder.put((Object)"node-scheduler.include-coordinator", (Object)"true");
            propertiesBuilder.put((Object)"join-distribution-type", (Object)"PARTITIONED");
        }
        HashMap<String, String> properties = new HashMap<String, String>((Map<String, String>)propertiesBuilder.build());
        properties.putAll(extraProperties);
        TestingPrestoServer server = new TestingPrestoServer(coordinator, properties, environment, discoveryUri, parserOptions, (List)ImmutableList.of(), baseDataDir);
        String nodeRole = coordinator ? "coordinator" : "worker";
        log.info("Created %s TestingPrestoServer in %s: %s", new Object[]{nodeRole, Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit(), server.getBaseUrl()});
        return server;
    }

    private boolean allNodesGloballyVisible() {
        int expectedActiveNodes = this.externalWorkers.size() + this.servers.size();
        for (TestingPrestoServer server : this.servers) {
            AllNodes allNodes = server.refreshNodes();
            if (allNodes.getInactiveNodes().isEmpty() && allNodes.getActiveNodes().size() == expectedActiveNodes) continue;
            return false;
        }
        return true;
    }

    public TestingPrestoClient getClient() {
        return this.prestoClient;
    }

    public int getNodeCount() {
        return this.servers.size();
    }

    public Session getDefaultSession() {
        return this.prestoClient.getDefaultSession();
    }

    public TransactionManager getTransactionManager() {
        return this.coordinator.getTransactionManager();
    }

    public Metadata getMetadata() {
        return this.coordinator.getMetadata();
    }

    public SplitManager getSplitManager() {
        return this.coordinator.getSplitManager();
    }

    public PageSourceManager getPageSourceManager() {
        return this.coordinator.getPageSourceManager();
    }

    public NodePartitioningManager getNodePartitioningManager() {
        return this.coordinator.getNodePartitioningManager();
    }

    public ConnectorPlanOptimizerManager getPlanOptimizerManager() {
        return this.coordinator.getPlanOptimizerManager();
    }

    public StatsCalculator getStatsCalculator() {
        return this.coordinator.getStatsCalculator();
    }

    public Optional<EventListener> getEventListener() {
        return this.coordinator.getEventListener();
    }

    public TestingAccessControlManager getAccessControl() {
        return this.coordinator.getAccessControl();
    }

    public TestingPrestoServer getCoordinator() {
        return this.coordinator;
    }

    public List<TestingPrestoServer> getServers() {
        return ImmutableList.copyOf(this.servers);
    }

    public void installPlugin(Plugin plugin) {
        long start = System.nanoTime();
        for (TestingPrestoServer server : this.servers) {
            server.installPlugin(plugin);
        }
        log.info("Installed plugin %s in %s", new Object[]{plugin.getClass().getSimpleName(), Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    public void createCatalog(String catalogName, String connectorName) {
        this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        long start = System.nanoTime();
        HashSet<ConnectorId> connectorIds = new HashSet<ConnectorId>();
        for (TestingPrestoServer server : this.servers) {
            connectorIds.add(server.createCatalog(catalogName, connectorName, properties));
        }
        ConnectorId connectorId = (ConnectorId)Iterables.getOnlyElement(connectorIds);
        log.info("Created catalog %s (%s) in %s", new Object[]{catalogName, connectorId, Duration.nanosSince((long)start)});
        start = System.nanoTime();
        while (!this.isConnectorVisibleToAllNodes(connectorId)) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(100.0, TimeUnit.SECONDS), (String)("waiting for connector " + connectorId + " to be initialized in every node"));
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        log.info("Announced catalog %s (%s) in %s", new Object[]{catalogName, connectorId, Duration.nanosSince((long)start)});
    }

    public void loadFunctionNamespaceManager(String functionNamespaceManagerName, String catalogName, Map<String, String> properties) {
        for (TestingPrestoServer server : this.servers) {
            server.getMetadata().getFunctionAndTypeManager().loadFunctionNamespaceManager(functionNamespaceManagerName, catalogName, properties);
        }
    }

    public void enableTestFunctionNamespaces(List<String> catalogNames, Map<String, String> additionalProperties) {
        Preconditions.checkState((this.testFunctionNamespacesHandle.get() == null ? 1 : 0) != 0, (Object)"Test function namespaces already enabled");
        String databaseName = String.valueOf(System.nanoTime());
        ImmutableMap properties = ImmutableMap.builder().put((Object)"database-name", (Object)databaseName).putAll(additionalProperties).build();
        this.installPlugin(new H2FunctionNamespaceManagerPlugin());
        for (String catalogName : catalogNames) {
            this.loadFunctionNamespaceManager("h2", catalogName, (Map<String, String>)properties);
        }
        Handle handle = Jdbi.open((String)H2ConnectionModule.getJdbcUrl(databaseName));
        this.testFunctionNamespacesHandle.set(handle);
        this.closer.register((Closeable)handle);
    }

    public void createTestFunctionNamespace(String catalogName, String schemaName) {
        Preconditions.checkState((this.testFunctionNamespacesHandle.get() != null ? 1 : 0) != 0, (Object)"Test function namespaces not enabled");
        this.testFunctionNamespacesHandle.get().execute("INSERT INTO function_namespaces SELECT ?, ?", new Object[]{catalogName, schemaName});
    }

    private boolean isConnectorVisibleToAllNodes(ConnectorId connectorId) {
        if (!this.externalWorkers.isEmpty()) {
            return true;
        }
        for (TestingPrestoServer server : this.servers) {
            server.refreshNodes();
            Set activeNodesWithConnector = server.getActiveNodesWithConnector(connectorId);
            if (activeNodesWithConnector.size() == this.servers.size()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List<QualifiedObjectName> list = this.prestoClient.listTables(session, catalog, schema);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.prestoClient.tableExists(session, table);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MaterializedResult execute(@Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.prestoClient.execute(sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.prestoClient.execute(session, sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultWithQueryId<MaterializedResult> executeWithQueryId(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            ResultWithQueryId<MaterializedResult> resultWithQueryId = this.prestoClient.execute(session, sql);
            return resultWithQueryId;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public QueryRunner.MaterializedResultWithPlan executeWithPlan(Session session, String sql, WarningCollector warningCollector) {
        ResultWithQueryId<MaterializedResult> resultWithQueryId = this.executeWithQueryId(session, sql);
        return new QueryRunner.MaterializedResultWithPlan(resultWithQueryId.getResult().toTestTypes(), this.getQueryPlan(resultWithQueryId.getQueryId()));
    }

    public Plan createPlan(Session session, String sql, WarningCollector warningCollector) {
        QueryId queryId = this.executeWithQueryId(session, sql).getQueryId();
        Plan queryPlan = this.getQueryPlan(queryId);
        this.coordinator.getQueryManager().cancelQuery(queryId);
        return queryPlan;
    }

    public List<BasicQueryInfo> getQueries() {
        return this.coordinator.getQueryManager().getQueries();
    }

    public QueryInfo getQueryInfo(QueryId queryId) {
        return this.coordinator.getQueryManager().getFullQueryInfo(queryId);
    }

    public Plan getQueryPlan(QueryId queryId) {
        return this.coordinator.getQueryPlan(queryId);
    }

    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    public final void close() {
        this.cancelAllQueries();
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void cancelAllQueries() {
        QueryManager queryManager = this.coordinator.getQueryManager();
        for (BasicQueryInfo queryInfo : queryManager.getQueries()) {
            if (queryInfo.getState().isDone()) continue;
            queryManager.cancelQuery(queryInfo.getQueryId());
        }
    }

    private static void closeUnchecked(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ SqlParserOptions access$000() {
        return DEFAULT_SQL_PARSER_OPTIONS;
    }

    public static class Builder {
        private Session defaultSession;
        private int nodeCount = 4;
        private Map<String, String> extraProperties = ImmutableMap.of();
        private Map<String, String> coordinatorProperties = ImmutableMap.of();
        private SqlParserOptions parserOptions = DistributedQueryRunner.access$000();
        private String environment = "testing";
        private Optional<Path> baseDataDir = Optional.empty();
        private Optional<BiFunction<Integer, URI, Process>> externalWorkerLauncher = Optional.empty();

        protected Builder(Session defaultSession) {
            this.defaultSession = Objects.requireNonNull(defaultSession, "defaultSession is null");
        }

        public Builder amendSession(Function<Session.SessionBuilder, Session.SessionBuilder> amendSession) {
            Session.SessionBuilder builder = Session.builder((Session)this.defaultSession);
            this.defaultSession = amendSession.apply(builder).build();
            return this;
        }

        public Builder setNodeCount(int nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public Builder setExtraProperties(Map<String, String> extraProperties) {
            this.extraProperties = extraProperties;
            return this;
        }

        public Builder setSingleExtraProperty(String key, String value) {
            return this.setExtraProperties((Map<String, String>)ImmutableMap.of((Object)key, (Object)value));
        }

        public Builder setCoordinatorProperties(Map<String, String> coordinatorProperties) {
            this.coordinatorProperties = coordinatorProperties;
            return this;
        }

        public Builder setSingleCoordinatorProperty(String key, String value) {
            return this.setCoordinatorProperties((Map<String, String>)ImmutableMap.of((Object)key, (Object)value));
        }

        public Builder setParserOptions(SqlParserOptions parserOptions) {
            this.parserOptions = parserOptions;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder setBaseDataDir(Optional<Path> baseDataDir) {
            this.baseDataDir = Objects.requireNonNull(baseDataDir, "baseDataDir is null");
            return this;
        }

        public Builder setExternalWorkerLauncher(Optional<BiFunction<Integer, URI, Process>> externalWorkerLauncher) {
            this.externalWorkerLauncher = Objects.requireNonNull(externalWorkerLauncher, "externalWorkerLauncher is null");
            return this;
        }

        public DistributedQueryRunner build() throws Exception {
            return new DistributedQueryRunner(this.defaultSession, this.nodeCount, this.extraProperties, this.coordinatorProperties, this.parserOptions, this.environment, this.baseDataDir, this.externalWorkerLauncher);
        }
    }
}

