/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.Column;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryStatusInfo;
import com.facebook.presto.client.StatementClient;
import com.facebook.presto.client.StatementClientFactory;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.session.ResourceEstimates;
import com.facebook.presto.tests.ResultWithQueryId;
import com.facebook.presto.tests.ResultsSession;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.intellij.lang.annotations.Language;

public abstract class AbstractTestingPrestoClient<T>
implements Closeable {
    private final TestingPrestoServer prestoServer;
    private final Session defaultSession;
    private final OkHttpClient httpClient = new OkHttpClient();

    protected AbstractTestingPrestoClient(TestingPrestoServer prestoServer, Session defaultSession) {
        this.prestoServer = Objects.requireNonNull(prestoServer, "prestoServer is null");
        this.defaultSession = Objects.requireNonNull(defaultSession, "defaultSession is null");
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    protected abstract ResultsSession<T> getResultSession(Session var1);

    public ResultWithQueryId<T> execute(@Language(value="SQL") String sql) {
        return this.execute(this.defaultSession, sql);
    }

    public ResultWithQueryId<T> execute(Session session, @Language(value="SQL") String sql) {
        ResultsSession<T> resultsSession = this.getResultSession(session);
        ClientSession clientSession = AbstractTestingPrestoClient.toClientSession(session, this.prestoServer.getBaseUrl(), new Duration(2.0, TimeUnit.MINUTES));
        Throwable throwable = null;
        try (StatementClient client = StatementClientFactory.newStatementClient((OkHttpClient)this.httpClient, (ClientSession)clientSession, (String)sql);){
            while (client.isRunning()) {
                resultsSession.addResults(client.currentStatusInfo(), client.currentData());
                client.advance();
            }
            Preconditions.checkState((boolean)client.isFinished());
            QueryError error = client.finalStatusInfo().getError();
            if (error == null) {
                QueryStatusInfo results = client.finalStatusInfo();
                if (results.getUpdateType() != null) {
                    resultsSession.setUpdateType(results.getUpdateType());
                }
                if (results.getUpdateCount() != null) {
                    resultsSession.setUpdateCount(results.getUpdateCount());
                }
                resultsSession.setWarnings(results.getWarnings());
                T result = resultsSession.build(client.getSetSessionProperties(), client.getResetSessionProperties());
                ResultWithQueryId<T> resultWithQueryId = new ResultWithQueryId<T>(new QueryId(results.getId()), result);
                return resultWithQueryId;
            }
            try {
                if (error.getFailureInfo() != null) {
                    RuntimeException remoteException = error.getFailureInfo().toException();
                    throw new RuntimeException(Optional.ofNullable(remoteException.getMessage()).orElseGet(remoteException::toString), remoteException);
                }
                throw new RuntimeException("Query failed: " + error.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static ClientSession toClientSession(Session session, URI server, Duration clientRequestTimeout) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.putAll(session.getSystemProperties());
        for (Map.Entry connectorProperties : session.getUnprocessedCatalogProperties().entrySet()) {
            for (Map.Entry entry : ((Map)connectorProperties.getValue()).entrySet()) {
                properties.put((Object)((String)connectorProperties.getKey() + "." + (String)entry.getKey()), entry.getValue());
            }
        }
        ImmutableMap.Builder resourceEstimates = ImmutableMap.builder();
        ResourceEstimates estimates = session.getResourceEstimates();
        estimates.getExecutionTime().ifPresent(e -> resourceEstimates.put((Object)"EXECUTION_TIME", (Object)e.toString()));
        estimates.getCpuTime().ifPresent(e -> resourceEstimates.put((Object)"CPU_TIME", (Object)e.toString()));
        estimates.getPeakMemory().ifPresent(e -> resourceEstimates.put((Object)"PEAK_MEMORY", (Object)e.toString()));
        return new ClientSession(server, session.getIdentity().getUser(), (String)session.getSource().orElse(null), session.getTraceToken(), session.getClientTags(), (String)session.getClientInfo().orElse(null), (String)session.getCatalog().orElse(null), (String)session.getSchema().orElse(null), session.getTimeZoneKey().getId(), session.getLocale(), (Map)resourceEstimates.build(), (Map)properties.build(), session.getPreparedStatements(), session.getIdentity().getRoles(), session.getIdentity().getExtraCredentials(), (String)session.getTransactionId().map(Object::toString).orElse(null), clientRequestTimeout, true);
    }

    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        return (List)TransactionBuilder.transaction((TransactionManager)this.prestoServer.getTransactionManager(), (AccessControl)this.prestoServer.getAccessControl()).readOnly().execute(session, transactionSession -> this.prestoServer.getMetadata().listTables(transactionSession, new QualifiedTablePrefix(catalog, schema)));
    }

    public boolean tableExists(Session session, String table) {
        return (Boolean)TransactionBuilder.transaction((TransactionManager)this.prestoServer.getTransactionManager(), (AccessControl)this.prestoServer.getAccessControl()).readOnly().execute(session, transactionSession -> MetadataUtil.tableExists((Metadata)this.prestoServer.getMetadata(), (Session)transactionSession, (String)table));
    }

    public Session getDefaultSession() {
        return this.defaultSession;
    }

    public TestingPrestoServer getServer() {
        return this.prestoServer;
    }

    protected List<Type> getTypes(List<Column> columns) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(columns, this.columnTypeGetter()));
    }

    protected Function<Column, Type> columnTypeGetter() {
        return column -> {
            String typeName = column.getType();
            Type type = this.prestoServer.getMetadata().getType(TypeSignature.parseTypeSignature((String)typeName));
            if (type == null) {
                throw new AssertionError((Object)("Unhandled type: " + typeName));
            }
            return type;
        };
    }
}

