/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.testing.ProcedureTester;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class TestingProcedures {
    private final ProcedureTester tester;

    public TestingProcedures(ProcedureTester tester) {
        this.tester = Objects.requireNonNull(tester, "tester is null");
    }

    @UsedByGeneratedCode
    public void simple() {
        this.tester.recordCalled("simple", new Object[0]);
    }

    @UsedByGeneratedCode
    public void args(long x, double y, String z, boolean q) {
        this.tester.recordCalled("args", new Object[]{x, y, z, q});
    }

    @UsedByGeneratedCode
    public void nulls(Long x, String y) {
        this.tester.recordCalled("nulls", new Object[]{x, y});
    }

    @UsedByGeneratedCode
    public void arrays(List<Long> x, List<String> y) {
        this.tester.recordCalled("arrays", new Object[]{x, y});
    }

    @UsedByGeneratedCode
    public void nested(List<List<Long>> x) {
        this.tester.recordCalled("nested", new Object[]{x});
    }

    @UsedByGeneratedCode
    public void sessionFirst(ConnectorSession session, long x) {
        Objects.requireNonNull(session, "session is null");
        this.tester.recordCalled("session_first", new Object[]{x});
    }

    @UsedByGeneratedCode
    public void sessionLast(String x, ConnectorSession session) {
        Objects.requireNonNull(session, "session is null");
        this.tester.recordCalled("session_last", new Object[]{x});
    }

    @UsedByGeneratedCode
    public void exception() {
        this.tester.recordCalled("exception", new Object[0]);
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "test exception from procedure");
    }

    @UsedByGeneratedCode
    public void optionals(ConnectorSession session, String x) {
        this.tester.recordCalled("optionals", new Object[]{x});
    }

    @UsedByGeneratedCode
    public void optionals2(ConnectorSession session, String x, String y) {
        this.tester.recordCalled("optionals2", new Object[]{x, y});
    }

    @UsedByGeneratedCode
    public void optionals3(ConnectorSession session, String x, String y, String z) {
        this.tester.recordCalled("optionals3", new Object[]{x, y, z});
    }

    @UsedByGeneratedCode
    public void optionals4(ConnectorSession session, String x, String y, String z, String v) {
        this.tester.recordCalled("optionals4", new Object[]{x, y, z, v});
    }

    @UsedByGeneratedCode
    public void error() {
        this.tester.recordCalled("error", new Object[0]);
        throw new RuntimeException("test error from procedure");
    }

    public List<Procedure> getProcedures(String schema) {
        return ImmutableList.builder().add((Object)this.procedure(schema, "test_simple", "simple", (List<Procedure.Argument>)ImmutableList.of())).add((Object)this.procedure(schema, "test_args", "args", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", "bigint"), (Object)new Procedure.Argument("y", "double"), (Object)new Procedure.Argument("z", "varchar"), (Object)new Procedure.Argument("q", "boolean")))).add((Object)this.procedure(schema, "test_nulls", "nulls", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", "bigint"), (Object)new Procedure.Argument("y", "varchar")))).add((Object)this.procedure(schema, "test_arrays", "arrays", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", "array(bigint)"), (Object)new Procedure.Argument("y", "array(varchar)")))).add((Object)this.procedure(schema, "test_nested", "nested", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", "array(array(bigint))")))).add((Object)this.procedure(schema, "test_session_first", "sessionFirst", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", "bigint")))).add((Object)this.procedure(schema, "test_session_last", "sessionLast", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", "varchar")))).add((Object)this.procedure(schema, "test_optionals", "optionals", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", "varchar", false, (Object)"hello")))).add((Object)this.procedure(schema, "test_optionals2", "optionals2", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", "varchar"), (Object)new Procedure.Argument("y", "varchar", false, (Object)"world")))).add((Object)this.procedure(schema, "test_optionals3", "optionals3", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", "varchar", false, (Object)"this"), (Object)new Procedure.Argument("y", "varchar", false, (Object)"is"), (Object)new Procedure.Argument("z", "varchar", false, (Object)"default")))).add((Object)this.procedure(schema, "test_optionals4", "optionals4", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("x", "varchar"), (Object)new Procedure.Argument("y", "varchar"), (Object)new Procedure.Argument("z", "varchar", false, (Object)"z default"), (Object)new Procedure.Argument("v", "varchar", false, (Object)"v default")))).add((Object)this.procedure(schema, "test_exception", "exception", (List<Procedure.Argument>)ImmutableList.of())).add((Object)this.procedure(schema, "test_error", "error", (List<Procedure.Argument>)ImmutableList.of())).build();
    }

    private Procedure procedure(String schema, String name, String methodName, List<Procedure.Argument> arguments) {
        return new Procedure(schema, name, arguments, this.handle(methodName));
    }

    private MethodHandle handle(String name) {
        List methods = Arrays.stream(this.getClass().getMethods()).filter(method -> method.getName().equals(name)).collect(Collectors.toList());
        Preconditions.checkArgument((!methods.isEmpty() ? 1 : 0) != 0, (String)"no matching methods: %s", (Object)name);
        Preconditions.checkArgument((methods.size() == 1 ? 1 : 0) != 0, (String)"multiple matching methods: %s", methods);
        return Reflection.methodHandle((Method)((Method)methods.get(0))).bindTo(this);
    }
}

