/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.datatype;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.datatype.DataSetup;
import com.facebook.presto.tests.datatype.DataType;
import com.facebook.presto.tests.sql.TestTable;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.testng.Assert;

public class DataTypeTest {
    private final List<Input<?>> inputs = new ArrayList();

    private DataTypeTest() {
    }

    public static DataTypeTest create() {
        return new DataTypeTest();
    }

    public <T> DataTypeTest addRoundTrip(DataType<T> dataType, T value) {
        this.inputs.add(new Input<T>(dataType, value));
        return this;
    }

    public void execute(QueryRunner prestoExecutor, DataSetup dataSetup) {
        this.execute(prestoExecutor, prestoExecutor.getDefaultSession(), dataSetup);
    }

    public void execute(QueryRunner prestoExecutor, Session session, DataSetup dataSetup) {
        List expectedTypes = this.inputs.stream().map(Input::getPrestoResultType).collect(Collectors.toList());
        List expectedResults = this.inputs.stream().map(Input::toPrestoQueryResult).collect(Collectors.toList());
        try (TestTable testTable = dataSetup.setupTestTable(Collections.unmodifiableList(this.inputs));){
            MaterializedResult materializedRows = prestoExecutor.execute(session, "SELECT * from " + testTable.getName());
            Assert.assertEquals((Collection)materializedRows.getTypes(), expectedTypes);
            List actualResults = ((MaterializedRow)Iterables.getOnlyElement((Iterable)materializedRows)).getFields();
            Assert.assertEquals((int)actualResults.size(), (int)expectedResults.size(), (String)"lists don't have the same size");
            for (int i = 0; i < expectedResults.size(); ++i) {
                Assert.assertEquals(actualResults.get(i), expectedResults.get(i), (String)("Element " + i));
            }
        }
    }

    public static class Input<T> {
        private final DataType<T> dataType;
        private final T value;

        public Input(DataType<T> dataType, T value) {
            this.dataType = dataType;
            this.value = value;
        }

        String getInsertType() {
            return this.dataType.getInsertType();
        }

        Type getPrestoResultType() {
            return this.dataType.getPrestoResultType();
        }

        Object toPrestoQueryResult() {
            return this.dataType.toPrestoQueryResult(this.value);
        }

        String toLiteral() {
            return this.dataType.toLiteral(this.value);
        }
    }
}

