/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.datatype;

import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.function.Function;

public class DataType<T> {
    private final String insertType;
    private final Type prestoResultType;
    private final Function<T, String> toLiteral;
    private final Function<T, ?> toPrestoQueryResult;

    public static DataType<Boolean> booleanDataType() {
        return DataType.dataType("boolean", (Type)BooleanType.BOOLEAN);
    }

    public static DataType<Long> bigintDataType() {
        return DataType.dataType("bigint", (Type)BigintType.BIGINT);
    }

    public static DataType<Integer> integerDataType() {
        return DataType.dataType("integer", (Type)IntegerType.INTEGER);
    }

    public static DataType<Short> smallintDataType() {
        return DataType.dataType("smallint", (Type)SmallintType.SMALLINT);
    }

    public static DataType<Byte> tinyintDataType() {
        return DataType.dataType("tinyint", (Type)TinyintType.TINYINT);
    }

    public static DataType<Double> doubleDataType() {
        return DataType.dataType("double", (Type)DoubleType.DOUBLE);
    }

    public static DataType<Float> realDataType() {
        return DataType.dataType("real", (Type)RealType.REAL);
    }

    public static DataType<String> varcharDataType(int size) {
        return DataType.varcharDataType(size, "");
    }

    public static DataType<String> varcharDataType(int size, String properties) {
        return DataType.varcharDataType(Optional.of(size), properties);
    }

    public static DataType<String> varcharDataType() {
        return DataType.varcharDataType(Optional.empty(), "");
    }

    private static DataType<String> varcharDataType(Optional<Integer> length, String properties) {
        String prefix = length.map(size -> "varchar(" + size + ")").orElse("varchar");
        String suffix = properties.isEmpty() ? "" : " " + properties;
        VarcharType varcharType = length.map(VarcharType::createVarcharType).orElse(VarcharType.createUnboundedVarcharType());
        return DataType.stringDataType(prefix + suffix, (Type)varcharType);
    }

    public static DataType<String> stringDataType(String insertType, Type prestoResultType) {
        return DataType.dataType(insertType, prestoResultType, DataType::quote, Function.identity());
    }

    public static DataType<String> charDataType(int length) {
        return DataType.charDataType(length, "");
    }

    public static DataType<String> charDataType(int length, String properties) {
        String suffix = properties.isEmpty() ? "" : " " + properties;
        return DataType.charDataType("char(" + length + ")" + suffix, length);
    }

    public static DataType<String> charDataType(String insertType, int length) {
        return DataType.dataType(insertType, (Type)CharType.createCharType((long)length), DataType::quote, input -> Strings.padEnd((String)input, (int)length, (char)' '));
    }

    public static DataType<byte[]> varbinaryDataType() {
        return DataType.dataType("varbinary", (Type)VarbinaryType.VARBINARY, DataType::binaryLiteral, Function.identity());
    }

    public static DataType<BigDecimal> decimalDataType(int precision, int scale) {
        String databaseType = String.format("decimal(%s, %s)", precision, scale);
        return DataType.dataType(databaseType, (Type)DecimalType.createDecimalType((int)precision, (int)scale), bigDecimal -> String.format("CAST('%s' AS %s)", bigDecimal, databaseType), bigDecimal -> bigDecimal.setScale(scale, RoundingMode.UNNECESSARY));
    }

    public static DataType<LocalDate> dateDataType() {
        return DataType.dataType("DATE", (Type)DateType.DATE, DateTimeFormatter.ofPattern("'DATE '''yyyy-MM-dd''")::format, Function.identity());
    }

    private static String quote(String value) {
        return "'" + value + "'";
    }

    public static String binaryLiteral(byte[] value) {
        return "X'" + BaseEncoding.base16().encode(value) + "'";
    }

    private static <T> DataType<T> dataType(String insertType, Type prestoResultType) {
        return new DataType<Object>(insertType, prestoResultType, Object::toString, Function.identity());
    }

    public static <T> DataType<T> dataType(String insertType, Type prestoResultType, Function<T, String> toLiteral, Function<T, ?> toPrestoQueryResult) {
        return new DataType<T>(insertType, prestoResultType, toLiteral, toPrestoQueryResult);
    }

    private DataType(String insertType, Type prestoResultType, Function<T, String> toLiteral, Function<T, ?> toPrestoQueryResult) {
        this.insertType = insertType;
        this.prestoResultType = prestoResultType;
        this.toLiteral = toLiteral;
        this.toPrestoQueryResult = toPrestoQueryResult;
    }

    public String toLiteral(T inputValue) {
        if (inputValue == null) {
            return "NULL";
        }
        return this.toLiteral.apply(inputValue);
    }

    public Object toPrestoQueryResult(T inputValue) {
        return this.toPrestoQueryResult.apply(inputValue);
    }

    public String getInsertType() {
        return this.insertType;
    }

    public Type getPrestoResultType() {
        return this.prestoResultType;
    }
}

