/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostCalculatorUsingExchanges;
import com.facebook.presto.cost.CostCalculatorWithEstimatedExchanges;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.TaskCountEstimator;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ParsingUtil;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.PlanOptimizers;
import com.facebook.presto.sql.planner.assertions.PlanAssert;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.facebook.presto.tests.H2QueryRunner;
import com.facebook.presto.tests.QueryAssertions;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;
import javax.management.MBeanServer;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.testing.TestingMBeanServer;

public abstract class AbstractTestQueryFramework {
    private QueryRunnerSupplier queryRunnerSupplier;
    private QueryRunner queryRunner;
    private H2QueryRunner h2QueryRunner;
    private SqlParser sqlParser;

    protected AbstractTestQueryFramework(QueryRunnerSupplier supplier) {
        this.queryRunnerSupplier = Objects.requireNonNull(supplier, "queryRunnerSupplier is null");
    }

    @BeforeClass
    public void init() throws Exception {
        this.queryRunner = this.queryRunnerSupplier.get();
        this.h2QueryRunner = new H2QueryRunner();
        this.sqlParser = new SqlParser();
    }

    @AfterClass(alwaysRun=true)
    public void close() throws Exception {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.queryRunner, this.h2QueryRunner});
        this.queryRunner = null;
        this.h2QueryRunner = null;
        this.sqlParser = null;
        this.queryRunnerSupplier = null;
    }

    protected Session getSession() {
        return this.queryRunner.getDefaultSession();
    }

    public final int getNodeCount() {
        return this.queryRunner.getNodeCount();
    }

    protected MaterializedResult computeActual(@Language(value="SQL") String sql) {
        return this.computeActual(this.getSession(), sql);
    }

    protected MaterializedResult computeActual(Session session, @Language(value="SQL") String sql) {
        return this.queryRunner.execute(session, sql).toTestTypes();
    }

    protected Object computeScalar(@Language(value="SQL") String sql) {
        return this.computeActual(sql).getOnlyValue();
    }

    protected void assertQuery(@Language(value="SQL") String sql) {
        this.assertQuery(this.getSession(), sql);
    }

    protected void assertQuery(Session session, @Language(value="SQL") String sql) {
        QueryAssertions.assertQuery(this.queryRunner, session, sql, this.h2QueryRunner, sql, false, false);
    }

    protected void assertQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        QueryAssertions.assertQuery(this.queryRunner, this.getSession(), actual, this.h2QueryRunner, expected, false, false);
    }

    protected void assertQuery(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        QueryAssertions.assertQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected, false, false);
    }

    protected void assertQuery(Session session, @Language(value="SQL") String sql, Consumer<Plan> planAssertion) {
        Preconditions.checkArgument((boolean)(this.queryRunner instanceof DistributedQueryRunner), (Object)"pattern assertion is only supported for DistributedQueryRunner");
        QueryAssertions.assertQuery(this.queryRunner, session, sql, this.h2QueryRunner, sql, false, false, planAssertion);
    }

    protected void assertQuery(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected, Consumer<Plan> planAssertion) {
        Preconditions.checkArgument((boolean)(this.queryRunner instanceof DistributedQueryRunner), (Object)"pattern assertion is only supported for DistributedQueryRunner");
        QueryAssertions.assertQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected, false, false, planAssertion);
    }

    public void assertQueryOrdered(@Language(value="SQL") String sql) {
        this.assertQueryOrdered(this.getSession(), sql);
    }

    public void assertQueryOrdered(Session session, @Language(value="SQL") String sql) {
        this.assertQueryOrdered(session, sql, sql);
    }

    protected void assertQueryOrdered(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.assertQueryOrdered(this.getSession(), actual, expected);
    }

    protected void assertQueryOrdered(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        QueryAssertions.assertQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected, true, false);
    }

    protected void assertUpdate(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.assertUpdate(this.getSession(), actual, expected);
    }

    protected void assertUpdate(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        QueryAssertions.assertQuery(this.queryRunner, session, actual, this.h2QueryRunner, expected, false, true);
    }

    protected void assertUpdate(@Language(value="SQL") String sql) {
        this.assertUpdate(this.getSession(), sql);
    }

    protected void assertUpdate(Session session, @Language(value="SQL") String sql) {
        QueryAssertions.assertUpdate(this.queryRunner, session, sql, OptionalLong.empty(), Optional.empty());
    }

    protected void assertUpdate(@Language(value="SQL") String sql, long count) {
        this.assertUpdate(this.getSession(), sql, count);
    }

    protected void assertUpdate(Session session, @Language(value="SQL") String sql, long count) {
        QueryAssertions.assertUpdate(this.queryRunner, session, sql, OptionalLong.of(count), Optional.empty());
    }

    protected void assertUpdate(Session session, @Language(value="SQL") String sql, long count, Consumer<Plan> planAssertion) {
        QueryAssertions.assertUpdate(this.queryRunner, session, sql, OptionalLong.of(count), Optional.of(planAssertion));
    }

    protected void assertQuerySucceeds(Session session, @Language(value="SQL") String sql) {
        QueryAssertions.assertQuerySucceeds(this.queryRunner, session, sql);
    }

    protected void assertQueryFailsEventually(@Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp, Duration timeout) {
        QueryAssertions.assertQueryFailsEventually(this.queryRunner, this.getSession(), sql, expectedMessageRegExp, timeout);
    }

    protected void assertQueryFails(@Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp) {
        QueryAssertions.assertQueryFails(this.queryRunner, this.getSession(), sql, expectedMessageRegExp);
    }

    protected void assertQueryFails(Session session, @Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp) {
        QueryAssertions.assertQueryFails(this.queryRunner, session, sql, expectedMessageRegExp);
    }

    protected void assertQueryReturnsEmptyResult(@Language(value="SQL") String sql) {
        QueryAssertions.assertQueryReturnsEmptyResult(this.queryRunner, this.getSession(), sql);
    }

    protected void assertAccessAllowed(@Language(value="SQL") String sql, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) {
        this.assertAccessAllowed(this.getSession(), sql, deniedPrivileges);
    }

    protected void assertAccessAllowed(Session session, @Language(value="SQL") String sql, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) {
        this.executeExclusively(() -> {
            try {
                this.queryRunner.getAccessControl().deny(deniedPrivileges);
                this.queryRunner.execute(session, sql);
            }
            finally {
                this.queryRunner.getAccessControl().reset();
            }
        });
    }

    protected void assertAccessDenied(@Language(value="SQL") String sql, @Language(value="RegExp") String exceptionsMessageRegExp, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) {
        this.assertAccessDenied(this.getSession(), sql, exceptionsMessageRegExp, deniedPrivileges);
    }

    protected void assertAccessDenied(Session session, @Language(value="SQL") String sql, @Language(value="RegExp") String exceptionsMessageRegExp, TestingAccessControlManager.TestingPrivilege ... deniedPrivileges) {
        this.executeExclusively(() -> {
            try {
                this.queryRunner.getAccessControl().deny(deniedPrivileges);
                this.queryRunner.execute(session, sql);
                Assert.fail((String)("Expected " + AccessDeniedException.class.getSimpleName()));
            }
            catch (RuntimeException e) {
                AbstractTestQueryFramework.assertExceptionMessage(sql, e, ".*Access Denied: " + exceptionsMessageRegExp);
            }
            finally {
                this.queryRunner.getAccessControl().reset();
            }
        });
    }

    protected void assertTableColumnNames(String tableName, String ... columnNames) {
        MaterializedResult result = this.computeActual("DESCRIBE " + tableName);
        ImmutableList expected = ImmutableList.copyOf((Object[])columnNames);
        List actual = (List)result.getMaterializedRows().stream().map(row -> (String)row.getField(0)).collect(ImmutableList.toImmutableList());
        Assert.assertEquals((Collection)actual, (Collection)expected);
    }

    private static void assertExceptionMessage(String sql, Exception exception, @Language(value="RegExp") String regex) {
        if (!Strings.nullToEmpty((String)exception.getMessage()).matches(regex)) {
            Assert.fail((String)String.format("Expected exception message '%s' to match '%s' for query: %s", exception.getMessage(), regex, sql), (Throwable)exception);
        }
    }

    protected MaterializedResult computeExpected(@Language(value="SQL") String sql, List<? extends Type> resultTypes) {
        return this.h2QueryRunner.execute(this.getSession(), sql, resultTypes);
    }

    protected void executeExclusively(Runnable executionBlock) {
        this.queryRunner.getExclusiveLock().lock();
        try {
            executionBlock.run();
        }
        finally {
            this.queryRunner.getExclusiveLock().unlock();
        }
    }

    protected String formatSqlText(String sql) {
        return SqlFormatter.formatSql((Node)this.sqlParser.createStatement(sql, ParsingUtil.createParsingOptions((Session)this.queryRunner.getDefaultSession())), Optional.empty());
    }

    public String getExplainPlan(String query, ExplainType.Type planType) {
        QueryExplainer explainer = this.getQueryExplainer();
        return (String)TransactionBuilder.transaction((TransactionManager)this.queryRunner.getTransactionManager(), (AccessControl)this.queryRunner.getAccessControl()).singleStatement().execute(this.queryRunner.getDefaultSession(), session -> explainer.getPlan(session, this.sqlParser.createStatement(query, ParsingUtil.createParsingOptions((Session)session)), planType, Collections.emptyList(), false, WarningCollector.NOOP));
    }

    public String getGraphvizExplainPlan(String query, ExplainType.Type planType) {
        QueryExplainer explainer = this.getQueryExplainer();
        return (String)TransactionBuilder.transaction((TransactionManager)this.queryRunner.getTransactionManager(), (AccessControl)this.queryRunner.getAccessControl()).singleStatement().execute(this.queryRunner.getDefaultSession(), session -> explainer.getGraphvizPlan(session, this.sqlParser.createStatement(query, ParsingUtil.createParsingOptions((Session)session)), planType, Collections.emptyList(), WarningCollector.NOOP));
    }

    protected void assertPlan(@Language(value="SQL") String query, PlanMatchPattern pattern) {
        this.assertPlan(this.queryRunner.getDefaultSession(), query, pattern);
    }

    protected void assertPlan(Session session, @Language(value="SQL") String query, PlanMatchPattern pattern) {
        this.assertPlan(session, query, pattern, plan -> {});
    }

    protected void assertPlan(Session session, @Language(value="SQL") String query, PlanMatchPattern pattern, Consumer<Plan> planValidator) {
        QueryExplainer explainer = this.getQueryExplainer();
        TransactionBuilder.transaction((TransactionManager)this.queryRunner.getTransactionManager(), (AccessControl)this.queryRunner.getAccessControl()).singleStatement().execute(session, transactionSession -> {
            Plan actualPlan = explainer.getLogicalPlan(transactionSession, this.sqlParser.createStatement(query, ParsingUtil.createParsingOptions((Session)transactionSession)), Collections.emptyList(), WarningCollector.NOOP);
            PlanAssert.assertPlan((Session)transactionSession, (Metadata)this.queryRunner.getMetadata(), (StatsCalculator)this.queryRunner.getStatsCalculator(), (Plan)actualPlan, (PlanMatchPattern)pattern);
            planValidator.accept(actualPlan);
            return null;
        });
    }

    private QueryExplainer getQueryExplainer() {
        Metadata metadata = this.queryRunner.getMetadata();
        FeaturesConfig featuresConfig = new FeaturesConfig().setOptimizeHashGeneration(true);
        boolean forceSingleNode = this.queryRunner.getNodeCount() == 1;
        TaskCountEstimator taskCountEstimator = new TaskCountEstimator(() -> ((QueryRunner)this.queryRunner).getNodeCount());
        CostCalculatorUsingExchanges costCalculator = new CostCalculatorUsingExchanges(taskCountEstimator);
        List optimizers = new PlanOptimizers(metadata, this.sqlParser, featuresConfig, forceSingleNode, new MBeanExporter((MBeanServer)new TestingMBeanServer()), this.queryRunner.getSplitManager(), this.queryRunner.getPlanOptimizerManager(), this.queryRunner.getPageSourceManager(), this.queryRunner.getStatsCalculator(), (CostCalculator)costCalculator, (CostCalculator)new CostCalculatorWithEstimatedExchanges((CostCalculator)costCalculator, taskCountEstimator), new CostComparator(featuresConfig), taskCountEstimator).get();
        return new QueryExplainer(optimizers, new PlanFragmenter(metadata, this.queryRunner.getNodePartitioningManager(), new QueryManagerConfig(), this.sqlParser), metadata, (AccessControl)this.queryRunner.getAccessControl(), this.sqlParser, this.queryRunner.getStatsCalculator(), (CostCalculator)costCalculator, (Map)ImmutableMap.of());
    }

    protected static void skipTestUnless(boolean requirement) {
        if (!requirement) {
            throw new SkipException("requirement not met");
        }
    }

    protected QueryRunner getQueryRunner() {
        Preconditions.checkState((this.queryRunner != null ? 1 : 0) != 0, (Object)"queryRunner not set");
        return this.queryRunner;
    }

    public static interface QueryRunnerSupplier {
        public QueryRunner get() throws Exception;
    }
}

