/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public final class StructuralTestUtil {
    private static final TypeManager TYPE_MANAGER = new TypeRegistry();

    private StructuralTestUtil() {
    }

    public static boolean arrayBlocksEqual(Type elementType, Block block1, Block block2) {
        if (block1.getPositionCount() != block2.getPositionCount()) {
            return false;
        }
        for (int i = 0; i < block1.getPositionCount(); ++i) {
            if (block1.isNull(i) != block2.isNull(i)) {
                return false;
            }
            if (block1.isNull(i) || elementType.equalTo(block1, i, block2, i)) continue;
            return false;
        }
        return true;
    }

    public static boolean mapBlocksEqual(Type keyType, Type valueType, Block block1, Block block2) {
        if (block1.getPositionCount() != block2.getPositionCount()) {
            return false;
        }
        for (int i = 0; i < block1.getPositionCount(); i += 2) {
            if (block1.isNull(i) != block2.isNull(i) || block1.isNull(i + 1) != block2.isNull(i + 1)) {
                return false;
            }
            if (!block1.isNull(i) && !keyType.equalTo(block1, i, block2, i)) {
                return false;
            }
            if (block1.isNull(i + 1) || valueType.equalTo(block1, i + 1, block2, i + 1)) continue;
            return false;
        }
        return true;
    }

    public static Block arrayBlockOf(Type elementType, Object ... values) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(new BlockBuilderStatus(), 1024);
        for (Object value : values) {
            com.facebook.presto.util.StructuralTestUtil.appendToBlockBuilder((Type)elementType, (Object)value, (BlockBuilder)blockBuilder);
        }
        return blockBuilder.build();
    }

    public static Block mapBlockOf(Type keyType, Type valueType, Object key, Object value) {
        MapType mapType = StructuralTestUtil.mapType(keyType, valueType);
        BlockBuilder blockBuilder = mapType.createBlockBuilder(new BlockBuilderStatus(), 10);
        BlockBuilder singleMapBlockWriter = blockBuilder.beginBlockEntry();
        com.facebook.presto.util.StructuralTestUtil.appendToBlockBuilder((Type)keyType, (Object)key, (BlockBuilder)singleMapBlockWriter);
        com.facebook.presto.util.StructuralTestUtil.appendToBlockBuilder((Type)valueType, (Object)value, (BlockBuilder)singleMapBlockWriter);
        blockBuilder.closeEntry();
        return mapType.getObject((Block)blockBuilder, 0);
    }

    public static Block mapBlockOf(Type keyType, Type valueType, Object[] keys, Object[] values) {
        Preconditions.checkArgument((keys.length == values.length ? 1 : 0) != 0, (Object)"keys/values must have the same length");
        MapType mapType = StructuralTestUtil.mapType(keyType, valueType);
        BlockBuilder blockBuilder = mapType.createBlockBuilder(new BlockBuilderStatus(), 10);
        BlockBuilder singleMapBlockWriter = blockBuilder.beginBlockEntry();
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            Object value = values[i];
            com.facebook.presto.util.StructuralTestUtil.appendToBlockBuilder((Type)keyType, (Object)key, (BlockBuilder)singleMapBlockWriter);
            com.facebook.presto.util.StructuralTestUtil.appendToBlockBuilder((Type)valueType, (Object)value, (BlockBuilder)singleMapBlockWriter);
        }
        blockBuilder.closeEntry();
        return mapType.getObject((Block)blockBuilder, 0);
    }

    public static Block rowBlockOf(List<Type> parameterTypes, Object ... values) {
        InterleavedBlockBuilder blockBuilder = new InterleavedBlockBuilder(parameterTypes, new BlockBuilderStatus(), 1024);
        for (int i = 0; i < values.length; ++i) {
            com.facebook.presto.util.StructuralTestUtil.appendToBlockBuilder((Type)parameterTypes.get(i), (Object)values[i], (BlockBuilder)blockBuilder);
        }
        return blockBuilder.build();
    }

    public static Block decimalArrayBlockOf(DecimalType type, BigDecimal decimal) {
        if (type.isShort()) {
            long longDecimal = decimal.unscaledValue().longValue();
            return StructuralTestUtil.arrayBlockOf((Type)type, longDecimal);
        }
        Slice sliceDecimal = Decimals.encodeUnscaledValue((BigInteger)decimal.unscaledValue());
        return StructuralTestUtil.arrayBlockOf((Type)type, sliceDecimal);
    }

    public static Block decimalMapBlockOf(DecimalType type, BigDecimal decimal) {
        if (type.isShort()) {
            long longDecimal = decimal.unscaledValue().longValue();
            return StructuralTestUtil.mapBlockOf((Type)type, (Type)type, longDecimal, longDecimal);
        }
        Slice sliceDecimal = Decimals.encodeUnscaledValue((BigInteger)decimal.unscaledValue());
        return StructuralTestUtil.mapBlockOf((Type)type, (Type)type, sliceDecimal, sliceDecimal);
    }

    public static MapType mapType(Type keyType, Type valueType) {
        return (MapType)TYPE_MANAGER.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
    }

    static {
        new FunctionRegistry(TYPE_MANAGER, (BlockEncodingSerde)new BlockEncodingManager(TYPE_MANAGER, new BlockEncodingFactory[0]), new FeaturesConfig());
    }
}

