/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.tpch;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorIndex;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorIndexProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.MappedRecordSet;
import com.facebook.presto.tests.tpch.AppendingRecordSet;
import com.facebook.presto.tests.tpch.TpchConnectorIndex;
import com.facebook.presto.tests.tpch.TpchIndexHandle;
import com.facebook.presto.tests.tpch.TpchIndexedData;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class TpchIndexProvider
implements ConnectorIndexProvider {
    private final TpchIndexedData indexedData;

    public TpchIndexProvider(TpchIndexedData indexedData) {
        this.indexedData = Objects.requireNonNull(indexedData, "indexedData is null");
    }

    public ConnectorIndex getIndex(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorIndexHandle indexHandle, List<ColumnHandle> lookupSchema, List<ColumnHandle> outputSchema) {
        TpchIndexHandle tpchIndexHandle = (TpchIndexHandle)indexHandle;
        Map fixedValues = (Map)TupleDomain.extractFixedValues(tpchIndexHandle.getFixedValues()).get();
        Preconditions.checkArgument((boolean)lookupSchema.stream().noneMatch(handle -> fixedValues.keySet().contains(handle)), (Object)"Lookup columnHandles are not expected to overlap with the fixed value predicates");
        ImmutableList fixedValueColumns = ImmutableList.copyOf(fixedValues.keySet());
        ArrayList<Object> rawFixedValues = new ArrayList<Object>(fixedValueColumns.size());
        ArrayList<Type> rawFixedTypes = new ArrayList<Type>(fixedValueColumns.size());
        for (ColumnHandle fixedValueColumn : fixedValueColumns) {
            rawFixedValues.add(((NullableValue)fixedValues.get(fixedValueColumn)).getValue());
            rawFixedTypes.add(((TpchColumnHandle)fixedValueColumn).getType());
        }
        ImmutableList finalLookupSchema = ImmutableList.builder().addAll(lookupSchema).addAll((Iterable)fixedValueColumns).build();
        Optional<TpchIndexedData.IndexedTable> indexedTable = this.indexedData.getIndexedTable(tpchIndexHandle.getTableName(), tpchIndexHandle.getScaleFactor(), tpchIndexHandle.getIndexColumnNames());
        Preconditions.checkState((boolean)indexedTable.isPresent());
        TpchIndexedData.IndexedTable table = indexedTable.get();
        List<Integer> keyRemap = TpchIndexProvider.computeRemap(TpchIndexProvider.handleToNames((List<ColumnHandle>)finalLookupSchema), table.getKeyColumns());
        Function keyFormatter = key -> new MappedRecordSet((RecordSet)new AppendingRecordSet((RecordSet)key, (List<Object>)rawFixedValues, (List<Type>)rawFixedTypes), keyRemap);
        List<Integer> outputRemap = TpchIndexProvider.computeRemap(table.getOutputColumns(), TpchIndexProvider.handleToNames(outputSchema));
        Function outputFormatter = output -> new MappedRecordSet(output, outputRemap);
        return new TpchConnectorIndex((Function<RecordSet, RecordSet>)keyFormatter, (Function<RecordSet, RecordSet>)outputFormatter, table);
    }

    private static List<Integer> computeRemap(List<String> startSchema, List<String> endSchema) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String columnName : endSchema) {
            int index = startSchema.indexOf(columnName);
            Preconditions.checkArgument((index != -1 ? 1 : 0) != 0, (String)"Column name in end that is not in the start: %s", (Object)columnName);
            builder.add((Object)index);
        }
        return builder.build();
    }

    static List<String> handleToNames(List<ColumnHandle> columnHandles) {
        return columnHandles.stream().map(TpchColumnHandle.class::cast).map(TpchColumnHandle::getColumnName).collect(Collectors.toList());
    }
}

