/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.tpch;

import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.tests.tpch.MaterializedTuple;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

class MaterializedTupleRecordSet
implements RecordSet {
    private final Iterable<MaterializedTuple> tuples;
    private final List<Type> types;

    public MaterializedTupleRecordSet(Iterable<MaterializedTuple> tuples, List<Type> types) {
        this.tuples = Objects.requireNonNull(tuples, "tuples is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
    }

    public List<Type> getColumnTypes() {
        return this.types;
    }

    public RecordCursor cursor() {
        return new MaterializedTupleRecordCursor(this.tuples.iterator(), this.types);
    }

    private static class MaterializedTupleRecordCursor
    implements RecordCursor {
        private final Iterator<MaterializedTuple> iterator;
        private final List<Type> types;
        private MaterializedTuple outputTuple;

        private MaterializedTupleRecordCursor(Iterator<MaterializedTuple> iterator, List<Type> types) {
            this.iterator = Objects.requireNonNull(iterator, "iterator is null");
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        }

        public long getTotalBytes() {
            return 0L;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            return this.types.get(field);
        }

        public boolean advanceNextPosition() {
            if (!this.iterator.hasNext()) {
                return false;
            }
            this.outputTuple = this.iterator.next();
            return true;
        }

        public boolean getBoolean(int field) {
            return (Boolean)this.outputTuple.getValues().get(field);
        }

        public long getLong(int field) {
            return (Long)this.outputTuple.getValues().get(field);
        }

        public double getDouble(int field) {
            return (Double)this.outputTuple.getValues().get(field);
        }

        public Slice getSlice(int field) {
            return Slices.utf8Slice((String)((String)this.outputTuple.getValues().get(field)));
        }

        public Object getObject(int field) {
            throw new UnsupportedOperationException();
        }

        public boolean isNull(int field) {
            return this.outputTuple.getValues().get(field) == null;
        }

        public void close() {
        }
    }
}

