/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.QueryAssertions;
import com.google.common.collect.ImmutableList;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestIntegrationSmokeTest
extends AbstractTestQueryFramework {
    protected AbstractTestIntegrationSmokeTest(QueryRunner queryRunner) {
        super(queryRunner);
    }

    @Test
    public void testAggregateSingleColumn() throws Exception {
        this.assertQuery("SELECT SUM(orderkey) FROM ORDERS");
        this.assertQuery("SELECT SUM(totalprice) FROM ORDERS");
        this.assertQuery("SELECT MAX(comment) FROM ORDERS");
    }

    @Test
    public void testColumnsInReverseOrder() throws Exception {
        this.assertQuery("SELECT shippriority, clerk, totalprice FROM ORDERS");
    }

    @Test
    public void testCountAll() throws Exception {
        this.assertQuery("SELECT COUNT(*) FROM ORDERS");
    }

    @Test
    public void testExactPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey = 10");
    }

    @Test
    public void testInListPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey IN (10, 11, 20, 21)");
    }

    @Test
    public void testIsNullPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey = 10 OR orderkey IS NULL");
    }

    @Test
    public void testMultipleRangesPredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey BETWEEN 10 AND 50 or orderkey BETWEEN 100 AND 150");
    }

    @Test
    public void testRangePredicate() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testSelectAll() throws Exception {
        this.assertQuery("SELECT * FROM ORDERS");
    }

    @Test
    public void testShowSchemas() throws Exception {
        MaterializedResult actualSchemas = this.computeActual("SHOW SCHEMAS").toJdbcTypes();
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((Session)this.queryRunner.getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR}).row(new Object[]{"tpch"});
        QueryAssertions.assertContains(actualSchemas, resultBuilder.build());
    }

    @Test
    public void testShowTables() throws Exception {
        MaterializedResult actualTables = this.computeActual("SHOW TABLES").toJdbcTypes();
        MaterializedResult expectedTables = MaterializedResult.resultBuilder((Session)this.queryRunner.getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR}).row(new Object[]{"orders"}).build();
        QueryAssertions.assertContains(actualTables, expectedTables);
    }

    @Test
    public void testDescribeTable() throws Exception {
        MaterializedResult actualColumns = this.computeActual("DESC ORDERS").toJdbcTypes();
        ImmutableList expectedColumnsPossibilities = ImmutableList.of((Object)this.getExpectedTableDescription(true, true), (Object)this.getExpectedTableDescription(true, false), (Object)this.getExpectedTableDescription(false, true), (Object)this.getExpectedTableDescription(false, false));
        Assert.assertTrue((boolean)expectedColumnsPossibilities.contains(actualColumns), (String)String.format("%s not in %s", actualColumns, expectedColumnsPossibilities));
    }

    private MaterializedResult getExpectedTableDescription(boolean dateSupported, boolean parametrizedVarchar) {
        String orderDateType = dateSupported ? "date" : "varchar";
        if (parametrizedVarchar) {
            return MaterializedResult.resultBuilder((Session)this.queryRunner.getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", ""}).row(new Object[]{"custkey", "bigint", ""}).row(new Object[]{"orderstatus", "varchar", ""}).row(new Object[]{"totalprice", "double", ""}).row(new Object[]{"orderdate", orderDateType, ""}).row(new Object[]{"orderpriority", "varchar", ""}).row(new Object[]{"clerk", "varchar", ""}).row(new Object[]{"shippriority", "integer", ""}).row(new Object[]{"comment", "varchar", ""}).build();
        }
        return MaterializedResult.resultBuilder((Session)this.queryRunner.getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", ""}).row(new Object[]{"custkey", "bigint", ""}).row(new Object[]{"orderstatus", "varchar(1)", ""}).row(new Object[]{"totalprice", "double", ""}).row(new Object[]{"orderdate", orderDateType, ""}).row(new Object[]{"orderpriority", "varchar(15)", ""}).row(new Object[]{"clerk", "varchar(15)", ""}).row(new Object[]{"shippriority", "integer", ""}).row(new Object[]{"comment", "varchar(79)", ""}).build();
    }
}

