/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.datatype;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.datatype.DataSetup;
import com.facebook.presto.tests.datatype.DataType;
import com.facebook.presto.tests.sql.TestTable;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.testng.AssertJUnit;

public class DataTypeTest {
    private List<Input<?>> inputs = new ArrayList();

    private DataTypeTest() {
    }

    public static DataTypeTest create() {
        return new DataTypeTest();
    }

    public <T> DataTypeTest addRoundTrip(DataType<T> dataType, T value) {
        this.inputs.add(new Input<T>(dataType, value));
        return this;
    }

    public void execute(QueryRunner prestoExecutor, DataSetup dataSetup) {
        List expectedTypes = this.inputs.stream().map(Input::getPrestoResultType).collect(Collectors.toList());
        List expectedResults = this.inputs.stream().map(Input::toPrestoQueryResult).collect(Collectors.toList());
        try (TestTable testTable = dataSetup.setupTestTable(Collections.unmodifiableList(this.inputs));){
            MaterializedResult materializedRows = prestoExecutor.execute("SELECT * from " + testTable.getName());
            AssertJUnit.assertEquals(expectedTypes, (Object)materializedRows.getTypes());
            MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)materializedRows);
            AssertJUnit.assertEquals(expectedResults, (Object)row.getFields());
        }
    }

    public static class Input<T> {
        private final DataType<T> dataType;
        private final T value;

        public Input(DataType<T> dataType, T value) {
            this.dataType = dataType;
            this.value = value;
        }

        String getInsertType() {
            return this.dataType.getInsertType();
        }

        Type getPrestoResultType() {
            return this.dataType.getPrestoResultType();
        }

        Object toPrestoQueryResult() {
            return this.dataType.toPrestoQueryResult(this.value);
        }

        String toLiteral() {
            return this.dataType.toLiteral(this.value);
        }
    }
}

