/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.tpch.TpchIndexSpec;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestIndexedQueries
extends AbstractTestQueryFramework {
    public static final TpchIndexSpec INDEX_SPEC = new TpchIndexSpec.Builder().addIndex("orders", 0.01, (Set<String>)ImmutableSet.of((Object)"orderkey")).addIndex("orders", 0.01, (Set<String>)ImmutableSet.of((Object)"orderkey", (Object)"orderstatus")).addIndex("orders", 0.01, (Set<String>)ImmutableSet.of((Object)"orderkey", (Object)"custkey")).addIndex("orders", 0.01, (Set<String>)ImmutableSet.of((Object)"orderstatus", (Object)"shippriority")).build();

    protected AbstractTestIndexedQueries(QueryRunner queryRunner) {
        super(queryRunner);
    }

    @Test
    public void testExampleSystemTable() throws Exception {
        this.assertQuery("SELECT name FROM sys.example", "SELECT 'test' AS name");
        MaterializedResult result = this.computeActual("SHOW SCHEMAS");
        Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of((Object)"sf100", (Object)"tiny", (Object)"sys")));
        result = this.computeActual("SHOW TABLES FROM sys");
        Assert.assertEquals((Set)result.getOnlyColumnAsSet(), (Set)ImmutableSet.of((Object)"example"));
    }

    @Test
    public void testBasicIndexJoin() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testBasicIndexJoinReverseCandidates() throws Exception {
        this.assertQuery("SELECT *\nFROM orders o JOIN (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\n  ON o.orderkey = l.orderkey");
    }

    @Test
    public void testBasicIndexJoinWithNullKeys() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT CASE WHEN suppkey % 2 = 0 THEN orderkey ELSE NULL END AS orderkey\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testMultiKeyIndexJoinAligned() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey, CASE WHEN suppkey % 2 = 0 THEN 'F' ELSE 'O' END AS orderstatus\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey = o.orderkey AND l.orderstatus = o.orderstatus");
    }

    @Test
    public void testMultiKeyIndexJoinUnaligned() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey, CASE WHEN suppkey % 2 = 0 THEN 'F' ELSE 'O' END AS orderstatus\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderstatus = o.orderstatus AND l.orderkey = o.orderkey");
    }

    @Test
    public void testPredicateDerivedKey() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey = o.orderkey\nWHERE o.orderstatus = 'F'");
    }

    @Test
    public void testCompoundPredicateDerivedKey() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey = o.orderkey\nWHERE o.orderstatus = 'F'\n  AND o.custkey % 2 = 0");
    }

    @Test
    public void testChainedIndexJoin() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey, CASE WHEN suppkey % 2 = 0 THEN 'F' ELSE 'O' END AS orderstatus\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o1\n  ON l.orderkey = o1.orderkey AND l.orderstatus = o1.orderstatus\nJOIN orders o2\n  ON o1.custkey % 1024 = o2.orderkey");
    }

    @Test
    public void testBasicLeftIndexJoin() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nLEFT JOIN orders o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testNonIndexLeftJoin() throws Exception {
        this.assertQuery("SELECT *\nFROM orders o LEFT JOIN (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\n  ON o.orderkey = l.orderkey");
    }

    @Test
    public void testBasicRightIndexJoin() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM orders o RIGHT JOIN (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\n  ON o.orderkey = l.orderkey");
    }

    @Test
    public void testNonIndexRightJoin() throws Exception {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nRIGHT JOIN orders o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testIndexJoinThroughAggregation() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN (\n  SELECT orderkey, COUNT(*)\n  FROM orders\n  WHERE custkey % 8 = 0\n  GROUP BY orderkey\n  ORDER BY orderkey) o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testIndexJoinThroughMultiKeyAggregation() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN (\n  SELECT shippriority, orderkey, COUNT(*)\n  FROM orders\n  WHERE custkey % 8 = 0\n  GROUP BY shippriority, orderkey\n  ORDER BY orderkey) o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testNonIndexableKeys() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN (\n  SELECT orderkey % 2 as orderkey\n  FROM orders) o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testComposableIndexJoins() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) x\nJOIN (\n  SELECT o1.orderkey as orderkey, o2.custkey as custkey\n  FROM orders o1\n  JOIN orders o2\n    ON o1.orderkey = o2.orderkey) y\n  ON x.orderkey = y.orderkey\n");
    }

    @Test
    public void testNonComposableIndexJoins() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) x\nJOIN (\n  SELECT l.orderkey as orderkey, o.custkey as custkey\n  FROM lineitem l\n  JOIN orders o\n    ON l.orderkey = o.orderkey) y\n  ON x.orderkey = y.orderkey\n");
    }

    @Test
    public void testOverlappingIndexJoinLookupSymbol() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey % 1024 = o.orderkey AND l.partkey % 1024 = o.orderkey");
    }

    @Test
    public void testOverlappingSourceOuterIndexJoinLookupSymbol() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nLEFT JOIN orders o\n  ON l.orderkey % 1024 = o.orderkey AND l.partkey % 1024 = o.orderkey");
    }

    @Test
    public void testOverlappingIndexJoinProbeSymbol() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey = o.orderkey AND l.orderkey = o.custkey");
    }

    @Test
    public void testOverlappingSourceOuterIndexJoinProbeSymbol() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nLEFT JOIN orders o\n  ON l.orderkey = o.orderkey AND l.orderkey = o.custkey");
    }

    @Test
    public void testRepeatedIndexJoinClause() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN orders o\n  ON l.orderkey = o.orderkey AND l.orderkey = o.orderkey");
    }

    @Test
    public void testProbeNullInReadahead() throws Exception {
        this.assertQuery("select count(*) from (values (1), (cast(null as bigint))) x(orderkey) join orders using (orderkey)", "select count(*) from orders where orderkey = 1");
    }

    @Test
    public void testHighCardinalityIndexJoinResult() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM orders\n  WHERE orderkey % 10000 = 0) o1\nJOIN (\n  SELECT *\n  FROM orders\n  WHERE orderkey % 4 = 0) o2\n  ON o1.orderstatus = o2.orderstatus AND o1.shippriority = o2.shippriority");
    }

    @Test
    public void testReducedIndexProbeKey() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey % 64 AS a, suppkey % 2 AS b\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN (\n  SELECT orderkey AS a, SUM(LENGTH(comment)) % 2 AS b\n  FROM orders\n  GROUP BY orderkey) o\n  ON l.a = o.a AND l.b = o.b");
    }

    @Test
    public void testReducedIndexProbeKeyNegativeCaching() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey % 64 AS a, (suppkey % 2) + 1 AS b\n  FROM lineitem\n  WHERE partkey % 8 = 0) l\nJOIN (\n  SELECT orderkey AS a, SUM(LENGTH(comment)) % 2 AS b\n  FROM orders\n  GROUP BY orderkey) o\n  ON l.a = o.a AND l.b = o.b");
    }

    @Test
    public void testHighCardinalityReducedIndexProbeKey() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *, custkey % 4 AS x, custkey % 2 AS y\n  FROM orders\n  WHERE orderkey % 10000 = 0) o1\nJOIN (\n  SELECT *, custkey % 5 AS x, custkey % 3 AS y\n  FROM orders\n  WHERE orderkey % 4 = 0) o2\n  ON o1.orderstatus = o2.orderstatus AND o1.shippriority = o2.shippriority AND o1.x = o2.x AND o1.y = o2.y");
    }

    @Test
    public void testReducedIndexProbeKeyComplexQueryShapes() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey % 64 AS a, suppkey % 2 AS b, orderkey AS c, linenumber % 2 AS d\n  FROM lineitem\n  WHERE partkey % 7 = 0) l\nJOIN (\n  SELECT t1.a AS a, t1.b AS b, t2.orderkey AS c, SUM(LENGTH(t2.comment)) % 2 AS d\n  FROM (\n    SELECT orderkey AS a, custkey % 3 AS b\n    FROM orders\n  ) t1\n  JOIN orders t2 ON t1.a = (t2.orderkey % 1000)\n  WHERE t1.a % 1000 = 0\n  GROUP BY t1.a, t1.b, t2.orderkey) o\n  ON l.a = o.a AND l.b = o.b AND l.c = o.c AND l.d = o.d");
    }

    @Test
    public void testIndexJoinConstantPropagation() throws Exception {
        this.assertQuery("SELECT x, y, COUNT(*)\nFROM (SELECT orderkey, 0 AS x FROM orders) a \nJOIN (SELECT orderkey, 1 AS y FROM orders) b \nON a.orderkey = b.orderkey\nGROUP BY 1, 2");
    }

    @Test
    public void testIndexJoinThroughWindow() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 16 = 0) l\nJOIN (\n  SELECT *, COUNT(*) OVER (PARTITION BY orderkey)\n  FROM orders) o\n  ON l.orderkey = o.orderkey", "SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 16 = 0) l\nJOIN (\n  SELECT *, 1\n  FROM orders) o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testIndexJoinThroughWindowDoubleAggregation() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 16 = 0) l\nJOIN (\n  SELECT *, COUNT(*) OVER (PARTITION BY orderkey), SUM(orderkey) OVER (PARTITION BY orderkey)\n  FROM orders) o\n  ON l.orderkey = o.orderkey", "SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 16 = 0) l\nJOIN (\n  SELECT *, 1, orderkey as o\n  FROM orders) o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testIndexJoinThroughWindowPartialPartition() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 16 = 0) l\nJOIN (\n  SELECT *, COUNT(*) OVER (PARTITION BY orderkey, custkey)\n  FROM orders) o\n  ON l.orderkey = o.orderkey", "SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 16 = 0) l\nJOIN (\n  SELECT *, 1\n  FROM orders) o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testNoIndexJoinThroughWindowWithRowNumberFunction() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 16 = 0) l\nJOIN (\n  SELECT *, row_number() OVER (PARTITION BY orderkey)\n  FROM orders) o\n  ON l.orderkey = o.orderkey", "SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 16 = 0) l\nJOIN (\n  SELECT *, 1\n  FROM orders) o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testNoIndexJoinThroughWindowWithOrderBy() throws Exception {
        this.assertQuery("SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 16 = 0) l\nJOIN (\n  SELECT *, COUNT(*) OVER (PARTITION BY orderkey ORDER BY custkey)\n  FROM orders) o\n  ON l.orderkey = o.orderkey", "SELECT *\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 16 = 0) l\nJOIN (\n  SELECT *, 1\n  FROM orders) o\n  ON l.orderkey = o.orderkey");
    }

    @Test
    public void testNoIndexJoinThroughWindowWithRowFrame() throws Exception {
        this.assertQuery("SELECT l.orderkey, o.c\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 16 = 0) l\nJOIN (\n  SELECT *, COUNT(*) OVER (PARTITION BY orderkey ROWS 1 PRECEDING) as c\n  FROM orders) o\n  ON l.orderkey = o.orderkey", "SELECT l.orderkey, o.c\nFROM (\n  SELECT *\n  FROM lineitem\n  WHERE partkey % 16 = 0) l\nJOIN (\n  SELECT *, 1 as c\n  FROM orders) o\n  ON l.orderkey = o.orderkey");
    }
}

