/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestApproximateQueries;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestDistributedQueries
extends AbstractTestApproximateQueries {
    protected AbstractTestDistributedQueries(QueryRunner queryRunner) {
        super(queryRunner);
    }

    protected AbstractTestDistributedQueries(QueryRunner queryRunner, Session sampledSession) {
        super(queryRunner, sampledSession);
    }

    private void assertCreateTable(String table, @Language(value="SQL") String query, @Language(value="SQL") String rowCountQuery) throws Exception {
        this.assertCreateTable(table, query, query, rowCountQuery);
    }

    private void assertCreateTable(String table, @Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) throws Exception {
        this.assertQuery("CREATE TABLE " + table + " AS " + query, rowCountQuery);
        this.assertQuery("SELECT * FROM " + table, expectedQuery);
        this.assertQueryTrue("DROP TABLE " + table);
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), table));
    }

    @Test
    public void testSetSession() throws Exception {
        MaterializedResult result = this.computeActual("SET SESSION foo = 'bar'");
        Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        result = this.computeActual("SET SESSION foo.bar = 'baz'");
        Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"foo.bar", (Object)"baz"));
    }

    @Test
    public void testResetSession() throws Exception {
        MaterializedResult result = this.computeActual(this.getSession(), "RESET SESSION foo");
        Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Set)result.getResetSessionProperties(), (Set)ImmutableSet.of((Object)"foo"));
        result = this.computeActual(this.getSession(), "RESET SESSION connector.cheese");
        Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Set)result.getResetSessionProperties(), (Set)ImmutableSet.of((Object)"connector.cheese"));
    }

    @Test
    public void testCreateTable() throws Exception {
        this.assertQueryTrue("CREATE TABLE test_create (a bigint, b double, c varchar)");
        Assert.assertTrue((boolean)this.queryRunner.tableExists(this.getSession(), "test_create"));
        this.assertTableColumnNames("test_create", "a", "b", "c");
        this.assertQueryTrue("DROP TABLE test_create");
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_create"));
        this.assertQueryTrue("CREATE TABLE test_create_table_if_not_exists (a bigint, b varchar, c double)");
        Assert.assertTrue((boolean)this.queryRunner.tableExists(this.getSession(), "test_create_table_if_not_exists"));
        this.assertTableColumnNames("test_create_table_if_not_exists", "a", "b", "c");
        this.assertQueryTrue("CREATE TABLE IF NOT EXISTS test_create_table_if_not_exists (d bigint, e varchar)");
        Assert.assertTrue((boolean)this.queryRunner.tableExists(this.getSession(), "test_create_table_if_not_exists"));
        this.assertTableColumnNames("test_create_table_if_not_exists", "a", "b", "c");
        this.assertQueryTrue("DROP TABLE test_create_table_if_not_exists");
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_create_table_if_not_exists"));
    }

    @Test
    public void testCreateTableAsSelect() throws Exception {
        this.assertCreateTable("test_select", "SELECT orderdate, orderkey, totalprice FROM orders", "SELECT count(*) FROM orders");
        this.assertCreateTable("test_group", "SELECT orderstatus, sum(totalprice) x FROM orders GROUP BY orderstatus", "SELECT count(DISTINCT orderstatus) FROM orders");
        this.assertCreateTable("test_join", "SELECT count(*) x FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey", "SELECT 1");
        this.assertCreateTable("test_limit", "SELECT orderkey FROM orders ORDER BY orderkey LIMIT 10", "SELECT 10");
        this.assertCreateTable("test_unicode", "SELECT '\u2603' unicode", "SELECT 1");
    }

    @Test
    public void testCreateTableAsSelectSampled() throws Exception {
        this.assertCreateTable("test_sampled", "SELECT orderkey FROM tpch_sampled.tiny.orders ORDER BY orderkey LIMIT 10", "SELECT orderkey FROM orders ORDER BY orderkey LIMIT 10", "SELECT 10");
    }

    @Test
    public void testRenameTable() throws Exception {
        this.assertQueryTrue("CREATE TABLE test_rename AS SELECT 123 x");
        this.assertQueryTrue("ALTER TABLE test_rename RENAME TO test_rename_new");
        this.assertQueryTrue("DROP TABLE test_rename_new");
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_rename"));
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_rename_new"));
    }

    @Test
    public void testRenameColumn() throws Exception {
        this.assertQueryTrue("CREATE TABLE test_rename_column AS SELECT 123 x");
        this.assertQueryTrue("ALTER TABLE test_rename_column RENAME COLUMN x TO y");
        MaterializedResult materializedRows = this.computeActual("SELECT y FROM test_rename_column");
        Assert.assertEquals((Object)((MaterializedRow)Iterables.getOnlyElement((Iterable)materializedRows.getMaterializedRows())).getField(0), (Object)123L);
        this.assertQueryTrue("DROP TABLE test_rename_column");
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_rename_column"));
    }

    @Test
    public void testInsert() throws Exception {
        String query = "SELECT orderdate, orderkey FROM orders";
        this.assertQuery("CREATE TABLE test_insert AS " + query, "SELECT count(*) FROM orders");
        this.assertQuery("SELECT * FROM test_insert", query);
        this.assertQuery("INSERT INTO test_insert " + query, "SELECT count(*) FROM orders");
        this.assertQuery("SELECT * FROM test_insert", query + " UNION ALL " + query);
        this.assertQueryTrue("DROP TABLE test_insert");
    }

    @Test
    public void testDelete() throws Exception {
        this.assertQuery("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertQuery("DELETE FROM test_delete WHERE orderkey % 2 = 0", "SELECT count(*) FROM orders WHERE orderkey % 2 = 0");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE orderkey % 2 <> 0");
        this.assertQuery("DELETE FROM test_delete", "SELECT count(*) FROM orders WHERE orderkey % 2 <> 0");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders LIMIT 0");
        this.assertQueryTrue("DROP TABLE test_delete");
        this.assertQuery("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertQuery("DELETE FROM test_delete WHERE custkey <= 100", "SELECT count(*) FROM orders WHERE custkey <= 100");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE custkey > 100");
        this.assertQuery("DELETE FROM test_delete WHERE custkey <= 300", "SELECT count(*) FROM orders WHERE custkey > 100 AND custkey <= 300");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE custkey > 300");
        this.assertQuery("DELETE FROM test_delete WHERE custkey <= 500", "SELECT count(*) FROM orders WHERE custkey > 300 AND custkey <= 500");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE custkey > 500");
        this.assertQueryTrue("DROP TABLE test_delete");
        this.assertQuery("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertQuery("DELETE FROM test_delete WHERE orderstatus = 'O'", "SELECT count(*) FROM orders WHERE orderstatus = 'O'");
        this.assertQuery("SELECT * FROM test_delete", "SELECT * FROM orders WHERE orderstatus <> 'O'");
        this.assertQueryTrue("DROP TABLE test_delete");
        this.assertQuery("CREATE TABLE test_delete AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertQuery("DELETE FROM test_delete WHERE rand() < 0", "SELECT 0");
        this.assertQueryTrue("DROP TABLE test_delete");
    }

    @Test
    public void testDeleteSemiJoin() throws Exception {
        this.assertQuery("CREATE TABLE test_delete_semi_join AS SELECT * FROM lineitem", "SELECT count(*) FROM lineitem");
        this.assertQuery("DELETE FROM test_delete_semi_join WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')", "SELECT count(*) FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')");
        this.assertQuery("SELECT * FROM test_delete_semi_join", "SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus <> 'F')");
        this.assertQueryTrue("DROP TABLE test_delete_semi_join");
        this.assertQuery("CREATE TABLE test_delete_semi_join AS SELECT * FROM lineitem", "SELECT count(*) FROM lineitem");
        this.assertQuery("DELETE FROM test_delete_semi_join\nWHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')\n  AND orderkey IN (SELECT orderkey FROM orders WHERE custkey % 5 = 0)\n", "SELECT count(*) FROM lineitem\nWHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')\n  AND orderkey IN (SELECT orderkey FROM orders WHERE custkey % 5 = 0)");
        this.assertQuery("SELECT * FROM test_delete_semi_join", "SELECT * FROM lineitem\nWHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus <> 'F')\n  OR orderkey IN (SELECT orderkey FROM orders WHERE custkey % 5 <> 0)");
        this.assertQueryTrue("DROP TABLE test_delete_semi_join");
        this.assertQuery("CREATE TABLE test_delete_semi_join AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertQuery("DELETE FROM test_delete_semi_join\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NULL\n", "SELECT count(*) FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NULL\n");
        this.assertQuery("SELECT * FROM test_delete_semi_join", "SELECT * FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NOT NULL\n");
        this.assertQueryTrue("DROP TABLE test_delete_semi_join");
    }

    @Test
    public void testDropTableIfExists() throws Exception {
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_drop_if_exists"));
        this.assertQueryTrue("DROP TABLE IF EXISTS test_drop_if_exists");
        Assert.assertFalse((boolean)this.queryRunner.tableExists(this.getSession(), "test_drop_if_exists"));
    }

    @Test
    public void testView() throws Exception {
        String query = "SELECT orderkey, orderstatus, totalprice / 2 half FROM orders";
        this.assertQueryTrue("CREATE VIEW test_view AS SELECT 123 x");
        this.assertQueryTrue("CREATE OR REPLACE VIEW test_view AS " + query);
        this.assertQuery("SELECT * FROM test_view", query);
        this.assertQuery("SELECT * FROM test_view a JOIN test_view b on a.orderkey = b.orderkey", String.format("SELECT * FROM (%s) a JOIN (%s) b ON a.orderkey = b.orderkey", query, query));
        this.assertQuery("WITH orders AS (SELECT * FROM orders LIMIT 0) SELECT * FROM test_view", query);
        String name = String.format("%s.%s.test_view", this.getSession().getCatalog(), this.getSession().getSchema());
        this.assertQuery("SELECT * FROM " + name, query);
        this.assertQueryTrue("DROP VIEW test_view");
    }

    @Test
    public void testViewMetadata() throws Exception {
        String query = "SELECT 123 x, 'foo' y";
        this.assertQueryTrue("CREATE VIEW meta_test_view AS " + query);
        MaterializedResult actual = this.computeActual(String.format("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '%s'", this.getSession().getSchema()));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"customer", "BASE TABLE"}).row(new Object[]{"lineitem", "BASE TABLE"}).row(new Object[]{"meta_test_view", "VIEW"}).row(new Object[]{"nation", "BASE TABLE"}).row(new Object[]{"orders", "BASE TABLE"}).row(new Object[]{"part", "BASE TABLE"}).row(new Object[]{"partsupp", "BASE TABLE"}).row(new Object[]{"region", "BASE TABLE"}).row(new Object[]{"supplier", "BASE TABLE"}).build();
        AbstractTestDistributedQueries.assertContains(actual, expected);
        actual = this.computeActual("SHOW TABLES");
        MaterializedResult.Builder builder = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes());
        for (MaterializedRow row : expected.getMaterializedRows()) {
            builder.row(new Object[]{row.getField(0)});
        }
        expected = builder.build();
        AbstractTestDistributedQueries.assertContains(actual, expected);
        actual = this.computeActual(String.format("SELECT table_name, view_definition FROM information_schema.views WHERE table_schema = '%s'", this.getSession().getSchema()));
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"meta_test_view", SqlFormatter.formatSql((Node)new SqlParser().createStatement(query))}).build();
        AbstractTestDistributedQueries.assertContains(actual, expected);
        actual = this.computeActual("SHOW COLUMNS FROM meta_test_view");
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BooleanType.BOOLEAN, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"x", "bigint", true, false, ""}).row(new Object[]{"y", "varchar", true, false, ""}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
        this.assertQueryTrue("DROP VIEW meta_test_view");
    }

    @Test
    public void testLargeQuerySuccess() throws Exception {
        this.assertQuery("SELECT " + Joiner.on((String)" AND ").join(Collections.nCopies(500, "1 = 1")), "SELECT true");
    }

    @Test
    public void testShowSchemasFromOther() throws Exception {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS FROM tpch");
        ImmutableSet schemaNames = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)result.getMaterializedRows(), this.onlyColumnGetter()));
        Assert.assertTrue((boolean)schemaNames.containsAll((Collection)ImmutableSet.of((Object)"information_schema", (Object)"tiny", (Object)"sf1")));
    }

    @Test
    public void testTableSampleSystem() throws Exception {
        int total = this.computeActual("SELECT orderkey FROM orders").getMaterializedRows().size();
        boolean sampleSizeFound = false;
        for (int i = 0; i < 100; ++i) {
            int sampleSize = this.computeActual("SELECT orderkey FROM ORDERS TABLESAMPLE SYSTEM (50)").getMaterializedRows().size();
            if (sampleSize <= 0 || sampleSize >= total) continue;
            sampleSizeFound = true;
            break;
        }
        Assert.assertTrue((boolean)sampleSizeFound, (String)"Table sample returned unexpected number of rows");
    }

    @Test
    public void testTableSampleSystemBoundaryValues() throws Exception {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (0)");
        MaterializedResult all = this.computeActual("SELECT orderkey FROM orders");
        Assert.assertTrue((boolean)all.getMaterializedRows().containsAll(fullSample.getMaterializedRows()));
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
    }

    @Override
    @Test
    public void testTableSamplePoissonizedRescaled() throws Exception {
        MaterializedResult sample = this.computeActual("SELECT * FROM orders TABLESAMPLE POISSONIZED (10) RESCALED");
        MaterializedResult all = this.computeExpected("SELECT * FROM orders", sample.getTypes());
        Assert.assertTrue((!sample.getMaterializedRows().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)all.getMaterializedRows().containsAll(sample.getMaterializedRows()));
    }

    @Test
    public void testSymbolAliasing() throws Exception {
        this.assertQueryTrue("CREATE TABLE test_symbol_aliasing AS SELECT 1 foo_1, 2 foo_2_4");
        this.assertQuery("SELECT foo_1, foo_2_4 FROM test_symbol_aliasing", "SELECT 1, 2");
        this.assertQueryTrue("DROP TABLE test_symbol_aliasing");
    }

    private void assertTableColumnNames(String tableName, String ... columnNames) {
        MaterializedResult result = this.computeActual("DESCRIBE " + tableName);
        ImmutableList expected = ImmutableList.copyOf((Object[])columnNames);
        List actual = (List)result.getMaterializedRows().stream().map(row -> (String)row.getField(0)).collect(ImmutableCollectors.toImmutableList());
        Assert.assertEquals((Collection)actual, (Collection)expected);
    }

    private static void assertContains(MaterializedResult actual, MaterializedResult expected) {
        for (MaterializedRow row : expected.getMaterializedRows()) {
            if (actual.getMaterializedRows().contains(row)) continue;
            Assert.fail((String)String.format("expected row missing: %s%nActual:%n      %s%nExpected:%n      %s", row, actual, expected));
        }
    }
}

