/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.scalar.sql;

import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.SqlInvokedScalarFunction;
import com.facebook.presto.spi.function.SqlParameter;
import com.facebook.presto.spi.function.SqlParameters;
import com.facebook.presto.spi.function.SqlType;

public class StringSqlFunctions {
    private StringSqlFunctions() {
    }

    @SqlInvokedScalarFunction(value="replace_first", deterministic=true, calledOnNullInput=true)
    @Description(value="Replaces the first occurrence of a substring that matches the given pattern with the given replacement.")
    @SqlParameters(value={@SqlParameter(name="str", type="varchar"), @SqlParameter(name="search", type="varchar"), @SqlParameter(name="replace", type="varchar")})
    @SqlType(value="varchar")
    public static String replaceFirst() {
        return "RETURN IF(replace IS NULL, NULL, IF(STRPOS(str, search) = 0, str, SUBSTR(str, 1, STRPOS(str, search) - 1) || replace || SUBSTR(str, STRPOS(str, search) + LENGTH(search))))";
    }

    @SqlInvokedScalarFunction(value="trail", deterministic=true, calledOnNullInput=true)
    @Description(value="Returns the last N characters of the input string.")
    @SqlParameters(value={@SqlParameter(name="str", type="varchar"), @SqlParameter(name="N", type="int")})
    @SqlType(value="varchar")
    public static String trail() {
        return "RETURN REVERSE(SUBSTR(REVERSE(str), 1, N))";
    }
}

