/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.scalar.sql;

import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.SqlInvokedScalarFunction;
import com.facebook.presto.spi.function.SqlParameter;
import com.facebook.presto.spi.function.SqlType;

public class SimpleSamplingPercent {
    private SimpleSamplingPercent() {
    }

    @SqlInvokedScalarFunction(value="key_sampling_percent", deterministic=true, calledOnNullInput=false)
    @Description(value="Returns a value between 0.0 and 1.0 using the hash of the given input string")
    @SqlParameter(name="input", type="varchar")
    @SqlType(value="double")
    public static String keySamplingPercent() {
        return "return (abs(from_ieee754_64(xxhash64(cast(input as varbinary)))) % 100) / 100. ";
    }
}

