/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlock;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.util.Arrays;
import java.util.Objects;

public class VariableWidthBlockBuilder
extends AbstractVariableWidthBlock
implements BlockBuilder {
    private final BlockBuilderStatus blockBuilderStatus;
    private final SliceOutput sliceOutput;
    private int positions;
    private int[] offsets = new int[1024];
    private boolean[] valueIsNull = new boolean[1024];
    private int currentEntrySize;

    public VariableWidthBlockBuilder(BlockBuilderStatus blockBuilderStatus) {
        this(blockBuilderStatus, (int)((double)blockBuilderStatus.getMaxBlockSizeInBytes() * 1.2));
    }

    public VariableWidthBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedSizeInBytes) {
        this.blockBuilderStatus = Objects.requireNonNull(blockBuilderStatus, "blockBuilderStatus is null");
        this.sliceOutput = new DynamicSliceOutput(expectedSizeInBytes);
    }

    @Override
    protected int getPositionOffset(int position) {
        if (position >= this.positions) {
            throw new IllegalArgumentException("position " + position + " must be less than position count " + this.positions);
        }
        return this.offsets[position];
    }

    @Override
    public int getLength(int position) {
        if (position >= this.positions) {
            throw new IllegalArgumentException("position " + position + " must be less than position count " + this.positions);
        }
        return this.offsets[position + 1] - this.offsets[position];
    }

    @Override
    protected Slice getRawSlice(int position) {
        return this.sliceOutput.getUnderlyingSlice();
    }

    @Override
    public int getPositionCount() {
        return this.positions;
    }

    @Override
    public boolean isEmpty() {
        return this.positions == 0;
    }

    @Override
    public boolean isFull() {
        return this.blockBuilderStatus.isFull();
    }

    @Override
    public int getSizeInBytes() {
        long size = (long)this.sliceOutput.getUnderlyingSlice().length() + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((boolean[])this.valueIsNull);
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public BlockBuilder writeByte(int value) {
        this.sliceOutput.writeByte(value);
        ++this.currentEntrySize;
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        this.sliceOutput.writeShort(value);
        this.currentEntrySize += 2;
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        this.sliceOutput.writeInt(value);
        this.currentEntrySize += 4;
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        this.sliceOutput.writeLong(value);
        this.currentEntrySize += 8;
        return this;
    }

    @Override
    public BlockBuilder writeFloat(float value) {
        this.sliceOutput.writeFloat(value);
        this.currentEntrySize += 4;
        return this;
    }

    @Override
    public BlockBuilder writeDouble(double value) {
        this.sliceOutput.writeDouble(value);
        this.currentEntrySize += 8;
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        this.sliceOutput.writeBytes(source, sourceIndex, length);
        this.currentEntrySize += length;
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        this.entryAdded(this.currentEntrySize, false);
        this.currentEntrySize = 0;
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(0, true);
        return this;
    }

    private void entryAdded(int bytesWritten, boolean isNull) {
        if (this.positions + 1 >= this.offsets.length) {
            this.offsets = Arrays.copyOf(this.offsets, this.offsets.length * 2);
            this.valueIsNull = Arrays.copyOf(this.valueIsNull, this.valueIsNull.length * 2);
        }
        this.valueIsNull[this.positions] = isNull;
        ++this.positions;
        this.offsets[this.positions] = this.sliceOutput.size();
        this.blockBuilderStatus.addBytes(5 + bytesWritten);
        if (this.sliceOutput.size() + 5 * this.positions >= this.blockBuilderStatus.getMaxBlockSizeInBytes()) {
            this.blockBuilderStatus.setFull();
        }
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull[position];
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        int[] newOffsets = Arrays.copyOfRange(this.offsets, positionOffset, positionOffset + length + 1);
        boolean[] newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset, positionOffset + length);
        return new VariableWidthBlock(length, this.sliceOutput.slice(), newOffsets, newValueIsNull);
    }

    @Override
    public Block build() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        return new VariableWidthBlock(this.positions, this.sliceOutput.slice(), Arrays.copyOf(this.offsets, this.positions + 1), Arrays.copyOf(this.valueIsNull, this.positions));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VariableWidthBlockBuilder{");
        sb.append("positionCount=").append(this.positions);
        sb.append(", size=").append(this.sliceOutput.size());
        sb.append('}');
        return sb.toString();
    }
}

