/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypeSignature {
    @Test
    public void test() throws Exception {
        TestTypeSignature.assertSignature("bigint", (List<String>)ImmutableList.of());
        TestTypeSignature.assertSignature("boolean", (List<String>)ImmutableList.of());
        TestTypeSignature.assertSignature("varchar", (List<String>)ImmutableList.of());
        TestTypeSignature.assertSignature("array", (List<String>)ImmutableList.of((Object)"bigint"));
        TestTypeSignature.assertSignature("array", (List<String>)ImmutableList.of((Object)"array<bigint>"));
        TestTypeSignature.assertSignature("map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"bigint"));
        TestTypeSignature.assertSignature("map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"array<bigint>"));
        TestTypeSignature.assertSignature("map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"map<bigint,map<varchar,bigint>>"));
        TestTypeSignature.assertSignature("array", (List<String>)ImmutableList.of((Object)"timestamp with time zone"));
        TestTypeSignature.assertSignature("row", (List<String>)ImmutableList.of((Object)"bigint", (Object)"varchar"), (List<Object>)ImmutableList.of((Object)"a", (Object)"b"));
        TestTypeSignature.assertSignature("row", (List<String>)ImmutableList.of((Object)"bigint", (Object)"array<bigint>", (Object)"row<bigint>('a')"), (List<Object>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        TestTypeSignature.assertSignature("row", (List<String>)ImmutableList.of((Object)"varchar(10)", (Object)"row<bigint>('a')"), (List<Object>)ImmutableList.of((Object)"a", (Object)"b"));
        TestTypeSignature.assertSignature("foo", (List<String>)ImmutableList.of(), (List<Object>)ImmutableList.of((Object)"a"));
        TestTypeSignature.assertSignature("varchar", (List<String>)ImmutableList.of(), (List<Object>)ImmutableList.of((Object)10L));
        try {
            TypeSignature.parseTypeSignature((String)"blah<>");
            Assert.fail((String)"Type signatures with zero parameters should fail to parse");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            TypeSignature.parseTypeSignature((String)"blah()");
            Assert.fail((String)"Type signatures with zero literal parameters should fail to parse");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static void assertSignature(String base, List<String> parameters) {
        TestTypeSignature.assertSignature(base, parameters, (List<Object>)ImmutableList.of());
    }

    private static void assertSignature(String base, List<String> parameters, List<Object> literalParameters) {
        List lowerCaseTypeNames = parameters.stream().map(value -> value.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
        String typeName = base.toLowerCase(Locale.ENGLISH);
        if (!parameters.isEmpty()) {
            typeName = typeName + "<" + Joiner.on((String)",").join(lowerCaseTypeNames) + ">";
        }
        if (!literalParameters.isEmpty()) {
            List transform = literalParameters.stream().map(TestTypeSignature::convertParameter).collect(Collectors.toList());
            typeName = typeName + "(" + Joiner.on((String)",").join(transform) + ")";
        }
        TypeSignature signature = TypeSignature.parseTypeSignature((String)typeName);
        Assert.assertEquals((String)signature.getBase(), (String)base);
        Assert.assertEquals((int)signature.getParameters().size(), (int)parameters.size());
        for (int i = 0; i < signature.getParameters().size(); ++i) {
            Assert.assertEquals((String)((TypeSignature)signature.getParameters().get(i)).toString(), (String)parameters.get(i));
        }
        Assert.assertEquals((Collection)signature.getLiteralParameters(), literalParameters);
        Assert.assertEquals((String)typeName, (String)signature.toString());
    }

    private static String convertParameter(Object value) {
        if (value instanceof String) {
            return "'" + value + "'";
        }
        return value.toString();
    }
}

