/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class TypeSignature {
    private final String base;
    private final List<TypeSignature> parameters;
    private final List<Object> literalParameters;

    public TypeSignature(String base, List<TypeSignature> parameters, List<Object> literalParameters) {
        TypeSignature.checkArgument(base != null, "base is null", new Object[0]);
        this.base = base;
        TypeSignature.checkArgument(!base.isEmpty(), "base is empty", new Object[0]);
        TypeSignature.checkArgument(TypeSignature.validateName(base), "Bad characters in base type: %s", base);
        TypeSignature.checkArgument(parameters != null, "parameters is null", new Object[0]);
        TypeSignature.checkArgument(literalParameters != null, "literalParameters is null", new Object[0]);
        for (Object literal : literalParameters) {
            TypeSignature.checkArgument(literal instanceof String || literal instanceof Long, "Unsupported literal type: %s", literal.getClass());
        }
        this.parameters = Collections.unmodifiableList(new ArrayList<TypeSignature>(parameters));
        this.literalParameters = Collections.unmodifiableList(new ArrayList<Object>(literalParameters));
    }

    private static boolean validateName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c != '<' && c != '>' && c != ',') continue;
            return false;
        }
        return true;
    }

    @JsonValue
    public String toString() {
        boolean first;
        StringBuilder typeName = new StringBuilder(this.base);
        if (!this.parameters.isEmpty()) {
            typeName.append("<");
            first = true;
            for (TypeSignature typeSignature : this.parameters) {
                if (!first) {
                    typeName.append(",");
                }
                first = false;
                typeName.append(typeSignature.toString());
            }
            typeName.append(">");
        }
        if (!this.literalParameters.isEmpty()) {
            typeName.append("(");
            first = true;
            for (Object object : this.literalParameters) {
                if (!first) {
                    typeName.append(",");
                }
                first = false;
                if (object instanceof String) {
                    typeName.append("'").append(object).append("'");
                    continue;
                }
                typeName.append(object.toString());
            }
            typeName.append(")");
        }
        return typeName.toString();
    }

    public String getBase() {
        return this.base;
    }

    public List<TypeSignature> getParameters() {
        return this.parameters;
    }

    public List<Object> getLiteralParameters() {
        return this.literalParameters;
    }

    @JsonCreator
    public static TypeSignature parseTypeSignature(String signature) {
        if (!signature.contains("<") && !signature.contains("(")) {
            return new TypeSignature(signature, new ArrayList<TypeSignature>(), new ArrayList<Object>());
        }
        String baseName = null;
        ArrayList<TypeSignature> parameters = new ArrayList<TypeSignature>();
        ArrayList<Object> literalParameters = new ArrayList<Object>();
        int parameterStart = -1;
        int bracketCount = 0;
        boolean inLiteralParameters = false;
        for (int i = 0; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            if (c == '<') {
                if (bracketCount == 0) {
                    TypeSignature.verify(baseName == null, "Expected baseName to be null");
                    TypeSignature.verify(parameterStart == -1, "Expected parameter start to be -1");
                    baseName = signature.substring(0, i);
                    parameterStart = i + 1;
                }
                ++bracketCount;
                continue;
            }
            if (c == '>') {
                TypeSignature.checkArgument(--bracketCount >= 0, "Bad type signature: '%s'", signature);
                if (bracketCount != 0) continue;
                TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
                parameters.add(TypeSignature.parseTypeSignature(signature.substring(parameterStart, i)));
                parameterStart = i + 1;
                if (i != signature.length() - 1) continue;
                return new TypeSignature(baseName, parameters, literalParameters);
            }
            if (c == ',') {
                if (bracketCount == 1 && !inLiteralParameters) {
                    TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
                    parameters.add(TypeSignature.parseTypeSignature(signature.substring(parameterStart, i)));
                    parameterStart = i + 1;
                    continue;
                }
                if (bracketCount != 0 || !inLiteralParameters) continue;
                TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
                literalParameters.add(TypeSignature.parseLiteral(signature.substring(parameterStart, i)));
                parameterStart = i + 1;
                continue;
            }
            if (c == '(') {
                TypeSignature.checkArgument(!inLiteralParameters, "Bad type signature: '%s'", signature);
                inLiteralParameters = true;
                if (bracketCount != 0) continue;
                if (baseName == null) {
                    TypeSignature.verify(parameters.isEmpty(), "Expected no parameters");
                    TypeSignature.verify(parameterStart == -1, "Expected parameter start to be -1");
                    baseName = signature.substring(0, i);
                }
                parameterStart = i + 1;
                continue;
            }
            if (c != ')') continue;
            TypeSignature.checkArgument(inLiteralParameters, "Bad type signature: '%s'", signature);
            inLiteralParameters = false;
            if (bracketCount != 0) continue;
            TypeSignature.checkArgument(i == signature.length() - 1, "Bad type signature: '%s'", signature);
            TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
            literalParameters.add(TypeSignature.parseLiteral(signature.substring(parameterStart, i)));
            return new TypeSignature(baseName, parameters, literalParameters);
        }
        throw new IllegalArgumentException(String.format("Bad type signature: '%s'", signature));
    }

    private static Object parseLiteral(String literal) {
        if (literal.startsWith("'") || literal.endsWith("'")) {
            TypeSignature.checkArgument(literal.startsWith("'") && literal.endsWith("'"), "Bad literal: '%s'", literal);
            return literal.substring(1, literal.length() - 1);
        }
        return Long.parseLong(literal);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSignature other = (TypeSignature)o;
        return Objects.equals(this.base.toLowerCase(Locale.ENGLISH), other.base.toLowerCase(Locale.ENGLISH)) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.literalParameters, other.literalParameters);
    }

    public int hashCode() {
        return Objects.hash(this.base.toLowerCase(Locale.ENGLISH), this.parameters, this.literalParameters);
    }

    private static void checkArgument(boolean argument, String format, Object ... args) {
        if (!argument) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    private static void verify(boolean argument, String message) {
        if (!argument) {
            throw new AssertionError((Object)message);
        }
    }
}

