/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.TimeZoneIndex;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.fasterxml.jackson.annotation.JsonValue;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public final class SqlTime {
    private final long millisUtc;
    private final TimeZoneKey sessionTimeZoneKey;

    public SqlTime(long millisUtc, TimeZoneKey sessionTimeZoneKey) {
        this.millisUtc = millisUtc;
        this.sessionTimeZoneKey = sessionTimeZoneKey;
    }

    public long getMillisUtc() {
        return this.millisUtc;
    }

    public TimeZoneKey getSessionTimeZoneKey() {
        return this.sessionTimeZoneKey;
    }

    public int hashCode() {
        return Objects.hash(this.millisUtc, this.sessionTimeZoneKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlTime other = (SqlTime)obj;
        return Objects.equals(this.millisUtc, other.millisUtc) && Objects.equals(this.sessionTimeZoneKey, other.sessionTimeZoneKey);
    }

    @JsonValue
    public String toString() {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.SSS");
        format.setTimeZone(TimeZoneIndex.getTimeZoneForKey(this.sessionTimeZoneKey));
        return format.format(new Date(this.millisUtc));
    }
}

