/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.EncoderUtil;
import com.facebook.presto.spi.block.VariableWidthBlock;
import com.facebook.presto.spi.type.TypeManager;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class VariableWidthBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<VariableWidthBlockEncoding> FACTORY = new VariableWidthBlockEncodingFactory();
    private static final String NAME = "VARIABLE_WIDTH";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        AbstractVariableWidthBlock variableWidthBlock = (AbstractVariableWidthBlock)block;
        int positionCount = variableWidthBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        int totalLength = 0;
        for (int position = 0; position < positionCount; ++position) {
            int length = variableWidthBlock.getLength(position);
            sliceOutput.appendInt(length);
            totalLength += length;
        }
        EncoderUtil.encodeNullsAsBits(sliceOutput, variableWidthBlock);
        if ((positionCount & 7) > 0) {
            int value = 0;
            int mask = 128;
            for (int position = positionCount & 0xFFFFFFF8; position < positionCount; ++position) {
                value = (byte)(value | (variableWidthBlock.isNull(position) ? mask : 0));
                mask >>>= 1;
            }
            sliceOutput.appendByte(value);
        }
        sliceOutput.appendInt(totalLength).writeBytes(variableWidthBlock.getRawSlice(0), variableWidthBlock.getPositionOffset(0), totalLength);
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        int[] offsets = new int[positionCount + 1];
        int offset = 0;
        for (int position = 0; position < positionCount; ++position) {
            offsets[position + 1] = offset += sliceInput.readInt();
        }
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        int blockSize = sliceInput.readInt();
        Slice slice = sliceInput.readSlice(blockSize);
        return new VariableWidthBlock(positionCount, slice, offsets, valueIsNull);
    }

    public static class VariableWidthBlockEncodingFactory
    implements BlockEncodingFactory<VariableWidthBlockEncoding> {
        @Override
        public String getName() {
            return VariableWidthBlockEncoding.NAME;
        }

        @Override
        public VariableWidthBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            return new VariableWidthBlockEncoding();
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, VariableWidthBlockEncoding blockEncoding) {
        }
    }
}

