/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.SliceArrayBlockEncoding;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import java.util.Arrays;

public class SliceArrayBlock
extends AbstractVariableWidthBlock {
    private final int positionCount;
    private final Slice[] values;
    private final int sizeInBytes;

    public SliceArrayBlock(int positionCount, Slice[] values) {
        this.positionCount = positionCount;
        if (values.length < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        this.sizeInBytes = SliceArrayBlock.getSliceArraySizeInBytes(values);
    }

    Slice[] getValues() {
        return this.values;
    }

    @Override
    protected Slice getRawSlice(int position) {
        return this.values[position];
    }

    @Override
    protected int getPositionOffset(int position) {
        return 0;
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.values[position] == null;
    }

    @Override
    public BlockEncoding getEncoding() {
        return new SliceArrayBlockEncoding();
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getLength(int position) {
        return this.values[position].length();
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        Slice[] newValues = Arrays.copyOfRange(this.values, positionOffset, positionOffset + length);
        return new SliceArrayBlock(length, newValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SliceArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    static int getSliceArraySizeInBytes(Slice[] values) {
        long sizeInBytes = SizeOf.sizeOf((Object[])values);
        for (Slice value : values) {
            if (value == null) continue;
            sizeInBytes += (long)value.length();
        }
        if (sizeInBytes > Integer.MAX_VALUE) {
            sizeInBytes = Integer.MAX_VALUE;
        }
        return (int)sizeInBytes;
    }
}

