/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.SerializableNativeValue;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TupleDomain<T> {
    private final Map<T, Domain> domains;

    private TupleDomain(Map<T, Domain> domains) {
        this.domains = domains == null || TupleDomain.containsNoneDomain(domains) ? null : Collections.unmodifiableMap(TupleDomain.normalizeAndCopy(domains));
    }

    public static <T> TupleDomain<T> withColumnDomains(Map<T, Domain> domains) {
        return new TupleDomain<T>(Objects.requireNonNull(domains, "domains is null"));
    }

    public static <T> TupleDomain<T> none() {
        return new TupleDomain<T>(null);
    }

    public static <T> TupleDomain<T> all() {
        return new TupleDomain(Collections.emptyMap());
    }

    public static <T> TupleDomain<T> withFixedValues(Map<T, Comparable<?>> fixedValues) {
        HashMap<T, Domain> domains = new HashMap<T, Domain>();
        for (Map.Entry<T, Comparable<?>> entry : fixedValues.entrySet()) {
            domains.put(entry.getKey(), Domain.singleValue(entry.getValue()));
        }
        return TupleDomain.withColumnDomains(domains);
    }

    public static <T> TupleDomain<T> withNullableFixedValues(Map<T, SerializableNativeValue> fixedValues) {
        HashMap<T, Domain> domains = new HashMap<T, Domain>();
        for (Map.Entry<T, SerializableNativeValue> entry : fixedValues.entrySet()) {
            if (entry.getValue().getValue() != null) {
                domains.put(entry.getKey(), Domain.singleValue(entry.getValue().getValue()));
                continue;
            }
            domains.put(entry.getKey(), Domain.onlyNull(entry.getValue().getType()));
        }
        return TupleDomain.withColumnDomains(domains);
    }

    @JsonCreator
    public static <T> TupleDomain<T> fromNullableColumnDomains(@JsonProperty(value="nullableColumnDomains") List<ColumnDomain<T>> nullableColumnDomains) {
        if (nullableColumnDomains == null) {
            return TupleDomain.none();
        }
        return TupleDomain.withColumnDomains(TupleDomain.toMap(nullableColumnDomains));
    }

    @JsonProperty
    public List<ColumnDomain<T>> getNullableColumnDomains() {
        return this.domains == null ? null : TupleDomain.toList(this.domains);
    }

    private static <T> Map<T, Domain> toMap(List<ColumnDomain<T>> columnDomains) {
        HashMap<T, Domain> map = new HashMap<T, Domain>();
        for (ColumnDomain<T> columnDomain : columnDomains) {
            if (map.containsKey(columnDomain.getColumnHandle())) {
                throw new IllegalArgumentException("Duplicate column handle!");
            }
            map.put(columnDomain.getColumnHandle(), columnDomain.getDomain());
        }
        return map;
    }

    private static <T> List<ColumnDomain<T>> toList(Map<T, Domain> columnDomains) {
        ArrayList<ColumnDomain<T>> list = new ArrayList<ColumnDomain<T>>();
        for (Map.Entry<T, Domain> entry : columnDomains.entrySet()) {
            list.add(new ColumnDomain<T>(entry.getKey(), entry.getValue()));
        }
        return list;
    }

    private static <T> boolean containsNoneDomain(Map<T, Domain> domains) {
        for (Domain domain : domains.values()) {
            if (!domain.isNone()) continue;
            return true;
        }
        return false;
    }

    private static <T> Map<T, Domain> normalizeAndCopy(Map<T, Domain> domains) {
        HashMap<T, Domain> map = new HashMap<T, Domain>();
        for (Map.Entry<T, Domain> entry : domains.entrySet()) {
            if (entry.getValue().isAll()) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    @JsonIgnore
    public boolean isAll() {
        return this.domains != null && this.domains.isEmpty();
    }

    @JsonIgnore
    public boolean isNone() {
        return this.domains == null;
    }

    @JsonIgnore
    public Map<T, Domain> getDomains() {
        if (this.domains == null) {
            throw new IllegalStateException("Can not get column Domains from a none TupleDomain");
        }
        return this.domains;
    }

    public Map<T, Comparable<?>> extractFixedValues() {
        if (this.isNone()) {
            return Collections.emptyMap();
        }
        HashMap fixedValues = new HashMap();
        for (Map.Entry<T, Domain> entry : this.getDomains().entrySet()) {
            if (!entry.getValue().isSingleValue()) continue;
            fixedValues.put(entry.getKey(), entry.getValue().getSingleValue());
        }
        return fixedValues;
    }

    public Map<T, SerializableNativeValue> extractNullableFixedValues() {
        if (this.isNone()) {
            return Collections.emptyMap();
        }
        HashMap<T, SerializableNativeValue> builder = new HashMap<T, SerializableNativeValue>();
        for (Map.Entry<T, Domain> entry : this.getDomains().entrySet()) {
            if (entry.getValue().isSingleValue()) {
                builder.put(entry.getKey(), new SerializableNativeValue(entry.getValue().getType(), entry.getValue().getSingleValue()));
                continue;
            }
            if (!entry.getValue().isOnlyNull()) continue;
            builder.put(entry.getKey(), new SerializableNativeValue(entry.getValue().getType(), null));
        }
        return builder;
    }

    public TupleDomain<T> intersect(TupleDomain<T> other) {
        if (this.isNone() || other.isNone()) {
            return TupleDomain.none();
        }
        HashMap<T, Domain> intersected = new HashMap<T, Domain>(this.getDomains());
        for (Map.Entry<T, Domain> entry : other.getDomains().entrySet()) {
            Domain intersectionDomain = (Domain)intersected.get(entry.getKey());
            if (intersectionDomain == null) {
                intersected.put(entry.getKey(), entry.getValue());
                continue;
            }
            intersected.put(entry.getKey(), intersectionDomain.intersect(entry.getValue()));
        }
        return TupleDomain.withColumnDomains(intersected);
    }

    @SafeVarargs
    public static <T> TupleDomain<T> columnWiseUnion(TupleDomain<T> first, TupleDomain<T> second, TupleDomain<T> ... rest) {
        ArrayList<TupleDomain<T>> domains = new ArrayList<TupleDomain<T>>();
        domains.add(first);
        domains.add(second);
        domains.addAll(Arrays.asList(rest));
        return TupleDomain.columnWiseUnion(domains);
    }

    public static <T> TupleDomain<T> columnWiseUnion(List<TupleDomain<T>> tupleDomains) {
        TupleDomain<T> domain;
        if (tupleDomains.isEmpty()) {
            throw new IllegalArgumentException("tupleDomains must have at least one element");
        }
        if (tupleDomains.size() == 1) {
            return tupleDomains.get(0);
        }
        HashSet<T> commonColumns = new HashSet<T>();
        boolean found = false;
        Iterator<TupleDomain<T>> domains = tupleDomains.iterator();
        while (domains.hasNext()) {
            domain = domains.next();
            if (domain.isNone()) continue;
            found = true;
            commonColumns.addAll(domain.getDomains().keySet());
            break;
        }
        if (!found) {
            return TupleDomain.none();
        }
        while (domains.hasNext()) {
            domain = domains.next();
            if (domain.isNone()) continue;
            commonColumns.retainAll(domain.getDomains().keySet());
        }
        HashMap<T, ArrayList<Domain>> domainsByColumn = new HashMap<T, ArrayList<Domain>>();
        for (TupleDomain<T> domain2 : tupleDomains) {
            if (domain2.isNone()) continue;
            for (Map.Entry<T, Domain> entry : domain2.getDomains().entrySet()) {
                if (!commonColumns.contains(entry.getKey())) continue;
                ArrayList<Domain> domainForColumn = (ArrayList<Domain>)domainsByColumn.get(entry.getKey());
                if (domainForColumn == null) {
                    domainForColumn = new ArrayList<Domain>();
                    domainsByColumn.put(entry.getKey(), domainForColumn);
                }
                domainForColumn.add(entry.getValue());
            }
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : domainsByColumn.entrySet()) {
            result.put(entry.getKey(), Domain.union((List)entry.getValue()));
        }
        return TupleDomain.withColumnDomains(result);
    }

    public boolean overlaps(TupleDomain<T> other) {
        return !this.intersect(other).isNone();
    }

    public boolean contains(TupleDomain<T> other) {
        return other.isNone() || TupleDomain.columnWiseUnion(this, other, new TupleDomain[0]).equals(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TupleDomain)) {
            return false;
        }
        TupleDomain that = (TupleDomain)o;
        return !(this.domains != null ? !this.domains.equals(that.domains) : that.domains != null);
    }

    public int hashCode() {
        return this.domains != null ? this.domains.hashCode() : 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("TupleDomain:");
        if (this.isAll()) {
            builder.append("ALL");
        } else if (this.isNone()) {
            builder.append("NONE");
        } else {
            builder.append(this.domains);
        }
        return builder.toString();
    }

    public <U> TupleDomain<U> transform(Function<T, U> function) {
        if (this.domains == null) {
            return new TupleDomain<T>(null);
        }
        HashMap<U, Domain> result = new HashMap<U, Domain>(this.domains.size());
        for (Map.Entry<T, Domain> entry : this.domains.entrySet()) {
            U key = function.apply(entry.getKey());
            Domain previous = result.put(key, entry.getValue());
            if (previous == null) continue;
            throw new IllegalArgumentException(String.format("Every argument must have a unique mapping. %s maps to %s and %s", entry.getKey(), entry.getValue(), previous));
        }
        return new TupleDomain(result);
    }

    public static interface Function<F, T> {
        public T apply(F var1);
    }

    public static class ColumnDomain<C> {
        private final C columnHandle;
        private final Domain domain;

        @JsonCreator
        public ColumnDomain(@JsonProperty(value="columnHandle") C columnHandle, @JsonProperty(value="domain") Domain domain) {
            this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
            this.domain = Objects.requireNonNull(domain, "domain is null");
        }

        @JsonProperty
        public C getColumnHandle() {
            return this.columnHandle;
        }

        @JsonProperty
        public Domain getDomain() {
            return this.domain;
        }
    }
}

