/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.SortedRangeSet;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDomain {
    @Test
    public void testNone() throws Exception {
        Domain domain = Domain.none(Long.class);
        Assert.assertTrue((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Iterable)domain.getRanges(), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Object)domain.getType(), Long.class);
        Assert.assertFalse((boolean)domain.includesValue((Comparable)Long.valueOf(Long.MIN_VALUE)));
        Assert.assertFalse((boolean)domain.includesValue((Comparable)Long.valueOf(0L)));
        Assert.assertFalse((boolean)domain.includesValue((Comparable)Long.valueOf(Long.MAX_VALUE)));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.all(Long.class));
    }

    @Test
    public void testAll() throws Exception {
        Domain domain = Domain.all(Long.class);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertTrue((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertEquals((Iterable)domain.getRanges(), (Iterable)SortedRangeSet.all(Long.class));
        Assert.assertEquals((Object)domain.getType(), Long.class);
        Assert.assertTrue((boolean)domain.includesValue((Comparable)Long.valueOf(Long.MIN_VALUE)));
        Assert.assertTrue((boolean)domain.includesValue((Comparable)Long.valueOf(0L)));
        Assert.assertTrue((boolean)domain.includesValue((Comparable)Long.valueOf(Long.MAX_VALUE)));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.none(Long.class));
    }

    @Test
    public void testNullOnly() throws Exception {
        Domain domain = Domain.onlyNull(Long.class);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertEquals((Iterable)domain.getRanges(), (Iterable)SortedRangeSet.none(Long.class));
        Assert.assertEquals((Object)domain.getType(), Long.class);
        Assert.assertFalse((boolean)domain.includesValue((Comparable)Long.valueOf(Long.MIN_VALUE)));
        Assert.assertFalse((boolean)domain.includesValue((Comparable)Long.valueOf(0L)));
        Assert.assertFalse((boolean)domain.includesValue((Comparable)Long.valueOf(Long.MAX_VALUE)));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.notNull(Long.class));
    }

    @Test
    public void testNotNull() throws Exception {
        Domain domain = Domain.notNull(Long.class);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Iterable)domain.getRanges(), (Iterable)SortedRangeSet.all(Long.class));
        Assert.assertEquals((Object)domain.getType(), Long.class);
        Assert.assertTrue((boolean)domain.includesValue((Comparable)Long.valueOf(Long.MIN_VALUE)));
        Assert.assertTrue((boolean)domain.includesValue((Comparable)Long.valueOf(0L)));
        Assert.assertTrue((boolean)domain.includesValue((Comparable)Long.valueOf(Long.MAX_VALUE)));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.onlyNull(Long.class));
    }

    @Test
    public void testSingleValue() throws Exception {
        Domain domain = Domain.singleValue((Comparable)Long.valueOf(0L));
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertTrue((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Iterable)domain.getRanges(), (Iterable)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[0]));
        Assert.assertEquals((Object)domain.getType(), Long.class);
        Assert.assertFalse((boolean)domain.includesValue((Comparable)Long.valueOf(Long.MIN_VALUE)));
        Assert.assertTrue((boolean)domain.includesValue((Comparable)Long.valueOf(0L)));
        Assert.assertFalse((boolean)domain.includesValue((Comparable)Long.valueOf(Long.MAX_VALUE)));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(0L))}), (boolean)true));
        Assert.assertEquals((Object)domain.getSingleValue(), (Object)0L);
        try {
            Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.range((Comparable)Integer.valueOf(1), (boolean)true, (Comparable)Integer.valueOf(2), (boolean)true), (Range[])new Range[0]), (boolean)false).getSingleValue();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testOverlaps() throws Exception {
        Assert.assertTrue((boolean)Domain.all(Long.class).overlaps(Domain.all(Long.class)));
        Assert.assertFalse((boolean)Domain.all(Long.class).overlaps(Domain.none(Long.class)));
        Assert.assertTrue((boolean)Domain.all(Long.class).overlaps(Domain.notNull(Long.class)));
        Assert.assertTrue((boolean)Domain.all(Long.class).overlaps(Domain.onlyNull(Long.class)));
        Assert.assertTrue((boolean)Domain.all(Long.class).overlaps(Domain.singleValue((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)Domain.none(Long.class).overlaps(Domain.all(Long.class)));
        Assert.assertFalse((boolean)Domain.none(Long.class).overlaps(Domain.none(Long.class)));
        Assert.assertFalse((boolean)Domain.none(Long.class).overlaps(Domain.notNull(Long.class)));
        Assert.assertFalse((boolean)Domain.none(Long.class).overlaps(Domain.onlyNull(Long.class)));
        Assert.assertFalse((boolean)Domain.none(Long.class).overlaps(Domain.singleValue((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)Domain.notNull(Long.class).overlaps(Domain.all(Long.class)));
        Assert.assertFalse((boolean)Domain.notNull(Long.class).overlaps(Domain.none(Long.class)));
        Assert.assertTrue((boolean)Domain.notNull(Long.class).overlaps(Domain.notNull(Long.class)));
        Assert.assertFalse((boolean)Domain.notNull(Long.class).overlaps(Domain.onlyNull(Long.class)));
        Assert.assertTrue((boolean)Domain.notNull(Long.class).overlaps(Domain.singleValue((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)Domain.onlyNull(Long.class).overlaps(Domain.all(Long.class)));
        Assert.assertFalse((boolean)Domain.onlyNull(Long.class).overlaps(Domain.none(Long.class)));
        Assert.assertFalse((boolean)Domain.onlyNull(Long.class).overlaps(Domain.notNull(Long.class)));
        Assert.assertTrue((boolean)Domain.onlyNull(Long.class).overlaps(Domain.onlyNull(Long.class)));
        Assert.assertFalse((boolean)Domain.onlyNull(Long.class).overlaps(Domain.singleValue((Comparable)Long.valueOf(0L))));
        Assert.assertTrue((boolean)Domain.singleValue((Comparable)Long.valueOf(0L)).overlaps(Domain.all(Long.class)));
        Assert.assertFalse((boolean)Domain.singleValue((Comparable)Long.valueOf(0L)).overlaps(Domain.none(Long.class)));
        Assert.assertTrue((boolean)Domain.singleValue((Comparable)Long.valueOf(0L)).overlaps(Domain.notNull(Long.class)));
        Assert.assertFalse((boolean)Domain.singleValue((Comparable)Long.valueOf(0L)).overlaps(Domain.onlyNull(Long.class)));
        Assert.assertTrue((boolean)Domain.singleValue((Comparable)Long.valueOf(0L)).overlaps(Domain.singleValue((Comparable)Long.valueOf(0L))));
    }

    @Test
    public void testContains() throws Exception {
        Assert.assertTrue((boolean)Domain.all(Long.class).contains(Domain.all(Long.class)));
        Assert.assertTrue((boolean)Domain.all(Long.class).contains(Domain.none(Long.class)));
        Assert.assertTrue((boolean)Domain.all(Long.class).contains(Domain.notNull(Long.class)));
        Assert.assertTrue((boolean)Domain.all(Long.class).contains(Domain.onlyNull(Long.class)));
        Assert.assertTrue((boolean)Domain.all(Long.class).contains(Domain.singleValue((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)Domain.none(Long.class).contains(Domain.all(Long.class)));
        Assert.assertTrue((boolean)Domain.none(Long.class).contains(Domain.none(Long.class)));
        Assert.assertFalse((boolean)Domain.none(Long.class).contains(Domain.notNull(Long.class)));
        Assert.assertFalse((boolean)Domain.none(Long.class).contains(Domain.onlyNull(Long.class)));
        Assert.assertFalse((boolean)Domain.none(Long.class).contains(Domain.singleValue((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)Domain.notNull(Long.class).contains(Domain.all(Long.class)));
        Assert.assertTrue((boolean)Domain.notNull(Long.class).contains(Domain.none(Long.class)));
        Assert.assertTrue((boolean)Domain.notNull(Long.class).contains(Domain.notNull(Long.class)));
        Assert.assertFalse((boolean)Domain.notNull(Long.class).contains(Domain.onlyNull(Long.class)));
        Assert.assertTrue((boolean)Domain.notNull(Long.class).contains(Domain.singleValue((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)Domain.onlyNull(Long.class).contains(Domain.all(Long.class)));
        Assert.assertTrue((boolean)Domain.onlyNull(Long.class).contains(Domain.none(Long.class)));
        Assert.assertFalse((boolean)Domain.onlyNull(Long.class).contains(Domain.notNull(Long.class)));
        Assert.assertTrue((boolean)Domain.onlyNull(Long.class).contains(Domain.onlyNull(Long.class)));
        Assert.assertFalse((boolean)Domain.onlyNull(Long.class).contains(Domain.singleValue((Comparable)Long.valueOf(0L))));
        Assert.assertFalse((boolean)Domain.singleValue((Comparable)Long.valueOf(0L)).contains(Domain.all(Long.class)));
        Assert.assertTrue((boolean)Domain.singleValue((Comparable)Long.valueOf(0L)).contains(Domain.none(Long.class)));
        Assert.assertFalse((boolean)Domain.singleValue((Comparable)Long.valueOf(0L)).contains(Domain.notNull(Long.class)));
        Assert.assertFalse((boolean)Domain.singleValue((Comparable)Long.valueOf(0L)).contains(Domain.onlyNull(Long.class)));
        Assert.assertTrue((boolean)Domain.singleValue((Comparable)Long.valueOf(0L)).contains(Domain.singleValue((Comparable)Long.valueOf(0L))));
    }

    @Test
    public void testIntersect() throws Exception {
        Assert.assertEquals((Object)Domain.all(Long.class).intersect(Domain.all(Long.class)), (Object)Domain.all(Long.class));
        Assert.assertEquals((Object)Domain.none(Long.class).intersect(Domain.none(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.all(Long.class).intersect(Domain.none(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.notNull(Long.class).intersect(Domain.onlyNull(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.singleValue((Comparable)Long.valueOf(0L)).intersect(Domain.all(Long.class)), (Object)Domain.singleValue((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)Domain.singleValue((Comparable)Long.valueOf(0L)).intersect(Domain.onlyNull(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[0]), (boolean)true).intersect(Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)true)), (Object)Domain.onlyNull(Long.class));
        Assert.assertEquals((Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[0]), (boolean)true).intersect(Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(2L))}), (boolean)false)), (Object)Domain.singleValue((Comparable)Long.valueOf(1L)));
    }

    @Test
    public void testUnion() throws Exception {
        this.assertUnion(Domain.all(Long.class), Domain.all(Long.class), Domain.all(Long.class));
        this.assertUnion(Domain.none(Long.class), Domain.none(Long.class), Domain.none(Long.class));
        this.assertUnion(Domain.all(Long.class), Domain.none(Long.class), Domain.all(Long.class));
        this.assertUnion(Domain.notNull(Long.class), Domain.onlyNull(Long.class), Domain.all(Long.class));
        this.assertUnion(Domain.singleValue((Comparable)Long.valueOf(0L)), Domain.all(Long.class), Domain.all(Long.class));
        this.assertUnion(Domain.singleValue((Comparable)Long.valueOf(0L)), Domain.notNull(Long.class), Domain.notNull(Long.class));
        this.assertUnion(Domain.singleValue((Comparable)Long.valueOf(0L)), Domain.onlyNull(Long.class), Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(0L)), (Range[])new Range[0]), (boolean)true));
        this.assertUnion(Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[0]), (boolean)true), Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)true), Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(2L))}), (boolean)true));
        this.assertUnion(Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[0]), (boolean)true), Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(2L))}), (boolean)false), Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(2L))}), (boolean)true));
    }

    @Test
    public void testSubtract() throws Exception {
        Assert.assertEquals((Object)Domain.all(Long.class).subtract(Domain.all(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.all(Long.class).subtract(Domain.none(Long.class)), (Object)Domain.all(Long.class));
        Assert.assertEquals((Object)Domain.all(Long.class).subtract(Domain.notNull(Long.class)), (Object)Domain.onlyNull(Long.class));
        Assert.assertEquals((Object)Domain.all(Long.class).subtract(Domain.onlyNull(Long.class)), (Object)Domain.notNull(Long.class));
        Assert.assertEquals((Object)Domain.all(Long.class).subtract(Domain.singleValue((Comparable)Long.valueOf(0L))), (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(0L))}), (boolean)true));
        Assert.assertEquals((Object)Domain.none(Long.class).subtract(Domain.all(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.none(Long.class).subtract(Domain.none(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.none(Long.class).subtract(Domain.notNull(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.none(Long.class).subtract(Domain.onlyNull(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.none(Long.class).subtract(Domain.singleValue((Comparable)Long.valueOf(0L))), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.notNull(Long.class).subtract(Domain.all(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.notNull(Long.class).subtract(Domain.none(Long.class)), (Object)Domain.notNull(Long.class));
        Assert.assertEquals((Object)Domain.notNull(Long.class).subtract(Domain.notNull(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.notNull(Long.class).subtract(Domain.onlyNull(Long.class)), (Object)Domain.notNull(Long.class));
        Assert.assertEquals((Object)Domain.notNull(Long.class).subtract(Domain.singleValue((Comparable)Long.valueOf(0L))), (Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.greaterThan((Comparable)Long.valueOf(0L))}), (boolean)false));
        Assert.assertEquals((Object)Domain.onlyNull(Long.class).subtract(Domain.all(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.onlyNull(Long.class).subtract(Domain.none(Long.class)), (Object)Domain.onlyNull(Long.class));
        Assert.assertEquals((Object)Domain.onlyNull(Long.class).subtract(Domain.notNull(Long.class)), (Object)Domain.onlyNull(Long.class));
        Assert.assertEquals((Object)Domain.onlyNull(Long.class).subtract(Domain.onlyNull(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.onlyNull(Long.class).subtract(Domain.singleValue((Comparable)Long.valueOf(0L))), (Object)Domain.onlyNull(Long.class));
        Assert.assertEquals((Object)Domain.singleValue((Comparable)Long.valueOf(0L)).subtract(Domain.all(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.singleValue((Comparable)Long.valueOf(0L)).subtract(Domain.none(Long.class)), (Object)Domain.singleValue((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)Domain.singleValue((Comparable)Long.valueOf(0L)).subtract(Domain.notNull(Long.class)), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.singleValue((Comparable)Long.valueOf(0L)).subtract(Domain.onlyNull(Long.class)), (Object)Domain.singleValue((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)Domain.singleValue((Comparable)Long.valueOf(0L)).subtract(Domain.singleValue((Comparable)Long.valueOf(0L))), (Object)Domain.none(Long.class));
        Assert.assertEquals((Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[0]), (boolean)true).subtract(Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(2L)), (Range[])new Range[0]), (boolean)true)), (Object)Domain.singleValue((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Object)Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[0]), (boolean)true).subtract(Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.equal((Comparable)Long.valueOf(1L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(2L))}), (boolean)false)), (Object)Domain.onlyNull(Long.class));
    }

    @Test
    public void testJsonSerialization() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Domain domain = Domain.all(Long.class);
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.none(Double.class);
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.notNull(Boolean.class);
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.onlyNull(String.class);
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.singleValue((Comparable)Long.valueOf(Long.MIN_VALUE));
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan((Comparable)Long.valueOf(0L)), (Range[])new Range[]{Range.equal((Comparable)Long.valueOf(1L)), Range.range((Comparable)Long.valueOf(2L), (boolean)true, (Comparable)Long.valueOf(3L), (boolean)true)}), (boolean)true);
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
    }

    private void assertUnion(Domain first, Domain second, Domain expected) {
        Assert.assertEquals((Object)first.union(second), (Object)expected);
        Assert.assertEquals((Object)Domain.union((List)ImmutableList.of((Object)first, (Object)second)), (Object)expected);
    }
}

