/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.Marker;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMarker {
    @Test
    public void testTypes() throws Exception {
        Assert.assertEquals((Object)Marker.lowerUnbounded(Long.class).getType(), Long.class);
        Assert.assertEquals((Object)Marker.below((Comparable)Long.valueOf(1L)).getType(), Long.class);
        Assert.assertEquals((Object)Marker.exactly((Comparable)Long.valueOf(1L)).getType(), Long.class);
        Assert.assertEquals((Object)Marker.above((Comparable)Long.valueOf(1L)).getType(), Long.class);
        Assert.assertEquals((Object)Marker.upperUnbounded(Long.class).getType(), Long.class);
    }

    @Test
    public void testUnbounded() throws Exception {
        Assert.assertTrue((boolean)Marker.lowerUnbounded(Long.class).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.lowerUnbounded(Long.class).isUpperUnbounded());
        Assert.assertTrue((boolean)Marker.upperUnbounded(Long.class).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.upperUnbounded(Long.class).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.below((Comparable)Long.valueOf(1L)).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.below((Comparable)Long.valueOf(1L)).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.exactly((Comparable)Long.valueOf(1L)).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.exactly((Comparable)Long.valueOf(1L)).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.above((Comparable)Long.valueOf(1L)).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.above((Comparable)Long.valueOf(1L)).isUpperUnbounded());
    }

    @Test
    public void testComparisons() throws Exception {
        ImmutableList markers = ImmutableList.of((Object)Marker.lowerUnbounded(Long.class), (Object)Marker.above((Comparable)Long.valueOf(0L)), (Object)Marker.below((Comparable)Long.valueOf(1L)), (Object)Marker.exactly((Comparable)Long.valueOf(1L)), (Object)Marker.above((Comparable)Long.valueOf(1L)), (Object)Marker.below((Comparable)Long.valueOf(2L)), (Object)Marker.upperUnbounded(Long.class));
        Assert.assertTrue((boolean)Ordering.natural().isStrictlyOrdered((Iterable)markers));
        for (int i = 0; i < markers.size(); ++i) {
            for (int j = 0; j < markers.size(); ++j) {
                Assert.assertTrue((((Marker)markers.get(i)).compareTo((Marker)markers.get(j)) == Integer.compare(i, j) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testAdjacency() throws Exception {
        ImmutableMap markers = ImmutableMap.builder().put((Object)Marker.lowerUnbounded(Long.class), (Object)-1000).put((Object)Marker.above((Comparable)Long.valueOf(0L)), (Object)-100).put((Object)Marker.below((Comparable)Long.valueOf(1L)), (Object)-1).put((Object)Marker.exactly((Comparable)Long.valueOf(1L)), (Object)0).put((Object)Marker.above((Comparable)Long.valueOf(1L)), (Object)1).put((Object)Marker.below((Comparable)Long.valueOf(2L)), (Object)100).put((Object)Marker.upperUnbounded(Long.class), (Object)1000).build();
        for (Map.Entry entry1 : markers.entrySet()) {
            for (Map.Entry entry2 : markers.entrySet()) {
                boolean adjacent = ((Marker)entry1.getKey()).isAdjacent((Marker)entry2.getKey());
                boolean distanceIsOne = Math.abs((Integer)entry1.getValue() - (Integer)entry2.getValue()) == 1;
                Assert.assertEquals((boolean)adjacent, (boolean)distanceIsOne);
            }
        }
        Assert.assertEquals((Object)Marker.below((Comparable)Long.valueOf(1L)).greaterAdjacent(), (Object)Marker.exactly((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Object)Marker.exactly((Comparable)Long.valueOf(1L)).greaterAdjacent(), (Object)Marker.above((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Object)Marker.above((Comparable)Long.valueOf(1L)).lesserAdjacent(), (Object)Marker.exactly((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Object)Marker.exactly((Comparable)Long.valueOf(1L)).lesserAdjacent(), (Object)Marker.below((Comparable)Long.valueOf(1L)));
        try {
            Marker.below((Comparable)Long.valueOf(1L)).lesserAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            Marker.above((Comparable)Long.valueOf(1L)).greaterAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            Marker.lowerUnbounded(Long.class).lesserAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            Marker.lowerUnbounded(Long.class).greaterAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            Marker.upperUnbounded(Long.class).lesserAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            Marker.upperUnbounded(Long.class).greaterAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testJsonSerialization() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Marker marker = Marker.above((Comparable)Long.valueOf(0L));
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.exactly((Comparable)((Object)"abc"));
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.below((Comparable)Double.valueOf(0.123));
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.exactly((Comparable)Boolean.valueOf(true));
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.upperUnbounded(Long.class);
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.lowerUnbounded(Long.class);
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
    }
}

