/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypeSignature {
    @Test
    public void test() throws Exception {
        TestTypeSignature.assertSignature("bigint", (List<String>)ImmutableList.of());
        TestTypeSignature.assertSignature("boolean", (List<String>)ImmutableList.of());
        TestTypeSignature.assertSignature("varchar", (List<String>)ImmutableList.of());
        TestTypeSignature.assertSignature("array", (List<String>)ImmutableList.of((Object)"bigint"));
        TestTypeSignature.assertSignature("array", (List<String>)ImmutableList.of((Object)"array<bigint>"));
        TestTypeSignature.assertSignature("map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"bigint"));
        TestTypeSignature.assertSignature("map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"array<bigint>"));
        TestTypeSignature.assertSignature("map", (List<String>)ImmutableList.of((Object)"bigint", (Object)"map<bigint,map<varchar,bigint>>"));
        TestTypeSignature.assertSignature("array", (List<String>)ImmutableList.of((Object)"timestamp with time zone"));
        try {
            TypeSignature.parseTypeSignature((String)"blah<>");
            Assert.fail((String)"Type signatures with zero parameters should fail to parse");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static void assertSignature(String base, List<String> parameters) {
        ImmutableList lowerCaseTypeNames = FluentIterable.from(parameters).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                return input.toLowerCase(Locale.ENGLISH);
            }
        }).toList();
        String typeName = base.toLowerCase(Locale.ENGLISH);
        if (!parameters.isEmpty()) {
            typeName = typeName + "<" + Joiner.on((String)",").join((Iterable)lowerCaseTypeNames) + ">";
        }
        TypeSignature signature = TypeSignature.parseTypeSignature((String)typeName);
        Assert.assertEquals((String)signature.getBase(), (String)base);
        Assert.assertEquals((int)signature.getParameters().size(), (int)parameters.size());
        for (int i = 0; i < signature.getParameters().size(); ++i) {
            Assert.assertEquals((String)((TypeSignature)signature.getParameters().get(i)).toString(), (String)parameters.get(i));
        }
        Assert.assertEquals((String)typeName, (String)signature.toString());
    }
}

