/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spi.type.VariableWidthType;
import io.airlift.slice.Slices;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestVariableWidthBlockBuilder {
    private static final int VARCHAR_VALUE_SIZE = 7;
    private static final int VARCHAR_ENTRY_SIZE = 11;
    private static final int EXPECTED_ENTRY_COUNT = 3;

    @Test
    public void testFixedBlockIsFull() throws Exception {
        this.testIsFull(new VariableWidthBlockBuilder((VariableWidthType)VarcharType.VARCHAR, new BlockBuilderStatus(33, 1024)));
        this.testIsFull(new VariableWidthBlockBuilder((VariableWidthType)VarcharType.VARCHAR, new BlockBuilderStatus(1024, 33)));
    }

    private void testIsFull(VariableWidthBlockBuilder blockBuilder) {
        Assert.assertTrue((boolean)blockBuilder.isEmpty());
        while (!blockBuilder.isFull()) {
            blockBuilder.appendSlice(Slices.allocate((int)7));
        }
        Assert.assertEquals((int)blockBuilder.getPositionCount(), (int)3);
        Assert.assertEquals((boolean)blockBuilder.isFull(), (boolean)true);
    }
}

