/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.FixedWidthBlockBuilder;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.FixedWidthType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFixedWidthBlockBuilder {
    private static final int BOOLEAN_ENTRY_SIZE = BooleanType.BOOLEAN.getFixedSize();
    private static final int EXPECTED_ENTRY_COUNT = 3;

    @Test
    public void testFixedBlockIsFull() throws Exception {
        TestFixedWidthBlockBuilder.testIsFull(new FixedWidthBlockBuilder((FixedWidthType)BooleanType.BOOLEAN, 3));
        TestFixedWidthBlockBuilder.testIsFull(new FixedWidthBlockBuilder((FixedWidthType)BooleanType.BOOLEAN, new BlockBuilderStatus(BOOLEAN_ENTRY_SIZE * 3, 1024)));
        TestFixedWidthBlockBuilder.testIsFull(new FixedWidthBlockBuilder((FixedWidthType)BooleanType.BOOLEAN, new BlockBuilderStatus(1024, BOOLEAN_ENTRY_SIZE * 3)));
    }

    private static void testIsFull(FixedWidthBlockBuilder blockBuilder) {
        Assert.assertTrue((boolean)blockBuilder.isEmpty());
        while (!blockBuilder.isFull()) {
            blockBuilder.appendBoolean(true);
        }
        Assert.assertEquals((int)blockBuilder.getPositionCount(), (int)3);
        Assert.assertEquals((boolean)blockBuilder.isFull(), (boolean)true);
    }
}

