/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.testing.Assertions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStandardErrorCode {
    @Test
    public void testUnique() {
        HashSet<Integer> codes = new HashSet<Integer>();
        for (StandardErrorCode code : StandardErrorCode.values()) {
            Assert.assertTrue((boolean)codes.add(TestStandardErrorCode.code(code)), (String)("Code already exists: " + code));
        }
        Assert.assertEquals((int)codes.size(), (int)StandardErrorCode.values().length);
    }

    @Test
    public void testReserved() {
        for (StandardErrorCode errorCode : StandardErrorCode.values()) {
            Assertions.assertLessThanOrEqual((Comparable)Integer.valueOf(TestStandardErrorCode.code(errorCode)), (Comparable)Integer.valueOf(TestStandardErrorCode.code(StandardErrorCode.EXTERNAL)));
        }
    }

    @Test
    public void testOrdering() throws Exception {
        Iterator<StandardErrorCode> iterator = Arrays.asList(StandardErrorCode.values()).iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        int previous = TestStandardErrorCode.code(iterator.next());
        while (iterator.hasNext()) {
            StandardErrorCode code = iterator.next();
            int current = TestStandardErrorCode.code(code);
            Assertions.assertGreaterThan((Comparable)Integer.valueOf(current), (Comparable)Integer.valueOf(previous), (String)("Code is out of order: " + code));
            if (code != StandardErrorCode.INTERNAL && code != StandardErrorCode.INSUFFICIENT_RESOURCES && code != StandardErrorCode.EXTERNAL) {
                Assert.assertEquals((int)current, (int)(previous + 1), (String)("Code is not sequential: " + code));
            }
            previous = current;
        }
        Assert.assertEquals((int)previous, (int)TestStandardErrorCode.code(StandardErrorCode.EXTERNAL), (String)"Last code is not EXTERNAL");
    }

    @Test
    public void testCategoryCodes() throws Exception {
        Assert.assertEquals((int)TestStandardErrorCode.code(StandardErrorCode.USER_ERROR), (int)0);
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(TestStandardErrorCode.code(StandardErrorCode.INTERNAL)), (Comparable)Integer.valueOf(TestStandardErrorCode.code(StandardErrorCode.USER_ERROR)));
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(TestStandardErrorCode.code(StandardErrorCode.INSUFFICIENT_RESOURCES)), (Comparable)Integer.valueOf(TestStandardErrorCode.code(StandardErrorCode.INTERNAL)));
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(TestStandardErrorCode.code(StandardErrorCode.EXTERNAL)), (Comparable)Integer.valueOf(TestStandardErrorCode.code(StandardErrorCode.INSUFFICIENT_RESOURCES)));
    }

    private static int code(StandardErrorCode error) {
        return error.toErrorCode().getCode();
    }
}

