/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.spi.block.VariableWidthBlockEncoding;
import com.facebook.presto.spi.type.VariableWidthType;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;

public class VarbinaryType
implements VariableWidthType {
    public static final VarbinaryType VARBINARY = new VarbinaryType();
    public static final BlockEncodingFactory<?> BLOCK_ENCODING_FACTORY = new VariableWidthBlockEncoding.VariableWidthBlockEncodingFactory(VARBINARY);

    @JsonCreator
    public VarbinaryType() {
    }

    public static VarbinaryType getInstance() {
        return VARBINARY;
    }

    @Override
    public String getName() {
        return "varbinary";
    }

    @Override
    public Class<?> getJavaType() {
        return Slice.class;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Slice slice, int offset) {
        return slice.slice(offset + 4, this.getValueSize(slice, offset));
    }

    @Override
    public int getLength(Slice slice, int offset) {
        return this.getValueSize(slice, offset) + 4;
    }

    private int getValueSize(Slice slice, int offset) {
        return slice.getInt(offset);
    }

    @Override
    public Slice getSlice(Slice slice, int offset) {
        return slice.slice(offset + 4, this.getValueSize(slice, offset));
    }

    @Override
    public int writeSlice(SliceOutput sliceOutput, Slice value, int offset, int length) {
        sliceOutput.writeInt(length);
        sliceOutput.writeBytes(value, offset, length);
        return length + 4;
    }

    @Override
    public boolean equalTo(Slice leftSlice, int leftOffset, Slice rightSlice, int rightOffset) {
        int leftLength = this.getValueSize(leftSlice, leftOffset);
        int rightLength = this.getValueSize(rightSlice, rightOffset);
        return leftSlice.equals(leftOffset + 4, leftLength, rightSlice, rightOffset + 4, rightLength);
    }

    @Override
    public boolean equalTo(Slice leftSlice, int leftOffset, BlockCursor rightCursor) {
        int leftLength = this.getValueSize(leftSlice, leftOffset);
        Slice rightSlice = rightCursor.getSlice();
        return leftSlice.equals(leftOffset + 4, leftLength, rightSlice, 0, rightSlice.length());
    }

    @Override
    public int hash(Slice slice, int offset) {
        int length = this.getValueSize(slice, offset);
        return slice.hashCode(offset + 4, length);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus) {
        return new VariableWidthBlockBuilder(this, blockBuilderStatus);
    }

    @Override
    public int compareTo(Slice leftSlice, int leftOffset, Slice rightSlice, int rightOffset) {
        int leftLength = this.getValueSize(leftSlice, leftOffset);
        int rightLength = this.getValueSize(rightSlice, rightOffset);
        return leftSlice.compareTo(leftOffset + 4, leftLength, rightSlice, rightOffset + 4, rightLength);
    }

    @Override
    public void appendTo(Slice slice, int offset, BlockBuilder blockBuilder) {
        int length = this.getValueSize(slice, offset);
        blockBuilder.appendSlice(slice, offset + 4, length);
    }

    @Override
    public void appendTo(Slice slice, int offset, SliceOutput sliceOutput) {
        int length = this.getLength(slice, offset);
        sliceOutput.writeBytes(slice, offset, length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

