/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.TimeZoneIndex;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.fasterxml.jackson.annotation.JsonValue;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public final class SqlDate {
    private final long millisAtMidnight;
    private final TimeZoneKey sessionTimeZoneKey;

    public SqlDate(long millisAtMidnight, TimeZoneKey sessionTimeZoneKey) {
        this.millisAtMidnight = millisAtMidnight;
        this.sessionTimeZoneKey = sessionTimeZoneKey;
    }

    public long getMillisAtMidnight() {
        return this.millisAtMidnight;
    }

    public TimeZoneKey getSessionTimeZoneKey() {
        return this.sessionTimeZoneKey;
    }

    public int hashCode() {
        return Objects.hash(this.millisAtMidnight, this.sessionTimeZoneKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlDate other = (SqlDate)obj;
        return Objects.equals(this.millisAtMidnight, other.millisAtMidnight) && Objects.equals(this.sessionTimeZoneKey, other.sessionTimeZoneKey);
    }

    @JsonValue
    public String toString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        format.setTimeZone(TimeZoneIndex.getTimeZoneForKey(this.sessionTimeZoneKey));
        return format.format(new Date(this.millisAtMidnight));
    }
}

