/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.spi.block.VariableWidthBlockEncoding;
import com.facebook.presto.spi.type.VariableWidthType;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;

public class HyperLogLogType
implements VariableWidthType {
    public static final HyperLogLogType HYPER_LOG_LOG = new HyperLogLogType();
    public static final BlockEncodingFactory<?> BLOCK_ENCODING_FACTORY = new VariableWidthBlockEncoding.VariableWidthBlockEncodingFactory(HYPER_LOG_LOG);

    public static HyperLogLogType getInstance() {
        return HYPER_LOG_LOG;
    }

    @JsonCreator
    public HyperLogLogType() {
    }

    @Override
    public String getName() {
        return "HyperLogLog";
    }

    @Override
    public Class<?> getJavaType() {
        return Slice.class;
    }

    @Override
    public int getLength(Slice slice, int offset) {
        return HyperLogLogType.getValueSize(slice, offset) + 2;
    }

    @Override
    public Slice getSlice(Slice slice, int offset) {
        return slice.slice(offset + 2, HyperLogLogType.getValueSize(slice, offset));
    }

    @Override
    public int writeSlice(SliceOutput sliceOutput, Slice value, int offset, int length) {
        sliceOutput.writeShort(length);
        sliceOutput.writeBytes(value, offset, length);
        return length + 2;
    }

    @Override
    public boolean equalTo(Slice leftSlice, int leftOffset, Slice rightSlice, int rightOffset) {
        throw new UnsupportedOperationException("HyperLogLog type is not comparable");
    }

    @Override
    public boolean equalTo(Slice leftSlice, int leftOffset, BlockCursor rightCursor) {
        throw new UnsupportedOperationException("HyperLogLog type is not comparable");
    }

    @Override
    public int hash(Slice slice, int offset) {
        throw new UnsupportedOperationException("HyperLogLog type is not comparable");
    }

    @Override
    public int compareTo(Slice leftSlice, int leftOffset, Slice rightSlice, int rightOffset) {
        throw new UnsupportedOperationException("HyperLogLog type is not ordered");
    }

    @Override
    public void appendTo(Slice slice, int offset, BlockBuilder blockBuilder) {
        int length = HyperLogLogType.getValueSize(slice, offset);
        blockBuilder.appendSlice(slice, offset + 2, length);
    }

    @Override
    public void appendTo(Slice slice, int offset, SliceOutput sliceOutput) {
        int length = this.getLength(slice, offset);
        sliceOutput.writeBytes(slice, offset, length);
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Slice slice, int offset) {
        return "<HyperLogLog>";
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus) {
        return new VariableWidthBlockBuilder(this, blockBuilderStatus);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static int getValueSize(Slice slice, int offset) {
        return slice.getShort(offset);
    }

    public String toString() {
        return this.getName();
    }
}

