/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.FixedWidthBlockUtil;
import com.facebook.presto.spi.type.FixedWidthType;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;

public final class BooleanType
implements FixedWidthType {
    public static final BooleanType BOOLEAN = new BooleanType();
    private static final FixedWidthBlockUtil.FixedWidthBlockBuilderFactory BLOCK_BUILDER_FACTORY = FixedWidthBlockUtil.createIsolatedFixedWidthBlockBuilderFactory(BOOLEAN);
    public static final BlockEncodingFactory<?> BLOCK_ENCODING_FACTORY = BLOCK_BUILDER_FACTORY.getBlockEncodingFactory();

    public static BooleanType getInstance() {
        return BOOLEAN;
    }

    private BooleanType() {
    }

    @Override
    public String getName() {
        return "boolean";
    }

    @Override
    public Class<?> getJavaType() {
        return Boolean.TYPE;
    }

    @Override
    public int getFixedSize() {
        return 1;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Slice slice, int offset) {
        return slice.getByte(offset) != 0;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus) {
        return BLOCK_BUILDER_FACTORY.createFixedWidthBlockBuilder(blockBuilderStatus);
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return BLOCK_BUILDER_FACTORY.createFixedWidthBlockBuilder(positionCount);
    }

    @Override
    public boolean getBoolean(Slice slice, int offset) {
        return slice.getByte(offset) != 0;
    }

    @Override
    public void writeBoolean(SliceOutput sliceOutput, boolean value) {
        sliceOutput.writeByte(value ? 1 : 0);
    }

    @Override
    public long getLong(Slice slice, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeLong(SliceOutput sliceOutput, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(Slice slice, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeDouble(SliceOutput sliceOutput, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice getSlice(Slice slice, int offset) {
        return slice.slice(offset, this.getFixedSize());
    }

    @Override
    public void writeSlice(SliceOutput sliceOutput, Slice value, int offset) {
        sliceOutput.writeBytes(value, offset, 1);
    }

    @Override
    public boolean equalTo(Slice leftSlice, int leftOffset, Slice rightSlice, int rightOffset) {
        boolean leftValue = leftSlice.getByte(leftOffset) != 0;
        boolean rightValue = rightSlice.getByte(rightOffset) != 0;
        return leftValue == rightValue;
    }

    @Override
    public boolean equalTo(Slice leftSlice, int leftOffset, BlockCursor rightCursor) {
        boolean leftValue = leftSlice.getByte(leftOffset) != 0;
        boolean rightValue = rightCursor.getBoolean();
        return leftValue == rightValue;
    }

    @Override
    public int hash(Slice slice, int offset) {
        return slice.getByte(offset) != 0 ? 1231 : 1237;
    }

    @Override
    public int compareTo(Slice leftSlice, int leftOffset, Slice rightSlice, int rightOffset) {
        boolean leftValue = leftSlice.getByte(leftOffset) != 0;
        boolean rightValue = rightSlice.getByte(rightOffset) != 0;
        return Boolean.compare(leftValue, rightValue);
    }

    @Override
    public void appendTo(Slice slice, int offset, BlockBuilder blockBuilder) {
        boolean value = slice.getByte(offset) != 0;
        blockBuilder.appendBoolean(value);
    }

    @Override
    public void appendTo(Slice slice, int offset, SliceOutput sliceOutput) {
        sliceOutput.writeBytes(slice, offset, 1);
    }

    public String toString() {
        return this.getName();
    }
}

