/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.VariableWidthBlock;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VariableWidthType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.Objects;

public class VariableWidthCursor
implements BlockCursor {
    private final VariableWidthType type;
    private final Slice slice;
    private final int[] offsets;
    private final int positionCount;
    private int position = -1;

    public VariableWidthCursor(VariableWidthType type, int positionCount, Slice slice, int[] offsets) {
        this.type = Objects.requireNonNull(type, "type is null");
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.offsets = Objects.requireNonNull(offsets, "offsets is null");
        this.position = -1;
    }

    public VariableWidthCursor(VariableWidthCursor cursor) {
        this.type = cursor.type;
        this.slice = cursor.slice;
        this.offsets = cursor.offsets;
        this.positionCount = cursor.positionCount;
        this.position = cursor.position;
    }

    @Override
    public VariableWidthCursor duplicate() {
        return new VariableWidthCursor(this);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int getRemainingPositions() {
        return this.positionCount - (this.position + 1);
    }

    @Override
    public boolean isValid() {
        return 0 <= this.position && this.position < this.positionCount;
    }

    @Override
    public boolean isFinished() {
        return this.position >= this.positionCount;
    }

    private void checkReadablePosition() {
        if (!this.isValid()) {
            throw new IllegalStateException("cursor is not valid");
        }
    }

    @Override
    public boolean advanceNextPosition() {
        if (this.position >= this.positionCount - 1) {
            this.position = this.positionCount;
            return false;
        }
        ++this.position;
        return true;
    }

    @Override
    public boolean advanceToPosition(int newPosition) {
        if (newPosition >= this.positionCount) {
            this.position = this.positionCount;
            return false;
        }
        if (newPosition < this.position) {
            throw new IllegalArgumentException("Can't advance backwards");
        }
        this.position = newPosition;
        return true;
    }

    @Override
    public Block getRegionAndAdvance(int length) {
        int startPosition = this.position + 1;
        length = Math.min(length, this.getRemainingPositions());
        this.position += length;
        int[] newOffsets = Arrays.copyOfRange(this.offsets, startPosition, startPosition + length);
        return new VariableWidthBlock(this.type, length, this.slice, newOffsets);
    }

    @Override
    public int getPosition() {
        this.checkReadablePosition();
        return this.position;
    }

    @Override
    public Block getSingleValueBlock() {
        this.checkReadablePosition();
        if (this.isNull()) {
            return new VariableWidthBlock(this.type, 1, Slices.wrappedBuffer((byte[])new byte[]{1}), new int[]{0});
        }
        Slice copy = Slices.copyOf((Slice)this.slice, (int)this.offsets[this.position], (int)this.entrySize());
        return new VariableWidthBlock(this.type, 1, copy, new int[]{0});
    }

    @Override
    public boolean getBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice getSlice() {
        this.checkReadablePosition();
        return this.type.getSlice(this.slice, this.valueOffset());
    }

    @Override
    public Object getObjectValue(ConnectorSession session) {
        this.checkReadablePosition();
        if (this.isNull()) {
            return null;
        }
        return this.type.getObjectValue(session, this.slice, this.valueOffset());
    }

    @Override
    public boolean isNull() {
        this.checkReadablePosition();
        int offset = this.offsets[this.position];
        return this.isEntryAtOffsetNull(offset);
    }

    @Override
    public int compareTo(Slice otherSlice, int otherOffset) {
        this.checkReadablePosition();
        return this.type.compareTo(this.slice, this.valueOffset(), otherSlice, otherOffset);
    }

    @Override
    public int hash() {
        if (this.isNull()) {
            return 0;
        }
        return this.type.hash(this.slice, this.valueOffset());
    }

    @Override
    public void appendTo(BlockBuilder blockBuilder) {
        if (this.isNull()) {
            blockBuilder.appendNull();
        } else {
            this.type.appendTo(this.slice, this.valueOffset(), blockBuilder);
        }
    }

    private boolean isEntryAtOffsetNull(int offset) {
        return this.slice.getByte(offset) != 0;
    }

    private int valueOffset() {
        return this.offsets[this.position] + 1;
    }

    public int entrySize() {
        return this.type.getLength(this.slice, this.offsets[this.position] + 1) + 1;
    }
}

