/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.VariableWidthBlock;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VariableWidthType;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Objects;

public class VariableWidthBlockEncoding
implements BlockEncoding {
    private final VariableWidthType type;

    public VariableWidthBlockEncoding(Type type) {
        this.type = (VariableWidthType)Objects.requireNonNull(type, "type is null");
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        if (!block.getType().equals(this.type)) {
            throw new IllegalArgumentException("Invalid block");
        }
        AbstractVariableWidthBlock uncompressedBlock = (AbstractVariableWidthBlock)block;
        Slice rawSlice = uncompressedBlock.getRawSlice();
        int positionCount = uncompressedBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        for (int position = 0; position < positionCount; ++position) {
            sliceOutput.appendInt(uncompressedBlock.getPositionOffset(position));
        }
        sliceOutput.appendInt(rawSlice.length()).writeBytes(rawSlice);
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        int[] offsets = new int[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            offsets[position] = sliceInput.readInt();
        }
        int blockSize = sliceInput.readInt();
        Slice slice = sliceInput.readSlice(blockSize);
        return new VariableWidthBlock(this.type, positionCount, slice, offsets);
    }

    public static class VariableWidthBlockEncodingFactory
    implements BlockEncodingFactory<VariableWidthBlockEncoding> {
        private final Type type;

        public VariableWidthBlockEncodingFactory(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @Override
        public String getName() {
            return this.type.getName();
        }

        @Override
        public VariableWidthBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            return new VariableWidthBlockEncoding(this.type);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, VariableWidthBlockEncoding blockEncoding) {
        }
    }
}

