/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlock;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VariableWidthType;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.util.Arrays;
import java.util.Objects;

public class VariableWidthBlockBuilder
extends AbstractVariableWidthBlock
implements BlockBuilder {
    private final BlockBuilderStatus blockBuilderStatus;
    private final SliceOutput sliceOutput;
    private int positions;
    private int[] offsets = new int[1024];

    public VariableWidthBlockBuilder(VariableWidthType type, BlockBuilderStatus blockBuilderStatus) {
        super(type);
        this.blockBuilderStatus = Objects.requireNonNull(blockBuilderStatus, "blockBuilderStatus is null");
        this.sliceOutput = new DynamicSliceOutput((int)((double)blockBuilderStatus.getMaxBlockSizeInBytes() * 1.2));
    }

    @Override
    protected int getPositionOffset(int position) {
        if (position >= this.positions) {
            throw new IllegalArgumentException("position " + position + " must be less than position count " + this.positions);
        }
        return this.offsets[position];
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    protected Slice getRawSlice() {
        return this.sliceOutput.getUnderlyingSlice();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int getPositionCount() {
        return this.positions;
    }

    @Override
    public boolean isEmpty() {
        return this.positions == 0;
    }

    @Override
    public boolean isFull() {
        return this.blockBuilderStatus.isFull();
    }

    @Override
    public int getSizeInBytes() {
        return this.getRawSlice().length();
    }

    @Override
    public BlockBuilder appendBoolean(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder appendLong(long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder appendDouble(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder appendSlice(Slice value) {
        return this.appendSlice(value, 0, value.length());
    }

    @Override
    public BlockBuilder appendSlice(Slice value, int offset, int length) {
        this.recordNewPosition();
        this.sliceOutput.writeByte(0);
        int bytesWritten = this.type.writeSlice(this.sliceOutput, value, offset, length);
        this.entryAdded(bytesWritten);
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        this.recordNewPosition();
        this.sliceOutput.writeByte(1);
        this.entryAdded(0);
        return this;
    }

    private void entryAdded(int bytesWritten) {
        this.blockBuilderStatus.addBytes(1 + bytesWritten);
        if (this.sliceOutput.size() >= this.blockBuilderStatus.getMaxBlockSizeInBytes()) {
            this.blockBuilderStatus.setFull();
        }
    }

    private void recordNewPosition() {
        if (this.positions == this.offsets.length) {
            this.offsets = Arrays.copyOf(this.offsets, this.offsets.length * 2);
        }
        this.offsets[this.positions] = this.sliceOutput.size();
        ++this.positions;
    }

    @Override
    public Block build() {
        return new VariableWidthBlock(this.type, this.positions, this.sliceOutput.slice(), Arrays.copyOf(this.offsets, this.positions));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VariableWidthBlockBuilder{");
        sb.append("positionCount=").append(this.positions);
        sb.append(", size=").append(this.sliceOutput.size());
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }
}

