/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractFixedWidthBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.FixedWidthBlock;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Objects;

public class FixedWidthBlockEncoding
implements BlockEncoding {
    private final FixedWidthType type;

    public FixedWidthBlockEncoding(Type type) {
        this.type = (FixedWidthType)Objects.requireNonNull(type, "type is null");
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        AbstractFixedWidthBlock fixedWidthBlock = (AbstractFixedWidthBlock)block;
        if (!block.getType().equals(this.type)) {
            throw new IllegalArgumentException("Invalid block");
        }
        FixedWidthBlockEncoding.writeUncompressedBlock(sliceOutput, fixedWidthBlock.getPositionCount(), fixedWidthBlock.getRawSlice());
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int blockSize = sliceInput.readInt();
        int positionCount = sliceInput.readInt();
        Slice slice = sliceInput.readSlice(blockSize);
        return new FixedWidthBlock(this.type, positionCount, slice);
    }

    private static void writeUncompressedBlock(SliceOutput destination, int positionCount, Slice slice) {
        destination.appendInt(slice.length()).appendInt(positionCount).writeBytes(slice);
    }

    public static class FixedWidthBlockEncodingFactory
    implements BlockEncodingFactory<BlockEncoding> {
        private final Type type;

        public FixedWidthBlockEncodingFactory(Type type) {
            this.type = type;
        }

        @Override
        public String getName() {
            return this.type.getName();
        }

        @Override
        public BlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            return new FixedWidthBlockEncoding(this.type);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, BlockEncoding blockEncoding) {
        }
    }
}

