/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.FixedWidthBlock;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;

public class FixedWidthBlockCursor
implements BlockCursor {
    private final FixedWidthType type;
    private final int entrySize;
    private final Slice slice;
    private final int positionCount;
    private int position;
    private int offset;

    public FixedWidthBlockCursor(FixedWidthType type, int positionCount, Slice slice) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.entrySize = type.getFixedSize() + 1;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.position = -1;
        this.offset = -this.entrySize;
    }

    public FixedWidthBlockCursor(FixedWidthBlockCursor cursor) {
        this.type = cursor.type;
        this.entrySize = cursor.entrySize;
        this.slice = cursor.slice;
        this.positionCount = cursor.positionCount;
        this.position = cursor.position;
        this.offset = cursor.offset;
    }

    @Override
    public FixedWidthBlockCursor duplicate() {
        return new FixedWidthBlockCursor(this);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int getRemainingPositions() {
        return this.positionCount - (this.position + 1);
    }

    @Override
    public boolean isValid() {
        return 0 <= this.position && this.position < this.positionCount;
    }

    @Override
    public boolean isFinished() {
        return this.position >= this.positionCount;
    }

    private void checkReadablePosition() {
        if (!this.isValid()) {
            throw new IllegalStateException("cursor is not valid");
        }
    }

    @Override
    public boolean advanceNextPosition() {
        if (this.position >= this.positionCount - 1) {
            this.position = this.positionCount;
            return false;
        }
        ++this.position;
        this.offset += this.entrySize;
        return true;
    }

    @Override
    public boolean advanceToPosition(int newPosition) {
        if (newPosition >= this.positionCount) {
            this.position = this.positionCount;
            return false;
        }
        if (newPosition < this.position) {
            throw new IllegalArgumentException("Can't advance backwards");
        }
        this.offset += (newPosition - this.position) * this.entrySize;
        this.position = newPosition;
        return true;
    }

    @Override
    public Block getRegionAndAdvance(int length) {
        int startOffset = this.offset + this.entrySize;
        length = Math.min(length, this.getRemainingPositions());
        this.offset += length * this.entrySize;
        this.position += length;
        Slice newSlice = this.slice.slice(startOffset, length * this.entrySize);
        return new FixedWidthBlock(this.type, length, newSlice);
    }

    @Override
    public int getPosition() {
        this.checkReadablePosition();
        return this.position;
    }

    @Override
    public Block getSingleValueBlock() {
        this.checkReadablePosition();
        Slice copy = Slices.copyOf((Slice)this.slice, (int)this.offset, (int)this.entrySize);
        return new FixedWidthBlock(this.type, 1, copy);
    }

    @Override
    public boolean getBoolean() {
        this.checkReadablePosition();
        return this.type.getBoolean(this.slice, this.valueOffset());
    }

    @Override
    public long getLong() {
        this.checkReadablePosition();
        return this.type.getLong(this.slice, this.valueOffset());
    }

    @Override
    public double getDouble() {
        this.checkReadablePosition();
        return this.type.getDouble(this.slice, this.valueOffset());
    }

    @Override
    public Slice getSlice() {
        this.checkReadablePosition();
        return this.type.getSlice(this.slice, this.valueOffset());
    }

    @Override
    public Object getObjectValue(ConnectorSession session) {
        this.checkReadablePosition();
        if (this.isNull()) {
            return null;
        }
        return this.type.getObjectValue(session, this.slice, this.valueOffset());
    }

    @Override
    public boolean isNull() {
        this.checkReadablePosition();
        return this.slice.getByte(this.offset) != 0;
    }

    @Override
    public int compareTo(Slice otherSlice, int otherOffset) {
        this.checkReadablePosition();
        return this.type.compareTo(this.slice, this.valueOffset(), otherSlice, otherOffset);
    }

    @Override
    public int hash() {
        if (this.isNull()) {
            return 0;
        }
        return this.type.hash(this.slice, this.valueOffset());
    }

    @Override
    public void appendTo(BlockBuilder blockBuilder) {
        if (this.isNull()) {
            blockBuilder.appendNull();
        } else {
            this.type.appendTo(this.slice, this.valueOffset(), blockBuilder);
        }
    }

    private int valueOffset() {
        return this.offset + 1;
    }
}

