/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractFixedWidthBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.FixedWidthBlock;
import com.facebook.presto.spi.type.FixedWidthType;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;

public class FixedWidthBlockBuilder
extends AbstractFixedWidthBlock
implements BlockBuilder {
    private final BlockBuilderStatus blockBuilderStatus;
    private final SliceOutput sliceOutput;
    private int positionCount;

    public FixedWidthBlockBuilder(FixedWidthType type, BlockBuilderStatus blockBuilderStatus) {
        super(type);
        this.blockBuilderStatus = blockBuilderStatus;
        this.sliceOutput = new DynamicSliceOutput(blockBuilderStatus.getMaxBlockSizeInBytes());
    }

    public FixedWidthBlockBuilder(FixedWidthType type, int positionCount) {
        super(type);
        Slice slice = Slices.allocate((int)(this.entrySize * positionCount));
        this.blockBuilderStatus = new BlockBuilderStatus(slice.length(), slice.length());
        this.sliceOutput = slice.getOutput();
    }

    @Override
    protected Slice getRawSlice() {
        return this.sliceOutput.getUnderlyingSlice();
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public boolean isEmpty() {
        return this.positionCount == 0;
    }

    @Override
    public boolean isFull() {
        return this.blockBuilderStatus.isFull();
    }

    @Override
    public int getSizeInBytes() {
        return this.getRawSlice().length();
    }

    @Override
    public BlockBuilder appendBoolean(boolean value) {
        this.sliceOutput.writeByte(0);
        this.type.writeBoolean(this.sliceOutput, value);
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder appendLong(long value) {
        this.sliceOutput.writeByte(0);
        this.type.writeLong(this.sliceOutput, value);
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder appendDouble(double value) {
        this.sliceOutput.writeByte(0);
        this.type.writeDouble(this.sliceOutput, value);
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder appendSlice(Slice value) {
        return this.appendSlice(value, 0, value.length());
    }

    @Override
    public BlockBuilder appendSlice(Slice value, int offset, int length) {
        if (length != this.type.getFixedSize()) {
            throw new IllegalArgumentException("length must be " + this.type.getFixedSize() + " but is " + length);
        }
        this.sliceOutput.writeByte(0);
        this.type.writeSlice(this.sliceOutput, value, offset);
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        this.sliceOutput.writeByte(1);
        this.sliceOutput.writeZero(this.type.getFixedSize());
        this.entryAdded();
        return this;
    }

    private void entryAdded() {
        ++this.positionCount;
        this.blockBuilderStatus.addBytes(this.entrySize);
        if (this.sliceOutput.size() >= this.blockBuilderStatus.getMaxBlockSizeInBytes()) {
            this.blockBuilderStatus.setFull();
        }
    }

    @Override
    public Block build() {
        return new FixedWidthBlock(this.type, this.positionCount, this.sliceOutput.slice());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FixedWidthBlockBuilder{");
        sb.append("positionCount=").append(this.positionCount);
        sb.append(", size=").append(this.sliceOutput.size());
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }
}

