/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractFixedWidthBlock;
import com.facebook.presto.spi.type.FixedWidthType;
import io.airlift.slice.Slice;
import java.util.Objects;

public class FixedWidthBlock
extends AbstractFixedWidthBlock {
    private final Slice slice;
    private final int positionCount;

    public FixedWidthBlock(FixedWidthType type, int positionCount, Slice slice) {
        super(type);
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        this.slice = Objects.requireNonNull(slice, "slice is null");
    }

    @Override
    protected Slice getRawSlice() {
        return this.slice;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FixedWidthBlock{");
        sb.append("positionCount=").append(this.positionCount);
        sb.append(", slice=").append(this.slice);
        sb.append('}');
        return sb.toString();
    }
}

