/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

public class BlockBuilderStatus {
    public static final int DEFAULT_MAX_PAGE_SIZE_IN_BYTES = 0x100000;
    public static final int DEFAULT_MAX_BLOCK_SIZE_IN_BYTES = 65536;
    private final int maxPageSizeInBytes;
    private final int maxBlockSizeInBytes;
    private boolean full;
    private int currentSize;

    public BlockBuilderStatus() {
        this(0x100000, 65536);
    }

    public BlockBuilderStatus(int maxPageSizeInBytes, int maxBlockSizeInBytes) {
        this.maxPageSizeInBytes = maxPageSizeInBytes;
        this.maxBlockSizeInBytes = maxBlockSizeInBytes;
    }

    public BlockBuilderStatus(BlockBuilderStatus status) {
        this.maxPageSizeInBytes = status.maxPageSizeInBytes;
        this.maxBlockSizeInBytes = status.maxBlockSizeInBytes;
    }

    public int getMaxBlockSizeInBytes() {
        return this.maxBlockSizeInBytes;
    }

    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    public boolean isFull() {
        return this.full || this.currentSize >= this.maxPageSizeInBytes;
    }

    public void setFull() {
        this.full = true;
    }

    public void addBytes(int bytes) {
        this.currentSize += bytes;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("BlockBuilderStatus{");
        buffer.append("maxSizeInBytes=").append(this.maxPageSizeInBytes);
        buffer.append(", full=").append(this.full);
        buffer.append(", currentSize=").append(this.currentSize);
        buffer.append('}');
        return buffer.toString();
    }
}

