/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.block.VariableWidthBlock;
import com.facebook.presto.spi.block.VariableWidthBlockEncoding;
import com.facebook.presto.spi.block.VariableWidthCursor;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VariableWidthType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public abstract class AbstractVariableWidthBlock
implements Block {
    protected final VariableWidthType type;

    protected AbstractVariableWidthBlock(VariableWidthType type) {
        this.type = type;
    }

    protected abstract Slice getRawSlice();

    protected abstract int getPositionOffset(int var1);

    protected abstract int[] getOffsets();

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int getSizeInBytes() {
        return this.getRawSlice().length();
    }

    @Override
    public BlockCursor cursor() {
        return new VariableWidthCursor(this.type, this.getPositionCount(), this.getRawSlice(), this.getOffsets());
    }

    @Override
    public BlockEncoding getEncoding() {
        return new VariableWidthBlockEncoding(this.type);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        return this.cursor().getRegionAndAdvance(length);
    }

    @Override
    public boolean getBoolean(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObjectValue(ConnectorSession session, int position) {
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            return null;
        }
        int offset = this.getPositionOffset(position);
        return this.type.getObjectValue(session, this.getRawSlice(), AbstractVariableWidthBlock.valueOffset(offset));
    }

    @Override
    public Slice getSlice(int position) {
        if (this.isNull(position)) {
            throw new IllegalStateException("position is null");
        }
        int offset = this.getPositionOffset(position);
        return this.type.getSlice(this.getRawSlice(), AbstractVariableWidthBlock.valueOffset(offset));
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        int offset = this.getPositionOffset(position);
        if (this.isEntryAtOffsetNull(offset)) {
            return new VariableWidthBlock(this.type, 1, Slices.wrappedBuffer((byte[])new byte[]{1}), new int[]{0});
        }
        int entrySize = AbstractVariableWidthBlock.valueOffset(this.type.getLength(this.getRawSlice(), AbstractVariableWidthBlock.valueOffset(offset)));
        Slice copy = Slices.copyOf((Slice)this.getRawSlice(), (int)offset, (int)entrySize);
        return new VariableWidthBlock(this.type, 1, copy, new int[]{0});
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        int offset = this.getPositionOffset(position);
        return this.isEntryAtOffsetNull(offset);
    }

    @Override
    public boolean equalTo(int position, Block otherBlock, int otherPosition) {
        this.checkReadablePosition(position);
        int leftOffset = this.getPositionOffset(position);
        boolean leftIsNull = this.isEntryAtOffsetNull(leftOffset);
        boolean rightIsNull = otherBlock.isNull(otherPosition);
        if (leftIsNull != rightIsNull) {
            return false;
        }
        if (leftIsNull) {
            return true;
        }
        return otherBlock.equalTo(otherPosition, this.getRawSlice(), AbstractVariableWidthBlock.valueOffset(leftOffset));
    }

    @Override
    public boolean equalTo(int position, BlockCursor cursor) {
        this.checkReadablePosition(position);
        int offset = this.getPositionOffset(position);
        boolean thisIsNull = this.isEntryAtOffsetNull(offset);
        boolean valueIsNull = cursor.isNull();
        if (thisIsNull != valueIsNull) {
            return false;
        }
        if (thisIsNull) {
            return true;
        }
        return this.type.equalTo(this.getRawSlice(), AbstractVariableWidthBlock.valueOffset(offset), cursor);
    }

    @Override
    public boolean equalTo(int position, Slice otherSlice, int otherOffset) {
        this.checkReadablePosition(position);
        int leftEntryOffset = this.getPositionOffset(position);
        return this.type.equalTo(this.getRawSlice(), AbstractVariableWidthBlock.valueOffset(leftEntryOffset), otherSlice, otherOffset);
    }

    @Override
    public int hash(int position) {
        this.checkReadablePosition(position);
        int offset = this.getPositionOffset(position);
        if (this.isEntryAtOffsetNull(offset)) {
            return 0;
        }
        return this.type.hash(this.getRawSlice(), AbstractVariableWidthBlock.valueOffset(offset));
    }

    @Override
    public int compareTo(SortOrder sortOrder, int position, Block otherBlock, int otherPosition) {
        this.checkReadablePosition(position);
        int leftOffset = this.getPositionOffset(position);
        boolean leftIsNull = this.isEntryAtOffsetNull(leftOffset);
        boolean rightIsNull = otherBlock.isNull(otherPosition);
        if (leftIsNull && rightIsNull) {
            return 0;
        }
        if (leftIsNull) {
            return sortOrder.isNullsFirst() ? -1 : 1;
        }
        if (rightIsNull) {
            return sortOrder.isNullsFirst() ? 1 : -1;
        }
        int result = -otherBlock.compareTo(otherPosition, this.getRawSlice(), AbstractVariableWidthBlock.valueOffset(leftOffset));
        return sortOrder.isAscending() ? result : -result;
    }

    @Override
    public int compareTo(SortOrder sortOrder, int position, BlockCursor cursor) {
        this.checkReadablePosition(position);
        int leftEntryOffset = this.getPositionOffset(position);
        boolean leftIsNull = this.isEntryAtOffsetNull(leftEntryOffset);
        boolean rightIsNull = cursor.isNull();
        if (leftIsNull && rightIsNull) {
            return 0;
        }
        if (leftIsNull) {
            return sortOrder.isNullsFirst() ? -1 : 1;
        }
        if (rightIsNull) {
            return sortOrder.isNullsFirst() ? 1 : -1;
        }
        int result = -cursor.compareTo(this.getRawSlice(), AbstractVariableWidthBlock.valueOffset(leftEntryOffset));
        return sortOrder.isAscending() ? result : -result;
    }

    @Override
    public int compareTo(int position, Slice otherSlice, int otherOffset) {
        this.checkReadablePosition(position);
        int leftEntryOffset = this.getPositionOffset(position);
        return this.type.compareTo(this.getRawSlice(), AbstractVariableWidthBlock.valueOffset(leftEntryOffset), otherSlice, otherOffset);
    }

    @Override
    public void appendTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        int offset = this.getPositionOffset(position);
        if (this.isEntryAtOffsetNull(offset)) {
            blockBuilder.appendNull();
        } else {
            this.type.appendTo(this.getRawSlice(), AbstractVariableWidthBlock.valueOffset(offset), blockBuilder);
        }
    }

    private boolean isEntryAtOffsetNull(int offset) {
        return this.getRawSlice().getByte(offset) != 0;
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalStateException("position is not valid");
        }
    }

    private static int valueOffset(int entryOffset) {
        return entryOffset + 1;
    }
}

